/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class OracleSql {
    boolean isV8Compatible = false;
    int current_argument;
    int parameterCount;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    boolean isLocate = false;

    public OracleSql() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleSql.OracleSql()");
        }
        this.oracle_sql = new StringBuffer(128);
        this.token_buffer = new StringBuffer(32);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleSql.OracleSql:return");
        }
    }

    public synchronized String parse(String os) throws SQLException {
        this.current_argument = 1;
        this.parameterCount = 0;
        this.i = 0;
        this.first = true;
        this.in_string = false;
        this.oracle_sql.ensureCapacity(this.length);
        this.oracle_sql.setLength(0);
        this.odbc_sql = os;
        this.length = this.odbc_sql.length();
        this.handleODBC();
        if (this.i < this.length) {
            Integer index = new Integer(this.i);
            DBError.check_error((int)33, (Object)index);
        }
        return this.oracle_sql.toString();
    }

    void handleODBC() throws SQLException {
        StringBuffer arg1 = null;
        StringBuffer arg2 = null;
        boolean arg2Start = false;
        while (this.i < this.length) {
            this.c = this.odbc_sql.charAt(this.i);
            if (this.in_string) {
                this.oracle_sql.append(this.c);
                if (this.c == '\'') {
                    this.in_string = false;
                }
                ++this.i;
                continue;
            }
            switch (this.c) {
                case '\'': {
                    this.oracle_sql.append(this.c);
                    this.in_string = true;
                    ++this.i;
                    this.first = false;
                    break;
                }
                case '{': {
                    this.token_buffer.setLength(0);
                    ++this.i;
                    this.skipSpace();
                    while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                        this.token_buffer.append(this.c);
                        ++this.i;
                    }
                    this.handleToken(this.token_buffer.toString());
                    this.c = this.odbc_sql.charAt(this.i);
                    if (this.c != '}') {
                        String s2 = new String(this.i + ": Expecting \"}\" got \"" + this.c + "\"");
                        DBError.check_error((int)33, (Object)s2);
                    }
                    ++this.i;
                    break;
                }
                case '}': {
                    return;
                }
                default: {
                    if (this.c != ' ' && this.c != '(' && this.isLocate) {
                        if (this.c == ')') {
                            this.oracle_sql.append(arg2);
                            this.oracle_sql.append(", ");
                            this.oracle_sql.append(arg1);
                            this.appendChar(this.oracle_sql, this.c);
                            this.isLocate = false;
                        }
                        if (arg1 == null) {
                            arg1 = new StringBuffer();
                            arg2 = new StringBuffer();
                        }
                        if (this.c == ',') {
                            arg2Start = true;
                            ++this.i;
                            this.first = false;
                            break;
                        }
                        if (!arg2Start) {
                            arg1.append(this.c);
                        } else {
                            arg2.append(this.c);
                        }
                    } else {
                        this.appendChar(this.oracle_sql, this.c);
                    }
                    ++this.i;
                    this.first = false;
                }
            }
        }
    }

    void handleToken(String token) throws SQLException {
        if (token.equalsIgnoreCase("?")) {
            this.handleFunction();
        } else if (token.equalsIgnoreCase("call")) {
            this.handleCall();
        } else if (token.equalsIgnoreCase("ts")) {
            this.handleTimestamp();
        } else if (token.equalsIgnoreCase("t")) {
            this.handleTime();
        } else if (token.equalsIgnoreCase("d")) {
            this.handleDate();
        } else if (token.equalsIgnoreCase("escape")) {
            this.handleEscape();
        } else if (token.equalsIgnoreCase("fn")) {
            this.handleScalarFunction();
        } else if (token.equalsIgnoreCase("oj")) {
            this.handleOuterJoin();
        } else {
            String s2 = new String(this.i + ": " + token);
            DBError.check_error((int)34, (Object)s2);
        }
    }

    void handleFunction() throws SQLException {
        String s2;
        boolean need_block = this.first;
        if (need_block) {
            this.oracle_sql.append("BEGIN ");
        }
        this.appendChar(this.oracle_sql, '?');
        this.skipSpace();
        if (this.c != '=') {
            s2 = new String(this.i + ". Expecting \"=\" got \"" + this.c + "\"");
            DBError.check_error((int)33, (Object)s2);
        }
        ++this.i;
        this.skipSpace();
        if (!this.odbc_sql.startsWith("call", this.i)) {
            s2 = new String(this.i + ". Expecting \"call\"");
            DBError.check_error((int)33, (Object)s2);
        }
        this.i += 4;
        this.oracle_sql.append(" := ");
        this.skipSpace();
        this.handleODBC();
        if (need_block) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleCall() throws SQLException {
        boolean need_block = this.first;
        if (need_block) {
            this.oracle_sql.append("BEGIN ");
        }
        this.skipSpace();
        this.handleODBC();
        this.skipSpace();
        if (need_block) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleTimestamp() throws SQLException {
        if (this.isV8Compatible) {
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            boolean in_nanos = false;
            while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) != '}') {
                if (!in_nanos) {
                    if (this.c == '.') {
                        in_nanos = true;
                    } else {
                        this.oracle_sql.append(this.c);
                    }
                }
                ++this.i;
            }
            if (in_nanos) {
                this.oracle_sql.append('\'');
            }
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    void handleTime() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'HH24:MI:SS')");
    }

    void handleDate() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'YYYY-MM-DD')");
    }

    void handleEscape() throws SQLException {
        this.oracle_sql.append("ESCAPE ");
        this.skipSpace();
        this.handleODBC();
    }

    void handleScalarFunction() throws SQLException {
        this.token_buffer.setLength(0);
        ++this.i;
        this.skipSpace();
        while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
            this.token_buffer.append(this.c);
            ++this.i;
        }
        String functionName = this.token_buffer.toString().toUpperCase();
        if (functionName.equals("ABS")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("ACOS")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("ASIN")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("ATAN")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("ATAN2")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("CEILING")) {
            this.usingFunctionName("CEIL");
        } else if (functionName.equals("COS")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("COT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("DEGREES")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("EXP")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("FLOOR")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("LOG")) {
            this.usingFunctionName("LN");
        } else if (functionName.equals("LOG10")) {
            this.replacingFunctionPrefix("LOG ( 10, ");
        } else if (functionName.equals("MOD")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("PI")) {
            this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if (functionName.equals("POWER")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("RADIANS")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("RAND")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("ROUND")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("SIGN")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("SIN")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("SQRT")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("TAN")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("TRUNCATE")) {
            this.usingFunctionName("TRUNC");
        } else if (functionName.equals("ASCII")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("CHAR")) {
            this.usingFunctionName("CHR");
        } else if (functionName.equals("CONCAT")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("DIFFERENCE")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("INSERT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("LCASE")) {
            this.usingFunctionName("LOWER");
        } else if (functionName.equals("LEFT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("LENGTH")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("LOCATE")) {
            this.isLocate = true;
            this.usingFunctionName("INSTR");
        } else if (functionName.equals("LTRIM")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("REPEAT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("REPLACE")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("RIGHT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("RTRIM")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("SOUNDEX")) {
            this.usingFunctionName(functionName);
        } else if (functionName.equals("SPACE")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("SUBSTRING")) {
            this.usingFunctionName("SUBSTR");
        } else if (functionName.equals("UCASE")) {
            this.usingFunctionName("UPPER");
        } else if (functionName.equals("CURDATE")) {
            this.replacingFunctionPrefix("(CURRENT_DATE");
        } else if (functionName.equals("CURTIME")) {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (functionName.equals("DAYNAME")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("DAYOFMONTH")) {
            this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if (functionName.equals("DAYOFWEEK")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("DAYOFYEAR")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("HOUR")) {
            this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if (functionName.equals("MINUTE")) {
            this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if (functionName.equals("MONTH")) {
            this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if (functionName.equals("MONTHNAME")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("NOW")) {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (functionName.equals("QUARTER")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("SECOND")) {
            this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if (functionName.equals("TIMESTAMPADD")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("TIMESTAMPDIFF")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("WEEK")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("YEAR")) {
            this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if (functionName.equals("DATABASE")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("IFNULL")) {
            DBError.check_error((int)34, (Object)functionName);
        } else if (functionName.equals("USER")) {
            this.replacingFunctionPrefix("(USER");
        } else if (functionName.equals("CONVERT")) {
            DBError.check_error((int)34, (Object)functionName);
        } else {
            DBError.check_error((int)34, (Object)functionName);
        }
    }

    void usingFunctionName(String newName) throws SQLException {
        this.oracle_sql.append(newName);
        this.skipSpace();
        this.handleODBC();
    }

    void replacingFunctionPrefix(String newPrefix) throws SQLException {
        this.skipSpace();
        if (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == '(') {
            ++this.i;
        } else {
            DBError.check_error((int)33);
        }
        this.oracle_sql.append(newPrefix);
        this.skipSpace();
        this.handleODBC();
    }

    void handleOuterJoin() throws SQLException {
        this.oracle_sql.append(" ( ");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(" ) ");
    }

    String nextArgument() {
        String result = ":" + this.current_argument;
        ++this.current_argument;
        return result;
    }

    void appendChar(StringBuffer oracle_sql, char c2) {
        switch (c2) {
            case '?': {
                oracle_sql.append(this.nextArgument());
                ++this.parameterCount;
                break;
            }
            case ':': {
                ++this.parameterCount;
            }
            default: {
                oracle_sql.append(c2);
            }
        }
    }

    void skipSpace() {
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
            ++this.i;
        }
    }
}

