/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.gss.util.NLSCharacter;
import oracle.jdbc.OracleDatabaseMetaData;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleResultSetMetaData
implements oracle.jdbc.internal.OracleResultSetMetaData {
    oracle.jdbc.internal.OracleConnection connection;
    OracleStatement statement;
    int m_beginColumnIndex;

    public OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection conn, OracleStatement stmt) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleResultSetMetaData.OracleResultSetMetaData(conn, stmt)");
        }
        this.connection = conn;
        this.statement = stmt;
        stmt.describe();
        this.m_beginColumnIndex = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleResultSetMetaData.OracleResultSetMetaData:return");
        }
    }

    OracleResultSetMetaData(oracle.jdbc.internal.OracleConnection conn, OracleStatement stmt, int beginColumnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetMetaData.OracleResultSetMetaData(conn, stmt, ColIndex:" + beginColumnIndex + ")"));
        }
        this.connection = conn;
        this.statement = stmt;
        stmt.describe();
        this.m_beginColumnIndex = beginColumnIndex;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleResultSetMetaData.OracleResultSetMetaData:return");
        }
    }

    public OracleResultSetMetaData(OracleResultSet rs) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleResultSetMetaData.OracleResultSetMetaData(rs)");
        }
        this.statement = (OracleStatement)rs.getStatement();
        this.connection = (oracle.jdbc.internal.OracleConnection)this.statement.getConnection();
        this.statement.describe();
        this.m_beginColumnIndex = rs.getFirstUserColumnIndex();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)"OracleResultSetMetaData.OracleResultSetMetaData:return");
        }
    }

    public int getColumnCount() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)("Rset Column count: " + (this.statement.getDBDescription().length - this.m_beginColumnIndex)));
        }
        return this.statement.getDBDescription().length - this.m_beginColumnIndex;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    private int getValidColumnIndex(int column) throws SQLException {
        int index = column + this.m_beginColumnIndex - 1;
        if (index < 0 || index >= this.statement.getDBDescription().length) {
            DBError.check_error((int)3, (Object)"getValidColumnIndex");
        }
        return index;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type == 1 || type == 12 || type == -1;
    }

    public boolean isSearchable(int column) throws SQLException {
        int type = this.getColumnType(column);
        return type != -4 && type != -1 && type != 2004 && type != 2005 && type != -13 && type != 2002 && type != 2008 && type != 2007 && type != 2003 && type != 2006 && type != -10;
    }

    public boolean isCurrency(int column) throws SQLException {
        return this.getColumnType(column) == 2;
    }

    public int isNullable(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.statement.getDBDescription()[index].nullable ? 1 : 0;
    }

    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        int UACFCUS = 4096;
        int index = this.getValidColumnIndex(column);
        DBColumn dbcolumn = this.statement.getDBDescription()[index];
        if ((dbcolumn.contflag & UACFCUS) == UACFCUS) {
            return dbcolumn.max_length / NLSCharacter.getRatio((int)(dbcolumn.FormOfUse == 2 ? ((OracleConnection)this.connection).getNCsId() : ((OracleConnection)this.connection).getDbCsId()), (int)1);
        }
        return dbcolumn.max_length;
    }

    int getColumnByteSize(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.statement.getDBDescription()[index].max_length;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        return this.statement.getDBDescription()[index].name;
    }

    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    public int getPrecision(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.statement.getDBDescription()[index].type;
        switch (type) {
            case 112: 
            case 113: {
                return Integer.parseInt(OracleDatabaseMetaData.getLobPrecision());
            }
            case 8: 
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 1: 
            case 96: {
                return this.statement.getDBDescription()[index].max_length;
            }
        }
        return this.statement.getDBDescription()[index].precision;
    }

    public int getScale(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int _scale = this.statement.getDBDescription()[index].scale;
        return _scale == -127 && this.statement.connection.m_j2ee13Compliant ? 0 : _scale;
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.statement.getDBDescription()[index].type;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)("Rset Column Type:<" + type + ">"));
        }
        switch (type) {
            case 96: {
                return 1;
            }
            case 1: {
                return 12;
            }
            case 8: {
                return -1;
            }
            case 2: 
            case 6: {
                if (this.statement.connection.m_j2ee13Compliant && this.statement.getDBDescription()[index].precision != 0 && this.statement.getDBDescription()[index].scale == -127) {
                    return 6;
                }
                return 2;
            }
            case 23: {
                return -3;
            }
            case 24: {
                return -4;
            }
            case 104: {
                return -8;
            }
            case 102: {
                return -10;
            }
            case 12: {
                return ((OracleConnection)this.connection).m_v8compatible ? 93 : 91;
            }
            case 180: {
                return 93;
            }
            case 181: {
                return -101;
            }
            case 231: {
                return -102;
            }
            case 113: {
                return 2004;
            }
            case 112: {
                return 2005;
            }
            case 114: {
                return -13;
            }
            case 109: {
                OracleNamedType ntypeObj = (OracleNamedType)this.statement.getDBDescription()[index].otype;
                TypeDescriptor descriptor = TypeDescriptor.getTypeDescriptor(ntypeObj.getFullName(), this.connection);
                if (descriptor != null) {
                    return descriptor.getTypeCode();
                }
                DBError.throwSqlException((int)60);
                return -1;
            }
            case 111: {
                return 2006;
            }
            case 182: {
                return -103;
            }
            case 183: {
                return -104;
            }
        }
        return 1111;
    }

    public String getColumnTypeName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR2";
            }
            case -1: {
                return "LONG";
            }
            case -3: {
                return "RAW";
            }
            case -4: {
                return "LONG RAW";
            }
            case 2: {
                return "NUMBER";
            }
            case 6: {
                return "FLOAT";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return ((OracleConnection)this.connection).m_v8compatible ? "DATE" : "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case -8: {
                return "ROWID";
            }
            case -10: {
                return "REFCURSOR";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                int index = this.getValidColumnIndex(column);
                OracleTypeADT otype = (OracleTypeADT)this.statement.getDBDescription()[index].otype;
                return otype.getFullName();
            }
            case 2006: {
                int index = this.getValidColumnIndex(column);
                OracleTypeADT otype = (OracleTypeADT)this.statement.getDBDescription()[index].otype;
                return otype.getFullName();
            }
        }
        return null;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return true;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        int index = this.getValidColumnIndex(column);
        int type = this.statement.getDBDescription()[index].type;
        switch (type) {
            case 1: 
            case 8: 
            case 96: 
            case 999: {
                return "java.lang.String";
            }
            case 2: 
            case 6: {
                return "java.math.BigDecimal";
            }
            case 23: 
            case 24: {
                return "byte[]";
            }
            case 12: {
                return "java.sql.Timestamp";
            }
            case 180: {
                return "oracle.sql.TIMESTAMP";
            }
            case 181: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case 231: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 182: {
                return "oracle.sql.INTERVALYM";
            }
            case 104: {
                return "oracle.sql.ROWID";
            }
            case 113: {
                return "oracle.sql.BLOB";
            }
            case 112: {
                return "oracle.sql.CLOB";
            }
            case 114: {
                return "oracle.sql.BFILE";
            }
            case 102: {
                return "oracle.jdbc.driver.OracleResultSet";
            }
            case 109: {
                switch (this.getColumnType(column)) {
                    case 2003: {
                        return "oracle.sql.ARRAY";
                    }
                    case 2007: {
                        return "oracle.sql.OPAQUE";
                    }
                    case 2008: {
                        Class c2;
                        OracleNamedType ntype = (OracleNamedType)this.statement.getDBDescription()[index].otype;
                        Map map = this.connection.getJavaObjectTypeMap();
                        if (map != null && (c2 = (Class)map.get(ntype.getFullName())) != null) {
                            return c2.getName();
                        }
                        return StructDescriptor.getJavaObjectClassName(this.connection, ntype.getSchemaName(), ntype.getSimpleName());
                    }
                    case 2002: {
                        Class c3;
                        Map map = this.connection.getTypeMap();
                        if (map != null && (c3 = (Class)map.get(((OracleNamedType)this.statement.getDBDescription()[index].otype).getFullName())) != null) {
                            return c3.getName();
                        }
                        return "oracle.sql.STRUCT";
                    }
                }
                DBError.throwSqlException((int)1);
            }
            case 111: {
                return "oracle.sql.REF";
            }
        }
        return null;
    }

    public boolean isNCHAR(int columnIndex) throws SQLException {
        int index = this.getValidColumnIndex(columnIndex);
        return this.statement.getDBDescription()[index].FormOfUse == 2;
    }
}

