/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleResultSetImpl
extends BaseResultSet {
    OracleConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    private boolean m_emptyRset;

    OracleResultSetImpl(OracleConnection c2, OracleStatement s2) throws SQLException {
        this.connection = c2;
        this.statement = s2;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"OracleResultSetImpl.close()");
        }
        this.internal_close();
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.explicitly_closed = true;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"OracleResultSetImpl.wasNull()");
        }
        return this.statement.wasNullValue();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"OracleResultSetImpl.getMetaData()");
        }
        if (this.explicitly_closed) {
            DBError.check_error((int)10, (Object)"getMetaData");
        }
        if (this.statement.closed) {
            DBError.check_error((int)9, (Object)"getMetaData");
        }
        if (this.statement.dbstmt == null) {
            DBError.check_error((int)137, (Object)"getMetaData");
        }
        return new OracleResultSetMetaData((oracle.jdbc.internal.OracleConnection)this.connection, (oracle.jdbc.internal.OracleStatement)this.statement);
    }

    public synchronized Statement getStatement() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.getStatement(): return: " + this.statement));
        }
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.next(): closed=" + this.closed));
        }
        if (this.explicitly_closed) {
            DBError.check_error((int)10, (Object)"next");
        }
        if (this.statement.connection == null || this.statement.connection.closed) {
            DBError.check_error((int)8, (Object)"next");
        }
        if (this.statement.closed) {
            DBError.check_error((int)9, (Object)"next");
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)("closed=" + this.closed + ", statement.current_row=" + this.statement.current_row + ", statement.total_rows_visited=" + this.statement.total_rows_visited + ", statement.max_rows=" + this.statement.max_rows + ", statement.valid_rows=" + this.statement.valid_rows + ", statement.got_last_batch=" + this.statement.got_last_batch));
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.current_row;
        ++this.statement.total_rows_visited;
        if (this.statement.max_rows != 0 && this.statement.total_rows_visited > this.statement.max_rows) {
            this.internal_close();
            return false;
        }
        if (this.statement.current_row >= this.statement.valid_rows) {
            try {
                if (this.statement.got_last_batch) {
                    this.internal_close();
                    return false;
                }
                this.statement.check_row_prefetch_changed_for_resultset();
                this.prepare_for_new_row();
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)32, (int)32, (String)"about to call fetch");
                }
                this.statement.connection.needLine();
                try {
                    this.statement.m_isExecuting = true;
                    this.statement.valid_rows = this.connection.db_access.fetch(this.statement.dbstmt, this.statement.defines, this.statement.row_prefetch);
                    Object var2_1 = null;
                    this.statement.m_isExecuting = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.statement.m_isExecuting = false;
                    throw throwable;
                }
                this.statement.fetchedFirstColumns();
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)this.statement.defines.getInfoString());
                }
                if (this.statement.valid_rows == 0) {
                    this.internal_close();
                    return false;
                }
                this.statement.current_row = 0;
                this.statement.checkValidRowsStatus();
                return true;
            }
            catch (IOException e2) {
                DBError.check_error((IOException)e2);
            }
        }
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.isBeforeFirst: return: " + (!this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed)));
        }
        return !this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.isAfterLast: return: " + (!this.isEmptyResultSet() && this.closed)));
        }
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.isFirst: return: " + (this.getRow() == 1)));
        }
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"OracleResultSetImpl.isLast()");
        }
        DBError.throwSqlException((int)75, (Object)"isLast");
        return false;
    }

    public int getRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)16, (String)("OracleResultSetImpl.getRow: return: " + this.statement.total_rows_visited));
        }
        return this.statement.total_rows_visited;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getString(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getStringValue(true, columnIndex);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBoolean(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBooleanValue(true, columnIndex);
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getByte(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getByteValue(true, columnIndex);
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getShort(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getShortValue(true, columnIndex);
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getInt(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getIntValue(true, columnIndex);
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getLong(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getLongValue(true, columnIndex);
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getFloat(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getFloatValue(true, columnIndex);
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getDouble(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getDoubleValue(true, columnIndex);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBigDecimal(columnIndex=" + columnIndex + ", scale=" + scale + ")"));
        }
        return this.statement.getBigDecimalValue(true, columnIndex, scale);
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBytes(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBytesValue(true, columnIndex);
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getDate(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getDateValue(true, columnIndex);
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getTime(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getTimeValue(true, columnIndex);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getTimestamp(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getTimestampValue(true, columnIndex);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getAsciiStream(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getAsciiStreamValue(true, columnIndex);
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getUnicodeStream(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getUnicodeStreamValue(true, columnIndex);
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBinaryStream(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBinaryStreamValue(true, columnIndex);
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getObject(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getObjectValue(true, columnIndex);
    }

    public synchronized ResultSet getCursor(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getCursor(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getCursorValue(true, columnIndex);
    }

    public synchronized Datum getOracleObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getOracleObject(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getOracleObjectValue(true, columnIndex);
    }

    public synchronized ROWID getROWID(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getROWID(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getROWIDValue(true, columnIndex);
    }

    public synchronized NUMBER getNUMBER(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getNUMBER(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getNUMBERValue(true, columnIndex);
    }

    public synchronized DATE getDATE(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getDATE(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getDATEValue(true, columnIndex);
    }

    public synchronized ARRAY getARRAY(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getARRAY(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getARRAYValue(true, columnIndex);
    }

    public synchronized STRUCT getSTRUCT(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getSTRUCT(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getSTRUCTValue(true, columnIndex);
    }

    public synchronized OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getOPAQUE(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getOPAQUEValue(true, columnIndex);
    }

    public synchronized REF getREF(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getREF(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getREFValue(true, columnIndex);
    }

    public synchronized CHAR getCHAR(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getCHAR(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getCHARValue(true, columnIndex);
    }

    public synchronized RAW getRAW(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getRAW(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getRAWValue(true, columnIndex);
    }

    public synchronized BLOB getBLOB(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBLOB(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBLOBValue(true, columnIndex);
    }

    public synchronized CLOB getCLOB(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getCLOB(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getCLOBValue(true, columnIndex);
    }

    public synchronized BFILE getBFILE(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBFILE(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBFILEValue(true, columnIndex);
    }

    public synchronized BFILE getBfile(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getBfile(columnIndex=" + columnIndex + ")"));
        }
        return this.getBFILE(columnIndex);
    }

    public synchronized CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getCustomDatum(columnIndex=" + columnIndex + ", factory=" + factory + ")"));
        }
        return this.statement.getCustomDatumValue(true, columnIndex, factory);
    }

    public synchronized ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getORAData(columnIndex=" + columnIndex + ", factory=" + factory + ")"));
        }
        return this.statement.getORADataValue(true, columnIndex, factory);
    }

    public synchronized Object getObject(int columnIndex, Map map) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.getObject(columnIndex=" + columnIndex + ", map=" + map + ")"));
        }
        return this.statement.getObjectValue(true, columnIndex, map);
    }

    public synchronized Ref getRef(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getRef(columnIndex=" + columnIndex + ")"));
        }
        return this.getREF(columnIndex);
    }

    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getBlog(columnIndex=" + columnIndex + ")"));
        }
        return this.getBLOB(columnIndex);
    }

    public synchronized Clob getClob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getClob(columnIndex=" + columnIndex + ")"));
        }
        return this.getCLOB(columnIndex);
    }

    public synchronized Array getArray(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getArray(columnIndex=" + columnIndex + ")"));
        }
        return this.getARRAY(columnIndex);
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getCharacterStream(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getCharacterStreamValue(true, columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getBigDecimal(columnIndex=" + columnIndex + ")"));
        }
        return this.statement.getBigDecimalValue(true, columnIndex, 0);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getDate(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return this.statement.getDateValue(true, columnIndex, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getTime(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return this.statement.getTimeValue(true, columnIndex, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getTimestamp(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        return this.statement.getTimestampValue(true, columnIndex, cal);
    }

    public INTERVALYM getINTERVALYM(int paramIdx) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getINTERVALYM(paramIdx=" + paramIdx + ")"));
        }
        return this.statement.getINTERVALYMValue(true, paramIdx);
    }

    public TIMESTAMP getTIMESTAMP(int paramIdx) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getTIMESTAMP(paramIdx=" + paramIdx + ")"));
        }
        return this.statement.getTIMESTAMPValue(true, paramIdx);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int paramIdx) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getTIMESTAMPTZ(paramIdx=" + paramIdx + ")"));
        }
        return this.statement.getTIMESTAMPTZValue(true, paramIdx);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int paramIdx) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getTIMESTAMPLTZ(paramIdx=" + paramIdx + ")"));
        }
        return this.statement.getTIMESTAMPLTZValue(true, paramIdx);
    }

    public void setFetchSize(int rows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.setFetchSize(rows=" + rows + ")"));
        }
        this.statement.setPrefetchInternal(rows, false, false);
    }

    public int getFetchSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ResultSet.getFetchSize()");
        }
        return this.statement.getPrefetchInternal(false);
    }

    void internal_close() throws SQLException {
        if (this.statement.dbstmt == null || this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.got_last_batch && this.statement.valid_rows == 0) {
            this.m_emptyRset = true;
        }
        if (this.statement.dbstmt == null) {
            return;
        }
        try {
            this.statement.connection.needLine();
            this.statement.connection.db_access.closeQuery(this.statement.dbstmt);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.statement.end_of_result_set();
    }

    void prepare_for_new_row() throws SQLException {
        if (this.statement.streams != null) {
            try {
                this.statement.streams.close();
            }
            catch (IOException e2) {
                DBError.check_error((IOException)e2);
            }
        }
        this.clearWarnings();
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("OracleResultSetImpl.findColumn(columnName=" + columnName + ")"));
        }
        return this.statement.get_column_index(columnName);
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.got_last_batch && this.statement.valid_rows == 0;
    }

    int getValidRows() {
        return this.statement.valid_rows;
    }
}

