/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    private int min_binary_stream_size;
    private int min_ascii_stream_size;
    private int premature_batch_count;
    boolean check_bind_types = true;
    DBDataSet m_binds;
    boolean m_scrollRsetTypeSolved;
    boolean has_ref_cursors = false;
    protected static final int BSTYLE_UNKNOWN = 0;
    protected static final int BSTYLE_ORACLE = 1;
    protected static final int BSTYLE_JDBC = 2;
    protected int m_batchStyle = 0;

    public OraclePreparedStatement(OracleConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue)");
        }
    }

    public OraclePreparedStatement(OracleConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.OraclePreparedStatement(conn, sql, batchValue, rowPrefetchValue, UserResultSetType)");
        }
        this.statementType = 1;
        this.need_to_parse = true;
        this.has_ref_cursors = false;
        this.prepare_for_new_result(true);
        this.sql_query = sql;
        this.sql_string_changed = true;
        this.m_originalSql = sql;
        this.clear_params = true;
        this.m_binds = null;
        this.m_scrollRsetTypeSolved = false;
        this.premature_batch_count = 0;
        this.binds_in = this.connection.db_access.createDBDataSet(conn, (OracleStatement)this, batch_value, 1);
        this.sql_kind = (byte)-1;
        if (conn.db_access.getVersionNumber() >= 8000) {
            this.min_binary_stream_size = 2000;
            this.min_ascii_stream_size = 4000;
        } else {
            this.min_binary_stream_size = 255;
            this.min_ascii_stream_size = 2000;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.OraclePreparedStatement(conn, sql, UserResultSetType):return");
        }
    }

    protected void enterImplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"enterImplicitCache() entry");
        }
        if (this.dbstmt != null && this.defines != null && this.defines.hasStreamType()) {
            this.need_to_prepare_define_buffer = true;
        }
        this.cacheState = OracleStatement.CACHED;
        this.m_creationState = 1;
        this.was_columns_defined_by_user = this.columns_defined_by_user;
        this.initializeState(this.batch, this.row_prefetch, this.m_autoRefetch, this.serverCursor);
        if (this.connection.m_stmtClearMetaData) {
            this.initializeMetaData();
        }
        if (this.dbstmt != null) {
            this.dbstmt.enterCache();
        }
        if (this.binds_in != null) {
            this.binds_in.enterCache();
        }
        if (this.binds_out != null) {
            this.binds_out.enterCache();
        }
        if (this.connection.noCachingBuffer && this.defines != null) {
            if (this.defines != null) {
                this.defines.clearItemBuffers();
                this.need_to_prepare_java_define_buffers = true;
            }
            if (this.binds_in != null) {
                this.binds_in.clearItemBuffers();
            }
            if (this.binds_out != null) {
                this.binds_out.clearItemBuffers();
                this.need_to_prepare_java_define_buffers = true;
            }
        }
        if (this.columns_defined_by_user && this.defines != null) {
            this.defines.enterCache();
            this.need_to_prepare_define_buffer = true;
        }
        if (this.sql_kind == 4 || this.sql_kind == -1) {
            this.need_to_parse = true;
        }
    }

    protected void enterExplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"enterExplicitCache() entry");
        }
        if (this.dbstmt != null && this.defines != null && this.defines.hasStreamType()) {
            this.need_to_prepare_define_buffer = true;
        }
        this.cacheState = OracleStatement.CACHED;
        this.m_creationState = 2;
    }

    protected void exitImplicitCacheToActive() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"exitImplicitCacheToActive() entry");
        }
        this.cacheState = OracleStatement.ACTIVE;
        if (this.dbstmt != null) {
            this.dbstmt.reactivate();
        }
        if (this.binds_in != null) {
            this.binds_in.reactivate();
        }
        if (this.binds_out != null) {
            this.binds_out.reactivate();
        }
        if (this.defines != null) {
            this.defines.reactivate();
        }
        this.default_row_prefetch = this.connection.getDefaultRowPrefetch();
        if (this.row_prefetch != this.default_row_prefetch) {
            this.row_prefetch = this.default_row_prefetch;
            if (this.defines != null && this.defines.hasStreamType()) {
                this.row_prefetch_changed = true;
                this.initializeStreams(this.defines.getNoOfArgs());
            }
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.batch = this.connection.getDefaultExecuteBatch();
            this.need_to_parse = true;
        }
        if (this.m_autoRefetch != this.connection.getDefaultAutoRefetch()) {
            this.m_autoRefetch = this.connection.getDefaultAutoRefetch();
            this.need_to_parse = true;
        }
    }

    protected void exitExplicitCacheToActive() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.exitImplicitCacheToActive()");
        }
        this.cacheState = OracleStatement.ACTIVE;
    }

    protected void exitImplicitCacheToClose() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.exitImplicitCacheToClose()");
        }
        this.cacheState = OracleStatement.CLOSED;
        super.close();
    }

    protected void exitExplicitCacheToClose() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.exitExplicitCacheToClose()");
        }
        this.cacheState = OracleStatement.CLOSED;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithKey(String key) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(key);
            }
        }
    }

    private void privateClose(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.privateClose(key)");
        }
        if (this.closed) {
            return;
        }
        if (this.doesJdbcBatchExist()) {
            this.clearBatch();
        } else {
            this.premature_batch_count = this.sendBatch();
        }
        if (this.isCachable && this.connection.isStatementCacheInitialized() && this.cacheState != OracleStatement.CLOSED && this.cacheState != OracleStatement.NON_CACHED) {
            if (key == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement(this, this.sql_query, this.statementType, this.m_userRsetType);
                } else {
                    this.cacheState = OracleStatement.CLOSED;
                    super.close();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement(this, key);
            } else {
                this.cacheState = OracleStatement.CLOSED;
                super.close();
            }
        } else {
            this.cacheState = OracleStatement.CLOSED;
            super.close();
        }
        if (key == null) {
            this.cleanup();
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.privateClose(key):return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                OracleResultSet oracleResultSet;
                block11: {
                    OracleResultSetImpl oracleResultSetImpl;
                    block10: {
                        try {
                            this.executionType = 1;
                            if (OracleLog.TRACE) {
                                OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.executeQuery()");
                            }
                            this.connection.db_access.setStatementWarning(this.m_warning);
                            this.executeUpdate();
                            if (this.isRegularResultSet()) {
                                oracleResultSetImpl = this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
                                Object var5_5 = null;
                                break block10;
                            }
                            if (this.m_scrollRset == null) {
                                this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
                                this.m_scrollRset = this.current_result_set;
                            }
                            oracleResultSet = this.m_scrollRset;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            this.executionType = (byte)-1;
                            this.m_warning = this.connection.db_access.getStatementWarning();
                            throw throwable;
                        }
                    }
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    return oracleResultSetImpl;
                }
                Object var5_6 = null;
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return oracleResultSet;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int n2;
                block16: {
                    int n3;
                    block15: {
                        int n4;
                        block14: {
                            try {
                                int retVal;
                                if (this.executionType == -1) {
                                    this.executionType = (byte)2;
                                }
                                if (OracleLog.TRACE) {
                                    OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.executeUpdate()");
                                }
                                this.connection.db_access.setStatementWarning(this.m_warning);
                                this.noMoreUpdateCounts = false;
                                this.checkIfJdbcBatchExists();
                                this.ensureOpen();
                                if (this.has_ref_cursors) {
                                    this.need_to_parse = true;
                                }
                                if (this.isRegularResultSet()) {
                                    this.prepare_for_new_result(true);
                                    this.get_data_for_columns(this.batch);
                                    this.doExecuteWithTimeout();
                                    if (this.valid_rows > 0) {
                                        this.valid_rows += this.premature_batch_count;
                                        this.premature_batch_count = 0;
                                    }
                                    n4 = this.valid_rows;
                                    Object var6_6 = null;
                                    break block14;
                                }
                                if (this.m_scrollRsetTypeSolved) {
                                    this.prepare_for_new_result(true);
                                    this.get_data_for_columns(this.batch);
                                    this.doExecuteWithTimeout();
                                    this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
                                    this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
                                    if (this.connection.m_accumulateBatchResult && this.valid_rows > 0) {
                                        this.valid_rows += this.premature_batch_count;
                                        this.premature_batch_count = 0;
                                    }
                                    n3 = this.valid_rows;
                                    break block15;
                                }
                                n2 = retVal = this.doScrollPstmtExecuteUpdate() + this.premature_batch_count;
                                break block16;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                this.executionType = (byte)-1;
                                this.m_warning = this.connection.db_access.getStatementWarning();
                                throw throwable;
                            }
                        }
                        this.executionType = (byte)-1;
                        this.m_warning = this.connection.db_access.getStatementWarning();
                        return n4;
                    }
                    Object var6_7 = null;
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    return n3;
                }
                Object var6_8 = null;
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                boolean bl;
                try {
                    this.executionType = (byte)3;
                    this.connection.db_access.setStatementWarning(this.m_warning);
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.execute()");
                    }
                    this.checkIfJdbcBatchExists();
                    this.executeUpdate();
                    bl = this.sql_kind == 0;
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.executionType = (byte)-1;
                    this.m_warning = this.connection.db_access.getStatementWarning();
                    throw throwable;
                }
                this.executionType = (byte)-1;
                this.m_warning = this.connection.db_access.getStatementWarning();
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                block12: {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.sendBatch()");
                        OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Send batch: batch=" + this.batch + ", m_currentRank=" + this.m_currentRank));
                    }
                    if (this.isJdbcBatchStyle()) {
                        return 0;
                    }
                    this.ensureOpen();
                    if (this.m_currentRank <= 0) {
                        if (this.connection.m_accumulateBatchResult) {
                            return 0;
                        }
                        int n2 = this.valid_rows;
                        return n2;
                    }
                    int actual_batch = this.batch;
                    int tmp_currentRank = this.m_currentRank--;
                    try {
                        if (this.batch != this.m_currentRank) {
                            this.batch = this.m_currentRank;
                            this.need_to_parse = true;
                        }
                        this.doExecuteWithTimeout();
                        Object var7_7 = null;
                        if (this.batch == actual_batch) break block12;
                        this.batch = actual_batch;
                        this.need_to_parse = true;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (this.batch == actual_batch) throw throwable;
                        this.batch = actual_batch;
                        this.need_to_parse = true;
                        this.binds_in.clearItem(tmp_currentRank, true);
                        throw throwable;
                    }
                    this.binds_in.clearItem(tmp_currentRank, true);
                }
                if (!this.connection.m_accumulateBatchResult) return this.valid_rows;
                this.valid_rows += this.premature_batch_count;
                this.premature_batch_count = 0;
                return this.valid_rows;
            }
        }
    }

    public synchronized void setExecuteBatch(int batchValue) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setExecuteBatch(batchValue=" + batchValue + ")"));
        }
        this.setOracleBatchStyle();
        this.set_execute_batch(batchValue);
    }

    private synchronized void set_execute_batch(int batchValue) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setExecuteBatch(batchValue=" + batchValue + "): batch=" + this.batch));
        }
        if (batchValue <= 0) {
            DBError.throwSqlException((int)42);
        }
        if (batchValue == this.batch) {
            return;
        }
        this.batch = batchValue;
        if (this.m_currentRank > 0) {
            this.premature_batch_count = this.sendBatch();
        }
        this.binds_in.setBatchSize(batchValue);
        this.need_to_parse = true;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.setExecuteBatch:return");
        }
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    public synchronized void defineParameterTypeBytes(int param_index, int type, int max_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.defineParameterType(param_index=" + param_index + ", type=" + type + ", max_size=" + max_size + ")"));
        }
        if (max_size < 0) {
            DBError.throwSqlException((int)53);
        }
        if (param_index < 1) {
            DBError.throwSqlException((int)3);
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                type = 6;
                break;
            }
            case 999: {
                type = 999;
                break;
            }
            case 1: {
                type = 96;
                break;
            }
            case 12: {
                type = 1;
                break;
            }
            case 91: 
            case 92: {
                type = 12;
                break;
            }
            case -103: {
                type = 182;
                break;
            }
            case -104: {
                type = 183;
                break;
            }
            case -100: 
            case 93: {
                type = 180;
                break;
            }
            case -101: {
                type = 181;
                break;
            }
            case -102: {
                type = 231;
                break;
            }
            case -3: 
            case -2: {
                type = 23;
                break;
            }
            case -8: {
                type = 104;
                break;
            }
            case 2004: {
                type = 113;
                break;
            }
            case 2005: {
                type = 112;
                break;
            }
            case -13: {
                type = 114;
                break;
            }
            case -10: {
                type = 102;
                break;
            }
            default: {
                DBError.throwSqlException((int)23);
            }
        }
        this.binds_in.setType(param_index - 1, type, max_size, (short)1);
    }

    public synchronized void defineParameterTypeChars(int param_index, int type, int max_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.defineParameterTypeChars(param_index=" + param_index + ", type=" + type + ", max_size=" + max_size + ")"));
        }
        int nlsratio = this.connection.db_access.getNlsRatio();
        if (type == 1 || type == 12) {
            this.defineParameterTypeBytes(param_index, type, max_size * nlsratio);
        } else {
            this.defineParameterTypeBytes(param_index, type, max_size);
        }
    }

    public synchronized void defineParameterType(int param_index, int type, int max_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleStatement.defineParameterType(param_index=" + param_index + "type=" + type + "max_size=" + max_size + ")"));
        }
        this.defineParameterTypeBytes(param_index, type, max_size * this.connection.dataSizeScale);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet _rset = this.getResultSet();
        if (_rset != null) {
            return _rset.getMetaData();
        }
        return null;
    }

    protected void setItem(int index, int type, byte[] array) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setItem(index=" + index + ", type=" + type + ", array)"));
        }
        this.checkBindTypes(true, index, type);
        boolean change = this.binds_in.setBytesBindItem(index, this.m_currentRank, type, array);
        if (!this.connection.getProtocolType().equals("thin") && !this.connection.getProtocolType().equals("thin-server") && change) {
            this.need_to_parse = true;
        }
    }

    protected void setItem(int index, int type, String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setItem(index=" + index + ", type=" + type + ", str)"));
        }
        this.checkBindTypes(true, index, type);
        boolean change = this.binds_in.setBytesBindItem(index, this.m_currentRank, type, str);
        if (!this.connection.getProtocolType().equals("thin") && !this.connection.getProtocolType().equals("thin-server") && change) {
            this.need_to_parse = true;
        }
    }

    protected void setStreamItem(int index, int type, InputStream istream, int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setStreamItem(index=" + index + ", type=" + type + ", istream, size=" + size + ")"));
        }
        if (size < 0) {
            DBError.throwSqlException((int)43);
        }
        this.checkBindTypes(true, index, type);
        this.binds_in.setStreamBindItem(index, this.m_currentRank, type, istream, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setNull(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", sqlName=" + sqlName + ")"));
        }
        if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003 || sqlType == 2007 || sqlType == 2006) {
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                OraclePreparedStatement oraclePreparedStatement = this;
                synchronized (oraclePreparedStatement) {
                    this.setNullCritial(paramIndex, sqlType, sqlName);
                }
            }
        }
        this.setNull(paramIndex, sqlType);
        return;
    }

    void setNullCritial(int paramIndex, int sqlType, String sqlName) throws SQLException {
        int index = paramIndex - 1;
        int internal_type = this.get_internal_type(sqlType);
        OracleNamedType otype = null;
        this.columnSetNull = true;
        this.checkBindTypes(true, index, internal_type);
        switch (sqlType) {
            case 2002: 
            case 2006: 
            case 2008: {
                StructDescriptor desc = StructDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = desc.getOracleTypeADT();
                break;
            }
            case 2003: {
                ArrayDescriptor desc = ArrayDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = desc.getOracleTypeCOLLECTION();
                break;
            }
            case 2007: {
                OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                otype = desc.getPickler();
                break;
            }
            default: {
                DBError.throwSqlException((int)1);
            }
        }
        if (this.binds_in.setNullADTBindItem(index, this.m_currentRank, internal_type, (OracleType)otype)) {
            this.need_to_parse = true;
        }
        this.columnSetNull = false;
    }

    public synchronized void setNull(int paramIndex, int sqlType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OraclePreparedStatement.setNull(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ")"));
        }
        if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003 || sqlType == 2007 || sqlType == 2006) {
            DBError.throwSqlException((int)4, (Object)("sqlType=" + sqlType));
        }
        int index = paramIndex - 1;
        int internal_type = this.get_internal_type(sqlType);
        this.columnSetNull = true;
        this.checkBindTypes(true, index, internal_type);
        switch (internal_type) {
            case 180: {
                if (!this.connection.m_v8compatible) break;
                internal_type = 12;
                break;
            }
            case 8: {
                internal_type = 1;
                break;
            }
            case 24: {
                internal_type = 23;
            }
        }
        this.binds_in.setNullBindItem(index, this.m_currentRank, internal_type);
        this.columnSetNull = false;
    }

    public synchronized void setBoolean(int paramIndex, boolean x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBoolean(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.BooleanToNumberBytes((boolean)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setByte(int paramIndex, byte x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setByte(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.ByteToNumberBytes((byte)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setShort(int paramIndex, short x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setShort(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.ShortToNumberBytes((short)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setInt(int paramIndex, int x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setInt(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.IntToNumberBytes((int)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setLong(int paramIndex, long x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setLong(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.LongToNumberBytes((long)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setFloat(int paramIndex, float x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setFloat(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.FloatToNumberBytes((float)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setDouble(int paramIndex, double x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setDouble(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.DoubleToNumberBytes((double)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBigDecimal(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = DBConversion.BigDecimalToNumberBytes((BigDecimal)x);
        this.setItem(index, 6, array);
    }

    public synchronized void setString(int paramIndex, String x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setString(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        boolean thin = this.connection.getProtocolType().equals("thin");
        boolean isNtype = false;
        if (this.binds_in != null) {
            boolean bl = isNtype = this.binds_in.getFormOfUse(paramIndex - 1) == 2;
        }
        if (thin) {
            this.setItem(index, 1, x);
        } else {
            byte[] array = null;
            array = isNtype ? this.connection.conversion.StringToNCharBytes(x) : this.connection.conversion.StringToCharBytes(x);
            this.setItem(index, 1, array);
        }
    }

    public synchronized void setFixedCHAR(int paramIndex, String x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setFixedCHAR(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        int index = paramIndex - 1;
        byte[] array = this.connection.conversion.StringToCharBytes(x);
        this.setItem(index, 999, array);
    }

    public synchronized void setCursor(int paramIndex, ResultSet rs) throws SQLException {
        throw DBError.newSqlException((int)23);
    }

    public synchronized void setROWID(int paramIndex, ROWID rowid) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setROWID(paramIndex=" + paramIndex + ", rowid)"));
        }
        this.setDatum(paramIndex - 1, 104, rowid);
    }

    public synchronized void setArray(int paramIndex, Array arr) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setArray(paramIndex=" + paramIndex + ", array)"));
        }
        this.setARRAY(paramIndex, (ARRAY)arr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setARRAY(int paramIndex, ARRAY arr) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setARRAYr(paramIndex=" + paramIndex + ", array)"));
        }
        if (arr == null) {
            DBError.throwSqlException((int)68);
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (arr.getDescriptor() == null) {
                    DBError.throwSqlException((int)61);
                }
                int index = paramIndex - 1;
                this.checkBindTypes(true, index, 109);
                byte[] pickled_bytes = arr.toBytes();
                if (this.binds_in.setADTBindItem(index, this.m_currentRank, 109, pickled_bytes, (OracleType)arr.getDescriptor().getOracleTypeCOLLECTION())) {
                    this.need_to_parse = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOPAQUE(int paramIndex, OPAQUE opaque) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setOPAQUE(paramIndex=" + paramIndex + ", struct)"));
        }
        int index = paramIndex - 1;
        if (opaque == null) {
            DBError.throwSqlException((int)68);
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (opaque.getDescriptor() == null) {
                    DBError.throwSqlException((int)61);
                }
                this.checkBindTypes(true, index, 109);
                byte[] pickled_bytes = opaque.toBytes();
                if (this.binds_in.setADTBindItem(index, this.m_currentRank, 109, pickled_bytes, (OracleType)((OracleTypeOPAQUE)opaque.getDescriptor().getPickler()))) {
                    this.need_to_parse = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStructDescriptor(int paramIndex, StructDescriptor desc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setStructDescriptor(paramIndex=" + paramIndex + ", desc)"));
        }
        int index = paramIndex - 1;
        if (desc == null) {
            DBError.throwSqlException((int)68);
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.checkBindTypes(true, index, 109);
                this.binds_in.setADTBindType(index, this.m_currentRank, 109, (OracleType)desc.getOracleTypeADT());
            }
        }
    }

    public synchronized void setPreBindsCompelete() throws SQLException {
        this.binds_in.setFirstRow(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSTRUCT(int paramIndex, STRUCT struct) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setSTRUCT(paramIndex=" + paramIndex + ", struct)"));
        }
        int index = paramIndex - 1;
        if (struct == null) {
            DBError.throwSqlException((int)68);
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                StructDescriptor desc = struct.getDescriptor();
                if (desc == null) {
                    DBError.throwSqlException((int)61);
                }
                this.checkBindObjectTypes(true, index, 109, desc);
                byte[] pickled_bytes = struct.toBytes();
                if (this.binds_in.setADTBindItem(index, this.m_currentRank, 109, pickled_bytes, (OracleType)desc.getOracleTypeADT())) {
                    this.need_to_parse = true;
                }
            }
        }
    }

    public synchronized void setRAW(int paramIndex, RAW raw) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setRAW(paramIndex=" + paramIndex + ", raq)"));
        }
        this.setDatum(paramIndex - 1, 23, raw);
    }

    public synchronized void setCHAR(int paramIndex, CHAR ch) throws SQLException {
        if (OracleLog.TRACE) {
            String char_desc = null;
            char_desc = ch == null ? "=null" : "(charset=" + String.valueOf(ch.getCharacterSet().getOracleId()) + ")";
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setCHAR(paramIdx=" + paramIndex + ", CHAR" + char_desc + ")"));
        }
        int db_type = 1;
        CHAR c2 = ch;
        if (c2 != null) {
            CharacterSet targetCS;
            short char_cs_id = (short)c2.getCharacterSet().getOracleId();
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (String)("OraclePreparedStatement.setCHAR() may not be able to handle charset of " + char_cs_id));
            }
            if ((targetCS = this.binds_in != null && this.binds_in.getFormOfUse(paramIndex - 1) == 2 ? this.connection.conversion.getAccessNCharSetObj() : this.connection.conversion.getAccessCharSetObj()) != null && char_cs_id != targetCS.getOracleId()) {
                byte[] b2 = c2.getBytes();
                c2 = new CHAR(targetCS.convert(ch.getCharacterSet(), b2, 0, b2.length), targetCS);
            }
        }
        this.setDatum(paramIndex - 1, db_type, c2);
    }

    public synchronized void setDATE(int paramIndex, DATE date) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setDATE(paramIndex=" + paramIndex + ", date=" + date + ")"));
        }
        this.setDatum(paramIndex - 1, 12, date);
    }

    public synchronized void setNUMBER(int paramIndex, NUMBER num) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setNUMBER(paramIndex=" + paramIndex + ", num)"));
        }
        this.setDatum(paramIndex - 1, 6, num);
    }

    private void setDatum(int index, int type, Datum data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OraclePreparedStatement.setDatum(index=" + index + ", type=" + type + ", datum)"));
        }
        if (data == null) {
            this.setItem(index, type, null);
        } else {
            this.setItem(index, type, data.getBytes());
        }
    }

    public synchronized void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBLOB(paramIndex=" + paramIndex + ", lob)"));
        }
        this.setDatum(paramIndex - 1, 113, lob);
    }

    public synchronized void setBlob(int paramIndex, Blob lob) throws SQLException {
        this.setBLOB(paramIndex, (BLOB)lob);
    }

    public synchronized void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setCLOB(paramIndex=" + paramIndex + ", clob)"));
        }
        this.setDatum(paramIndex - 1, 112, lob);
    }

    public synchronized void setClob(int paramIndex, Clob lob) throws SQLException {
        this.setCLOB(paramIndex, (CLOB)lob);
    }

    public synchronized void setBFILE(int paramIndex, BFILE file) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBFILE(paramIndex=" + paramIndex + ", bfile)"));
        }
        this.setDatum(paramIndex - 1, 114, file);
    }

    public synchronized void setBfile(int paramIndex, BFILE file) throws SQLException {
        this.setBFILE(paramIndex, file);
    }

    public synchronized void setBytes(int paramIndex, byte[] x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBytes(paramIndex=" + paramIndex + ", bytes)"));
        }
        int index = paramIndex - 1;
        if (x != null) {
            byte[] cx = new byte[x.length];
            System.arraycopy(x, 0, cx, 0, x.length);
            this.setItem(index, 23, cx);
        } else {
            this.setItem(index, 23, null);
        }
    }

    public synchronized void setInternalBytes(int paramIndex, byte[] x, int dbtype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setInternalBytes(paramIndex=" + paramIndex + ", bytes, dbtype=" + dbtype));
        }
        int index = paramIndex - 1;
        this.setItem(index, dbtype, x);
    }

    public synchronized void setDate(int paramIndex, Date x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setDate(paramIndex=" + paramIndex + ", date)"));
        }
        int index = paramIndex - 1;
        byte[] array = this.connection.conversion.DateToDateBytes(x);
        this.setItem(index, 12, array);
    }

    public synchronized void setTime(int paramIndex, Time x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setTime(paramIndex=" + paramIndex + ", time)"));
        }
        int index = paramIndex - 1;
        byte[] array = this.connection.conversion.TimeToDateBytes(x);
        this.setItem(index, 12, array);
    }

    public synchronized void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setTimestamp(paramIndex=" + paramIndex + ", timestamp)"));
        }
        int index = paramIndex - 1;
        if (this.connection.m_v8compatible) {
            byte[] array = DATE.toBytes(x);
            this.setItem(index, 12, array);
        } else {
            byte[] array = TIMESTAMP.toBytes(x);
            this.setItem(index, 180, array);
        }
    }

    public synchronized void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setINTERVALYM(paramIndex=" + paramIndex + ", x=" + x + ")"));
        }
        this.setDatum(paramIndex - 1, 182, x);
    }

    public synchronized void setTIMESTAMP(int paramIdx, TIMESTAMP x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setTIMESTAMP(paramIdx=" + paramIdx + ", x=" + x + ")"));
        }
        this.setDatum(paramIdx - 1, 180, x);
    }

    public synchronized void setTIMESTAMPTZ(int paramIdx, TIMESTAMPTZ x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setTIMESTAMPTZ(paramIdx=" + paramIdx + ", x=" + x + ")"));
        }
        this.setDatum(paramIdx - 1, 181, x);
    }

    public synchronized void setTIMESTAMPLTZ(int paramIdx, TIMESTAMPLTZ x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setTIMESTAMPLTZ(paramIdx=" + paramIdx + ", x=" + x + ")"));
        }
        if (this.connection.getSessionTimeZone() == null) {
            DBError.throwSqlException((int)105);
        }
        this.setDatum(paramIdx - 1, 231, x);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setAsciiStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setAsciiStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")"));
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.setString(paramIndex, null);
            return;
        }
        int index = paramIndex - 1;
        int _minStreamSize = this.connection.db_access.getMinAsciiStreamSize(this.connection, this.min_ascii_stream_size);
        if (this.sql_kind == -1) {
            this.sql_kind = this.getSqlKind(this.sql_query);
        }
        if (this.sql_kind != 1) {
            if (this.sql_kind != 3 && length > _minStreamSize && this.isRegularResultSet()) {
                InputStream converted_stream = this.connection.conversion.ConvertStream(istream, 5, length);
                this.setStreamItem(index, 8, converted_stream, length);
                return;
            }
        }
        try {
            byte[] _byteBuf = new byte[length];
            istream.read(_byteBuf, 0, length);
            byte[] _accessBytes = this.connection.conversion.asciiBytesToCHARBytes(_byteBuf);
            this.setItem(index, 1, _accessBytes);
            return;
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setBinaryStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setBinaryStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")"));
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.setBytes(paramIndex, null);
            return;
        }
        int index = paramIndex - 1;
        if (this.sql_kind == -1) {
            this.sql_kind = this.getSqlKind(this.sql_query);
        }
        if (this.sql_kind != 1) {
            if (this.sql_kind != 3 && length > this.min_binary_stream_size && this.isRegularResultSet()) {
                this.setStreamItem(index, 24, istream, length);
                return;
            }
        }
        try {
            byte[] _byteBuf = new byte[length];
            istream.read(_byteBuf, 0, length);
            this.setItem(index, 23, _byteBuf);
            return;
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setUnicodeStream(int paramIndex, InputStream istream, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setUnicodeStream(paramIndex=" + paramIndex + ", istream, length=" + length + ")"));
        }
        this.set_execute_batch(1);
        if (istream == null) {
            this.setString(paramIndex, null);
            return;
        }
        int index = paramIndex - 1;
        InputStream converted_stream = this.connection.conversion.ConvertStream(istream, 4, length);
        int _minStreamSize = 2 * (this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio()) / this.connection.conversion.getMaxCharbyteSize();
        if (this.sql_kind == -1) {
            this.sql_kind = this.getSqlKind(this.sql_query);
        }
        if (this.sql_kind != 1) {
            if (this.sql_kind != 3 && length > _minStreamSize && this.isRegularResultSet()) {
                this.setStreamItem(index, 8, converted_stream, length * this.connection.conversion.getMaxCharbyteSize());
                return;
            }
        }
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(1024);
            byte[] _byteBuf = new byte[1024];
            while (true) {
                void var9_10;
                int _len;
                if ((_len = converted_stream.read(_byteBuf)) == -1) {
                    this.setItem(index, 1, outstream.toByteArray());
                    outstream.close();
                    return;
                }
                outstream.write(_byteBuf, 0, (int)var9_10);
            }
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setCustomDataum(paramIndex=" + paramIndex + ", customDatum)"));
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum d2 = x.toDatum(this.connection);
                this.setOracleObject(paramIndex, d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setORAData(paramIndex=" + paramIndex + ", ORAData)"));
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                Datum d2 = x.toDatum(this.connection);
                this.setOracleObject(paramIndex, d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setObject(paramIndex=" + paramIndex + ", object, targetSqlType=" + targetSqlType + ", scale=" + scale + ")"));
        }
        if (x == null && targetSqlType != 2002 && targetSqlType != 2008 && targetSqlType != 2003 && targetSqlType != 2007 && targetSqlType != 2006) {
            this.setNull(paramIndex, targetSqlType);
        } else {
            if (targetSqlType == 2002 || targetSqlType == 2008 || targetSqlType == 2003) {
                OracleConnection oracleConnection = this.connection;
                synchronized (oracleConnection) {
                    OraclePreparedStatement oraclePreparedStatement = this;
                    synchronized (oraclePreparedStatement) {
                        this.setObjectCritical(paramIndex, x, targetSqlType, scale);
                    }
                }
            }
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.setObjectCritical(paramIndex, x, targetSqlType, scale);
            }
        }
    }

    void setObjectCritical(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        switch (targetSqlType) {
            case 1: {
                if (x instanceof CHAR) {
                    this.setCHAR(paramIndex, (CHAR)x);
                    break;
                }
                if (x instanceof String) {
                    this.setString(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setString(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setString(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setString(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setString(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setString(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setString(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setString(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setString(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setString(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 12: {
                if (x instanceof String) {
                    this.setString(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setString(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setString(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setString(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setString(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setString(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setString(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setString(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setString(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setString(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 999: {
                this.setFixedCHAR(paramIndex, (String)x);
                break;
            }
            case -1: {
                if (x instanceof String) {
                    this.setString(paramIndex, (String)x);
                    break;
                }
                if (x instanceof Boolean) {
                    this.setString(paramIndex, "" + ((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof Integer) {
                    this.setString(paramIndex, "" + (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setString(paramIndex, "" + (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setString(paramIndex, "" + ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setString(paramIndex, "" + (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setString(paramIndex, ((BigDecimal)x).toString());
                    break;
                }
                if (x instanceof Date) {
                    this.setString(paramIndex, "" + ((Date)x).toString());
                    break;
                }
                if (x instanceof Time) {
                    this.setString(paramIndex, "" + ((Time)x).toString());
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setString(paramIndex, "" + ((Timestamp)x).toString());
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 2: {
                if (x instanceof NUMBER) {
                    this.setNUMBER(paramIndex, (NUMBER)x);
                    break;
                }
                if (x instanceof Integer) {
                    this.setInt(paramIndex, (Integer)x);
                    break;
                }
                if (x instanceof Long) {
                    this.setLong(paramIndex, (Long)x);
                    break;
                }
                if (x instanceof Float) {
                    this.setFloat(paramIndex, ((Float)x).floatValue());
                    break;
                }
                if (x instanceof Double) {
                    this.setDouble(paramIndex, (Double)x);
                    break;
                }
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(paramIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof String) {
                    this.setNUMBER(paramIndex, new NUMBER((String)x, 0));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setInt(paramIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 3: {
                if (x instanceof BigDecimal) {
                    this.setBigDecimal(paramIndex, (BigDecimal)x);
                    break;
                }
                if (x instanceof Number) {
                    this.setBigDecimal(paramIndex, new BigDecimal(((Number)x).doubleValue()));
                    break;
                }
                if (x instanceof NUMBER) {
                    this.setBigDecimal(paramIndex, ((NUMBER)x).bigDecimalValue());
                    break;
                }
                if (x instanceof String) {
                    this.setBigDecimal(paramIndex, new BigDecimal((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setBigDecimal(paramIndex, new BigDecimal((Boolean)x != false ? 1.0 : 0.0));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case -7: {
                if (x instanceof Boolean) {
                    this.setByte(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                if (x instanceof String) {
                    this.setByte(paramIndex, (byte)("true".equalsIgnoreCase((String)x) || "1".equals(x) ? 1 : 0));
                    break;
                }
                if (x instanceof Number) {
                    this.setInt(paramIndex, ((Number)x).byteValue() != 0 ? 1 : 0);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case -6: {
                if (x instanceof Number) {
                    this.setByte(paramIndex, ((Number)x).byteValue());
                    break;
                }
                if (x instanceof String) {
                    this.setByte(paramIndex, Byte.parseByte((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setByte(paramIndex, (byte)((Boolean)x != false ? 1 : 0));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 5: {
                if (x instanceof Number) {
                    this.setShort(paramIndex, ((Number)x).shortValue());
                    break;
                }
                if (x instanceof String) {
                    this.setShort(paramIndex, Short.parseShort((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setShort(paramIndex, (short)((Boolean)x != false ? 1 : 0));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 4: {
                if (x instanceof Number) {
                    this.setInt(paramIndex, ((Number)x).intValue());
                    break;
                }
                if (x instanceof String) {
                    this.setInt(paramIndex, Integer.parseInt((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setInt(paramIndex, (Boolean)x != false ? 1 : 0);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case -5: {
                if (x instanceof Number) {
                    this.setLong(paramIndex, ((Number)x).longValue());
                    break;
                }
                if (x instanceof String) {
                    this.setLong(paramIndex, Long.parseLong((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setLong(paramIndex, (Boolean)x != false ? 1L : 0L);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 7: {
                if (x instanceof Number) {
                    this.setFloat(paramIndex, ((Number)x).floatValue());
                    break;
                }
                if (x instanceof String) {
                    this.setFloat(paramIndex, Float.valueOf((String)x).floatValue());
                    break;
                }
                if (x instanceof Boolean) {
                    this.setFloat(paramIndex, (Boolean)x != false ? 1.0f : 0.0f);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 6: 
            case 8: {
                if (x instanceof Number) {
                    this.setDouble(paramIndex, ((Number)x).doubleValue());
                    break;
                }
                if (x instanceof String) {
                    this.setDouble(paramIndex, Double.valueOf((String)x));
                    break;
                }
                if (x instanceof Boolean) {
                    this.setDouble(paramIndex, (Boolean)x != false ? 1.0 : 0.0);
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case -2: {
                if (x instanceof RAW) {
                    this.setRAW(paramIndex, (RAW)x);
                    break;
                }
                this.setBytes(paramIndex, (byte[])x);
                break;
            }
            case -3: {
                this.setBytes(paramIndex, (byte[])x);
                break;
            }
            case -4: {
                this.setBytes(paramIndex, (byte[])x);
                break;
            }
            case 91: {
                if (x instanceof DATE) {
                    this.setDATE(paramIndex, (DATE)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDate(paramIndex, (Date)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(paramIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof String) {
                    this.setDate(paramIndex, Date.valueOf((String)x));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 92: {
                if (x instanceof Time) {
                    this.setTime(paramIndex, (Time)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTime(paramIndex, new Time(((Timestamp)x).getTime()));
                    break;
                }
                if (x instanceof Date) {
                    this.setTime(paramIndex, new Time(((Date)x).getTime()));
                    break;
                }
                if (x instanceof String) {
                    this.setTime(paramIndex, Time.valueOf((String)x));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case 93: {
                if (x instanceof TIMESTAMP) {
                    this.setTIMESTAMP(paramIndex, (TIMESTAMP)x);
                    break;
                }
                if (x instanceof Timestamp) {
                    this.setTimestamp(paramIndex, (Timestamp)x);
                    break;
                }
                if (x instanceof Date) {
                    this.setDate(paramIndex, (Date)x);
                    break;
                }
                if (x instanceof DATE) {
                    this.setDATE(paramIndex, (DATE)x);
                    break;
                }
                if (x instanceof String) {
                    this.setTimestamp(paramIndex, Timestamp.valueOf((String)x));
                    break;
                }
                DBError.throwSqlException((int)132);
                break;
            }
            case -100: {
                this.setTIMESTAMP(paramIndex, (TIMESTAMP)x);
                break;
            }
            case -101: {
                this.setTIMESTAMPTZ(paramIndex, (TIMESTAMPTZ)x);
                break;
            }
            case -102: {
                this.setTIMESTAMPLTZ(paramIndex, (TIMESTAMPLTZ)x);
                break;
            }
            case -103: {
                this.setINTERVALYM(paramIndex, (INTERVALYM)x);
                break;
            }
            case -8: {
                this.setROWID(paramIndex, (ROWID)x);
                break;
            }
            case 2004: {
                this.setBLOB(paramIndex, (BLOB)x);
                break;
            }
            case 2005: {
                this.setCLOB(paramIndex, (CLOB)x);
                break;
            }
            case -13: {
                this.setBFILE(paramIndex, (BFILE)x);
                break;
            }
            case 2002: 
            case 2008: {
                this.setSTRUCT(paramIndex, STRUCT.toSTRUCT(x, this.connection));
                break;
            }
            case 2003: {
                this.setARRAY(paramIndex, ARRAY.toARRAY(x, this.connection));
                break;
            }
            case 2007: {
                this.setOPAQUE(paramIndex, (OPAQUE)x);
                break;
            }
            case 2006: {
                this.setREF(paramIndex, (REF)x);
                break;
            }
            default: {
                DBError.throwSqlException((int)4);
            }
        }
    }

    public void setObject(int paramIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(paramIndex, x, targetSqlType, 0);
    }

    public void setRefType(int paramIndex, REF ref) throws SQLException {
        this.setREF(paramIndex, ref);
    }

    public synchronized void setRef(int paramIndex, Ref ref) throws SQLException {
        this.setREF(paramIndex, (REF)ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setREF(int paramIndex, REF ref) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setREF(paramIndex=" + paramIndex + ", ref)"));
        }
        if (ref == null) {
            DBError.throwSqlException((int)68);
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (ref.getDescriptor() == null) {
                    DBError.throwSqlException((int)52);
                }
                int index = paramIndex - 1;
                this.checkBindTypes(true, index, 111);
                byte[] ref_bytes = ref.getBytes();
                if (this.binds_in.setADTBindItem(index, this.m_currentRank, 111, ref_bytes, (OracleType)ref.getDescriptor().getOracleTypeADT())) {
                    this.need_to_parse = true;
                }
            }
        }
    }

    public void setObject(int paramIndex, Object x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setObject(paramIndex=" + paramIndex + ", object)"));
        }
        if (x instanceof ORAData) {
            this.setORAData(paramIndex, (ORAData)x);
        } else if (x instanceof CustomDatum) {
            this.setCustomDatum(paramIndex, (CustomDatum)x);
        } else {
            int sqlType = this.sqlTypeForObject(x);
            this.setObject(paramIndex, x, sqlType, 0);
        }
    }

    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        this.setObject(paramIndex, x);
    }

    public synchronized void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setPlsqlIndexTable(paramIndex=" + paramIndex + ", arrayData=" + arrayData + " , maxLen=" + maxLen + " , curLen=" + curLen + " , elemSqlType=" + elemSqlType + " , " + elemMaxLen + ")"));
        }
        if (maxLen < 0 || curLen < 0 || maxLen < curLen) {
            DBError.throwSqlException((int)68, (Object)"maxLen < 0, curLen < 0 or maxLen < curLen ");
        }
        int elem_internal_type = this.get_internal_type(elemSqlType);
        this.checkPlsqlIndexTableBindTypes(true, paramIndex - 1, maxLen, elem_internal_type, elemMaxLen);
        Datum[] darray = null;
        switch (elem_internal_type) {
            case 1: 
            case 96: {
                if (arrayData instanceof CHAR[]) {
                    darray = (CHAR[])arrayData;
                    break;
                }
                if (!(arrayData instanceof String[])) break;
                String[] a2 = (String[])arrayData;
                darray = new CHAR[a2.length];
                int i2 = 0;
                while (i2 < a2.length) {
                    byte[] b2 = this.connection.conversion.StringToCharBytes(a2[i2]);
                    darray[i2] = new CHAR("", CharacterSet.make(this.connection.getJdbcCsId()));
                    if (b2 != null) {
                        darray[i2].setBytes(b2);
                    }
                    ++i2;
                }
                break;
            }
            case 2: 
            case 6: {
                darray = OracleTypeNUMBER.toNUMBERArray(arrayData, this.connection, 1L, curLen);
                break;
            }
            default: {
                DBError.throwSqlException((int)97);
                return;
            }
        }
        if (this.binds_in.setPlsqlIndexTableItem(paramIndex - 1, this.m_currentRank, darray, maxLen, curLen, elem_internal_type, elemMaxLen)) {
            this.need_to_parse = true;
        }
    }

    void checkPlsqlIndexTableBindTypes(boolean in, int index, int maxLen, int elemDBType, int elemMaxLen) throws SQLException {
        int result = 0;
        switch (elemDBType) {
            case 1: 
            case 2: 
            case 6: 
            case 96: {
                break;
            }
            default: {
                DBError.throwSqlException((int)97);
            }
        }
        if (!this.check_bind_types) {
            return;
        }
        result = in ? this.binds_in.checkPlsqlIndexTableBindTypes(this.binds_out, index, maxLen, elemMaxLen, elemDBType) : this.binds_out.checkPlsqlIndexTableBindTypes(this.binds_in, index, maxLen, elemMaxLen, elemDBType);
        if (result == -1) {
            this.premature_batch_count = this.sendBatch();
            this.need_to_parse = true;
            this.clearDefines();
        }
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result(false);
    }

    private void get_data_for_columns(int batchRows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.get_data_for_columns()");
        }
        this.binds_in.rowCompleted(this.m_currentRank);
        if (this.binds_out != null) {
            this.binds_out.rowCompleted(this.m_currentRank);
        }
    }

    protected void checkBindTypes(boolean in, int index, int type) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int result = in ? this.binds_in.checkBindTypes(this.binds_out, index, type) : this.binds_out.checkBindTypes(this.binds_in, index, type);
        if (result == -1) {
            int tmp_currentRank = this.m_currentRank;
            if (this.isJdbcBatchStyle()) {
                this.executeBatch();
            } else if (this.m_currentRank > 0) {
                this.premature_batch_count = this.sendBatch();
            }
            this.need_to_parse = true;
            this.binds_in.clearItem(tmp_currentRank, true);
        }
    }

    protected void checkBindObjectTypes(boolean in, int index, int type, StructDescriptor desc) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int result = in ? this.binds_in.checkBindObjectTypes(this.binds_out, index, type, desc) : this.binds_out.checkBindObjectTypes(this.binds_in, index, type, desc);
        if (result == -1) {
            if (this.m_currentRank > 0) {
                this.premature_batch_count = this.sendBatch();
            }
            this.need_to_parse = true;
        }
    }

    int sqlTypeForObject(Object x) {
        if (x == null) {
            return 0;
        }
        if (!(x instanceof Datum)) {
            if (x instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (x instanceof BigDecimal) {
                return 2;
            }
            if (x instanceof Boolean) {
                return -7;
            }
            if (x instanceof Integer) {
                return 4;
            }
            if (x instanceof Long) {
                return -5;
            }
            if (x instanceof Float) {
                return 6;
            }
            if (x instanceof Double) {
                return 8;
            }
            if (x instanceof byte[]) {
                return -3;
            }
            if (x instanceof Short) {
                return 5;
            }
            if (x instanceof Byte) {
                return -6;
            }
            if (x instanceof Date) {
                return 91;
            }
            if (x instanceof Time) {
                return 92;
            }
            if (x instanceof Timestamp) {
                return 93;
            }
            if (x instanceof SQLData) {
                return 2002;
            }
            if (x instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (x instanceof BLOB) {
                return 2004;
            }
            if (x instanceof CLOB) {
                return 2005;
            }
            if (x instanceof BFILE) {
                return -13;
            }
            if (x instanceof ROWID) {
                return -8;
            }
            if (x instanceof NUMBER) {
                return 2;
            }
            if (x instanceof DATE) {
                return 91;
            }
            if (x instanceof TIMESTAMP) {
                return 93;
            }
            if (x instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (x instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (x instanceof REF) {
                return 2006;
            }
            if (x instanceof CHAR) {
                return 1;
            }
            if (x instanceof RAW) {
                return -2;
            }
            if (x instanceof ARRAY) {
                return 2003;
            }
            if (x instanceof STRUCT) {
                return 2002;
            }
            if (x instanceof OPAQUE) {
                return 2007;
            }
            if (x instanceof INTERVALYM) {
                return -103;
            }
        }
        return 1111;
    }

    public synchronized void clearParameters() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.clearParameters()");
        }
        this.clear_params = true;
        if (this.binds_in != null) {
            this.binds_in.clearItem(this.m_currentRank, false);
        }
    }

    private void printByteArray(byte[] b2) {
        if (b2 == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)"<Null byte array!>");
            }
        } else {
            int n2 = b2.length;
            int i2 = 0;
            while (i2 < n2) {
                int v = b2[i2] & 0xFF;
                if (v < 16) {
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)("0" + Integer.toHexString(v) + " "));
                    }
                } else if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)(Integer.toHexString(v) + " "));
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCharacterStream(int paramIndex, Reader reader, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setCharacterStream(paramIndex=" + paramIndex + ", reader, length=" + length + ")"));
        }
        this.set_execute_batch(1);
        if (reader == null) {
            this.setString(paramIndex, null);
            return;
        }
        int index = paramIndex - 1;
        short form = 2;
        if (this.binds_in != null) {
            form = this.binds_in.getFormOfUse(index);
        }
        InputStream converted_stream = this.connection.conversion.ConvertStream(reader, 7, length, form);
        int _minStreamSize = this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio() / this.connection.conversion.getMaxCharbyteSize();
        if (this.sql_kind == -1) {
            this.sql_kind = this.getSqlKind(this.sql_query);
        }
        if (this.sql_kind != 1) {
            if (this.sql_kind != 3 && length > _minStreamSize && this.isRegularResultSet()) {
                this.setStreamItem(index, 8, converted_stream, length * this.connection.conversion.getMaxCharbyteSize());
                return;
            }
        }
        try {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream(1024);
            byte[] _byteBuf = new byte[1024];
            while (true) {
                void var10_11;
                int _len;
                if ((_len = converted_stream.read(_byteBuf)) == -1) {
                    this.setItem(index, 1, outstream.toByteArray());
                    outstream.close();
                    return;
                }
                outstream.write(_byteBuf, 0, (int)var10_11);
            }
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return;
        }
    }

    public void setDate(int paramIndex, Date x, Calendar cal) throws SQLException {
        this.setDATE(paramIndex, x == null ? null : new DATE(x, cal));
    }

    public void setTime(int paramIndex, Time x, Calendar cal) throws SQLException {
        this.setDATE(paramIndex, x == null ? null : new DATE(x, cal));
    }

    public void setTimestamp(int paramIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.connection.m_v8compatible) {
            if (x == null) {
                this.setDATE(paramIndex, null);
            } else {
                DATE d2 = new DATE(x, cal);
                this.setDATE(paramIndex, d2);
            }
            return;
        }
        if (x == null) {
            this.setTIMESTAMP(paramIndex, null);
        } else {
            int nanos = x.getNanos();
            byte[] result = nanos == 0 ? new byte[7] : new byte[11];
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            cal.clear();
            cal.setTime(x);
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -(year - 1);
            }
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            if (nanos != 0) {
                result[7] = (byte)(nanos >> 24);
                result[8] = (byte)(nanos >> 16 & 0xFF);
                result[9] = (byte)(nanos >> 8 & 0xFF);
                result[10] = (byte)(nanos & 0xFF);
            }
            this.setTIMESTAMP(paramIndex, new TIMESTAMP(result));
        }
    }

    public void setCheckBindTypes(boolean flag) {
        this.check_bind_types = flag;
    }

    protected final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DBError.throwSqlException((int)90, (Object)"operation cannot be mixed with JDBC-2.0-style batching");
        } else if (this.m_batchStyle == 0 && OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"First detected Oracle-style batching");
        }
        this.m_batchStyle = 1;
    }

    protected final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException((int)90, (Object)"operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    protected final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DBError.throwSqlException((int)81, (Object)"batch must be either executed or cleared");
        }
    }

    private boolean doesJdbcBatchExist() {
        return this.m_currentRank > 0 && this.m_batchStyle == 2;
    }

    private boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    public synchronized void addBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.addBatch()");
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Add batch: m_currentRank=" + this.m_currentRank));
        }
        if (OracleLog.TRACE && this.m_batchStyle == 0) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)"First detected Jdbc-style batching");
        }
        this.setJdbcBatchStyle();
        this.binds_in.rowCompleted(-1);
        if (this.binds_in.hasStreamType()) {
            DBError.throwSqlException((int)90, (Object)"streams type cannot be used in batching");
        }
        this.checkBindsInAndOut();
        ++this.m_currentRank;
    }

    public synchronized void addBatch(String sql) throws SQLException {
        DBError.throwSqlException((int)23);
    }

    public synchronized void clearBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.clearBatch()");
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Clear batch: m_currentRank=" + this.m_currentRank));
        }
        if (this.binds_in != null && this.binds_in.getNoOfArgs() > 0) {
            this.binds_in.clearItems();
        }
        this.m_currentRank = 0;
        this.clear_params = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int[] ret_array;
                int i2;
                block21: {
                    block20: {
                        i2 = 0;
                        if (OracleLog.TRACE) {
                            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OraclePreparedStatement.executeBatch()");
                            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Execute batch: m_currentRank=" + this.m_currentRank));
                        }
                        this.setJdbcBatchStyle();
                        if (this.m_currentRank == 0) {
                            return new int[0];
                        }
                        ret_array = new int[this.m_currentRank];
                        this.open();
                        this.ensureOpen();
                        this.prepare_for_new_result(true);
                        if (this.sql_string_changed) {
                            this.parseSqlKind();
                        }
                        if (this.sql_kind == 0) {
                            DBError.throwBatchUpdateException((int)80, (int)0, null);
                        }
                        this.noMoreUpdateCounts = false;
                        try {
                            Object var8_6;
                            SQLException e22;
                            block19: {
                                try {
                                    this.need_to_parse = true;
                                    this.doExecuteOther(true);
                                }
                                catch (SQLException e22) {
                                    i2 = 0;
                                    break block19;
                                }
                                var8_6 = null;
                                break block20;
                            }
                            while (true) {
                                if (i2 >= ret_array.length) break;
                                ret_array[i2] = -3;
                                ++i2;
                            }
                            DBError.throwBatchUpdateException((SQLException)e22, (int)ret_array.length, (int[])ret_array);
                            var8_6 = null;
                            this.cleanupForBatching();
                            break block21;
                        }
                        catch (Throwable throwable) {
                            Object var8_7 = null;
                            this.cleanupForBatching();
                            throw throwable;
                        }
                    }
                    this.cleanupForBatching();
                }
                if (this.valid_rows < 0) {
                    i2 = 0;
                    while (true) {
                        if (i2 >= ret_array.length) {
                            DBError.throwBatchUpdateException((int)81, (int)0, (int[])ret_array);
                            break;
                        }
                        ret_array[i2] = -3;
                        ++i2;
                    }
                }
                i2 = 0;
                while (i2 < ret_array.length) {
                    ret_array[i2] = -2;
                    ++i2;
                }
                return ret_array;
            }
        }
    }

    public DBDataSet getBinds() {
        return this.m_binds;
    }

    void scrollStmt_cleanup(boolean cleanSql) throws SQLException {
        this.m_binds = null;
        super.scrollStmt_cleanup(cleanSql);
    }

    private int doScrollPstmtExecuteUpdate() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.doScrollPstmtExecuteUpdate()");
        }
        this.scrollStmt_cleanup(false);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        boolean success = true;
        String _errMsg = null;
        if (!this.m_needToAddIdentifier) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql((String)this.m_originalSql);
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("revisedSql:<" + this.m_revisedSql + ">"));
                }
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_revisedSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.prepare_for_new_result(true);
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
            }
            catch (SQLException e2) {
                if (OracleLog.TRACE) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e2.printStackTrace(pw);
                    OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)sw.toString());
                }
                success = false;
                _errMsg = e2.getMessage();
                this.m_binds = this.binds_in;
            }
            if (success) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("RsetType:<" + this.m_realRsetType + ">"));
                }
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_originalSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.prepare_for_new_result(true);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, (OracleStatement)this);
                success = true;
            }
        }
        if (this.current_result_set == null || !success) {
            DBError.check_error((int)1, (Object)"Unable to create result set");
        } else {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (int)91, (Object)_errMsg);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
        }
        this.m_scrollRsetTypeSolved = true;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OraclePreparedStatement.doScrollPstmtExecuteUpdate():return");
        }
        return this.valid_rows;
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_in != null) {
            this.binds_in.cleanup();
        }
        this.clear_params = true;
    }

    public synchronized void setDisableStmtCaching(boolean cache) {
        if (cache) {
            this.cacheState = OracleStatement.NON_CACHED;
        }
    }

    public synchronized void setFormOfUse(int paramIndex, short formOfUse) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OraclePreparedStatement.setFormOfUse(paramIndex=" + paramIndex + ", formOfUse=" + formOfUse + ")"));
        }
        this.binds_in.setFormOfUse(paramIndex, formOfUse);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new oracle.jdbc.driver.OracleParameterMetaData(this.parameterCount);
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    static {
        BSTYLE_UNKNOWN = 0;
        BSTYLE_ORACLE = 1;
        BSTYLE_JDBC = 2;
    }
}

