/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import oracle.jdbc.driver.OracleDriver;

public class OracleLog {
    public static final int MASK_ALL_SET = 0xFFFFFFF;
    public static final int MAX_VECTOR_BITS = 32;
    public static final int MAX_MODULES = 32;
    public static final int MODULE_ALL = 0xFFFFFFF;
    public static final int MODULE_DRIVER = 1;
    public static final int MODULE_DBACCESS = 2;
    public static final int MODULE_DBCONV = 4;
    public static final int MODULE_JOLT = 8;
    public static final int MODULE_PICKLE = 16;
    public static final int MODULE_JTTC = 32;
    public static final int MODULE_DATUM = 64;
    public static final int MODULE_KPRB = 128;
    public static final int MODULE_XA = 256;
    public static final int MODULE_SQLJ = 512;
    public static final int MODULE_JOCI = 1024;
    public static final int MODULE_JPUB = 2048;
    public static final int MODULE_TOTAL = 12;
    public static final String[] ModuleName;
    public static final int SUBMOD_ALL = 0xFFFFFFF;
    public static final int SUBMOD_DEFAULT = 1;
    public static final int SUBMOD_DRVR_LOG = 2;
    public static final int SUBMOD_DRVR_ERR = 4;
    public static final int SUBMOD_DRVR_CONN = 8;
    public static final int SUBMOD_DRVR_STMT = 16;
    public static final int SUBMOD_DRVR_RSET = 32;
    public static final int SUBMOD_DRVR_UTIL = 64;
    public static final int SUBMOD_DRVR_SQL = 128;
    public static final int SUBMOD_DRVR_RWST = 256;
    public static final int SUBMOD_DRVR_POOL = 512;
    public static final int SUBMOD_DRVR_SCCH = 1024;
    public static final int SUBMOD_DBAC_DATA = 2;
    public static final int SUBMOD_PCKL_INIT = 2;
    public static final int SUBMOD_PCKL_TYPE = 4;
    public static final int SUBMOD_PCKL_PCKL = 8;
    public static final int SUBMOD_PCKL_UNPK = 16;
    public static final int SUBMOD_PCKL_CONV = 32;
    public static final int SUBMOD_PCKL_DESC = 64;
    public static final int SUBMOD_PCKL_PARS = 128;
    public static final int SUBMOD_PCKL_SERL = 256;
    public static final int SUBMOD_JOLT_COMM = 2;
    public static final int SUBMOD_JOLT_BASE = 4;
    public static final int SUBMOD_JOLT_JDBC = 8;
    public static final int SUBMOD_JTTC_BASE = 2;
    public static final int SUBMOD_JTTC_TX = 4;
    public static final int SUBMOD_JTTC_RX = 8;
    public static final int SUBMOD_JTTC_MARS = 16;
    public static final int SUBMOD_JTTC_UNMA = 32;
    public static final int SUBMOD_JTTC_CONN = 64;
    public static final int SUBMOD_JTTC_COMM = 128;
    public static final int SUBMOD_JTTC_DBAC = 256;
    public static final int SUBMOD_JTTC_LOBS = 512;
    public static final int SUBMOD_JTTC_ADTS = 1024;
    public static final int SUBMOD_KPRB_ERR = 2;
    public static final int SUBMOD_KPRB_CONN = 4;
    public static final int SUBMOD_KPRB_STMT = 8;
    public static final int SUBMOD_KPRB_RSET = 16;
    public static final int SUBMOD_KPRB_UTIL = 32;
    public static final int SUBMOD_KPRB_SQL = 64;
    public static final int SUBMOD_KPRB_DATA = 128;
    public static final int SUBMOD_KPRB_CONV = 256;
    public static final int SUBMOD_XA_DSRC = 2;
    public static final int SUBMOD_XA_CONN = 4;
    public static final int SUBMOD_XA_RSRC = 8;
    public static final int SUBMOD_XA_ARGS = 16;
    public static final int SUBMOD_XA_EXC = 32;
    public static final int SUBMOD_XA_XID = 64;
    public static final int SUBMOD_XA_HCON = 128;
    public static final int SUBMOD_XA_HCCB = 256;
    public static final int SUBMOD_XA_HRSC = 512;
    public static final int SUBMOD_SQLJ_RUN = 2;
    public static final int SUBMOD_JOCI_ACCS = 2;
    public static final int SUBMOD_JOCI_DSET = 4;
    public static final int SUBMOD_JOCI_ITEM = 8;
    public static final int SUBMOD_JOCI_STMT = 16;
    public static final int SUBMOD_JOCI_TYPE = 32;
    public static final int SUBMOD_JOCI_ENV = 64;
    public static final int SUBMOD_JPUB_RUNTIME = 2;
    public static final int CATEGORY_ALL = 0xFFFFFFF;
    public static final int USER_OPER = 1;
    public static final int PROG_ERROR = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 8;
    public static final int FUNCTION = 16;
    public static final int DEBUG1 = 32;
    public static final int DEBUG2 = 64;
    public static final int SQL_STR = 128;
    public static final int CATEGORY_TOTAL = 8;
    public static final String[] CategoryName;
    public static final int CATEGORY_LOW_VOL = 142;
    public static final int CATEGORY_MED_VOL = 143;
    public static final int CATEGORY_HIGH_VOL = 0xFFFFFFF;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_ALL = 0xFFFFFFF;
    public static final int FIELD_NUMBER = 1;
    public static final int FIELD_TIME = 2;
    public static final int FIELD_MODULE = 4;
    public static final int FIELD_SUBMOD = 8;
    public static final int FIELD_CATEGORY = 16;
    public static final int FIELD_OBJECT = 32;
    public static final int FIELD_THREAD = 64;
    public static final int FIELD_DEFAULT = 20;
    public static boolean TRACE;
    public static final boolean PRIVATE_TRACE = false;
    private static PrintWriter m_logWriter;
    private static PrintStream m_logStream;
    private static int m_printMask;
    private static int m_moduleMask;
    private static int[] m_submodMasks;
    private static int m_categoryMask;
    private static int m_maxPrintBytes;
    private static boolean m_warningEnabled;
    private static int m_msgNumber;
    static boolean m_security_exception_getting_system_properties;

    public static boolean isDebugZip() {
        boolean ret_val = true;
        return ret_val;
    }

    public static boolean isPrivateLogAvailable() {
        boolean ret_val = true;
        ret_val = false;
        return ret_val;
    }

    public static boolean isEnabled() {
        return TRACE;
    }

    public static void setLogWriter(PrintWriter out) {
        if (!OracleLog.isDebugZip()) {
            if (out != null) {
                out.println("Oracle Jdbc tracing is not avaliable in a non-debug zip/jar file");
                out.flush();
            }
            return;
        }
        if (out == null) {
            OracleLog.setTrace(false);
            OracleLog.print(null, (int)1, (int)2, (int)1, (String)OracleLog.info());
            m_logWriter = out;
        } else {
            OracleLog.setTrace(true);
            m_logWriter = out;
            OracleLog.print(null, (int)1, (int)2, (int)1, (String)OracleLog.info());
            if (m_security_exception_getting_system_properties) {
                OracleLog.print(null, (int)1, (int)2, (int)32, (String)"A security exception occured when attempt to get System properties. This will occur in an applet environment");
            }
        }
    }

    public static PrintWriter getLogWriter() {
        return m_logWriter;
    }

    public static void setLogStream(PrintStream out) {
        if (out == null) {
            OracleLog.setLogWriter(null);
        } else {
            OracleLog.setLogWriter((PrintWriter)new PrintWriter(out));
        }
        m_logStream = out;
    }

    public static PrintStream getLogStream() {
        return m_logStream;
    }

    public static void enableWarning(boolean enable) {
        m_warningEnabled = enable;
    }

    public static void setLogVolume(int level) {
        OracleLog.print(null, (int)1, (int)2, (int)1, (String)("Set logging volume level to " + level));
        int category = 142;
        switch (level) {
            case 1: {
                category = 142;
                break;
            }
            case 2: {
                category = 143;
                break;
            }
            case 3: {
                category = 0xFFFFFFF;
                break;
            }
            default: {
                OracleLog.print(null, (int)1, (int)2, (int)4, (String)("Logging volume level " + level + " is not in the range of 1 to 3"));
                return;
            }
        }
        OracleLog.config((int)m_printMask, (int)m_moduleMask, (int)category);
    }

    public static void startLogging() {
        OracleLog.setLogStream((PrintStream)System.out);
    }

    public static void stopLogging() {
        OracleLog.setLogStream(null);
    }

    public static void config(int printMask, int moduleMask, int categoryMask) {
        m_printMask = printMask;
        m_moduleMask = moduleMask;
        m_categoryMask = categoryMask;
        OracleLog.print(null, (int)1, (int)2, (int)1, (String)("Set logging masks (printMask " + OracleLog.getMaskHexStr((int)m_printMask) + ", moduleMask " + OracleLog.getMaskHexStr((int)m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr((int)m_categoryMask) + ")"));
    }

    public static void setSubmodMask(int module, int submodMask) {
        int mod_num = OracleLog.getBitNumFromVector((int)module);
        OracleLog.m_submodMasks[mod_num] = submodMask;
        OracleLog.print(null, (int)1, (int)2, (int)1, (String)("Set logging sub-mask for module " + OracleLog.getMaskHexStr((int)m_moduleMask) + "(number " + mod_num + ") to " + OracleLog.getMaskHexStr((int)submodMask)));
    }

    public static void setMaxPrintBytes(int maxbytes) {
        if (maxbytes > 0) {
            m_maxPrintBytes = maxbytes;
        }
        OracleLog.print(null, (int)1, (int)2, (int)1, (String)("Set the maximum number of bytes to be printed to " + m_maxPrintBytes));
    }

    private static void setTrace(boolean enable) {
        TRACE = enable;
    }

    public static void setPrivateTrace(boolean enable) {
        boolean bl = enable;
    }

    private static void initialize() {
        OracleLog.internalCodeChecks();
        OracleLog.setupFromSystemProperties();
    }

    private static void internalCodeChecks() {
        if (ModuleName.length != 12) {
            System.out.println("ERROR: OracleLog.ModuleName[] has " + ModuleName.length + " items (expected " + 12 + ")");
        }
        if (CategoryName.length != 8) {
            System.out.println("ERROR: OracleLog.CategoryName[] has " + ModuleName.length + " items (expected " + 12 + ")");
        }
    }

    public static void setupFromSystemProperties() {
        boolean turnLoggingOn = false;
        m_security_exception_getting_system_properties = false;
        PrintStream logStream = System.out;
        try {
            String prop_str = null;
            prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.LogFile");
            if (prop_str != null) {
                try {
                    File f2 = new File(prop_str);
                    logStream = new PrintStream(new FileOutputStream(f2));
                    turnLoggingOn = true;
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.out);
                }
            }
            if ((prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.Trace")) != null && prop_str.compareTo("true") == 0) {
                turnLoggingOn = true;
            }
            if ((prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.PrintMask")) != null) {
                m_printMask = Integer.parseInt(prop_str, 16);
                turnLoggingOn = true;
            }
            if ((prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.PrintFields")) != null) {
                if (prop_str.equalsIgnoreCase("default")) {
                    m_printMask = 20;
                }
                if (prop_str.equalsIgnoreCase("all")) {
                    m_printMask = 0xFFFFFFF;
                }
                if (prop_str.equalsIgnoreCase("thread")) {
                    m_printMask = 84;
                }
                if (prop_str.equalsIgnoreCase("none")) {
                    m_printMask = 0;
                }
                turnLoggingOn = true;
            }
            if ((prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.ModuleMask")) != null) {
                m_moduleMask = Integer.parseInt(prop_str, 16);
                turnLoggingOn = true;
            }
            if ((prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.CategoryMask")) != null) {
                m_categoryMask = Integer.parseInt(prop_str, 16);
                turnLoggingOn = true;
            }
            int i2 = 0;
            while (i2 < 32) {
                prop_str = OracleDriver.getSystemProperty((String)("oracle.jdbc.SubmodMask" + i2));
                if (prop_str != null) {
                    OracleLog.m_submodMasks[i2] = Integer.parseInt(prop_str, 16);
                    turnLoggingOn = true;
                }
                ++i2;
            }
            prop_str = OracleDriver.getSystemProperty((String)"oracle.jdbc.MaxPrintBytes");
            if (prop_str != null) {
                m_maxPrintBytes = Integer.parseInt(prop_str, 10);
                turnLoggingOn = true;
            }
        }
        catch (SecurityException e2) {
            m_security_exception_getting_system_properties = true;
        }
        if (turnLoggingOn) {
            OracleLog.setLogStream((PrintStream)logStream);
        }
    }

    public static void print(Object thisObject, int module, int submodule, int category, String message) {
        if (m_logWriter == null) {
            return;
        }
        boolean show_output = false;
        if ((module & m_moduleMask) != 0 && (submodule & m_submodMasks[OracleLog.getBitNumFromVector((int)module)]) != 0 && (category & m_categoryMask) != 0) {
            show_output = true;
        }
        if ((category & 4) != 0) {
            show_output = true;
        }
        if (m_warningEnabled && (category & 8) != 0) {
            show_output = true;
        }
        if (show_output) {
            StringBuffer strbuf = new StringBuffer("");
            if ((m_printMask & 1) != 0) {
                strbuf.append(OracleLog.getMessageNumber());
            }
            if ((m_printMask & 2) != 0) {
                strbuf.append(OracleLog.getCurrTimeStr());
            }
            if ((m_printMask & 4) != 0) {
                strbuf.append(OracleLog.getModuleName((int)module));
            }
            if ((m_printMask & 8) != 0) {
                strbuf.append(OracleLog.getBitNumFromVector((int)submodule) + " ");
            }
            if ((m_printMask & 0x10) != 0) {
                strbuf.append(OracleLog.getCategoryName((int)category));
            }
            if ((m_printMask & 0x40) != 0) {
                strbuf.append(Thread.currentThread() + "_" + Thread.currentThread().hashCode() + "_");
            }
            strbuf.append(message);
            if ((m_printMask & 0x20) != 0) {
                strbuf.append(" " + thisObject);
            }
            if (m_logStream == System.out) {
                m_logWriter.println();
            }
            m_logWriter.println(strbuf.toString());
            m_logWriter.flush();
        }
    }

    public static void print(Object thisObject, int module, int submodule, int category, String message, Exception exception) {
        if (m_logWriter == null) {
            return;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        OracleLog.print((Object)thisObject, (int)module, (int)submodule, (int)category, (String)(message + sw.toString()));
    }

    public static void print(Object thisObject, int module, int category, String message) {
        OracleLog.print((Object)thisObject, (int)module, (int)1, (int)category, (String)message);
    }

    public static String info() {
        String ret_str = null;
        ret_str = OracleLog.isEnabled() ? "Enabled logging (moduleMask " + OracleLog.getMaskHexStr((int)m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr((int)m_categoryMask) + ")" : "Disabled logging";
        return ret_str;
    }

    public static String getModuleName(int module) {
        String ret_str = null;
        int mask = 1;
        int i2 = 0;
        while (i2 < 12) {
            if ((mask & module) != 0) {
                ret_str = ModuleName[i2];
                break;
            }
            mask <<= 1;
            ++i2;
        }
        return ret_str;
    }

    public static String getCategoryName(int category) {
        String ret_str = null;
        int mask = 1;
        int i2 = 0;
        while (i2 < 8) {
            if ((mask & category) != 0) {
                ret_str = CategoryName[i2];
                break;
            }
            mask <<= 1;
            ++i2;
        }
        return ret_str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMessageNumber() {
        int num_str_len;
        int num;
        StringBuffer str_buf = new StringBuffer("");
        PrintWriter printWriter = m_logWriter;
        synchronized (printWriter) {
            m_msgNumber = m_msgNumber == Integer.MAX_VALUE ? 0 : ++m_msgNumber;
            num = m_msgNumber;
        }
        String num_str = Integer.toString(num);
        int i2 = num_str_len = num_str.length();
        while (i2 < 10) {
            str_buf.append("0");
            ++i2;
        }
        str_buf.append(num_str);
        str_buf.append(" ");
        return str_buf.toString();
    }

    private static String getCurrTimeStr() {
        Date date = new Date();
        return date.toString() + " ";
    }

    public static String getMaskHexStr(int mask) {
        int n_nibbles = 8;
        String hex_str = Integer.toHexString(mask);
        char[] pad_array = new char[n_nibbles - hex_str.length()];
        int i2 = 0;
        while (i2 < pad_array.length) {
            pad_array[i2] = 48;
            ++i2;
        }
        String pad_str = new String(pad_array);
        return new String("0x" + pad_str + hex_str);
    }

    public static int getBitNumFromVector(int bitVector) {
        int bit_num = 0;
        int test_mask = 1;
        int i2 = 0;
        while (i2 < 32) {
            if ((bitVector & test_mask) != 0) {
                bit_num = i2;
                break;
            }
            test_mask <<= 1;
            ++i2;
        }
        return bit_num;
    }

    public static String byteToHexString(byte b2) {
        StringBuffer buf = new StringBuffer("");
        int b_value = 0xFF & b2;
        if (b_value <= 15) {
            buf.append("0x0");
        } else {
            buf.append("0x");
        }
        buf.append(Integer.toHexString(b_value));
        return buf.toString();
    }

    public static String bytesToPrintableForm(String header, byte[] bytes) {
        int bytes_len = bytes == null ? 0 : bytes.length;
        return OracleLog.bytesToPrintableForm(header, bytes, bytes_len);
    }

    public static String bytesToPrintableForm(String header, byte[] bytes, int nbytes) {
        String ret_str = null;
        ret_str = bytes == null ? header + ": null" : header + " (" + bytes.length + " bytes):\n" + OracleLog.bytesToFormattedStr(bytes, nbytes, "  ");
        return ret_str;
    }

    public static String bytesToFormattedStr(byte[] bytes, int nbytes, String margin) {
        StringBuffer buf = new StringBuffer("");
        if (margin == null) {
            margin = new String("");
        }
        buf.append(margin);
        if (bytes == null) {
            buf.append("byte [] is null");
            return buf.toString();
        }
        int i2 = 0;
        while (i2 < nbytes) {
            int b_value;
            if (i2 >= m_maxPrintBytes) {
                buf.append("\n" + margin + "... last " + (nbytes - m_maxPrintBytes) + " bytes were not printed to limit the output size");
                break;
            }
            if (i2 > 0 && i2 % 20 == 0) {
                buf.append("\n" + margin);
            }
            if (i2 % 20 == 10) {
                buf.append(" ");
            }
            if ((b_value = 0xFF & bytes[i2]) <= 15) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(b_value) + " ");
            ++i2;
        }
        return buf.toString();
    }

    public static byte[] strToUcs2Bytes(String str) {
        if (str == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(str.toCharArray());
    }

    public static byte[] charsToUcs2Bytes(char[] chars) {
        if (chars == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(chars, chars.length);
    }

    public static byte[] charsToUcs2Bytes(char[] chars, int nchars) {
        if (chars == null) {
            return null;
        }
        if (nchars < 0) {
            return null;
        }
        byte[] bytes = new byte[2 * nchars];
        int char_i = 0;
        int byte_i = 0;
        while (char_i < nchars) {
            bytes[byte_i++] = (byte)(chars[char_i] >> 8 & 0xFF);
            bytes[byte_i++] = (byte)(chars[char_i] & 0xFF);
            ++char_i;
        }
        return bytes;
    }

    public static String toPrintableStr(String str, int maxchars) {
        if (str == null) {
            return "null";
        }
        if (str.length() > maxchars) {
            return str.substring(0, maxchars - 1) + "\n ... the actual length was " + str.length();
        }
        return str;
    }

    static {
        MASK_ALL_SET = 0xFFFFFFF;
        MAX_VECTOR_BITS = 32;
        MAX_MODULES = 32;
        MODULE_ALL = 0xFFFFFFF;
        MODULE_DRIVER = 1;
        MODULE_DBACCESS = 2;
        MODULE_DBCONV = 4;
        MODULE_JOLT = 8;
        MODULE_PICKLE = 16;
        MODULE_JTTC = 32;
        MODULE_DATUM = 64;
        MODULE_KPRB = 128;
        MODULE_XA = 256;
        MODULE_SQLJ = 512;
        MODULE_JOCI = 1024;
        MODULE_JPUB = 2048;
        MODULE_TOTAL = 12;
        ModuleName = new String[]{"DRVR ", "DBAC ", "DBCV ", "JOLT ", "PIKL ", "JTTC ", "DATM ", "KPRB ", "XA   ", "SQLJ ", "JOCI ", "JPUB "};
        SUBMOD_ALL = 0xFFFFFFF;
        SUBMOD_DEFAULT = 1;
        SUBMOD_DRVR_LOG = 2;
        SUBMOD_DRVR_ERR = 4;
        SUBMOD_DRVR_CONN = 8;
        SUBMOD_DRVR_STMT = 16;
        SUBMOD_DRVR_RSET = 32;
        SUBMOD_DRVR_UTIL = 64;
        SUBMOD_DRVR_SQL = 128;
        SUBMOD_DRVR_RWST = 256;
        SUBMOD_DRVR_POOL = 512;
        SUBMOD_DRVR_SCCH = 1024;
        SUBMOD_DBAC_DATA = 2;
        SUBMOD_PCKL_INIT = 2;
        SUBMOD_PCKL_TYPE = 4;
        SUBMOD_PCKL_PCKL = 8;
        SUBMOD_PCKL_UNPK = 16;
        SUBMOD_PCKL_CONV = 32;
        SUBMOD_PCKL_DESC = 64;
        SUBMOD_PCKL_PARS = 128;
        SUBMOD_PCKL_SERL = 256;
        SUBMOD_JOLT_COMM = 2;
        SUBMOD_JOLT_BASE = 4;
        SUBMOD_JOLT_JDBC = 8;
        SUBMOD_JTTC_BASE = 2;
        SUBMOD_JTTC_TX = 4;
        SUBMOD_JTTC_RX = 8;
        SUBMOD_JTTC_MARS = 16;
        SUBMOD_JTTC_UNMA = 32;
        SUBMOD_JTTC_CONN = 64;
        SUBMOD_JTTC_COMM = 128;
        SUBMOD_JTTC_DBAC = 256;
        SUBMOD_JTTC_LOBS = 512;
        SUBMOD_JTTC_ADTS = 1024;
        SUBMOD_KPRB_ERR = 2;
        SUBMOD_KPRB_CONN = 4;
        SUBMOD_KPRB_STMT = 8;
        SUBMOD_KPRB_RSET = 16;
        SUBMOD_KPRB_UTIL = 32;
        SUBMOD_KPRB_SQL = 64;
        SUBMOD_KPRB_DATA = 128;
        SUBMOD_KPRB_CONV = 256;
        SUBMOD_XA_DSRC = 2;
        SUBMOD_XA_CONN = 4;
        SUBMOD_XA_RSRC = 8;
        SUBMOD_XA_ARGS = 16;
        SUBMOD_XA_EXC = 32;
        SUBMOD_XA_XID = 64;
        SUBMOD_XA_HCON = 128;
        SUBMOD_XA_HCCB = 256;
        SUBMOD_XA_HRSC = 512;
        SUBMOD_SQLJ_RUN = 2;
        SUBMOD_JOCI_ACCS = 2;
        SUBMOD_JOCI_DSET = 4;
        SUBMOD_JOCI_ITEM = 8;
        SUBMOD_JOCI_STMT = 16;
        SUBMOD_JOCI_TYPE = 32;
        SUBMOD_JOCI_ENV = 64;
        SUBMOD_JPUB_RUNTIME = 2;
        CATEGORY_ALL = 0xFFFFFFF;
        USER_OPER = 1;
        PROG_ERROR = 2;
        ERROR = 4;
        WARNING = 8;
        FUNCTION = 16;
        DEBUG1 = 32;
        DEBUG2 = 64;
        SQL_STR = 128;
        CATEGORY_TOTAL = 8;
        CategoryName = new String[]{"OPER ", "PERR ", "ERRO ", "WARN ", "FUNC ", "DBG1 ", "DBG2 ", "SQLS "};
        CATEGORY_LOW_VOL = 142;
        CATEGORY_MED_VOL = 143;
        CATEGORY_HIGH_VOL = 0xFFFFFFF;
        FIELD_NONE = 0;
        FIELD_ALL = 0xFFFFFFF;
        FIELD_NUMBER = 1;
        FIELD_TIME = 2;
        FIELD_MODULE = 4;
        FIELD_SUBMOD = 8;
        FIELD_CATEGORY = 16;
        FIELD_OBJECT = 32;
        FIELD_THREAD = 64;
        FIELD_DEFAULT = 20;
        TRACE = false;
        PRIVATE_TRACE = false;
        m_logWriter = null;
        m_logStream = null;
        m_printMask = 20;
        m_moduleMask = 0xFFFFFFF;
        m_submodMasks = null;
        m_categoryMask = 143;
        m_maxPrintBytes = 200;
        m_warningEnabled = true;
        m_msgNumber = 0;
        m_submodMasks = new int[32];
        int i2 = 0;
        while (i2 < 32) {
            OracleLog.m_submodMasks[i2] = 0xFFFFFFF;
            ++i2;
        }
        OracleLog.initialize();
    }
}

