/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;

public class OracleInputStream
extends OracleBufferedStream {
    boolean isNull;
    OracleStatement statement;
    int columnIndex;
    OracleInputStream previous_stream;

    public OracleInputStream(OracleStatement stmt, int index, OracleInputStream previous) {
        super(stmt.connection.db_access.getDefaultStreamChunkSize());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleInputStream.OracleInputStream(stmt, index)");
        }
        this.closed = true;
        this.previous_stream = previous;
        this.statement = stmt;
        this.columnIndex = index;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleInputStream.OracleInputStream:return");
        }
    }

    public boolean needBytes() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("OIS.needBytes: closed = " + this.closed + " index = " + this.columnIndex));
        }
        if (this.closed) {
            return false;
        }
        if (this.pos >= this.count) {
            try {
                int readLength = this.statement.connection.db_access.read(this.statement.dbstmt, this.buf, this.chunkSize, this.columnIndex);
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("OIS.needBytes: read = " + readLength));
                }
                this.pos = 0;
                this.count = readLength;
                if (this.count == -1) {
                    if (this.statement.streams == this) {
                        this.statement.connection.releaseLine();
                    }
                    this.closed = true;
                    this.statement.fetchNextColumns();
                    return false;
                }
            }
            catch (SQLException e2) {
                if (OracleLog.TRACE) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e2.printStackTrace(pw);
                    OracleLog.print((Object)this, (int)1, (int)16, (int)64, (String)sw.toString());
                }
                DBError.SQLToIOException((SQLException)e2);
            }
        }
        return true;
    }

    public boolean isNull() throws IOException {
        boolean result = false;
        try {
            result = this.statement.defines != null && this.statement.defines.getNoOfArgs() > 0 ? this.statement.defines.isNull(this.columnIndex - 1, 0) : this.statement.binds_out.isNull(this.columnIndex - 1, 0);
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
        return result;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.previous_stream != null) {
                this.previous_stream.close();
            }
            if (!this.isNull()) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Closing stream " + this));
                }
                while (this.needBytes()) {
                    this.pos = this.count;
                }
            }
            this.closed = true;
        }
    }

    public void resetLong() {
        if (this.previous_stream != null) {
            this.previous_stream.resetLong();
        }
        this.count = 0;
        this.pos = 0;
        this.closed = false;
    }
}

