/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oci.OracleOCIConnection;

public class OracleDriver
implements Driver {
    public static final char slash_character = '/';
    public static final char at_sign_character = '@';
    static final String oracle_string = "oracle";
    public static final String user_string = "user";
    public static final String password_string = "password";
    public static final String database_string = "database";
    static final String server_string = "server";
    static final String access_string = "access";
    public static final String protocol_string = "protocol";
    public static final String dll_string = "dll";
    public static final String logon_as_internal_str = "internal_logon";
    static final String prefetch_string = "prefetch";
    static final String row_prefetch_string = "rowPrefetch";
    static final String default_row_prefetch_string = "defaultRowPrefetch";
    static final String batch_string = "batch";
    static final String execute_batch_string = "executeBatch";
    static final String default_execute_batch_string = "defaultExecuteBatch";
    public static final String process_escapes_string = "processEscapes";
    public static final String permit_timestamp_date_mismatch_string = "oracle.jdbc.internal.permitBindDateDefineTimestampMismatch";
    public static final String dms_parent_name_string = "DMSName";
    public static final String dms_parent_type_string = "DMSType";
    public static final String dms_stmt_metrics_string = "oracle.jdbc.DMSStatementMetrics";
    public static final String dms_stmt_caching_metrics_string = "oracle.jdbc.DMSStatementCachingMetrics";
    static final String accumulate_batch_result = "AccumulateBatchResult";
    public static final String j2ee_compliance = "oracle.jdbc.J2EE13Compliant";
    public static final String v8compatible_string = "oracle.jdbc.V8Compatible";
    static final String remarks_string = "remarks";
    static final String report_remarks_string = "remarksReporting";
    public static final String tcp_no_delay = "oracle.jdbc.TcpNoDelay";
    public static final String no_caching_buffers = "oracle.jdbc.FreeMemoryOnEnterImplicitCache";
    public static final String synonyms_string = "synonyms";
    public static final String include_synonyms_string = "includeSynonyms";
    public static final String restrict_getTables_string = "restrictGetTables";
    public static final String fixed_string_string = "fixedString";
    public static final String StreamChunkSize_string = "oracle.jdbc.StreamChunkSize";
    private static final int ACCEPTS_URL_GEN_ERROR = 1;
    private static final int ACCEPTS_URL_ORACLE_ERROR = 2;
    private static final int ACCEPTS_URL_SUCCESS = 3;
    private static final String DRIVER_ULTRA = "ultra";
    private static Properties m_driverAccess;
    protected static Connection m_defaultConn;
    private static OracleDriver m_defaultDriver;

    public Connection connect(String url, Properties info) throws SQLException {
        String j2ee_compliance_value;
        Driver driverobj;
        String v8compat_type;
        String synonyms;
        String remarks;
        String batch;
        String prefetch;
        int login_timeout_value;
        int flag;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleDriver.connect(url=" + url + ", info)"));
        }
        if (url.regionMatches(0, "jdbc:default:connection", 0, 23)) {
            String url1 = "jdbc:oracle:kprb";
            int l2 = url.length();
            url = l2 > 23 ? url1.concat(url.substring(23, url.length())) : url1.concat(":");
            url1 = null;
        }
        if ((flag = this.oracleAcceptsURL(url)) == 1) {
            return null;
        }
        if (flag == 2) {
            DBError.throwSqlException((int)67);
            return null;
        }
        Hashtable url_properties = this.parseUrl(url);
        if (url_properties == null) {
            return null;
        }
        String user = info.getProperty(user_string);
        String password = info.getProperty(password_string);
        String database = info.getProperty(database_string);
        if (database == null) {
            database = info.getProperty(server_string);
        }
        if (user == null) {
            user = (String)url_properties.get(user_string);
        }
        user = this.parseLoginOption(user, info);
        if (password == null) {
            password = (String)url_properties.get(password_string);
        }
        if (database == null) {
            database = (String)url_properties.get(database_string);
        }
        String protocol = (String)url_properties.get(protocol_string);
        info.put(protocol_string, protocol);
        if (protocol == null) {
            DBError.throwSqlException((int)40, (Object)"Protocol is not specified in URL");
            return null;
        }
        String dll_str = info.getProperty(dll_string);
        if (dll_str == null) {
            info.put(dll_string, "ocijdbc9");
        }
        if ((login_timeout_value = DriverManager.getLoginTimeout()) != 0 && info.get("oracle.net.CONNECT_TIMEOUT") == null) {
            info.put("oracle.net.CONNECT_TIMEOUT", "" + login_timeout_value * 1000);
        }
        if ((prefetch = info.getProperty(prefetch_string)) == null) {
            prefetch = info.getProperty(row_prefetch_string);
        }
        if (prefetch == null) {
            prefetch = info.getProperty(default_row_prefetch_string);
        }
        if (prefetch != null && Integer.parseInt(prefetch) <= 0) {
            prefetch = null;
        }
        if ((batch = info.getProperty(batch_string)) == null) {
            batch = info.getProperty(execute_batch_string);
        }
        if (batch == null) {
            batch = info.getProperty(default_execute_batch_string);
        }
        if (batch != null && Integer.parseInt(batch) <= 0) {
            batch = null;
        }
        if ((remarks = info.getProperty(remarks_string)) == null) {
            remarks = info.getProperty(report_remarks_string);
        }
        if ((synonyms = info.getProperty(synonyms_string)) == null) {
            synonyms = info.getProperty(include_synonyms_string);
        }
        String restrict_getTables = info.getProperty(restrict_getTables_string);
        String fixedString = info.getProperty(fixed_string_string);
        String dataSizeUnits = info.getProperty("dataSizeUnits");
        String batching_type = info.getProperty(accumulate_batch_result);
        if (batching_type == null) {
            batching_type = "true";
        }
        if ((v8compat_type = info.getProperty(v8compatible_string)) == null) {
            v8compat_type = "false";
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("user=" + user + ", password=" + password + ", database=" + database + ", protocol=" + protocol + ", dll_str=" + dll_str + ", prefetch=" + prefetch + ", batch=" + batch + ", accumulate batch result =" + batching_type + ", remarks=" + remarks + ", synonyms=" + synonyms));
        }
        Enumeration<Driver> enumdrivers = DriverManager.getDrivers();
        while (enumdrivers.hasMoreElements()) {
            driverobj = enumdrivers.nextElement();
            if (driverobj instanceof OracleDriver) break;
        }
        while (enumdrivers.hasMoreElements()) {
            driverobj = enumdrivers.nextElement();
            if (!(driverobj instanceof OracleDriver)) continue;
            DriverManager.deregisterDriver(driverobj);
        }
        String tcp_nodelay_value = info.getProperty(tcp_no_delay);
        if (tcp_nodelay_value == null) {
            tcp_nodelay_value = OracleDriver.getSystemProperty((String)tcp_no_delay);
        }
        if (tcp_nodelay_value != null && tcp_nodelay_value.equalsIgnoreCase("true")) {
            info.put("TCP.NODELAY", "YES");
        }
        Connection conn = this.getConnectionInstance(protocol, url, user, password, database, info);
        if (prefetch != null) {
            ((OracleConnection)conn).setDefaultRowPrefetch(Integer.parseInt(prefetch));
        }
        if (batch != null) {
            ((OracleConnection)conn).setDefaultExecuteBatch(Integer.parseInt(batch));
        }
        if (remarks != null) {
            ((OracleConnection)conn).setRemarksReporting(remarks.equalsIgnoreCase("true"));
        }
        if (synonyms != null) {
            ((OracleConnection)conn).setIncludeSynonyms(synonyms.equalsIgnoreCase("true"));
        }
        if (restrict_getTables != null) {
            ((OracleConnection)conn).setRestrictGetTables(restrict_getTables.equalsIgnoreCase("true"));
        }
        if (fixedString != null) {
            ((OracleConnection)conn).setDefaultFixedString(fixedString.equalsIgnoreCase("true"));
        }
        if (dataSizeUnits != null) {
            ((OracleConnection)conn).setDataSizeUnits(dataSizeUnits);
        }
        ((OracleConnection)conn).setAccumulateBatchResult(batching_type.equalsIgnoreCase("true"));
        ((OracleConnection)conn).m_v8compatible = v8compat_type.equalsIgnoreCase("true");
        String system_j2ee_compliance_value = OracleDriver.getSystemProperty((String)j2ee_compliance);
        if (system_j2ee_compliance_value == null) {
            j2ee_compliance_value = info.getProperty(j2ee_compliance);
            if (j2ee_compliance_value == null) {
                j2ee_compliance_value = "false";
            }
        } else {
            j2ee_compliance_value = system_j2ee_compliance_value;
        }
        ((OracleConnection)conn).setJ2EE13Compliant(j2ee_compliance_value.equalsIgnoreCase("true"));
        url_properties = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleDriver.connect(url,info):return");
        }
        return conn;
    }

    private Connection getConnectionInstance(String protocol, String url, String user, String password, String db, Properties info) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleDriver.getConnectionInstance(protocol, url=" + url + ", user=" + user + ")"));
        }
        Connection conn = null;
        if (protocol.compareTo(DRIVER_ULTRA) == 0) {
            try {
                Class<?>[] arg_types = null;
                Object[] arg_objects = new Object[]{protocol, url, user, password, db, info};
                Class<?> drv = Class.forName("oracle.jdbc.ultra.client.Driver");
                Method[] ms = drv.getMethods();
                int j2 = 0;
                while (j2 < ms.length) {
                    if (ms[j2].getName().equals("getConnection")) {
                        arg_types = ms[j2].getParameterTypes();
                        break;
                    }
                    ++j2;
                }
                Method m2 = drv.getMethod("getConnection", arg_types);
                conn = (Connection)m2.invoke(drv.newInstance(), arg_objects);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                DBError.throwSqlException((int)1);
            }
        } else {
            String temp_protocol = null;
            temp_protocol = protocol.equals("thin") && OracleDriver.getSystemProperty((String)"oracle.jserver.version") != null ? "thin-server" : ((protocol.equals("oci8") || protocol.equals("oci")) && OracleDriver.getSystemProperty((String)"oracle.jserver.version") != null ? "oci-server" : protocol);
            String access = (String)m_driverAccess.get(temp_protocol);
            if (access == null) {
                DBError.throwSqlException((int)67, (Object)("Invalid protocol " + protocol));
            }
            DBAccess accessor = null;
            try {
                accessor = (DBAccess)Class.forName(access).newInstance();
            }
            catch (Exception e3) {
                return null;
            }
            if (info.getProperty("is_connection_pooling") == "true") {
                info.put(database_string, db == null ? "" : db);
                conn = new OracleOCIConnection(accessor, url, user, password, db, info);
            } else {
                conn = new OracleConnection(accessor, url, user, password, db, info);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleDriver.getConnectionInstance(protocol, url, user):return");
        }
        return conn;
    }

    public Connection defaultConnection() throws SQLException {
        if (m_defaultConn == null || m_defaultConn.isClosed()) {
            m_defaultConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return m_defaultConn;
    }

    private int oracleAcceptsURL(String url) {
        int first_colon = url.indexOf(58);
        if (first_colon == -1) {
            return 1;
        }
        int second_colon = url.indexOf(58, first_colon + 1);
        if (second_colon == -1) {
            return 1;
        }
        if (!url.regionMatches(true, first_colon + 1, oracle_string, 0, second_colon - (first_colon + 1))) {
            return 1;
        }
        int third_colon = url.indexOf(58, second_colon + 1);
        if (third_colon == -1) {
            return 2;
        }
        String sub_name = url.substring(second_colon + 1, third_colon);
        if (sub_name.equals("oci8") || sub_name.equals("oci") || sub_name.equals("thin") || sub_name.equals("kprb") || sub_name.equals(DRIVER_ULTRA)) {
            return 3;
        }
        return 2;
    }

    public boolean acceptsURL(String url) {
        int flag = this.oracleAcceptsURL(url);
        return flag == 3;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private String parseLoginOption(String user, Properties info) {
        int i2 = 0;
        String userOnly = null;
        if (user == null) {
            return null;
        }
        int len = user.length();
        if (len == 0) {
            return null;
        }
        String lowerCaseUser = user.toLowerCase();
        i2 = lowerCaseUser.lastIndexOf(" as ");
        if (i2 == -1 || i2 < lowerCaseUser.lastIndexOf("\"")) {
            return user;
        }
        userOnly = user.substring(0, i2);
        i2 += 4;
        while (i2 < len && lowerCaseUser.charAt(i2) == ' ') {
            ++i2;
        }
        if (i2 == len) {
            return user;
        }
        String loginMode = lowerCaseUser.substring(i2).trim();
        if (loginMode.length() > 0) {
            info.put(logon_as_internal_str, loginMode);
        }
        return userOnly;
    }

    private Hashtable parseUrl(String url) throws SQLException {
        int end;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("OracleDriver.parseUrl(url=" + url + ")"));
        }
        Hashtable<String, String> result = new Hashtable<String, String>(5);
        int sub_sub_index = url.indexOf(58, url.indexOf(58) + 1) + 1;
        if (sub_sub_index == (end = url.length())) {
            return result;
        }
        int next_colon_index = url.indexOf(58, sub_sub_index);
        if (next_colon_index == -1) {
            return result;
        }
        result.put(protocol_string, url.substring(sub_sub_index, next_colon_index));
        int user = next_colon_index + 1;
        int slash = url.indexOf(47, user);
        int at_sign = url.indexOf(64, user);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("sub_sub_index=" + sub_sub_index + ", end=" + end + ", next_colon_index=" + next_colon_index + ", user=" + user + ", slash=" + slash + ", at_sign=" + at_sign));
        }
        if (at_sign > user && user > sub_sub_index && slash == -1) {
            return null;
        }
        if (at_sign == -1) {
            at_sign = end;
        }
        if (slash == -1) {
            slash = at_sign;
        }
        if (slash < at_sign) {
            result.put(user_string, url.substring(user, slash));
            result.put(password_string, url.substring(slash + 1, at_sign));
        }
        if (at_sign < end) {
            result.put(database_string, url.substring(at_sign + 1));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)"OracleDriver.parseUrl(url):return");
        }
        return result;
    }

    public static String getCompileTime() {
        String t = "Fri_Jun__9_04:48:44_PDT_2006-stint262-aime";
        return t;
    }

    public static String getSystemProperty(String str) {
        return OracleDriver.getSystemProperty((String)str, null);
    }

    public static String getSystemProperty(String str, String defaultValue) {
        try {
            return System.getProperty(str, defaultValue);
        }
        catch (SecurityException securityException) {
            return defaultValue;
        }
    }

    static {
        slash_character = (char)47;
        at_sign_character = (char)64;
        oracle_string = oracle_string;
        user_string = user_string;
        password_string = password_string;
        database_string = database_string;
        server_string = server_string;
        access_string = access_string;
        protocol_string = protocol_string;
        dll_string = dll_string;
        logon_as_internal_str = logon_as_internal_str;
        prefetch_string = prefetch_string;
        row_prefetch_string = row_prefetch_string;
        default_row_prefetch_string = default_row_prefetch_string;
        batch_string = batch_string;
        execute_batch_string = execute_batch_string;
        default_execute_batch_string = default_execute_batch_string;
        process_escapes_string = process_escapes_string;
        permit_timestamp_date_mismatch_string = permit_timestamp_date_mismatch_string;
        dms_parent_name_string = dms_parent_name_string;
        dms_parent_type_string = dms_parent_type_string;
        dms_stmt_metrics_string = dms_stmt_metrics_string;
        dms_stmt_caching_metrics_string = dms_stmt_caching_metrics_string;
        accumulate_batch_result = accumulate_batch_result;
        j2ee_compliance = j2ee_compliance;
        v8compatible_string = v8compatible_string;
        remarks_string = remarks_string;
        report_remarks_string = report_remarks_string;
        tcp_no_delay = tcp_no_delay;
        no_caching_buffers = no_caching_buffers;
        synonyms_string = synonyms_string;
        include_synonyms_string = include_synonyms_string;
        restrict_getTables_string = restrict_getTables_string;
        fixed_string_string = fixed_string_string;
        StreamChunkSize_string = StreamChunkSize_string;
        ACCEPTS_URL_GEN_ERROR = 1;
        ACCEPTS_URL_ORACLE_ERROR = 2;
        ACCEPTS_URL_SUCCESS = 3;
        DRIVER_ULTRA = DRIVER_ULTRA;
        m_driverAccess = new Properties();
        m_driverAccess.put("thin-server", "oracle.jdbc.thinserver.ServerTTC7Protocol");
        m_driverAccess.put("oci-server", "oracle.jdbc.ociserver.ServerOCIDBAccess");
        m_driverAccess.put("thin", "oracle.jdbc.ttc7.TTC7Protocol");
        m_driverAccess.put("oci8", "oracle.jdbc.oci8.OCIDBAccess");
        m_driverAccess.put("oci", "oracle.jdbc.oci8.OCIDBAccess");
        m_driverAccess.put("kprb", "oracle.jdbc.kprb.KprbDBAccess");
        m_defaultConn = null;
        m_defaultDriver = null;
        Timestamp ignore = Timestamp.valueOf("2000-01-01 00:00:00.0");
        try {
            if (m_defaultDriver == null) {
                m_defaultDriver = new OracleDriver();
                DriverManager.registerDriver(m_defaultDriver);
            }
        }
        catch (RuntimeException e2) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

