/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;

public class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 4096;
    DBConversion db_conversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;

    public OracleConversionReader(DBConversion conv_object, InputStream istream, int conversion) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionReader.OracleConversionReader(conv_object=" + conv_object + ", istream=" + istream + ", conversion=" + conversion + ") -- after super()"));
        }
        if (conv_object == null || istream == null || conversion != 8 && conversion != 9) {
            DBError.throwSqlException((int)68);
        }
        this.db_conversion = conv_object;
        this.conversion = conversion;
        this.istream = istream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        if (conversion == 8) {
            this.byteBuf = new byte[2048];
            this.buf = new char[4096];
        } else if (conversion == 9) {
            this.byteBuf = new byte[4096];
            this.buf = new char[4096];
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)"OracleConversionReader.OracleConversionReader: return");
        }
    }

    public void setFormOfUse(short csform) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionReader.setFormOfUse(csform=" + csform + ")"));
        }
        this.csform = csform;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleConversionReader.read(csform=" + this.csform + ")"));
        }
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int start = off;
        int end = start + Math.min(len, cbuf.length - off);
        start += this.writeChars(cbuf, start, end - start);
        while (start < end && this.needChars()) {
            start += this.writeChars(cbuf, start, end - start);
        }
        return start - off;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    int bytes_read = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                    if (bytes_read == -1) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            DBError.throwSqlException((int)55);
                        }
                    }
                    if ((bytes_read += this.numUnconvertedBytes) > 0) {
                        switch (this.conversion) {
                            case 8: {
                                this.count = DBConversion.RAWBytesToHexChars((byte[])this.byteBuf, (int)bytes_read, (char[])this.buf);
                                break;
                            }
                            case 9: {
                                int[] nbytes = new int[]{bytes_read};
                                this.count = this.csform == 2 ? this.db_conversion.NCHARBytesToJavaChars(this.byteBuf, nbytes, this.buf) : this.db_conversion.CHARBytesToJavaChars(this.byteBuf, nbytes, this.buf);
                                this.numUnconvertedBytes = nbytes[0];
                                int i2 = 0;
                                while (i2 < this.numUnconvertedBytes) {
                                    this.byteBuf[i2] = this.byteBuf[bytes_read - this.numUnconvertedBytes + i2];
                                    ++i2;
                                }
                                break;
                            }
                            default: {
                                DBError.throwSqlException((int)23);
                            }
                        }
                        if (this.count > 0) {
                            this.pos = 0;
                            return true;
                        }
                    }
                }
                catch (SQLException e2) {
                    DBError.SQLToIOException((SQLException)e2);
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] destbuf, int offset, int length) {
        int availableLength = Math.min(length, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    public boolean ready() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleConversionReader.ready()");
        }
        this.ensureOpen();
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleConversionReader.ready: return: " + (this.pos < this.count)));
        }
        return this.pos < this.count;
    }

    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleConversionReader.close(): isClosed=" + this.isClosed));
        }
        if (!this.isClosed) {
            this.isClosed = true;
            this.istream.close();
        }
    }

    void ensureOpen() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleConversionReader.ensureOpen(): isClosed=" + this.isClosed));
        }
        try {
            if (this.isClosed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    static {
        CHUNK_SIZE = 4096;
    }
}

