/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;

public class OracleConversionInputStream
extends OracleBufferedStream {
    static final int CHUNK_SIZE = 4096;
    DBConversion converter;
    int conversion;
    InputStream istream;
    Reader reader;
    byte[] convbuf;
    char[] java_chars;
    int max_size;
    int total_size;
    int numUnconvertedBytes;
    boolean endOfStream;
    private short csform;

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion) {
        super(4096);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionInputStream.OracleConversionInputStream(conv_object=" + conv_object + ", istream=" + istream + ", conversion=" + conversion + ") -- after super()"));
        }
        this.istream = istream;
        this.conversion = conversion;
        this.converter = conv_object;
        this.max_size = 0;
        this.total_size = 0;
        this.numUnconvertedBytes = 0;
        this.endOfStream = false;
        switch (conversion) {
            case 0: {
                this.java_chars = new char[4096];
                this.convbuf = new byte[4096];
                break;
            }
            case 1: {
                this.convbuf = new byte[2048];
                this.java_chars = new char[2048];
                break;
            }
            case 2: {
                this.convbuf = new byte[2048];
                this.java_chars = new char[4096];
                break;
            }
            case 3: {
                this.convbuf = new byte[1024];
                this.java_chars = new char[2048];
                break;
            }
            case 4: {
                int size = 4096 / this.converter.getMaxCharbyteSize();
                this.convbuf = new byte[size * 2];
                this.java_chars = new char[size];
                break;
            }
            case 5: {
                if (this.converter.isUcs2CharSet()) {
                    this.convbuf = new byte[2048];
                    this.java_chars = new char[2048];
                    break;
                }
                this.convbuf = new byte[4096];
                this.java_chars = new char[4096];
                break;
            }
            case 7: {
                int size = 4096 / this.converter.getMaxCharbyteSize();
                this.java_chars = new char[size];
                break;
            }
            default: {
                this.convbuf = new byte[4096];
                this.java_chars = new char[4096];
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)"OracleConversionInputStream.OracleConversionInputStream: return");
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, InputStream istream, int conversion, int max_bytesize) {
        this(conv_object, istream, conversion);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionInputStream.OracleConversionInputStream(conv_object=" + conv_object + ", istream=" + istream + ", conversion=" + conversion + ", max_bytesize=" + max_bytesize + ") -- after this()"));
        }
        this.max_size = max_bytesize;
        this.total_size = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)"OracleConversionInputStream.OracleConversionInputStream: return");
        }
    }

    public OracleConversionInputStream(DBConversion conv_object, Reader reader, int conversion, int max_charsize) {
        this(conv_object, null, conversion);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionInputStream.OracleConversionInputStream(conv_object=" + conv_object + ", reader=" + reader + ", conversion=" + conversion + ", max_charsize=" + max_charsize + ") -- after this()"));
        }
        this.reader = reader;
        this.max_size = max_charsize;
        this.total_size = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)"OracleConversionInputStream.OracleConversionInputStream: return");
        }
    }

    public void setFormOfUse(short csform) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleConversionInputStream.setFormOfUse(csform=" + csform + ")"));
        }
        this.csform = csform;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)"OracleConversionInputStream.setFormOfUse: return");
        }
    }

    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos < this.count) {
            return true;
        }
        if (this.istream != null) {
            return this.needBytesFromStream();
        }
        if (this.reader != null) {
            return this.needBytesFromReader();
        }
        return false;
    }

    public boolean needBytesFromReader() throws IOException {
        try {
            int read_size = 0;
            read_size = this.max_size == 0 ? this.java_chars.length : Math.min(this.max_size - this.total_size, this.java_chars.length);
            if (read_size <= 0) {
                this.reader.close();
                this.close();
                return false;
            }
            int chars_read = this.reader.read(this.java_chars, 0, read_size);
            if (chars_read == -1) {
                this.reader.close();
                this.close();
                return false;
            }
            this.total_size += chars_read;
            switch (this.conversion) {
                case 7: {
                    if (this.csform == 2) {
                        this.count = this.converter.javaCharsToNCHARBytes(this.java_chars, chars_read, this.buf);
                        break;
                    }
                    this.count = this.converter.javaCharsToCHARBytes(this.java_chars, chars_read, this.buf);
                    break;
                }
                default: {
                    System.arraycopy(this.convbuf, 0, this.buf, 0, chars_read);
                    this.count = chars_read;
                    break;
                }
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
        this.pos = 0;
        return true;
    }

    public boolean needBytesFromStream() throws IOException {
        if (!this.endOfStream) {
            try {
                int read_size = 0;
                read_size = this.max_size == 0 ? this.convbuf.length : Math.min(this.max_size - this.total_size, this.convbuf.length);
                int bytes_read = 0;
                if (read_size <= 0) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DBError.throwSqlException((int)55);
                    }
                } else {
                    bytes_read = this.istream.read(this.convbuf, this.numUnconvertedBytes, read_size - this.numUnconvertedBytes);
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)32, (String)OracleLog.bytesToPrintableForm("Read " + bytes_read + " bytes into convbuf", this.convbuf, bytes_read));
                    }
                }
                if (bytes_read == -1) {
                    this.endOfStream = true;
                    this.istream.close();
                    if (this.numUnconvertedBytes != 0) {
                        DBError.throwSqlException((int)55);
                    }
                } else {
                    this.total_size += (bytes_read += this.numUnconvertedBytes);
                }
                if (bytes_read <= 0) {
                    return false;
                }
                switch (this.conversion) {
                    case 0: {
                        int[] nbytes = new int[]{bytes_read};
                        int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, nbytes, this.java_chars);
                        this.numUnconvertedBytes = nbytes[0];
                        int i2 = 0;
                        while (i2 < this.numUnconvertedBytes) {
                            this.convbuf[i2] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            ++i2;
                        }
                        this.count = DBConversion.javaCharsToAsciiBytes((char[])this.java_chars, (int)chars_read, (byte[])this.buf);
                        break;
                    }
                    case 1: {
                        int[] nbytes = new int[]{bytes_read};
                        int chars_read = this.converter.CHARBytesToJavaChars(this.convbuf, nbytes, this.java_chars);
                        this.numUnconvertedBytes = nbytes[0];
                        int i3 = 0;
                        while (i3 < this.numUnconvertedBytes) {
                            this.convbuf[i3] = this.convbuf[bytes_read - this.numUnconvertedBytes];
                            ++i3;
                        }
                        this.count = DBConversion.javaCharsToUcs2Bytes((char[])this.java_chars, (int)chars_read, (byte[])this.buf);
                        break;
                    }
                    case 2: {
                        int chars_read = DBConversion.RAWBytesToHexChars((byte[])this.convbuf, (int)bytes_read, (char[])this.java_chars);
                        this.count = DBConversion.javaCharsToAsciiBytes((char[])this.java_chars, (int)chars_read, (byte[])this.buf);
                        break;
                    }
                    case 3: {
                        int chars_read = DBConversion.RAWBytesToHexChars((byte[])this.convbuf, (int)bytes_read, (char[])this.java_chars);
                        this.count = DBConversion.javaCharsToUcs2Bytes((char[])this.java_chars, (int)chars_read, (byte[])this.buf);
                        break;
                    }
                    case 4: {
                        int chars_read = DBConversion.ucs2BytesToJavaChars((byte[])this.convbuf, (int)bytes_read, (char[])this.java_chars);
                        this.count = this.converter.javaCharsToCHARBytes(this.java_chars, chars_read, this.buf);
                        break;
                    }
                    case 5: {
                        DBConversion.asciiBytesToJavaChars((byte[])this.convbuf, (int)bytes_read, (char[])this.java_chars);
                        this.count = this.converter.javaCharsToCHARBytes(this.java_chars, bytes_read, this.buf);
                        break;
                    }
                    default: {
                        System.arraycopy(this.convbuf, 0, this.buf, 0, bytes_read);
                        this.count = bytes_read;
                        break;
                    }
                }
            }
            catch (SQLException e2) {
                DBError.SQLToIOException((SQLException)e2);
            }
            this.pos = 0;
            return true;
        }
        return false;
    }

    static {
        CHUNK_SIZE = 4096;
    }
}

