/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.ClientDataSupport;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobDBAccessImpl;

public class OracleConnection
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    private static String dll_string = "dll";
    private String url;
    private String user;
    private String password;
    protected String database;
    private boolean auto_commit;
    private String protocol;
    public DBAccess db_access;
    public DBConversion conversion;
    public LobDBAccessImpl lob_dbaccess;
    public boolean XA_wants_error;
    public boolean UsingXA;
    public int m_txn_mode = 0;
    public static final int GLOBAL_TXN = 2;
    public static final int LOCAL_TXN = 1;
    public static final int NO_TXN = 0;
    private byte[] fdo;
    private Boolean big_endian;
    Hashtable statement_table;
    protected boolean closed;
    private boolean m_clientIdSet = false;
    private String m_clientId = null;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    boolean restrict_getTables = false;
    boolean m_accumulateBatchResult = true;
    boolean m_j2ee13Compliant = false;
    boolean m_v8compatible = false;
    public boolean looseTimestampDateCheck = false;
    int dataSizeScale = 1;
    boolean noCachingBuffer;
    private int trans_level;
    Map map;
    Map m_javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    oracle.jdbc.OracleDatabaseMetaData m_dbMetaData = null;
    private boolean physicalStatus;
    private boolean logicalHandle;
    private OraclePooledConnection m_opc = null;
    private OracleConnection m_opc_oc = null;
    static int DEFAULT_ROW_PREFETCH;
    OracleSql m_osql = null;
    SQLWarning m_warning = null;
    boolean m_readOnly = false;
    private long m_startTime = 0L;
    private LRUStatementCache statementCache = null;
    boolean m_stmtClearMetaData = false;
    boolean m_process_escapes = true;
    boolean m_defaultAutoRefetch = true;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    boolean defaultFixedString = false;
    private Statement m_svptStmt = null;
    private static final String svptPrefix = "ORACLE_SVPT_";
    oracle.jdbc.OracleConnection wrapper = null;
    Properties connectionProperties = null;
    OracleTimeout timeout;
    private static boolean m_traceEnabled;
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    private Hashtable m_clientData;
    private String m_sessionTimeZone = null;
    private Calendar m_dbTzCalendar = null;

    public OracleConnection(DBAccess access, String ur, String us, String p2, String db, Properties info) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.OracleConnection(access, ur=\"" + ur + "\", us=\"" + us + "\", p=\"" + p2 + "\", db=\"" + db + "\", info)"));
        }
        String prot = null;
        String prop_str = null;
        boolean default_auto_commit = true;
        if (info != null) {
            prot = (String)info.get("protocol");
            String processEscapesProp = info.getProperty("processEscapes");
            if (processEscapesProp != null && processEscapesProp.equalsIgnoreCase("false")) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)8, (int)64, (String)"OracleConnection.OracleConnection() processEscapes is set to false");
                }
                this.m_process_escapes = false;
            }
            this.connectionProperties = (Properties)info.clone();
            this.connectionProperties.remove("password");
        }
        this.password = p2;
        this.initialize(ur, us, prot, access, null, null, null, db);
        this.logicalHandle = false;
        try {
            String v8compat_type;
            this.needLine();
            this.conversion = this.db_access.logon(us, p2, db, info);
            this.m_warning = DBError.addSqlWarning((SQLWarning)this.m_warning, (SQLWarning)this.db_access.getConnectionWarning());
            if (info == null || info.getProperty("connection_pool") != "connection_pool") {
                this.default_row_prefetch = this.db_access.getDefaultPrefetch();
                if (info != null && (prop_str = info.getProperty("autoCommit")) != null && prop_str.equalsIgnoreCase("false")) {
                    default_auto_commit = false;
                    if (OracleLog.TRACE) {
                        OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)"User overrode autoCommit to false");
                    }
                }
                this.setAutoCommit(default_auto_commit);
                this.db_access.initNls(this);
            }
            String string = v8compat_type = info != null ? info.getProperty("oracle.jdbc.V8Compatible") : null;
            this.m_v8compatible = v8compat_type == null ? this.getVersionNumber() < 9000 : v8compat_type.equalsIgnoreCase("true");
            String string2 = prop_str = info != null ? info.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch") : null;
            if (prop_str != null && prop_str.equalsIgnoreCase("true")) {
                this.looseTimestampDateCheck = true;
            }
            String no_caching_buffers_value = info != null ? info.getProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache") : null;
            this.noCachingBuffer = no_caching_buffers_value != null && no_caching_buffers_value.equalsIgnoreCase("true");
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        catch (SQLException ea) {
            try {
                this.db_access.logoff();
            }
            catch (IOException eb) {
            }
            catch (SQLException eb) {
                // empty catch block
            }
            throw ea;
        }
        this.m_txn_mode = 0;
        this.db_access.registerConnection(this);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.OracleConnection(access, ur, us, p, db, info):return");
        }
    }

    public OracleConnection(OraclePooledConnection par, OracleConnection pc, boolean autoCommit) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.OracleConnection(par, pc, autoCommit=" + autoCommit + ")"));
        }
        this.initialize(pc.url, pc.user, pc.protocol, pc.db_access, pc.descriptorCache, pc.map, pc.m_javaObjectMap, null);
        this.logicalHandle = true;
        this.m_opc = par;
        this.m_opc_oc = pc;
        this.m_opc_oc.setWrapper(this);
        this.conversion = pc.conversion;
        this.m_v8compatible = pc.m_v8compatible;
        this.m_j2ee13Compliant = pc.m_j2ee13Compliant;
        this.m_accumulateBatchResult = pc.m_accumulateBatchResult;
        this.setAutoCommit(autoCommit);
        if (pc.closed) {
            DBError.throwSqlException((int)8);
        }
        this.m_txn_mode = 0;
        if (pc.trans_level == 8) {
            this.setTransactionIsolation(2);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.OracleConnection(par, pc, autoCommit):return");
        }
    }

    public Properties getProperties() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.getProperties(): no return trace");
        }
        return this.connectionProperties;
    }

    public synchronized Connection _getPC() {
        if (this.logicalHandle) {
            return this.m_opc_oc;
        }
        return null;
    }

    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this;
    }

    public synchronized boolean isLogicalConnection() {
        return this.logicalHandle;
    }

    private void initialize(String ur, String us, String prot, DBAccess access, Hashtable dc, Map pcmap, Map omap, String db) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.initialize(ur=\"" + ur + "\", us=\"" + us + "\", access)"));
        }
        this.initClientDataSupport();
        this.statementCache = null;
        this.m_stmtClearMetaData = false;
        this.database = db;
        this.url = ur;
        this.user = us != null ? us.toUpperCase() : us;
        this.db_access = access;
        this.protocol = prot;
        this.physicalStatus = true;
        this.default_row_prefetch = DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.statement_table = new Hashtable(10);
        this.descriptorCache = dc != null ? dc : new Hashtable(10);
        this.map = pcmap;
        this.m_javaObjectMap = omap != null ? omap : new Hashtable(10);
        this.closed = false;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.fdo = null;
        this.big_endian = null;
        this.m_occ = null;
        this.m_privData = null;
        this.m_clientIdSet = false;
        this.m_clientId = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.initialize(ur, us, access):return");
        }
    }

    public synchronized void setPhysicalStatus(boolean flag) {
        this.physicalStatus = flag;
    }

    private void checkPhyiscalStatus() throws SQLException {
        if (!this.physicalStatus) {
            DBError.throwSqlException((int)73);
        }
    }

    OracleTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = OracleTimeout.newTimeout(this.url);
        }
        return this.timeout;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.privateCreateStatement(-1, -1);
    }

    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.privateCreateStatement(resultSetType, resultSetConcurrency);
    }

    private Statement privateCreateStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.createStatement(resultSetType=" + resultSetType + ", resultSetConcurrency=" + resultSetConcurrency + ")"));
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        OracleStatement stmt = null;
        stmt = resultSetType != -1 || resultSetConcurrency != -1 ? new OracleStatement(this, 1, this.default_row_prefetch, resultSetType, resultSetConcurrency) : new OracleStatement(this, 1, this.default_row_prefetch);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.createStatement(resultSetType, resultSetConcurrency):return");
        }
        return stmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.privatePrepareStatement(sql, null, -1, -1);
    }

    public synchronized PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        if (key != null && !this.isStatementCacheInitialized()) {
            DBError.throwSqlException((int)95);
        }
        if (key == null) {
            return null;
        }
        return this.privatePrepareStatement(null, key, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.privatePrepareStatement(sql, null, resultSetType, resultSetConcurrency);
    }

    private PreparedStatement privatePrepareStatement(String sql, String key, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.prepareStatement(sql)");
            OracleLog.print((Object)this, (int)1, (int)8, (int)128, (String)("SQL: \"" + sql + "\""));
        }
        if (key == null && sql == null || sql == "") {
            DBError.throwSqlException((int)104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        PreparedStatement pstmt = null;
        if (this.logicalHandle && this.m_opc.isStatementCacheInitialized()) {
            pstmt = this.m_opc_oc.privatePrepareStatement(sql, key, resultSetType, resultSetConcurrency);
        } else {
            int rset_type = OracleStatement.DEFAULT_RSET_TYPE;
            if (resultSetType != -1 || resultSetConcurrency != -1) {
                rset_type = ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency);
            }
            if (this.statementCache != null) {
                pstmt = key != null ? (OraclePreparedStatement)this.statementCache.searchExplicitCache(key) : (OraclePreparedStatement)this.statementCache.searchImplicitCache(sql, 1, rset_type);
            }
            if ((this.statementCache == null || key == null) && pstmt == null) {
                pstmt = resultSetType != -1 || resultSetConcurrency != -1 ? new OraclePreparedStatement(this, sql, this.default_batch, this.default_row_prefetch, resultSetType, resultSetConcurrency) : new OraclePreparedStatement(this, sql, this.default_batch, this.default_row_prefetch);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.prepareStatement(sql):return");
        }
        return pstmt;
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.privatePrepareCall(sql, null, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.privatePrepareCall(sql, null, resultSetType, resultSetConcurrency);
    }

    public synchronized CallableStatement prepareCallWithKey(String key) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        if (key != null && !this.isStatementCacheInitialized()) {
            DBError.throwSqlException((int)95);
        }
        if (key == null) {
            return null;
        }
        return this.privatePrepareCall(null, key, -1, -1);
    }

    private CallableStatement privatePrepareCall(String sql, String key, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.prepareCall(sql)");
            OracleLog.print((Object)this, (int)1, (int)8, (int)128, (String)("SQL: \"" + sql + "\""));
        }
        if (key == null && sql == null || sql == "") {
            DBError.throwSqlException((int)104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        CallableStatement cstmt = null;
        if (this.logicalHandle && this.m_opc.isStatementCacheInitialized()) {
            cstmt = this.m_opc_oc.privatePrepareCall(sql, key, resultSetType, resultSetConcurrency);
        } else {
            int rset_type = OracleStatement.DEFAULT_RSET_TYPE;
            if (resultSetType != -1 || resultSetConcurrency != -1) {
                rset_type = ResultSetUtil.getRsetTypeCode(resultSetType, resultSetConcurrency);
            }
            if (this.statementCache != null) {
                cstmt = key != null ? (OracleCallableStatement)this.statementCache.searchExplicitCache(key) : (OracleCallableStatement)this.statementCache.searchImplicitCache(sql, 2, rset_type);
            }
            if ((this.statementCache == null || key == null) & cstmt == null) {
                cstmt = resultSetType != -1 || resultSetConcurrency != -1 ? new OracleCallableStatement(this, sql, 1, this.default_row_prefetch, resultSetType, resultSetConcurrency) : new OracleCallableStatement(this, sql, 1, this.default_row_prefetch);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.prepareCall(sql):return");
        }
        return cstmt;
    }

    public String nativeSQL(String sql) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)128, (int)16, (String)"OracleConnection.nativeSQL(sql)");
            OracleLog.print((Object)this, (int)1, (int)128, (int)128, (String)("Input SQL:  \"" + sql + "\""));
        }
        if (this.m_osql == null) {
            this.m_osql = new OracleSql();
        }
        this.m_osql.isV8Compatible = this.m_v8compatible;
        String osql = this.m_osql.parse(sql);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)128, (int)32, (String)("Output SQL: \"" + osql + "\""));
        }
        return osql;
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setAutoCommit(autoCommit=" + autoCommit + ")"));
        }
        this.checkPhyiscalStatus();
        if (autoCommit) {
            this.disallowGlobalTxnMode(116);
        }
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        try {
            this.needLine();
            this.db_access.setAutoCommit(autoCommit);
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        this.auto_commit = autoCommit;
        if (autoCommit) {
            this.switchTxnMode(1, 0);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.setAutoCommit(autoCommit): return");
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getAutoCommit() returned " + this.auto_commit));
        }
        return this.auto_commit;
    }

    public void cancel() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)"OracleConnection.cancel()");
        }
        Enumeration stmtSet = this.statement_table.elements();
        while (stmtSet != null && stmtSet.hasMoreElements()) {
            OracleStatement stmt = (OracleStatement)stmtSet.nextElement();
            if (stmt == null) continue;
            try {
                stmt.cancel();
            }
            catch (SQLException e2) {
                if (!OracleLog.TRACE) continue;
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("OracleConnection.cancel() failed: " + e2.getMessage()));
            }
        }
    }

    public synchronized void commit() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.commit()");
        }
        this.checkPhyiscalStatus();
        this.disallowGlobalTxnMode(114);
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        Enumeration e2 = this.statement_table.elements();
        while (e2.hasMoreElements()) {
            OracleStatement s2 = (OracleStatement)e2.nextElement();
            s2.sendBatch();
        }
        try {
            this.needLine();
            this.db_access.commit();
        }
        catch (IOException ex) {
            DBError.throwSqlException((IOException)ex);
        }
        this.enterTxnMode(0);
    }

    public synchronized void rollback() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.rollback()");
        }
        this.checkPhyiscalStatus();
        this.disallowGlobalTxnMode(115);
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        try {
            this.needLine();
            this.db_access.rollback();
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        this.enterTxnMode(0);
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.close()");
        }
        if (this.closed) {
            return;
        }
        if (this.m_occ != null) {
            this.m_occ.beforeClose(this, this.m_privData);
        }
        this.close_statements();
        this.closed = true;
        if (this.logicalHandle) {
            this.logicalClose();
            if (this.m_occ != null) {
                this.m_occ.afterClose(this.m_privData);
            }
            return;
        }
        try {
            this.needLine();
            this.db_access.logoff();
            this.cleanup();
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.isClosed() returned " + this.closed));
        }
        return this.closed;
    }

    private void cleanup() {
        this.fdo = null;
        this.db_access = null;
        this.conversion = null;
        this.statement_table = null;
        this.descriptorCache = null;
        this.map = null;
        this.m_javaObjectMap = null;
        this.statement_holding_line = null;
        this.m_opc = null;
        this.m_osql = null;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.getMetaData()");
        }
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReadOnly(boolean value) throws SQLException {
        block4: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setReadOnly(readOnly=" + value + ")"));
            }
            Statement pstmt = null;
            try {
                String sqlString = null;
                sqlString = value ? "SET TRANSACTION READ ONLY" : "SET TRANSACTION READ WRITE";
                pstmt = this.prepareStatement(sqlString);
                pstmt.execute();
                Object var5_4 = null;
                if (pstmt == null) break block4;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (pstmt != null) {
                    pstmt.close();
                }
                throw throwable;
            }
            pstmt.close();
        }
        this.m_readOnly = value;
    }

    public boolean isReadOnly() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.isReadOnly()");
        }
        return this.m_readOnly;
    }

    public void setCatalog(String catalog) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setCatalog(catalog=\"" + catalog + "\")"));
        }
    }

    public String getCatalog() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.getCatalog()");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setTransactionIsolation(level=" + level + ")"));
        }
        this.checkPhyiscalStatus();
        OracleStatement ostmt = (OracleStatement)this.createStatement();
        try {
            switch (level) {
                case 2: {
                    ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.trans_level = 2;
                    break;
                }
                case 8: {
                    ostmt.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.trans_level = 8;
                    break;
                }
                default: {
                    DBError.throwSqlException((int)30);
                }
            }
            Object var4_3 = null;
            if (this.logicalHandle) {
                this.m_opc_oc.trans_level = this.trans_level;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.logicalHandle) {
                this.m_opc_oc.trans_level = this.trans_level;
            }
            ostmt.close();
            throw throwable;
        }
        ostmt.close();
    }

    public int getTransactionIsolation() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getTransactionIsolation() returned " + this.trans_level));
        }
        return this.trans_level;
    }

    public synchronized void setAutoClose(boolean autoClose) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setAutoClose(autoClose=" + autoClose + ")"));
        }
        if (!autoClose) {
            DBError.throwSqlException((int)31);
        }
    }

    public boolean getAutoClose() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.getAutoClose()");
        }
        return true;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.getWarnings()");
        }
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.clearWarnings()");
        }
        this.m_warning = null;
    }

    public void trace(String s2) {
        PrintStream outStream = DriverManager.getLogStream();
        if (outStream == null) {
            if (m_traceEnabled) {
                OracleLog.setLogStream(null);
            }
            m_traceEnabled = false;
        } else {
            if (!m_traceEnabled) {
                OracleLog.setLogStream((PrintStream)outStream);
            }
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)s2);
            }
            m_traceEnabled = true;
        }
    }

    public void setDefaultRowPrefetch(int value) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setDefaultRowPrefetch(value=" + value + ")"));
        }
        if (value <= 0) {
            DBError.throwSqlException((int)20);
        }
        this.default_row_prefetch = value;
    }

    public int getDefaultRowPrefetch() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getDefaultRowPrefetch() returned " + this.default_row_prefetch));
        }
        return this.default_row_prefetch;
    }

    public synchronized void setDefaultExecuteBatch(int batch) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setDefaultExecuteBatch(batch=" + batch + ")"));
        }
        if (batch <= 0) {
            DBError.throwSqlException((int)42);
        }
        this.default_batch = batch;
    }

    public synchronized int getDefaultExecuteBatch() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getDefaultExecuteBatch() returned " + this.default_batch));
        }
        return this.default_batch;
    }

    public synchronized void setRemarksReporting(boolean reportRemarks) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setRemarksReporting(reportRemarks=" + reportRemarks + ")"));
        }
        this.report_remarks = reportRemarks;
    }

    public synchronized boolean getRemarksReporting() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.getRemarksReporting()");
        }
        return this.report_remarks;
    }

    public void setIncludeSynonyms(boolean synonyms) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setIncludeSynonyms(synonyms=" + synonyms + ")"));
        }
        this.include_synonyms = synonyms;
    }

    public boolean getIncludeSynonyms() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getIncludeSynonyms() returned " + this.include_synonyms));
        }
        return this.include_synonyms;
    }

    public void setRestrictGetTables(boolean restrict) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setRestrictGetTables(restrict=" + restrict + ")"));
        }
        this.restrict_getTables = restrict;
    }

    public boolean getRestrictGetTables() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getRestrictGetTables() returned " + this.restrict_getTables));
        }
        return this.restrict_getTables;
    }

    public void setDefaultFixedString(boolean fixedString) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setDefaultFixedString(fixedString=" + fixedString));
        }
        this.defaultFixedString = fixedString;
    }

    public boolean getDefaultFixedString() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.getDefaultFixedString() returning " + this.defaultFixedString));
        }
        return this.defaultFixedString;
    }

    public synchronized void setDataSizeUnits(String units) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("OracleConnection.setDataSizeUnits(" + units + ")"));
        }
        if (units.equalsIgnoreCase("ClientBytes")) {
            this.dataSizeScale = 1;
        } else if (units.equalsIgnoreCase("ServerBytes")) {
            this.dataSizeScale = this.db_access.getNlsRatio();
        } else {
            DBError.throwSqlException((int)68);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("OracleConnection.setDataSizeUnits, set scale to " + this.dataSizeScale));
        }
    }

    synchronized void add_statement(Statement s2) {
        this.statement_table.put(s2, s2);
    }

    synchronized void remove_statement(Statement s2) {
        this.statement_table.remove(s2);
    }

    public synchronized void close_statements() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.close_statements()");
        }
        if (this.isStatementCacheInitialized() && !this.logicalHandle) {
            this.statementCache.close();
            this.statementCache = null;
            this.m_stmtClearMetaData = true;
        } else {
            OracleStatement s2;
            Enumeration e2 = this.statement_table.elements();
            while (e2.hasMoreElements()) {
                s2 = (OracleStatement)e2.nextElement();
                if (s2 == null || !s2.serverCursor) continue;
                s2.close();
                this.remove_statement(s2);
                s2 = null;
            }
            e2 = this.statement_table.elements();
            while (e2.hasMoreElements()) {
                s2 = (OracleStatement)e2.nextElement();
                if (s2 == null) continue;
                s2.close();
                Object var2_2 = null;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.close_statements():return");
        }
    }

    public synchronized void needLine() throws SQLException {
        if (this.statement_holding_line != null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Freeing line from " + this.statement_holding_line));
            }
            this.statement_holding_line.freeLine();
        }
    }

    public synchronized void holdLine(oracle.jdbc.internal.OracleStatement stmt) {
        this.holdLine((OracleStatement)stmt);
    }

    public synchronized void holdLine(OracleStatement stmt) {
        this.statement_holding_line = stmt;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Holding line for " + this.statement_holding_line));
        }
    }

    public synchronized void releaseLine() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Releasing line from " + this.statement_holding_line));
        }
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statement_holding_line = null;
    }

    public synchronized void startup(String startup_str, int mode) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        this.db_access.startup(startup_str, mode);
    }

    public synchronized void shutdown(int mode) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        this.db_access.shutdown(mode);
    }

    public synchronized void archive(int mode, int aseq, String acstext) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException((int)8);
        }
        this.db_access.archive(mode, aseq, acstext);
    }

    public synchronized void registerSQLType(String sql_name, String java_class_name) throws SQLException {
        if (sql_name == null || java_class_name == null) {
            DBError.throwSqlException((int)68);
        }
        try {
            this.registerSQLType(sql_name, Class.forName(java_class_name));
        }
        catch (ClassNotFoundException e2) {
            DBError.throwSqlException((int)1, (Object)("Class not found: " + java_class_name));
        }
    }

    public synchronized void registerSQLType(String sql_name, Class java_class) throws SQLException {
        if (sql_name == null || java_class == null) {
            DBError.throwSqlException((int)68);
        }
        this.ensureClassMapExists();
        this.map.put(sql_name, java_class);
        this.map.put(java_class.getName(), sql_name);
    }

    private void ensureClassMapExists() {
        if (this.map == null) {
            this.initializeClassMap();
        }
    }

    private void initializeClassMap() {
        Hashtable aMap = new Hashtable(10);
        this.addDefaultClassMapEntriesTo(aMap);
        this.map = aMap;
    }

    public synchronized String getSQLType(Object obj) throws SQLException {
        if (obj != null && this.map != null) {
            String java_class_name = obj.getClass().getName();
            return (String)this.map.get(java_class_name);
        }
        return null;
    }

    public synchronized Object getJavaObject(String sql_name) throws SQLException {
        Object obj = null;
        try {
            if (sql_name != null && this.map != null) {
                Class java_class = (Class)this.map.get(sql_name);
                obj = java_class.newInstance();
            }
        }
        catch (IllegalAccessException e2) {
            e2.printStackTrace();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        return obj;
    }

    public synchronized void putDescriptor(String sql_name, Object desc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.putDescriptor (" + sql_name + ", " + desc + ")"));
        }
        if (sql_name != null && desc != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(sql_name, desc);
        } else {
            DBError.throwSqlException((int)68);
        }
    }

    public synchronized Object getDescriptor(String sql_name) {
        Object desc = null;
        if (sql_name != null && this.descriptorCache != null) {
            desc = this.descriptorCache.get(sql_name);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.getDescriptor (" + sql_name + ") return " + desc));
        }
        return desc;
    }

    public synchronized void removeDecriptor(String sql_name) {
        this.removeDescriptor(sql_name);
    }

    public synchronized void removeDescriptor(String sql_name) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.removeDescriptor (" + sql_name + ")"));
        }
        if (sql_name != null && this.descriptorCache != null) {
            this.descriptorCache.remove(sql_name);
        }
    }

    public synchronized void removeAllDescriptor() {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)"OracleConnection.removeAllDescriptor ()");
        }
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public int numberOfDescriptorCacheEntries() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.size();
        }
        return 0;
    }

    public synchronized void putDescriptor(byte[] toid, Object desc) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.putDescriptor (" + toid + ", " + desc + ")"));
        }
        if (toid != null && desc != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(new ByteArrayKey(toid), desc);
        } else {
            DBError.throwSqlException((int)68);
        }
    }

    public synchronized Object getDescriptor(byte[] toid) {
        Object desc = null;
        if (toid != null && this.descriptorCache != null) {
            desc = this.descriptorCache.get(new ByteArrayKey(toid));
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.getDescriptor (" + toid + ") return " + desc));
        }
        return desc;
    }

    public synchronized void removeDecriptor(byte[] toid) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)16, (int)64, (int)32, (String)("OracleConnection.removeDescriptor (" + toid + ")"));
        }
        if (toid != null && this.descriptorCache != null) {
            this.descriptorCache.remove(new ByteArrayKey(toid));
        }
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException((int)65);
        }
        return this.conversion.getAccessCharSet();
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException((int)65);
        }
        return this.conversion.getDbCharSet();
    }

    public short getNCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException((int)65);
        }
        return this.conversion.getNCharSet();
    }

    public short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public synchronized short getStructAttrNCsId() throws SQLException {
        return this.getNCsId();
    }

    public synchronized Map getTypeMap() {
        this.ensureClassMapExists();
        return this.map;
    }

    public synchronized void setTypeMap(Map map) {
        this.addDefaultClassMapEntriesTo(map);
        this.map = map;
    }

    private void addDefaultClassMapEntriesTo(Map map) {
        if (map != null) {
            this.addClassMapEntry("SYS.XMLTYPE", "oracle.xdb.XMLTypeFactory", map);
        }
    }

    private void addClassMapEntry(String typeName, String className, Map theMap) {
        if (OracleConnection.containsKey(theMap, typeName)) {
            return;
        }
        try {
            Class clazz = this.safelyGetClassForName(className);
            theMap.put(typeName, clazz);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
    }

    private static boolean containsKey(Map d2, Object o2) {
        return d2.get(o2) != null;
    }

    public synchronized void setUsingXAFlag(boolean value) {
        this.UsingXA = value;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public synchronized void setXAErrorFlag(boolean value) {
        this.XA_wants_error = value;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initUserName() throws SQLException {
        if (this.user != null) {
            return;
        }
        this.checkPhyiscalStatus();
        Statement stmt = this.createStatement();
        ((OracleStatement)stmt).setRowPrefetch(1);
        try {
            ResultSet rs = stmt.executeQuery("select USER from dual");
            if (rs.next()) {
                this.user = rs.getString(1);
            }
            rs.close();
            Object var2_2 = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            stmt.close();
            stmt = null;
            throw throwable;
        }
        stmt.close();
        stmt = null;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.getProtocolType().equals("kprb")) {
            return this.db_access.getUserName();
        }
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public DBAccess getDBAccess() {
        return this.db_access;
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (this.db_access == null) {
            return null;
        }
        return this.db_access.getDBAccessProperties();
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.m_opc != null && this.physicalStatus) {
            this.m_opc.logicalClose();
        }
        this.setPhysicalStatus(false);
        if (this.m_clientIdSet) {
            this.clearClientIdentifier(this.m_clientId);
        }
        this.m_startTime = 0L;
    }

    public synchronized void setStartTime(long startTime) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnection.setStartTime(" + startTime + ")"));
        }
        if (startTime <= 0L) {
            DBError.throwSqlException((int)68);
        } else {
            this.m_startTime = startTime;
        }
    }

    public long getStartTime() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)512, (int)16, (String)("OracleConnection.getStartTime(): returned " + this.m_startTime));
        }
        return this.m_startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getFDO(boolean init) throws SQLException {
        if (this.fdo == null && init) {
            CallableStatement cstmt;
            block4: {
                cstmt = null;
                try {
                    this.checkPhyiscalStatus();
                    cstmt = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                    cstmt.registerOutParameter(1, 2);
                    cstmt.registerOutParameter(2, -4);
                    cstmt.execute();
                    this.fdo = cstmt.getBytes(2);
                    Object var4_3 = null;
                    if (cstmt == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    cstmt = null;
                    throw throwable;
                }
                cstmt.close();
            }
            cstmt = null;
            {
            }
        }
        return this.fdo;
    }

    public synchronized void setFDO(byte[] fdo) throws SQLException {
        this.fdo = fdo;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] ub1fdo = Util.toJavaUnsignedBytes(this.getFDO(true));
            int kopfdo_auxinfo = ub1fdo[6 + ub1fdo[5] + ub1fdo[6] + 5];
            int offset = kopfdo_auxinfo & 0x10;
            if (offset < 0) {
                offset += 256;
            }
            this.big_endian = offset > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            DBError.throwSqlException((int)162);
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.setSavepoint()");
        }
        return this.oracleSetSavepoint();
    }

    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setSavepoint(name = " + name + ")"));
        }
        return this.oracleSetSavepoint(name);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.rollback(savepoint = " + savepoint + ")"));
        }
        this.disallowGlobalTxnMode(122);
        if (this.auto_commit) {
            DBError.throwSqlException((int)121);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        String _svptName = null;
        try {
            _svptName = savepoint.getSavepointName();
        }
        catch (SQLException exc) {
            _svptName = svptPrefix + savepoint.getSavepointId();
        }
        this.m_svptStmt.executeUpdate("ROLLBACK TO " + _svptName);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.rollback(savepoint): return");
        }
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            DBError.throwSqlException((int)162);
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            DBError.throwSqlException((int)162);
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            DBError.throwSqlException((int)162);
        }
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.oracleSetSavepoint()");
        }
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DBError.throwSqlException((int)120);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint();
        String _svptSqlString = "SAVEPOINT ORACLE_SVPT_" + _osvpt.getSavepointId();
        this.m_svptStmt.executeUpdate(_svptSqlString);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.oracleSetSavepoint(): return: " + _osvpt));
        }
        return _osvpt;
    }

    public synchronized OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.oracleSetSavepoint(name = " + name + ")"));
        }
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DBError.throwSqlException((int)120);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint _osvpt = new oracle.jdbc.driver.OracleSavepoint(name);
        String _svptSqlString = "SAVEPOINT " + _osvpt.getSavepointName();
        this.m_svptStmt.executeUpdate(_svptSqlString);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.oracleSetSavepoint(name): returns: " + _osvpt));
        }
        return _osvpt;
    }

    public synchronized void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.oracleRollback(savepoint = " + savepoint + ")"));
        }
        this.disallowGlobalTxnMode(115);
        if (this.auto_commit) {
            DBError.throwSqlException((int)121);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        String _svptName = null;
        try {
            _svptName = savepoint.getSavepointName();
        }
        catch (SQLException exc) {
            _svptName = svptPrefix + savepoint.getSavepointId();
        }
        this.m_svptStmt.executeUpdate("ROLLBACK TO " + _svptName);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)"OracleConnection.oracleRollback(savepoint): return");
        }
    }

    public synchronized void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    void switchTxnMode(int fromMode, int toMode) {
        if (this.logicalHandle) {
            if (this.m_opc_oc.m_txn_mode == fromMode) {
                this.m_opc_oc.m_txn_mode = toMode;
            }
        } else if (this.m_txn_mode == fromMode) {
            this.m_txn_mode = toMode;
        }
    }

    private void enterTxnMode(int mode) {
        if (this.logicalHandle) {
            this.m_opc_oc.m_txn_mode = mode;
        } else {
            this.m_txn_mode = mode;
        }
    }

    private void disallowGlobalTxnMode(int errorCode) throws SQLException {
        if (this.m_txn_mode == 2 || this.logicalHandle && this.m_opc_oc.m_txn_mode == 2) {
            DBError.throwSqlException((int)errorCode);
        }
    }

    public void setTxnMode(int mode) {
        this.m_txn_mode = mode;
    }

    public int getTxnMode() {
        return this.m_txn_mode;
    }

    private void initClientDataSupport() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.initClientDataSupport()");
        }
        this.m_clientData = null;
    }

    public synchronized Object getClientData(Object key) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.getClientData(key)");
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("OracleConnection.getClientData(key=" + key + ")"));
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(key);
    }

    public synchronized Object setClientData(Object key, Object value) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.setClientData(key, value)");
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("key:   " + key + ", value: " + value));
        }
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(key, value);
    }

    public synchronized Object removeClientData(Object key) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.removeClientData(key)");
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("key: " + key));
        }
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(key);
    }

    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public void printState() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"OracleConnection.printState()");
        }
        try {
            short jdbc_cs_id = this.getJdbcCsId();
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Jdbc character set id is   " + jdbc_cs_id));
            }
            short db_cs_id = this.getDbCsId();
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Db character set id is     " + db_cs_id));
            }
            short struct_cs_id = this.getStructAttrCsId();
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("STRUCT character set id is " + struct_cs_id));
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setStmtCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setStmtCacheSize(" + size + ") (deprecated)"));
        }
        this.setStatementCacheSize(size);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
    }

    public synchronized void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setStmtCacheSize(" + size + ", " + clearMetaData + ") (deprecated)"));
        }
        this.setStatementCacheSize(size);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
        this.m_stmtClearMetaData = clearMetaData;
    }

    public synchronized int getStmtCacheSize() {
        int returnValue;
        block4: {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getStmtCacheSize() (deprecated)");
            }
            returnValue = 0;
            try {
                returnValue = this.getStatementCacheSize();
            }
            catch (SQLException ex) {
                if (!OracleLog.TRACE) break block4;
                OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("getStmtCacheSize -- exception occured calling getStatementCacheSize  " + ex.getMessage()));
            }
        }
        if (returnValue == -1) {
            returnValue = 0;
        }
        return returnValue;
    }

    public synchronized void setStatementCacheSize(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setStatementCacheSize(" + size + ")"));
        }
        if (this.logicalHandle) {
            DBError.throwSqlException((int)96);
        }
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(size);
        } else {
            this.statementCache.resize(size);
        }
    }

    public synchronized int getStatementCacheSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getStatementCacheSize()");
        }
        if (this.logicalHandle) {
            return this.m_opc.getStatementCacheSize();
        }
        if (this.statementCache == null) {
            return -1;
        }
        return this.statementCache.getCacheSize();
    }

    public synchronized void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setImplicitCachingEnabled(" + cache + ")"));
        }
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setImplicitCachingEnabled(cache);
    }

    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getImplicitCachingEnabled()");
        }
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public synchronized void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setExplicitCachingEnabled(" + cache + ")"));
        }
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setExplicitCachingEnabled(cache);
    }

    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getExplicitCachingEnabled()");
        }
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getExplicitCachingEnabled();
    }

    public synchronized void purgeImplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"purgeImplicitCache()");
        }
        if (this.statementCache != null) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public synchronized void purgeExplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"purgeExplicitCache()");
        }
        if (this.statementCache != null) {
            this.statementCache.purgeExplicitCache();
        }
    }

    public synchronized PreparedStatement getStatementWithKey(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getStatementWithKey()");
        }
        if (this.statementCache != null) {
            OracleStatement os = this.statementCache.searchExplicitCache(key);
            if (os == null || os.statementType == 1) {
                return (PreparedStatement)((Object)os);
            }
            DBError.throwSqlException((int)125);
            return null;
        }
        return null;
    }

    public synchronized CallableStatement getCallWithKey(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"getCallWithKey()");
        }
        if (this.statementCache != null) {
            OracleStatement os = this.statementCache.searchExplicitCache(key);
            if (os == null || os.statementType == 2) {
                return (CallableStatement)((Object)os);
            }
            DBError.throwSqlException((int)125);
            return null;
        }
        return null;
    }

    public synchronized void cacheImplicitStatement(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)"cacheImplicitStatement()");
        }
        if (this.statementCache == null) {
            DBError.throwSqlException((int)95);
        } else {
            this.statementCache.addToImplicitCache(stmt, sql, statementType, scrollType);
        }
    }

    public synchronized void cacheExplicitStatement(OraclePreparedStatement stmt, String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("cacheExplicitStatement(" + key + ")"));
        }
        if (this.statementCache == null) {
            DBError.throwSqlException((int)95);
        } else {
            this.statementCache.addToExplicitCache(stmt, key);
        }
    }

    public synchronized boolean isStatementCacheInitialized() {
        if (this.logicalHandle) {
            return this.m_opc.isStatementCacheInitialized();
        }
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public void setDefaultAutoRefetch(boolean autoRefetch) throws SQLException {
        this.m_defaultAutoRefetch = autoRefetch;
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.m_defaultAutoRefetch;
    }

    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        if (this.db_access != null) {
            this.db_access.registerTAFCallback((Connection)this, cbk, obj);
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] error = new int[1];
        try {
            this.needLine();
            byte[] version = this.db_access.getVersion();
            return this.conversion.CharBytesToString(version, version.length);
        }
        catch (IOException e2) {
            return null;
        }
    }

    public synchronized boolean getReportRemarks() {
        return this.report_remarks;
    }

    public synchronized short getVersionNumber() throws SQLException {
        return this.db_access.getVersionNumber();
    }

    public synchronized void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        this.m_occ = occ;
        this.m_privData = privData;
    }

    public void setCreateStatementAsRefCursor(boolean value) {
        this.db_access.setCreateStatementAsRefCursor(value);
    }

    public boolean getCreateStatementAsRefCursor() {
        return this.db_access.getCreateStatementAsRefCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int pingDatabase(int timeOut) throws SQLException {
        int current_tx_mode;
        block8: {
            if (this.closed) {
                return -1;
            }
            Statement stmt = null;
            current_tx_mode = this.m_txn_mode;
            try {
                try {
                    stmt = this.createStatement();
                    ((OracleStatement)stmt).defineColumnType(1, 12, 1);
                    stmt.executeQuery("SELECT 'x' FROM DUAL");
                }
                catch (SQLException ea) {
                    int n2 = -1;
                    Object var7_5 = null;
                    if (stmt != null) {
                        stmt.close();
                    }
                    this.switchTxnMode(1, current_tx_mode);
                    return n2;
                }
                Object var7_4 = null;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (stmt != null) {
                    stmt.close();
                }
                this.switchTxnMode(1, current_tx_mode);
                throw throwable;
            }
            stmt.close();
        }
        this.switchTxnMode(1, current_tx_mode);
        return 0;
    }

    public synchronized Map getJavaObjectTypeMap() {
        return this.m_javaObjectMap;
    }

    public synchronized void setJavaObjectTypeMap(Map map) {
        this.m_javaObjectMap = map;
    }

    public void clearClientIdentifier(String clientId) throws SQLException {
        if (this.m_clientIdSet) {
            this.db_access.clearClientIdentifier(this, clientId);
        }
    }

    public void setClientIdentifier(String clientId) throws SQLException {
        this.m_clientIdSet = true;
        this.m_clientId = clientId;
        this.db_access.setClientIdentifier(this, clientId);
    }

    public void assertComplete() throws SQLException {
    }

    public boolean getSynchronousMode() {
        return true;
    }

    public void setSynchronousMode(boolean isSynchronous) {
    }

    public void registerApiDescription(String apiName, short major, short minor, String className) {
    }

    public Object openJoltConnection(String apiName, short major, short minor) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSessionTimeZone(String regionName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)1, (String)("OracleConnection.setSessionTimeZone(regionName=" + regionName + ")"));
        }
        Statement pstmt = null;
        ResultSet rset = null;
        int l_txn_mode = this.m_txn_mode;
        this.switchTxnMode(l_txn_mode, 0);
        try {
            try {
                pstmt = this.prepareStatement("ALTER SESSION SET TIME_ZONE = '" + regionName + "'");
                pstmt.executeUpdate();
                pstmt = this.prepareStatement("SELECT DBTIMEZONE FROM DUAL");
                rset = pstmt.executeQuery();
                rset.next();
                String db_tz_str = rset.getString(1);
                this.setDbTzCalendar(db_tz_str);
            }
            catch (SQLException e2) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("setSessionTimeZone() failed: " + e2.getMessage()));
                }
                throw e2;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            pstmt.close();
            if (l_txn_mode == 0) {
                this.m_txn_mode = l_txn_mode;
            }
            throw throwable;
        }
        pstmt.close();
        if (l_txn_mode == 0) {
            this.m_txn_mode = l_txn_mode;
        }
        this.m_sessionTimeZone = regionName;
    }

    public String getSessionTimeZone() {
        return this.m_sessionTimeZone;
    }

    private void setDbTzCalendar(String dbTzStr) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)16, (String)("setDbTzCalendar(dbTzStr=" + dbTzStr + ")"));
        }
        long offset = TimeZone.getTimeZone(dbTzStr).getRawOffset() - 28800000;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)8, (int)32, (String)("Database timezone offset is " + offset));
        }
        TimeZone tz = TimeZone.getDefault();
        tz.setRawOffset((int)offset);
        this.m_dbTzCalendar = new GregorianCalendar(tz);
    }

    public Calendar getDbTzCalendar() {
        return this.m_dbTzCalendar;
    }

    public void setAccumulateBatchResult(boolean val) {
        this.m_accumulateBatchResult = val;
    }

    public boolean isAccumulateBatchResult() {
        return this.m_accumulateBatchResult;
    }

    public void setJ2EE13Compliant(boolean val) {
        this.m_j2ee13Compliant = val;
    }

    public boolean getJ2EE13Compliant() {
        return this.m_j2ee13Compliant;
    }

    public Class classForNameAndSchema(String name, String schemaName) throws ClassNotFoundException {
        return this.db_access.classForNameAndSchema(name, schemaName);
    }

    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        return this.db_access.safelyGetClassForName(name);
    }

    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection wrappedConnection) {
        oracle.jdbc.OracleConnection previous;
        oracle.jdbc.OracleConnection next = previous = wrappedConnection;
        while (next != null) {
            previous = next;
            next = previous.unwrap();
        }
        return (OracleConnection)previous;
    }

    public void setWrapper(oracle.jdbc.OracleConnection w) {
        this.wrapper = w;
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return null;
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        return this;
    }

    public static oracle.jdbc.internal.OracleConnection physicalConnectionWithin(Connection possiblyWrappedPossiblyLogicalConnection) {
        OracleConnection unwrappedConnection = null;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)64, (int)16, (String)("oracle.jdbc.driver.OracleConnection.physicalConnectionWithin( conn=" + possiblyWrappedPossiblyLogicalConnection + ")"));
        }
        if (possiblyWrappedPossiblyLogicalConnection != null) {
            unwrappedConnection = OracleConnection.unwrapCompletely((oracle.jdbc.OracleConnection)((oracle.jdbc.OracleConnection)possiblyWrappedPossiblyLogicalConnection));
            if (unwrappedConnection.isLogicalConnection()) {
                unwrappedConnection = unwrappedConnection.m_opc_oc;
            }
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)64, (int)32, (String)("unwrappedPossiblyLogicalConnection: " + unwrappedConnection));
            }
        }
        return unwrappedConnection;
    }

    public void internalClose(DBAccess dbaccess) throws SQLException {
        this.closed = true;
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection conn) throws SQLException {
        OracleConnection c2;
        OracleConnection c1 = this.logicalHandle ? this.m_opc_oc : this;
        OracleConnection oracleConnection = c2 = ((OracleConnection)conn).logicalHandle ? ((OracleConnection)conn).m_opc_oc : (OracleConnection)conn;
        if (c1.protocol != null && c1.protocol.equals("oci8")) {
            return c1 == c2;
        }
        if (c1.protocol != null && c1.protocol.equals("kprb") || c2.protocol != null && c2.protocol.equals("kprb")) {
            return true;
        }
        return c1 == c2 || c1.url.equals(c2.url);
    }

    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        Hashtable<String, Map> hashTable = new Hashtable<String, Map>();
        hashTable.put("obj_type_map", this.m_javaObjectMap);
        Properties prop = new Properties();
        prop.put("user", this.user);
        prop.put("password", this.password);
        prop.put("connection_url", this.url);
        prop.put("connect_auto_commit", "" + this.auto_commit);
        prop.put("trans_isolation", "" + this.trans_level);
        if (this.getStatementCacheSize() != -1) {
            prop.put("stmt_cache_size", "" + this.getStatementCacheSize());
            prop.put("implicit_cache_enabled", "" + this.getImplicitCachingEnabled());
            prop.put("explict_cache_enabled", "" + this.getExplicitCachingEnabled());
        }
        prop.put("defaultExecuteBatch", "" + this.default_batch);
        prop.put("prefetch", "" + this.default_row_prefetch);
        prop.put("remarks", "" + this.report_remarks);
        prop.put("AccumulateBatchResult", "" + this.m_accumulateBatchResult);
        prop.put("processEscapes", "" + this.m_process_escapes);
        prop.put("restrictGetTables", "" + this.restrict_getTables);
        prop.put("synonyms", "" + this.include_synonyms);
        prop.put("fixedString", "" + this.defaultFixedString);
        hashTable.put("connection_properties", prop);
        pc.setProperties(hashTable);
    }

    public void getPropertyForXAResource(OracleXAResource xaResource) throws SQLException {
        Properties prop = new Properties();
        prop.put("user", this.user);
        prop.put("password", this.password);
        prop.put("connection_url", this.url);
        xaResource.setConnectionPropertiesInternal(prop);
    }

    public boolean isV8Compatible() throws SQLException {
        return this.m_v8compatible;
    }

    static {
        GLOBAL_TXN = 2;
        LOCAL_TXN = 1;
        NO_TXN = 0;
        DEFAULT_ROW_PREFETCH = 10;
        svptPrefix = svptPrefix;
        m_traceEnabled = false;
        BINARYSTREAM = 0;
        ASCIISTREAM = 1;
        UNICODESTREAM = 2;
        EOJ_NON = 0;
        EOJ_B_TO_A = 1;
        EOJ_B_TO_U = 2;
        EOJ_A_TO_U = 3;
        EOJ_8_TO_A = 4;
        EOJ_8_TO_U = 5;
        EOJ_U_TO_A = 6;
        ASCII_CHARSET = 0;
        NLS_CHARSET = 1;
        CHAR_TO_ASCII = 0;
        CHAR_TO_UNICODE = 1;
        RAW_TO_ASCII = 2;
        RAW_TO_UNICODE = 3;
        UNICODE_TO_CHAR = 4;
        ASCII_TO_CHAR = 5;
        NONE = 6;
        JAVACHAR_TO_CHAR = 7;
        RAW_TO_JAVACHAR = 8;
        CHAR_TO_JAVACHAR = 9;
    }
}

