/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CLOB;

public class OracleClobWriter
extends Writer {
    DBAccess db_access;
    DBConversion db_conversion;
    CLOB clob;
    long lob_offset;
    char[] charBuf;
    byte[] nativeBuf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;

    public OracleClobWriter(CLOB clob) throws SQLException {
        this(clob, clob.getConnection().db_access.getDefaultStreamChunkSize() / 3, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobWriter.OracleClobWriter(clob=" + clob + ") -- after this()"));
        }
    }

    public OracleClobWriter(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobWriter.OracleClobWriter(clob=" + clob + ", bufferSize=" + bufferSize + ") -- after this()"));
        }
    }

    public OracleClobWriter(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobWriter.OracleClobWriter(clob=" + clob + ", bufferSize=" + bufferSize + ", beginOffset=" + beginOffset + ") -- after supper()"));
        }
        if (clob == null || bufferSize <= 0 || clob.getConnection() == null || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = clob.getConnection().db_access;
        this.db_conversion = clob.getConnection().conversion;
        this.clob = clob;
        this.lob_offset = beginOffset;
        this.charBuf = new char[bufferSize];
        this.nativeBuf = new byte[bufferSize * 3];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = bufferSize;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobWriter.write(cbuf=" + cbuf + ", off=" + off + ", len=" + len + ")"));
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int start = off;
            int end = start + Math.min(len, cbuf.length - off);
            while (start < end) {
                int charsWritten = Math.min(this.chunkSize - this.count, end - start);
                System.arraycopy(cbuf, start, this.charBuf, this.count, charsWritten);
                start += charsWritten;
                this.count += charsWritten;
                if (this.count < this.chunkSize) continue;
                this.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobWriter.flush()");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobWriter.close()");
        }
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.count > 0) {
                    this.clob.putString((int)this.lob_offset, new String(this.charBuf, 0, this.count));
                    this.lob_offset += (long)this.count;
                    this.count = 0;
                }
            }
            catch (SQLException e2) {
                DBError.SQLToIOException((SQLException)e2);
            }
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }
}

