/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CLOB;

public class OracleClobReader
extends Reader {
    CLOB clob;
    DBAccess db_access;
    DBConversion db_conversion;
    long lob_offset;
    long markedChar;
    char[] buf;
    int pos;
    int count;
    int chunkSize;
    boolean isClosed;
    boolean endOfStream;

    public OracleClobReader(CLOB clob) throws SQLException {
        this(clob, clob.getConnection().db_access.getDefaultStreamChunkSize() / 3);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobReader.OracleClobReader(clob=" + clob + ") -- after this()"));
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobReader.OracleClobReader(clob=" + clob + ", bufferSize=" + bufferSize + ") -- after this()"));
        }
    }

    public OracleClobReader(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobReader.OracleClobReader(clob=" + clob + ", bufferSize=" + bufferSize + ", beginOffset=" + beginOffset + ") -- after this()"));
        }
        if (clob == null || bufferSize <= 0 || clob.getConnection() == null || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.db_access = clob.getConnection().db_access;
        this.db_conversion = clob.getConnection().conversion;
        this.clob = clob;
        this.lob_offset = beginOffset;
        this.markedChar = -1L;
        this.buf = new char[bufferSize];
        this.count = 0;
        this.pos = 0;
        this.chunkSize = bufferSize;
        this.isClosed = false;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobReader.read(cbuf=" + cbuf + ", off=" + off + ", len=" + len + ")"));
        }
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int start = off;
        int end = start + Math.min(len, cbuf.length - off);
        start += this.writeChars(cbuf, start, end - start);
        while (start < end && this.needChars()) {
            start += this.writeChars(cbuf, start, end - start);
        }
        return start - off;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.clob.getChars(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException e2) {
                    DBError.SQLToIOException((SQLException)e2);
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] destbuf, int offset, int length) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobReader.writeChars(destbuf=" + destbuf + ", offset=" + offset + ", length=" + length + ")"));
        }
        int availableLength = Math.min(length, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    public boolean ready() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobReader.ready()");
        }
        this.ensureOpen();
        return this.pos < this.count;
    }

    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobReader.close()");
        }
        this.isClosed = true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    public boolean markSupported() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobReader.markSupported()");
        }
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobReader.mark(readAheadLimit=" + readAheadLimit + ")"));
        }
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedChar = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public void reset() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobReader.reset()");
        }
        this.ensureOpen();
        if (this.markedChar < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedChar;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long n2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobReader.skip(n=" + n2 + ")"));
        }
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n2) {
            this.pos = (int)((long)this.pos + n2);
            start += n2;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = this.clob.length() - this.lob_offset + 1L;
                if (remainLen >= n2 - start) {
                    this.lob_offset += n2 - start;
                    start += n2 - start;
                } else {
                    this.lob_offset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e2) {
                DBError.SQLToIOException((SQLException)e2);
            }
        }
        return start;
    }
}

