/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CLOB;

public class OracleClobOutputStream
extends OutputStream {
    long m_lobOffset;
    CLOB m_clob;
    byte[] m_buf;
    int m_count;
    int m_bufSize;
    boolean m_isClosed;

    public OracleClobOutputStream(CLOB clob) throws SQLException {
        this(clob, clob.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobOutputStream.OracleClobOutputStream(clob=" + clob + ") -- after this()"));
        }
    }

    public OracleClobOutputStream(CLOB clob, int bufferSize) throws SQLException {
        this(clob, bufferSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobOutputStream.OracleClobOutputStream(clob=" + clob + ", bufferSize=" + bufferSize + ") -- after this()"));
        }
    }

    public OracleClobOutputStream(CLOB clob, int bufferSize, long beginOffset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobOutputStream.OracleClobOutputStream(clob=" + clob + ", bufferSize=" + bufferSize + ", beginOffset=" + beginOffset + ") -- after super()"));
        }
        if (clob == null || bufferSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_clob = clob;
        this.m_lobOffset = beginOffset;
        this.m_buf = new byte[bufferSize];
        this.m_count = 0;
        this.m_bufSize = bufferSize;
        this.m_isClosed = false;
    }

    public void write(int b2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobOutputStream.write(b=" + b2 + ")"));
        }
        this.ensureOpen();
        if (this.m_count >= this.m_buf.length) {
            this.flushBuffer();
        }
        this.m_buf[this.m_count++] = (byte)b2;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobOutputStream.write(b=" + b2 + ", off=" + off + ", len=" + len + ")"));
        }
        this.ensureOpen();
        int start = off;
        int end = start + Math.min(len, b2.length - off);
        while (start < end) {
            int bytesWritten = Math.min(this.m_bufSize - this.m_count, end - start);
            System.arraycopy(b2, start, this.m_buf, this.m_count, bytesWritten);
            start += bytesWritten;
            this.m_count += bytesWritten;
            if (this.m_count < this.m_bufSize) continue;
            this.flushBuffer();
        }
    }

    public void flush() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobOutputStream.flush()");
        }
        this.ensureOpen();
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobOutputStream.close()");
        }
        this.flushBuffer();
        this.m_isClosed = true;
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.m_count > 0) {
                char[] charArr = new char[this.m_count];
                int i2 = 0;
                while (i2 < this.m_count) {
                    charArr[i2] = (char)this.m_buf[i2];
                    ++i2;
                }
                this.m_lobOffset += (long)this.m_clob.putChars(this.m_lobOffset, charArr);
                this.m_count = 0;
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.m_isClosed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }
}

