/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CLOB;

public class OracleClobInputStream
extends OracleBufferedStream {
    protected long m_lobOffset;
    protected CLOB m_clob;
    protected long m_markedByte;
    protected boolean m_endOfStream;
    protected char[] m_charBuf;

    public OracleClobInputStream(CLOB clob) throws SQLException {
        this(clob, clob.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobInputStream.OracleClobInputStream(clob=" + clob + ") -- after this()"));
        }
    }

    public OracleClobInputStream(CLOB clob, int chunkSize) throws SQLException {
        this(clob, chunkSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobInputStream.OracleClobInputStream(clob=" + clob + ", chunkSize=" + chunkSize + ") -- after this()"));
        }
    }

    public OracleClobInputStream(CLOB clob, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleClobInputStream.OracleClobInputStream(clob=" + clob + ", chunkSize=" + chunkSize + ", beginOffset=" + beginOffset + ") -- after super()"));
        }
        if (clob == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.m_lobOffset = beginOffset;
        this.m_clob = clob;
        this.m_markedByte = -1L;
        this.m_endOfStream = false;
        this.m_charBuf = new char[chunkSize];
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.m_endOfStream) {
                try {
                    this.count = this.m_clob.getChars(this.m_lobOffset, this.chunkSize, this.m_charBuf);
                    int i2 = 0;
                    while (i2 < this.count) {
                        this.buf[i2] = (byte)this.m_charBuf[i2];
                        ++i2;
                    }
                    if (this.count < this.chunkSize) {
                        this.m_endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.m_lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException e2) {
                    DBError.SQLToIOException((SQLException)e2);
                }
            }
            return false;
        }
        return true;
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    public boolean markSupported() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobInputStream.markSupported()");
        }
        return true;
    }

    public synchronized void mark(int readLimit) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobInputStream.mark(readLimit=" + readLimit + ")"));
        }
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.m_markedByte = this.m_lobOffset - (long)this.count + (long)this.pos;
    }

    public synchronized void reset() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleClobInputStream.reset()");
        }
        this.ensureOpen();
        if (this.m_markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.m_lobOffset = this.m_markedByte;
        this.pos = this.count;
        this.m_endOfStream = false;
    }

    public long skip(long n2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleClobInputStream.skip(n=" + n2 + ")"));
        }
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n2) {
            this.pos = (int)((long)this.pos + n2);
            start += n2;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = 0L;
                remainLen = this.m_clob.length() - this.m_lobOffset + 1L;
                if (remainLen >= n2 - start) {
                    this.m_lobOffset += n2 - start;
                    start += n2 - start;
                } else {
                    this.m_lobOffset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e2) {
                DBError.SQLToIOException((SQLException)e2);
            }
        }
        return start;
    }
}

