/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORADataFactory;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

public class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    public OracleCallableStatement(OracleConnection conn, String sql, int batchValue, int rowPrefetchValue) throws SQLException {
        this(conn, sql, batchValue, rowPrefetchValue, 1003, 1007);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.OracleCallableStatement(conn, sql,batchValue, rowPrefetchValue)");
            OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("sql=<" + sql + ">"));
        }
    }

    public OracleCallableStatement(OracleConnection conn, String sql, int batch_value, int row_prefetch_value, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sql, batch_value, row_prefetch_value, UserResultSetType, UserResultSetConcur);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.OracleCallableStatement(conn, sql, batchValue, rowPrefetchValue, UserResultSetType=" + UserResultSetType + ", UserResultSetConcur)"));
            OracleLog.print((Object)this, (int)1, (int)16, (int)128, (String)("sql=<" + sql + ">"));
        }
        this.statementType = 2;
        this.parseSqlKind();
        this.binds_out = this.connection.db_access.createDBDataSet(conn, (OracleStatement)this, batch_value, 2);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.OracleCallableStatement:return");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int paramIndex, int sqlType, String sqlName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.registerOutParameter(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", sqlName=" + sqlName + ")"));
        }
        if (sqlType != 2002 && sqlType != 2008 && sqlType != 2003 && sqlType != 2006 && sqlType != 2007) {
            DBError.throwSqlException((int)12, (Object)("sqlType=" + sqlType));
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                int internal_type = this.get_internal_type(sqlType);
                int index = paramIndex - 1;
                this.checkBindTypes(false, index, internal_type);
                this.resetBatch();
                if (sqlType == 2002 || sqlType == 2006 || sqlType == 2008) {
                    StructDescriptor desc = StructDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    this.binds_out.setType(index, internal_type, (OracleType)desc.getOracleTypeADT());
                } else if (sqlType == 2003) {
                    ArrayDescriptor desc = ArrayDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    this.binds_out.setType(index, internal_type, (OracleType)desc.getOracleTypeCOLLECTION());
                } else if (sqlType == 2007) {
                    OpaqueDescriptor desc = OpaqueDescriptor.createDescriptor(sqlName, (Connection)this.connection);
                    this.binds_out.setType(index, internal_type, (OracleType)((OracleTypeOPAQUE)desc.getPickler()));
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.registerOutParameter(paramIndex, sqlType, sqlName):return");
        }
    }

    public synchronized void registerOutParameterBytes(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleCallableStatement.registerOutParameterBytes(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")"));
        }
        if (sqlType == 2002 || sqlType == 2008 || sqlType == 2003 || sqlType == 2006 || sqlType == 2007) {
            DBError.throwSqlException((int)12, (Object)("sqlType=" + sqlType));
        }
        int index = paramIndex - 1;
        int internal_type = this.get_internal_type(sqlType);
        this.checkBindTypes(false, index, internal_type);
        this.resetBatch();
        int max_value = this.max_field_size;
        if (internal_type == 96 || internal_type == 1 || internal_type == 999) {
            if (maxLength != -1 && max_value < maxLength) {
                max_value = maxLength;
            }
            this.binds_out.setType(index, 1, sqlType, max_value, this.binds_out.getFormOfUse(index));
        } else if (internal_type == 8) {
            if (maxLength != -1 && max_value < maxLength) {
                max_value = maxLength;
            }
            this.binds_out.setType(index, 1, sqlType, max_value, this.binds_out.getFormOfUse(index));
        } else if (internal_type == 24 || internal_type == 23) {
            if (maxLength != -1 && max_value < maxLength) {
                max_value = maxLength;
            }
            this.binds_out.setType(index, 23, sqlType, max_value, this.binds_out.getFormOfUse(index));
        } else if (internal_type == 102) {
            this.binds_out.setType(index, 102, sqlType, 0, this.binds_out.getFormOfUse(index));
            this.has_ref_cursors = true;
        } else {
            this.binds_out.setType(index, internal_type, sqlType, max_value, this.binds_out.getFormOfUse(index));
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.registerOutParameterBytes(paramIndex, sqlType, scale, maxLength):return");
        }
    }

    public synchronized void registerOutParameterChars(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleCallableStatement.registerOutParameterChars(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")"));
        }
        int nlsratio = this.connection.db_access.getNlsRatio();
        if (sqlType == 1 || sqlType == 12) {
            this.registerOutParameterBytes(paramIndex, sqlType, scale, maxLength * nlsratio);
        } else {
            this.registerOutParameterBytes(paramIndex, sqlType, scale, maxLength);
        }
    }

    public synchronized void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleCallableStatement.registerOutParameter(paramIndex=" + paramIndex + ", sqlType=" + sqlType + ", scale=" + scale + ", maxLength=" + maxLength + ")"));
        }
        this.registerOutParameterBytes(paramIndex, sqlType, scale, maxLength * this.connection.dataSizeScale);
    }

    private void resetBatch() {
        this.batch = 1;
    }

    public synchronized void setExecuteBatch(int nrows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleCallableStatement.setExecuteBatch(nrows=" + nrows + ")"));
        }
        this.resetBatch();
    }

    public synchronized int sendBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleCallableStatement.sendBatch()");
        }
        return this.valid_rows;
    }

    public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, 0, -1);
    }

    public void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, scale, -1);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullValue();
    }

    public String getString(int parameterIndex) throws SQLException {
        return this.getStringValue(false, parameterIndex);
    }

    public Datum getOracleObject(int parameterIndex) throws SQLException {
        return this.getOracleObjectValue(false, parameterIndex);
    }

    public ROWID getROWID(int parameterIndex) throws SQLException {
        return this.getROWIDValue(false, parameterIndex);
    }

    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        return this.getNUMBERValue(false, parameterIndex);
    }

    public DATE getDATE(int parameterIndex) throws SQLException {
        return this.getDATEValue(false, parameterIndex);
    }

    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        return this.getINTERVALYMValue(false, parameterIndex);
    }

    public TIMESTAMP getTIMESTAMP(int parameterIndex) throws SQLException {
        return this.getTIMESTAMPValue(false, parameterIndex);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int parameterIndex) throws SQLException {
        return this.getTIMESTAMPTZValue(false, parameterIndex);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int parameterIndex) throws SQLException {
        return this.getTIMESTAMPLTZValue(false, parameterIndex);
    }

    public REF getREF(int parameterIndex) throws SQLException {
        return this.getREFValue(false, parameterIndex);
    }

    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        return this.getARRAYValue(false, parameterIndex);
    }

    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        return this.getSTRUCTValue(false, parameterIndex);
    }

    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        return this.getOPAQUEValue(false, parameterIndex);
    }

    public CHAR getCHAR(int parameterIndex) throws SQLException {
        return this.getCHARValue(false, parameterIndex);
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStreamValue(false, parameterIndex);
    }

    public RAW getRAW(int parameterIndex) throws SQLException {
        return this.getRAWValue(false, parameterIndex);
    }

    public BLOB getBLOB(int parameterIndex) throws SQLException {
        return this.getBLOBValue(false, parameterIndex);
    }

    public CLOB getCLOB(int parameterIndex) throws SQLException {
        return this.getCLOBValue(false, parameterIndex);
    }

    public BFILE getBFILE(int parameterIndex) throws SQLException {
        return this.getBFILEValue(false, parameterIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getBooleanValue(false, parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this.getByteValue(false, parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this.getShortValue(false, parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this.getIntValue(false, parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this.getLongValue(false, parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this.getFloatValue(false, parameterIndex);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this.getDoubleValue(false, parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getBigDecimalValue(false, parameterIndex, scale);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getBytesValue(false, parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this.getDateValue(false, parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this.getTimeValue(false, parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestampValue(false, parameterIndex);
    }

    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        return this.getAsciiStreamValue(false, parameterIndex);
    }

    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        return this.getUnicodeStreamValue(false, parameterIndex);
    }

    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        return this.getBinaryStreamValue(false, parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this.getObjectValue(false, parameterIndex);
    }

    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        byte[] bytes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.getAnyDataEmbeddedObject(parameterIndex=" + parameterIndex + ")"));
        }
        int col_index = parameterIndex - 1;
        if (!this.connection.getProtocolType().equals("oci") && !this.connection.getProtocolType().equals("oci8")) {
            DBError.throwSqlException((int)23);
        }
        this.prepare_for_new_get(false, parameterIndex);
        DBDataSet dbset = this.binds_out;
        int row_index = this.m_currentRank;
        OracleTypeADT otype = (OracleTypeADT)dbset.getOtype(col_index);
        if (dbset.getType(col_index) != 109 || otype == null || !otype.getSimpleName().equals("ANYDATA")) {
            DBError.throwSqlException((int)4);
        }
        if ((bytes = dbset.getBytesItem(col_index, row_index)) == null || bytes.length == 0) {
            return null;
        }
        TypeDescriptor desc = this.connection.db_access.getAnyDataEmbTypeDesc(this.dbstmt, dbset, otype, row_index, col_index);
        Datum dat = null;
        int embDataPos = this.connection.db_access.getAnyDataEmbDataPos(this.dbstmt, row_index, col_index);
        int sizeofEmbData = bytes.length - embDataPos;
        byte[] embBytes = new byte[sizeofEmbData];
        System.arraycopy(bytes, embDataPos, embBytes, 0, sizeofEmbData);
        switch (desc.getTypeCode()) {
            case 2003: {
                dat = new ARRAY((ArrayDescriptor)desc, embBytes, this.connection);
                break;
            }
            case 2002: {
                dat = new STRUCT((StructDescriptor)desc, embBytes, this.connection);
                break;
            }
            case 2007: {
                dat = new OPAQUE((OpaqueDescriptor)desc, embBytes, this.connection);
                break;
            }
            case 2008: {
                dat = new JAVA_STRUCT((StructDescriptor)desc, embBytes, this.connection);
                break;
            }
            default: {
                DBError.throwSqlException((int)4);
            }
        }
        return dat.toJdbc();
    }

    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        return this.getCustomDatumValue(false, parameterIndex, factory);
    }

    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        return this.getORADataValue(false, parameterIndex, factory);
    }

    public ResultSet getCursor(int parameterIndex) throws SQLException {
        return this.getCursorValue(false, parameterIndex);
    }

    public synchronized void clearParameters() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleCallableStatement.clearParameters()");
        }
        if (this.binds_out != null) {
            this.binds_out.clearItems();
        }
        super.clearParameters();
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        return this.getObjectValue(false, parameterIndex, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        return this.getREFValue(false, parameterIndex);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getBLOBValue(false, parameterIndex);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getCLOBValue(false, parameterIndex);
    }

    public Array getArray(int parameterIndex) throws SQLException {
        return this.getARRAYValue(false, parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getBigDecimalValue(false, parameterIndex, 0);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this.getDateValue(false, parameterIndex, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimeValue(false, parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this.getTimestampValue(false, parameterIndex, cal);
    }

    public void addBatch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleCallableStatement.addBatch()");
            OracleLog.print((Object)this, (int)1, (int)16, (int)32, (String)("Add batch: binds_out.noOfOutParams=" + this.binds_out.getNoOfArgs()));
        }
        if (this.binds_out.getNoOfArgs() > 0) {
            DBError.throwSqlException((int)90, (Object)"Stored procedure with out or inout parameters cannot be batched");
        }
        super.addBatch();
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_out != null) {
            this.binds_out.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.close()");
        }
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OracleCallableStatement oracleCallableStatement = this;
            synchronized (oracleCallableStatement) {
                super.close();
                this.cleanup();
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.close():return");
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public URL getURL(int parameterIndex) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setShort(String parameterName, short x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setInt(String parameterName, int x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setLong(String parameterName, long x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setString(String parameterName, String x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public String getString(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return false;
    }

    public byte getByte(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public short getShort(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public int getInt(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public long getLong(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0L;
    }

    public float getFloat(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0.0f;
    }

    public double getDouble(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0.0;
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Date getDate(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized void registerIndexTableOutParameter(int paramIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.registerIndexTableOutParameter(paramIndex=" + paramIndex + ", maxLen=" + maxLen + ", elemSqlType=" + elemSqlType + ", elemMaxLength=" + elemMaxLen + ")"));
        }
        if (maxLen < 0) {
            DBError.throwSqlException((int)68, (Object)"maxLen < 0");
        }
        int elem_internal_type = this.get_internal_type(elemSqlType);
        this.checkPlsqlIndexTableBindTypes(false, paramIndex - 1, maxLen, elem_internal_type, elemMaxLen);
        this.resetBatch();
        this.binds_out.setPlsqlIndexTableType(paramIndex - 1, maxLen, elemMaxLen, elem_internal_type);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.registerIndexTableOutParameter(paramIndex, maxLen, elemSqlType, elemMaxLen):return");
        }
    }

    public synchronized Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.getPlsqlIndexTable(paramIndex=" + paramIndex + ")"));
        }
        Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
        int column_type = this.binds_out.getPlsqlIndexTableType(paramIndex - 1);
        Object jarray = null;
        switch (column_type) {
            case 1: 
            case 96: 
            case 999: {
                jarray = new String[darray.length];
                break;
            }
            case 2: 
            case 6: {
                jarray = new BigDecimal[darray.length];
                break;
            }
            case 23: {
                jarray = new byte[darray.length][];
                break;
            }
            case 12: {
                jarray = new Timestamp[darray.length];
                break;
            }
            default: {
                DBError.throwSqlException((int)1, (Object)"Invalid column type");
            }
        }
        int i2 = 0;
        while (i2 < ((Object[])jarray).length) {
            jarray[i2] = darray[i2] != null && darray[i2].getLength() != 0L ? darray[i2].toJdbc() : null;
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.getPlsqlIndexTable(paramIndex):return()");
        }
        return jarray;
    }

    public synchronized Object getPlsqlIndexTable(int paramIndex, Class primitiveType) throws SQLException {
        String type;
        Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
        if (primitiveType == null || !primitiveType.isPrimitive()) {
            DBError.throwSqlException((int)68);
        }
        if ((type = primitiveType.getName()).equals("byte")) {
            byte[] jarray = new byte[darray.length];
            int i2 = 0;
            while (i2 < darray.length) {
                jarray[i2] = darray[i2] != null ? darray[i2].byteValue() : (byte)0;
                ++i2;
            }
            return jarray;
        }
        if (type.equals("char")) {
            char[] jarray = new char[darray.length];
            int i3 = 0;
            while (i3 < darray.length) {
                jarray[i3] = darray[i3] != null && darray[i3].getLength() != 0L ? (char)darray[i3].intValue() : (char)'\u0000';
                ++i3;
            }
            return jarray;
        }
        if (type.equals("double")) {
            double[] jarray = new double[darray.length];
            int i4 = 0;
            while (i4 < darray.length) {
                jarray[i4] = darray[i4] != null && darray[i4].getLength() != 0L ? darray[i4].doubleValue() : 0.0;
                ++i4;
            }
            return jarray;
        }
        if (type.equals("float")) {
            float[] jarray = new float[darray.length];
            int i5 = 0;
            while (i5 < darray.length) {
                jarray[i5] = darray[i5] != null && darray[i5].getLength() != 0L ? darray[i5].floatValue() : 0.0f;
                ++i5;
            }
            return jarray;
        }
        if (type.equals("int")) {
            int[] jarray = new int[darray.length];
            int i6 = 0;
            while (i6 < darray.length) {
                jarray[i6] = darray[i6] != null && darray[i6].getLength() != 0L ? darray[i6].intValue() : 0;
                ++i6;
            }
            return jarray;
        }
        if (type.equals("long")) {
            long[] jarray = new long[darray.length];
            int i7 = 0;
            while (i7 < darray.length) {
                jarray[i7] = darray[i7] != null && darray[i7].getLength() != 0L ? darray[i7].longValue() : 0L;
                ++i7;
            }
            return jarray;
        }
        if (type.equals("short")) {
            short[] jarray = new short[darray.length];
            int i8 = 0;
            while (i8 < darray.length) {
                jarray[i8] = darray[i8] != null && darray[i8].getLength() != 0L ? (short)darray[i8].intValue() : (short)0;
                ++i8;
            }
            return jarray;
        }
        if (type.equals("boolean")) {
            boolean[] jarray = new boolean[darray.length];
            int i9 = 0;
            while (i9 < darray.length) {
                jarray[i9] = darray[i9] != null && darray[i9].getLength() != 0L ? darray[i9].booleanValue() : false;
                ++i9;
            }
            return jarray;
        }
        DBError.throwSqlException((int)23);
        return null;
    }

    public synchronized Datum[] getOraclePlsqlIndexTable(int paramIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleCallableStatement.getOraclePlsqlIndexTable(index=" + paramIndex + ")"));
        }
        this.prepare_for_new_get(false, paramIndex);
        if (this.binds_out.getType(paramIndex - 1) != 998) {
            DBError.throwSqlException((int)4);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleCallableStatement.getOraclePlsqlIndexTable(PlsqlIndexTableItem):return");
        }
        return this.binds_out.getPlsqlIndexTableItem(paramIndex - 1, this.m_currentRank);
    }

    public synchronized void setFormOfUse(int paramIndex, short formOfUse) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleCallableStatement.setFormOfUse(paramIndex=" + paramIndex + ", formOfUse=" + formOfUse + ")"));
        }
        this.binds_in.setFormOfUse(paramIndex, formOfUse);
        this.binds_out.setFormOfUse(paramIndex, formOfUse);
    }
}

