/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import oracle.jdbc.driver.OracleLog;

public class OracleBufferedStream
extends InputStream {
    byte[] buf;
    int pos;
    int count;
    boolean closed;
    int chunkSize;

    public OracleBufferedStream(int chunkSize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)("OracleBufferedStream.OracleBufferedStream(" + chunkSize + ")"));
        }
        this.pos = 0;
        this.count = 0;
        this.closed = false;
        this.chunkSize = chunkSize;
        this.buf = new byte[chunkSize];
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleBufferedStream.OracleBufferedStream:return");
        }
    }

    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleBufferedStream.close()");
        }
        this.closed = true;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)16, (String)"OracleBufferedStream.close():return");
        }
    }

    public boolean needBytes() throws IOException {
        throw new IOException("You should not call this method");
    }

    public int flushBytes(int n2) {
        int availableLength = n2 > this.count - this.pos ? this.count - this.pos : n2;
        this.pos += availableLength;
        return availableLength;
    }

    public int writeBytes(byte[] destbuf, int offset, int length) {
        int availableLength = length > this.count - this.pos ? this.count - this.pos : length;
        System.arraycopy(this.buf, this.pos, destbuf, offset, availableLength);
        this.pos += availableLength;
        return availableLength;
    }

    public synchronized int read() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleBufferedStream.read()");
        }
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)"OracleBufferedStream.read(b)");
        }
        return this.read(b2, 0, b2.length);
    }

    public synchronized int read(byte[] destbuf, int offset, int length) throws IOException {
        int start = offset;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleBufferedStream.read(destbuf, offset=" + offset + ", length=" + length + ")"));
        }
        if (this.closed || this.isNull()) {
            return -1;
        }
        int end = length > destbuf.length ? start + destbuf.length : start + length;
        if (!this.needBytes()) {
            return -1;
        }
        start += this.writeBytes(destbuf, start, end - start);
        while (start < end && this.needBytes()) {
            start += this.writeBytes(destbuf, start, end - start);
        }
        return start - offset;
    }

    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(int n) throws IOException {
        start = 0;
        end = n;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (int)1, (String)("OracleBufferedStream.skip(n=" + n + ")"));
        }
        if (this.closed || this.isNull()) {
            return -1L;
        }
        if (this.needBytes()) ** GOTO lbl10
        return -1L;
lbl-1000:
        // 1 sources

        {
            start += this.flushBytes(end - start);
lbl10:
            // 2 sources

            ** while (start < end && this.needBytes())
        }
lbl11:
        // 1 sources

        return start;
    }
}

