/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.BLOB;

public class OracleBlobOutputStream
extends OutputStream {
    long lob_offset;
    BLOB blob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;

    public OracleBlobOutputStream(BLOB blob) throws SQLException {
        this(blob, blob.getConnection().db_access.getDefaultStreamChunkSize());
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobOutputStream.OracleBlobOutputStream(blob=" + blob + ") -- after this()"));
        }
    }

    public OracleBlobOutputStream(BLOB blob, int bufferSize) throws SQLException {
        this(blob, bufferSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobOutputStream.OracleBlobOutputStream(blob=" + blob + ", bufferSize=" + bufferSize + ") -- after this()"));
        }
    }

    public OracleBlobOutputStream(BLOB blob, int bufferSize, long offset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobOutputStream.OracleBlobOutputStream(blob=" + blob + ", bufferSize=" + bufferSize + ", offset=" + offset + ") -- after super()"));
        }
        if (blob == null || bufferSize <= 0 || offset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = blob;
        this.lob_offset = offset;
        this.buf = new byte[bufferSize];
        this.count = 0;
        this.bufSize = bufferSize;
        this.isClosed = false;
    }

    public void write(int b2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleBlobOutputStream.write(b=" + b2 + ")"));
        }
        this.ensureOpen();
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b2;
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleBlobOutputStream.write(b=" + b2 + ", off=" + off + ", len=" + len + ")"));
        }
        this.ensureOpen();
        int start = off;
        int end = start + Math.min(len, b2.length - off);
        while (start < end) {
            int bytesWritten = Math.min(this.bufSize - this.count, end - start);
            System.arraycopy(b2, start, this.buf, this.count, bytesWritten);
            start += bytesWritten;
            this.count += bytesWritten;
            if (this.count < this.bufSize) continue;
            this.flushBuffer();
        }
    }

    public void flush() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleBlobOutputStream.flush()");
        }
        this.ensureOpen();
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleBlobOutputStream.close()");
        }
        this.flushBuffer();
        this.isClosed = true;
    }

    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                if (this.count < this.buf.length) {
                    byte[] tmp_buf = new byte[this.count];
                    System.arraycopy(this.buf, 0, tmp_buf, 0, this.count);
                    this.lob_offset += (long)this.blob.putBytes(this.lob_offset, tmp_buf);
                } else {
                    this.lob_offset += (long)this.blob.putBytes(this.lob_offset, this.buf);
                }
                this.count = 0;
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }
}

