/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.Datum;

public class OracleBlobInputStream
extends OracleBufferedStream {
    long lob_offset;
    Datum lob;
    long markedByte;
    boolean endOfStream = false;

    public OracleBlobInputStream(BLOB blob) throws SQLException {
        this(blob, blob.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(blob=" + blob + ") -- after this()"));
        }
    }

    public OracleBlobInputStream(BLOB blob, int chunkSize) throws SQLException {
        this(blob, chunkSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(blob=" + blob + ", chunkSize=" + chunkSize + ") -- after this()"));
        }
    }

    public OracleBlobInputStream(BLOB blob, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(blob=" + blob + ", chunkSize=" + chunkSize + ", beginOffset=" + beginOffset + ") -- after super()"));
        }
        if (blob == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = blob;
        this.markedByte = -1L;
        this.lob_offset = beginOffset;
    }

    public OracleBlobInputStream(BFILE bfile) throws SQLException {
        this(bfile, bfile.getConnection().db_access.getDefaultStreamChunkSize(), 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(bfile=" + bfile + ") -- after this()"));
        }
    }

    public OracleBlobInputStream(BFILE bfile, int chunkSize) throws SQLException {
        this(bfile, chunkSize, 1L);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(bfile=" + bfile + ", chunkSize=" + chunkSize + ") -- after this()"));
        }
    }

    public OracleBlobInputStream(BFILE bfile, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)16, (String)("OracleBlobInputStream.OracleBlobInputStream(bfile=" + bfile + ", chunkSize=" + chunkSize + ", beginOffset=" + beginOffset + ") -- after super()"));
        }
        if (bfile == null || chunkSize <= 0 || beginOffset < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.lob = bfile;
        this.markedByte = -1L;
        this.lob_offset = beginOffset;
    }

    public boolean needBytes() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    this.count = this.lob instanceof BLOB ? ((BLOB)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf) : ((BFILE)this.lob).getBytes(this.lob_offset, this.chunkSize, this.buf);
                    if (this.count < this.chunkSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lob_offset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException e2) {
                    DBError.SQLToIOException((SQLException)e2);
                }
            }
            return false;
        }
        return true;
    }

    void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                DBError.check_error((int)57, null);
            }
        }
        catch (SQLException e2) {
            DBError.SQLToIOException((SQLException)e2);
        }
    }

    public boolean markSupported() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleBlobInputStream.markSupported()");
        }
        return true;
    }

    public synchronized void mark(int readLimit) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleBlobInputStream.mark(readLimit=" + readLimit + ")"));
        }
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.markedByte = this.lob_offset - (long)this.count + (long)this.pos;
    }

    public synchronized void reset() throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)"OracleBlobInputStream.reset()");
        }
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException("Mark invalid or stream not marked.");
        }
        this.lob_offset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    public long skip(long n2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1, (String)("OracleBlogInputStream.skip(n=" + n2 + ")"));
        }
        this.ensureOpen();
        long start = 0L;
        if ((long)(this.count - this.pos) >= n2) {
            this.pos = (int)((long)this.pos + n2);
            start += n2;
        } else {
            start += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long remainLen = 0L;
                remainLen = this.lob instanceof BLOB ? ((BLOB)this.lob).length() - this.lob_offset + 1L : ((BFILE)this.lob).length() - this.lob_offset + 1L;
                if (remainLen >= n2 - start) {
                    this.lob_offset += n2 - start;
                    start += n2 - start;
                } else {
                    this.lob_offset += remainLen;
                    start += remainLen;
                }
            }
            catch (SQLException e2) {
                DBError.SQLToIOException((SQLException)e2);
            }
        }
        return start;
    }
}

