/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleStatementCacheEntry;

public class LRUStatementCache {
    private int cacheSize;
    private int numElements;
    private OracleStatementCacheEntry applicationCacheStart;
    private OracleStatementCacheEntry applicationCacheEnd;
    private OracleStatementCacheEntry implicitCacheStart;
    private OracleStatementCacheEntry explicitCacheStart;
    boolean implicitCacheEnabled;
    boolean explicitCacheEnabled;
    private boolean debug = false;

    protected LRUStatementCache(int size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("LRUStatementCache(" + size + ")"));
        }
        if (size < 0) {
            DBError.throwSqlException((int)123);
        }
        this.cacheSize = size;
        this.numElements = 0;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.implicitCacheEnabled = false;
        this.explicitCacheEnabled = false;
    }

    protected void resize(int newSize) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("resize(" + newSize + ") entry"));
            OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)("resize: existing size: " + this.cacheSize + ", new size: " + newSize));
        }
        if (newSize < 0) {
            DBError.throwSqlException((int)123);
        }
        if (newSize >= this.cacheSize || newSize >= this.numElements) {
            this.cacheSize = newSize;
        } else {
            OracleStatementCacheEntry e2 = this.applicationCacheEnd;
            while (this.numElements > newSize) {
                this.purgeCacheEntry(e2);
                e2 = e2.applicationPrev;
            }
            this.cacheSize = newSize;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("resize(" + newSize + ") exit"));
        }
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("setImplicitCachingEnabled(" + cache + ")"));
        }
        if (!cache) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = cache;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("getImplicitCachingEnabled(), returning " + retValue));
        }
        return retValue;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("setExplicitCachingEnabled(" + cache + ")"));
        }
        if (!cache) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = cache;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("getExplicitCachingEnabled(), returning " + retValue));
        }
        return retValue;
    }

    protected void addToImplicitCache(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("addToImplicitCache(" + sql + ", " + statementType + ", " + scrollType + ") entry"));
        }
        if (this.debug) {
            this.printCache("start of addToImplicitCache");
        }
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == OracleStatement.CACHED) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)"implicit caching not enabled or already cached, returning...");
            }
            if (this.debug) {
                System.out.println("addToImplicitCache: Not caching " + stmt);
            }
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        stmt.enterImplicitCache();
        OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
        entry.statement = stmt;
        entry.onImplicit = true;
        entry.sql = sql;
        entry.statementType = statementType;
        entry.scrollType = scrollType;
        entry.applicationNext = this.applicationCacheStart;
        entry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = entry;
        }
        this.applicationCacheStart = entry;
        entry.implicitNext = this.implicitCacheStart;
        entry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = entry;
        }
        this.implicitCacheStart = entry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = entry;
        }
        ++this.numElements;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"addToImplicitCache exit");
        }
        if (this.debug) {
            this.printCache("end of addToImplicitCache");
        }
    }

    protected void addToExplicitCache(OraclePreparedStatement stmt, String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("addToExplicitCache(" + key + ")"));
        }
        if (this.debug) {
            this.printCache("start of addToExplicitCache");
        }
        if (!this.explicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == OracleStatement.CACHED) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)"explicit caching not enabled or already cached, returning...");
            }
            if (this.debug) {
                System.out.println("addToImplicitCache: Not caching " + stmt);
            }
            return;
        }
        if (this.numElements == this.cacheSize) {
            this.purgeCacheEntry(this.applicationCacheEnd);
        }
        stmt.enterExplicitCache();
        OracleStatementCacheEntry entry = new OracleStatementCacheEntry();
        entry.statement = stmt;
        entry.sql = key;
        entry.onImplicit = false;
        entry.applicationNext = this.applicationCacheStart;
        entry.applicationPrev = null;
        if (this.applicationCacheStart != null) {
            this.applicationCacheStart.applicationPrev = entry;
        }
        this.applicationCacheStart = entry;
        entry.explicitNext = this.explicitCacheStart;
        entry.explicitPrev = null;
        if (this.explicitCacheStart != null) {
            this.explicitCacheStart.explicitPrev = entry;
        }
        this.explicitCacheStart = entry;
        if (this.applicationCacheEnd == null) {
            this.applicationCacheEnd = entry;
        }
        ++this.numElements;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"addToExplicitCache exit");
        }
        if (this.debug) {
            this.printCache("end of addToExplicitCache");
        }
    }

    protected OracleStatement searchImplicitCache(String sql, int statementType, int scrollType) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("searchImplicitCache(" + sql + ", " + statementType + ", " + scrollType + ")"));
        }
        if (this.debug) {
            this.printCache("start of searchImplicitCache");
        }
        if (!this.implicitCacheEnabled) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)"searchImplicitCache: implicit cache not enabled, returning null");
            }
            return null;
        }
        OracleStatementCacheEntry entry = null;
        entry = this.implicitCacheStart;
        while (entry != null) {
            if (entry.sql.equals(sql) && entry.statementType == statementType && entry.scrollType == scrollType) break;
            entry = entry.implicitNext;
        }
        if (entry != null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)("searchImplicitCache: Found statement with sql " + entry.sql + ", statementType: " + statementType + ", scrollType: " + scrollType));
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            if (entry.implicitPrev != null) {
                entry.implicitPrev.implicitNext = entry.implicitNext;
            }
            if (entry.implicitNext != null) {
                entry.implicitNext.implicitPrev = entry.implicitPrev;
            }
            if (this.implicitCacheStart == entry) {
                this.implicitCacheStart = entry.implicitNext;
            }
            --this.numElements;
            entry.statement.exitImplicitCacheToActive();
            if (this.debug) {
                this.printCache("searchImplicitCache, about to return success");
            }
            return entry.statement;
        }
        return null;
    }

    protected OracleStatement searchExplicitCache(String key) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("searchExplicitCache(" + key + ")"));
        }
        if (this.debug) {
            this.printCache("start of searchExplicitCache");
        }
        if (!this.explicitCacheEnabled) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)"searchExplicitCache: explicit cache not enabled, returning null");
            }
            return null;
        }
        OracleStatementCacheEntry entry = null;
        entry = this.explicitCacheStart;
        while (entry != null) {
            if (entry.sql.equals(key)) break;
            entry = entry.explicitNext;
        }
        if (entry != null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)("searchExplicitCache: Found statement with key " + entry.sql));
            }
            if (entry.applicationPrev != null) {
                entry.applicationPrev.applicationNext = entry.applicationNext;
            }
            if (entry.applicationNext != null) {
                entry.applicationNext.applicationPrev = entry.applicationPrev;
            }
            if (this.applicationCacheStart == entry) {
                this.applicationCacheStart = entry.applicationNext;
            }
            if (this.applicationCacheEnd == entry) {
                this.applicationCacheEnd = entry.applicationPrev;
            }
            if (entry.explicitPrev != null) {
                entry.explicitPrev.explicitNext = entry.explicitNext;
            }
            if (entry.explicitNext != null) {
                entry.explicitNext.explicitPrev = entry.explicitPrev;
            }
            if (this.explicitCacheStart == entry) {
                this.explicitCacheStart = entry.explicitNext;
            }
            --this.numElements;
            entry.statement.exitExplicitCacheToActive();
            if (this.debug) {
                this.printCache("searchExplicitCache, about to return success");
            }
            return entry.statement;
        }
        return null;
    }

    protected void purgeImplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"purgeImplicitCache() entry");
        }
        OracleStatementCacheEntry entry = this.implicitCacheStart;
        while (entry != null) {
            this.purgeCacheEntry(entry);
            entry = entry.implicitNext;
        }
        this.implicitCacheStart = null;
    }

    protected void purgeExplicitCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"purgeExplicitCache() entry");
        }
        OracleStatementCacheEntry entry = this.explicitCacheStart;
        while (entry != null) {
            this.purgeCacheEntry(entry);
            entry = entry.explicitNext;
        }
        this.explicitCacheStart = null;
    }

    private void purgeCacheEntry(OracleStatementCacheEntry entry) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"purgeCacheEntry()");
            OracleLog.print((Object)this, (int)1, (int)1024, (int)32, (String)("purgeCacheEntry: key is " + entry.sql + ", statementType: " + entry.statementType + ", scrollType: " + entry.scrollType));
        }
        if (entry.applicationNext != null) {
            entry.applicationNext.applicationPrev = entry.applicationPrev;
        }
        if (entry.applicationPrev != null) {
            entry.applicationPrev.applicationNext = entry.applicationNext;
        }
        if (this.applicationCacheStart == entry) {
            this.applicationCacheStart = entry.applicationNext;
        }
        if (this.applicationCacheEnd == entry) {
            this.applicationCacheEnd = entry.applicationPrev;
        }
        if (entry.onImplicit) {
            if (entry.implicitNext != null) {
                entry.implicitNext.implicitPrev = entry.implicitPrev;
            }
            if (entry.implicitPrev != null) {
                entry.implicitPrev.implicitNext = entry.implicitNext;
            }
            if (this.implicitCacheStart == entry) {
                this.implicitCacheStart = entry.implicitNext;
            }
        } else {
            if (entry.explicitNext != null) {
                entry.explicitNext.explicitPrev = entry.explicitPrev;
            }
            if (entry.explicitPrev != null) {
                entry.explicitPrev.explicitNext = entry.explicitNext;
            }
            if (this.explicitCacheStart == entry) {
                this.explicitCacheStart = entry.explicitNext;
            }
        }
        --this.numElements;
        if (entry.onImplicit) {
            entry.statement.exitImplicitCacheToClose();
        } else {
            entry.statement.exitExplicitCacheToClose();
        }
    }

    public int getCacheSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)("getCacheSize(), returning " + this.cacheSize));
        }
        return this.cacheSize;
    }

    public void printCache(String msg) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + msg + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled + " explicit enabled: " + this.explicitCacheEnabled);
        System.out.println("applicationStart: " + this.applicationCacheStart + "  applicationEnd: " + this.applicationCacheEnd);
        OracleStatementCacheEntry e2 = this.applicationCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.applicationNext;
        }
        System.out.println("implicitStart: " + this.implicitCacheStart);
        e2 = this.implicitCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.implicitNext;
        }
        System.out.println("explicitStart: " + this.explicitCacheStart);
        e2 = this.explicitCacheStart;
        while (e2 != null) {
            e2.print();
            e2 = e2.explicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + msg + ") ***");
    }

    public void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)1024, (int)16, (String)"LRUStatementCache.close()");
        }
        OracleStatementCacheEntry entry = this.applicationCacheStart;
        while (entry != null) {
            if (entry.onImplicit) {
                entry.statement.exitImplicitCacheToClose();
            } else {
                entry.statement.exitExplicitCacheToClose();
            }
            entry = entry.applicationNext;
        }
        this.applicationCacheStart = null;
        this.applicationCacheEnd = null;
        this.implicitCacheStart = null;
        this.explicitCacheStart = null;
        this.numElements = 0;
    }
}

