/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public abstract class BaseResultSet
extends OracleResultSet {
    SQLWarning m_warning = null;
    boolean m_autoRefetch = true;
    public boolean close_statement_on_close = false;

    public synchronized String getCursorName() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.getCursorName()");
        }
        DBError.check_error((int)23, (Object)"getCursorName");
        return null;
    }

    public void closeStatementOnClose() {
        this.close_statement_on_close = true;
    }

    public void beforeFirst() throws SQLException {
        DBError.throwSqlException((int)75, (Object)"beforeFirst");
    }

    public void afterLast() throws SQLException {
        DBError.throwSqlException((int)75, (Object)"afterLast");
    }

    public boolean first() throws SQLException {
        DBError.throwSqlException((int)75, (Object)"first");
        return false;
    }

    public boolean last() throws SQLException {
        DBError.throwSqlException((int)75, (Object)"last");
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        DBError.throwSqlException((int)75, (Object)"absolute");
        return false;
    }

    public boolean relative(int rows) throws SQLException {
        DBError.throwSqlException((int)75, (Object)"relative");
        return false;
    }

    public boolean previous() throws SQLException {
        DBError.throwSqlException((int)75, (Object)"previous");
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("BaseResultSet.setFetchDirection(direction=" + direction + ")"));
        }
        if (direction == 1000) {
            return;
        }
        if (direction == 1001 || direction == 1002) {
            DBError.throwSqlException((int)75, (Object)"setFetchDirection(FETCH_REVERSE, FETCH_UNKNOWN)");
        } else {
            DBError.throwSqlException((int)68, (Object)"setFetchDirection");
        }
    }

    public int getFetchDirection() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.getFetchDirection: return: 1000");
        }
        return 1000;
    }

    public int getType() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.getType: return: 1003");
        }
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.getConcurrency: return: 1007");
        }
        return 1007;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("BaseResultSet.getWarnings: return: " + this.m_warning));
        }
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.clearWarnings()");
        }
        this.m_warning = null;
    }

    public boolean rowUpdated() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.rowUpdated: return: false");
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.rowInserted: return: false");
        }
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"BaseResultSet.rowDeleted: return: false");
        }
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateNull");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBoolean");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateByte");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateShort");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateInt");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateLong");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateFloat");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateDouble");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBigDecimal");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateString");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBytes");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateDate");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateTime");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateTimestamp");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateAsciiStream");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBinaryStream");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateCharacterStream");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateObject");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateObject");
    }

    public void updateOracleObject(int columnIndex, Datum x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateOracleObject");
    }

    public void updateROWID(int columnIndex, ROWID x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateROWID");
    }

    public void updateNUMBER(int columnIndex, NUMBER x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateNUMBER");
    }

    public void updateDATE(int columnIndex, DATE x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateDATE");
    }

    public void updateARRAY(int columnIndex, ARRAY x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateARRAY");
    }

    public void updateSTRUCT(int columnIndex, STRUCT x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateSTRUCT");
    }

    public void updateOPAQUE(int columnIndex, OPAQUE x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateOPAQUE");
    }

    public void updateREF(int columnIndex, REF x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateREF");
    }

    public void updateCHAR(int columnIndex, CHAR x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateCHAR");
    }

    public void updateRAW(int columnIndex, RAW x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateRAW");
    }

    public void updateBLOB(int columnIndex, BLOB x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBLOB");
    }

    public void updateCLOB(int columnIndex, CLOB x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateCLOB");
    }

    public void updateBFILE(int columnIndex, BFILE x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBFILE");
    }

    public void updateINTERVALYM(int columnIndex, INTERVALYM x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateINTERVALYM");
    }

    public void updateTIMESTAMP(int columnIndex, TIMESTAMP x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateTIMESTAMP");
    }

    public void updateTIMESTAMPTZ(int columnIndex, TIMESTAMPTZ x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateTIMESTAMPTZ");
    }

    public void updateTIMESTAMPLTZ(int columnIndex, TIMESTAMPLTZ x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateTIMESTAMPLTZ");
    }

    public void updateBfile(int columnIndex, BFILE x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBfile");
    }

    public void updateCustomDatum(int columnIndex, CustomDatum x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateCustomDatum");
    }

    public void updateORAData(int columnIndex, ORAData x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateORAData");
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateRef");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateBlob");
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateClob");
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateArray");
    }

    public void insertRow() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"insertRow");
    }

    public void updateRow() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"updateRow");
    }

    public void deleteRow() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"deleteRow");
    }

    public void refreshRow() throws SQLException {
        DBError.check_error((int)23, null);
    }

    public void cancelRowUpdates() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"cancelRowUpdates");
    }

    public void moveToInsertRow() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"moveToInsertRow");
    }

    public void moveToCurrentRow() throws SQLException {
        DBError.throwSqlException((int)76, (Object)"moveToCurrentRow");
    }

    public void setAutoRefetch(boolean autoRefetch) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("BaseResultSet.setAutoRefetch(autoRefetch=" + autoRefetch + ")"));
        }
        this.m_autoRefetch = autoRefetch;
    }

    public boolean getAutoRefetch() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("BaseResultSet.getAutoRefetch: return: " + this.m_autoRefetch));
        }
        return this.m_autoRefetch;
    }
}

