/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map m_map;
    long m_beginIdx;
    int m_count;
    long m_idx;

    public ArrayLocatorResultSet(OracleConnection connection, ArrayDescriptor descriptor, byte[] locator, Map map) throws SQLException {
        this(connection, descriptor, locator, 0L, COUNT_UNLIMITED, map);
    }

    public ArrayLocatorResultSet(OracleConnection connection, ArrayDescriptor descriptor, byte[] locator, long beginIdx, int count, Map map) throws SQLException {
        super(connection, (OracleStatement)null);
        if (descriptor == null || connection == null) {
            DBError.check_error((int)1, (Object)"Invalid arguments");
        }
        this.close_statement_on_close = true;
        this.m_count = count;
        this.m_idx = 0L;
        this.m_beginIdx = beginIdx;
        this.m_map = map;
        OraclePreparedStatement pstmt = null;
        ARRAY tmpObj = new ARRAY(descriptor, connection, (Object)null);
        tmpObj.setLocator(locator);
        pstmt = descriptor.getBaseType() == 2002 || descriptor.getBaseType() == 2008 ? (OraclePreparedStatement)connection.prepareStatement("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(? AS " + descriptor.getName() + ") )") : (OraclePreparedStatement)connection.prepareStatement("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(? AS " + descriptor.getName() + ") )");
        pstmt.setArray(1, tmpObj);
        pstmt.executeQuery();
        this.statement = pstmt;
    }

    public synchronized boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ResultSet.next()");
        }
        if (this.m_idx < this.m_beginIdx) {
            while (this.m_idx < this.m_beginIdx) {
                ++this.m_idx;
                if (super.next()) continue;
                return false;
            }
            return true;
        }
        if (this.m_count == COUNT_UNLIMITED) {
            return super.next();
        }
        if (this.m_idx < this.m_beginIdx + (long)this.m_count - 1L) {
            ++this.m_idx;
            return super.next();
        }
        return false;
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.getObject(columnIndex=" + columnIndex + ")"));
        }
        return this.getObject(columnIndex, this.m_map);
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ResultSet.findColumn(columnName=" + columnName + ")"));
        }
        if (columnName.equalsIgnoreCase("index")) {
            return 1;
        }
        if (columnName.equalsIgnoreCase("value")) {
            return 2;
        }
        DBError.check_error((int)6, (Object)"get_column_index");
        return 0;
    }
}

