/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class ArrayDataResultSet
extends BaseResultSet {
    Datum[] m_data;
    Map m_map;
    private int m_idx;
    private int m_lastIdx;
    boolean m_closed;
    OracleConnection m_conn;
    private Boolean m_wasNull;
    private static Boolean BOOLEAN_TRUE = new Boolean(true);
    private static Boolean BOOLEAN_FALSE = new Boolean(false);
    private int m_fetchSz;
    ARRAY m_array;

    public ArrayDataResultSet(OracleConnection connection, Datum[] data, Map map) throws SQLException {
        this.m_conn = connection;
        this.m_data = data;
        this.m_map = map;
        this.m_idx = 0;
        this.m_lastIdx = this.m_data == null ? 0 : this.m_data.length;
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection connection, Datum[] data, long index, int count, Map map) throws SQLException {
        this.m_conn = connection;
        this.m_data = data;
        this.m_map = map;
        this.m_idx = (int)index - 1;
        int length = this.m_data == null ? 0 : this.m_data.length;
        this.m_lastIdx = this.m_idx + Math.min(length - this.m_idx, count);
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public ArrayDataResultSet(OracleConnection connection, ARRAY array, long index, int count, Map map) throws SQLException {
        this.m_conn = connection;
        this.m_array = array;
        this.m_map = map;
        this.m_idx = (int)index - 1;
        int length = this.m_array == null ? 0 : array.length();
        this.m_lastIdx = this.m_idx + (count == -1 ? length - this.m_idx : Math.min(length - this.m_idx, count));
        this.m_fetchSz = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    public boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ArrayDataResultSet.next()");
        }
        if (this.m_closed) {
            DBError.check_error((int)10, (Object)"next");
        }
        ++this.m_idx;
        return this.m_idx <= this.m_lastIdx;
    }

    public synchronized void close() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ArrayDataResultSet.close()");
        }
        this.m_closed = true;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ArrayDataResultSet.wasNull()");
        }
        if (this.m_wasNull == null) {
            DBError.check_error((int)24, null);
        }
        return this.m_wasNull;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getString(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.stringValue();
        }
        return null;
    }

    public synchronized ResultSet getCursor(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getCursor(columnIndex=" + columnIndex + ")"));
        }
        DBError.check_error((int)4, (Object)"getCursor");
        return null;
    }

    public synchronized Datum getOracleObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getOracleObject(columnIndex=" + columnIndex + ")"));
        }
        if (this.m_idx <= 0) {
            DBError.check_error((int)14, null);
        }
        if (columnIndex == 1) {
            this.m_wasNull = BOOLEAN_FALSE;
            return new NUMBER(this.m_idx);
        }
        if (columnIndex == 2) {
            Datum[] darray;
            if (this.m_data != null) {
                this.m_wasNull = this.m_data[this.m_idx - 1] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return this.m_data[this.m_idx - 1];
            }
            if (this.m_array != null && (darray = this.m_array.getOracleArray(this.m_idx, 1)) != null && darray.length >= 1) {
                this.m_wasNull = darray[0] == null ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                return darray[0];
            }
            DBError.check_error((int)1, (Object)"Out of sync");
        }
        DBError.check_error((int)3, null);
        return null;
    }

    public synchronized ROWID getROWID(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getROWID(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof ROWID) {
                return (ROWID)datum;
            }
            DBError.check_error((int)4, (Object)"getROWID");
        }
        return null;
    }

    public synchronized NUMBER getNUMBER(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getNUMBER(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof NUMBER) {
                return (NUMBER)datum;
            }
            DBError.check_error((int)4, (Object)"getNUMBER");
        }
        return null;
    }

    public synchronized DATE getDATE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getDATE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof DATE) {
                return (DATE)datum;
            }
            DBError.check_error((int)4, (Object)"getDATE");
        }
        return null;
    }

    public synchronized ARRAY getARRAY(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getARRAY(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof ARRAY) {
                return (ARRAY)datum;
            }
            DBError.check_error((int)4, (Object)"getARRAY");
        }
        return null;
    }

    public synchronized STRUCT getSTRUCT(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getSTRUCT(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof STRUCT) {
                return (STRUCT)datum;
            }
            DBError.check_error((int)4, (Object)"getSTRUCT");
        }
        return null;
    }

    public synchronized OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getOPAQUE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof OPAQUE) {
                return (OPAQUE)datum;
            }
            DBError.check_error((int)4, (Object)"getOPAQUE");
        }
        return null;
    }

    public synchronized REF getREF(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getREF(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof REF) {
                return (REF)datum;
            }
            DBError.check_error((int)4, (Object)"getREF");
        }
        return null;
    }

    public synchronized CHAR getCHAR(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getCHAR(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof CHAR) {
                return (CHAR)datum;
            }
            DBError.check_error((int)4, (Object)"getCHAR");
        }
        return null;
    }

    public synchronized RAW getRAW(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getRAW(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof RAW) {
                return (RAW)datum;
            }
            DBError.check_error((int)4, (Object)"getRAW");
        }
        return null;
    }

    public synchronized BLOB getBLOB(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBLOB(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof BLOB) {
                return (BLOB)datum;
            }
            DBError.check_error((int)4, (Object)"getBLOB");
        }
        return null;
    }

    public synchronized CLOB getCLOB(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getCLOB(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof CLOB) {
                return (CLOB)datum;
            }
            DBError.check_error((int)4, (Object)"getCLOB");
        }
        return null;
    }

    public synchronized BFILE getBFILE(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBFILE(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof BFILE) {
                return (BFILE)datum;
            }
            DBError.check_error((int)4, (Object)"getBFILE");
        }
        return null;
    }

    public synchronized BFILE getBfile(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBfile(columnIndex=" + columnIndex + ")"));
        }
        return this.getBFILE(columnIndex);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBoolean(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.booleanValue();
        }
        return false;
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getByte(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.byteValue();
        }
        return 0;
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        long result;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getShort(columnIndex=" + columnIndex + ")"));
        }
        if ((result = this.getLong(columnIndex)) > 65537L || result < -65538L) {
            DBError.check_error((int)26, (Object)"getShort");
        }
        return (short)result;
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getInt(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.intValue();
        }
        return 0;
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getLong(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.longValue();
        }
        return 0L;
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getFloat(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.floatValue();
        }
        return 0.0f;
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getDouble(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.doubleValue();
        }
        return 0.0;
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBigDecimal(columnIndex=" + columnIndex + ", scale=" + scale + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBytes(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof RAW) {
                return ((RAW)datum).shareBytes();
            }
            DBError.check_error((int)4, (Object)"getBytes");
        }
        return null;
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getDate(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.dateValue();
        }
        return null;
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getTime(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.timeValue();
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getTimestamp(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.timestampValue();
        }
        return null;
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getAsciiStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            datum.asciiStreamValue();
        }
        return null;
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getUnicodeStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            DBConversion dbconv = this.m_conn.conversion;
            byte[] bytes = datum.shareBytes();
            if (datum instanceof RAW) {
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 3);
            }
            if (datum instanceof CHAR) {
                return dbconv.ConvertStream((InputStream)new ByteArrayInputStream(bytes), 1);
            }
            DBError.check_error((int)4, (Object)"getUnicodeStream");
        }
        return null;
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBinaryStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.binaryStreamValue();
        }
        return null;
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getObject(columnIndex=" + columnIndex + ")"));
        }
        return this.getObject(columnIndex, this.m_map);
    }

    public synchronized CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getCustomDatum(columnIndex=" + columnIndex + ", factory=" + factory + ")"));
        }
        Datum d2 = this.getOracleObject(columnIndex);
        return factory.create(d2, 0);
    }

    public synchronized ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getORAData(columnIndex=" + columnIndex + ", factory=" + factory + ")"));
        }
        Datum d2 = this.getOracleObject(columnIndex);
        return factory.create(d2, 0);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ArrayDataResultSet.getMetaData()");
        }
        if (this.m_closed) {
            DBError.check_error((int)10, (Object)"getMetaData");
        }
        DBError.check_error((int)23, (Object)"getMetaData");
        return null;
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.findColumn(columnName=" + columnName + ")"));
        }
        if (columnName.equalsIgnoreCase("index")) {
            return 1;
        }
        if (columnName.equalsIgnoreCase("value")) {
            return 2;
        }
        DBError.check_error((int)6, (Object)"get_column_index");
        return 0;
    }

    public synchronized Statement getStatement() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)"ArrayDataResultSet.getStatement()");
        }
        return null;
    }

    public synchronized Object getObject(int columnIndex, Map map) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getObject(columnIndex=" + columnIndex + ", map=" + map + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(map);
            }
            return datum.toJdbc();
        }
        return null;
    }

    public synchronized Ref getRef(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getRef(columnIndex=" + columnIndex + ")"));
        }
        return this.getREF(columnIndex);
    }

    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBlob(columnIndex=" + columnIndex + ")"));
        }
        return this.getBLOB(columnIndex);
    }

    public synchronized Clob getClob(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getClob(columnIndex=" + columnIndex + ")"));
        }
        return this.getCLOB(columnIndex);
    }

    public synchronized Array getArray(int columnIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getArray(columnIndex=" + columnIndex + ")"));
        }
        return this.getARRAY(columnIndex);
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getCharacterStream(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getBigDecimal(columnIndex=" + columnIndex + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            return datum.bigDecimalValue();
        }
        return null;
    }

    public synchronized Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getDate(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            DATE dateValue = null;
            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dateValue != null) {
                return dateValue.dateValue(cal);
            }
        }
        return null;
    }

    public synchronized Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getTime(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            DATE dateValue = null;
            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dateValue != null) {
                return dateValue.timeValue(cal);
            }
        }
        return null;
    }

    public synchronized Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Datum datum;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getTimestamp(columnIndex=" + columnIndex + ", cal=" + cal + ")"));
        }
        if ((datum = this.getOracleObject(columnIndex)) != null) {
            DATE dateValue = null;
            dateValue = datum instanceof DATE ? (DATE)datum : new DATE(datum.stringValue());
            if (dateValue != null) {
                return dateValue.timestampValue(cal);
            }
        }
        return null;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.isBeforeFirst(): return: " + (this.m_idx < 1)));
        }
        return this.m_idx < 1;
    }

    public boolean isAfterLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.isAfterLast(): return: " + (this.m_idx > this.m_lastIdx)));
        }
        return this.m_idx > this.m_lastIdx;
    }

    public boolean isFirst() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.isFirst(): return: " + (this.m_idx == 1)));
        }
        return this.m_idx == 1;
    }

    public boolean isLast() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.isLast(): " + (this.m_idx == this.m_lastIdx)));
        }
        return this.m_idx == this.m_lastIdx;
    }

    public int getRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getRow(): return: " + this.m_idx));
        }
        return this.m_idx;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.setFetchSize(rows=" + rows + ")"));
        }
        if (rows < 0) {
            DBError.throwSqlException((int)68);
        } else {
            this.m_fetchSz = rows == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : rows;
        }
    }

    public int getFetchSize() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)1, (int)32, (int)1, (String)("ArrayDataResultSet.getFetchSize(): " + this.m_fetchSz));
        }
        return this.m_fetchSz;
    }
}

