/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleType;

public class DBType {
    public int type;
    public int max_length;
    public boolean is_stream;
    public int ncs;
    public short FormOfUse;
    public static int max_bind_array_length;
    public OracleType otype;
    public int external_type;
    public static final int FIXED_CHAR = 999;
    public static final int CHAR = 96;
    public static final int VARCHAR = 1;
    public static final int LONG = 8;
    public static final int NUMBER = 2;
    public static final int VARNUM = 6;
    public static final int RAW = 23;
    public static final int LONG_RAW = 24;
    public static final int ROWID = 104;
    public static final int RESULT_SET = 102;
    public static final int DATE = 12;
    public static final int BLOB = 113;
    public static final int CLOB = 112;
    public static final int BFILE = 114;
    public static final int NAMED_TYPE = 109;
    public static final int REF_TYPE = 111;
    public static final int TIMESTAMP = 180;
    public static final int TIMESTAMPTZ = 181;
    public static final int TIMESTAMPLTZ = 231;
    public static final int INTERVALYM = 182;
    public static final int INTERVALDS = 183;
    public static final int PLSQL_INDEX_TABLE = 998;

    protected void setFields(int type, short serverVersion) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.setFields(type=" + type + ", serverVersion=" + serverVersion + ")"));
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBType.setFields(int, short): serverVersion=" + serverVersion + ", type=" + type));
        }
        this.is_stream = false;
        this.external_type = 0;
        max_bind_array_length = serverVersion >= 8000 ? 4000 : 2000;
        switch (type) {
            case 96: 
            case 999: {
                if (serverVersion >= 8000) {
                    this.max_length = 2000;
                    break;
                }
                this.max_length = 255;
                break;
            }
            case 1: {
                if (serverVersion >= 8000) {
                    this.max_length = 4000;
                    break;
                }
                this.max_length = 2000;
                break;
            }
            case 8: {
                this.max_length = Integer.MAX_VALUE;
                this.is_stream = true;
                break;
            }
            case 2: 
            case 6: {
                this.max_length = 22;
                break;
            }
            case 23: {
                if (serverVersion >= 8000) {
                    this.max_length = 2000;
                    break;
                }
                this.max_length = 255;
                break;
            }
            case 24: {
                this.max_length = Integer.MAX_VALUE;
                this.is_stream = true;
                break;
            }
            case 104: {
                this.max_length = 128;
                break;
            }
            case 102: {
                this.max_length = 0;
                break;
            }
            case 12: {
                this.max_length = 7;
                break;
            }
            case 112: 
            case 113: {
                this.max_length = 3876;
                break;
            }
            case 114: {
                this.max_length = 530;
                break;
            }
            case 111: {
                this.max_length = 4000;
                break;
            }
            case 109: {
                this.max_length = Integer.MAX_VALUE;
                break;
            }
            case 998: {
                break;
            }
            case 182: {
                this.max_length = 5;
                break;
            }
            case 183: {
                this.max_length = 11;
                break;
            }
            case 180: {
                this.max_length = 11;
                break;
            }
            case 181: {
                this.max_length = 13;
                break;
            }
            case 231: {
                this.max_length = 11;
                break;
            }
        }
    }

    public DBType(int type, int max_size, boolean is_stream, short serverVersion) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.DBType(type=" + type + ", max_size=" + max_size + ", is_stream=" + is_stream + ", serverVersion=" + serverVersion + ")"));
        }
        this.type = type;
        this.setFields(type, serverVersion);
        this.max_length = !is_stream ? Math.min(max_size, this.max_length) : max_size;
        this.is_stream = is_stream;
    }

    public DBType() {
    }

    public DBType(int type, short serverVersion) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.DBType(type=" + type + ", serverVersion=" + serverVersion + ")"));
        }
        this.type = type;
        this.setFields(type, serverVersion);
    }

    public DBType(int type, int max_size, short serverVersion) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.DBType(type=" + type + ", max_size=" + max_size + ", serverVersion=" + serverVersion + ")"));
        }
        this.type = type;
        this.setFields(type, serverVersion);
        this.max_length = type == 102 ? max_size : Math.min(max_size, this.max_length);
    }

    public void setMaxSize(int max_size) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.setMaxSize(" + max_size + ")"));
        }
        this.max_length = max_size;
    }

    public void setPlsqlMaxLength() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBType.setPlsqlMaxLength()");
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBType.setPlsqlMaxLength(): type=" + this.type));
        }
        switch (this.type) {
            case 1: 
            case 23: 
            case 96: 
            case 999: {
                this.max_length = Short.MAX_VALUE;
                break;
            }
            case 8: 
            case 24: {
                this.max_length = 32760;
            }
        }
    }

    public void setExternalType(int externalType) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.setExternalType(" + externalType + ")"));
        }
        this.external_type = externalType;
    }

    public int getExternalType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBType.getExternalType(): returned " + this.external_type));
        }
        return this.external_type;
    }

    public static String getStringType(int type) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)2, (int)16, (String)("DBType.getStringType(" + type + ")"));
        }
        switch (type) {
            case 999: {
                return " FIXED_CHAR ";
            }
            case 96: {
                return " CHAR ";
            }
            case 1: {
                return " VARCHAR ";
            }
            case 8: {
                return " LONG ";
            }
            case 2: {
                return " NUMBER ";
            }
            case 6: {
                return " VARNUM ";
            }
            case 23: {
                return " RAW ";
            }
            case 24: {
                return " LONG_RAW ";
            }
            case 104: {
                return " ROWID ";
            }
            case 102: {
                return " RESULT_SET ";
            }
            case 12: {
                return " DATE ";
            }
            case 112: {
                return " CLOB ";
            }
            case 113: {
                return " BLOB ";
            }
            case 114: {
                return " BFILE ";
            }
            case 109: {
                return " NAMED_TYPE ";
            }
            case 111: {
                return " REF_TYPE ";
            }
            case 998: {
                return " PLSQL_INDEX_TABLE ";
            }
            case 180: {
                return " TIMESTAMP ";
            }
            case 181: {
                return " TIMESTAMPTZ ";
            }
            case 231: {
                return " TIMESTAMPLTZ ";
            }
        }
        return " Type is not set ";
    }

    public boolean isNType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBType.isNType()");
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBType.isNType(): FormOfUse=" + this.FormOfUse));
        }
        return this.FormOfUse == 2;
    }

    static {
        FIXED_CHAR = 999;
        CHAR = 96;
        VARCHAR = 1;
        LONG = 8;
        NUMBER = 2;
        VARNUM = 6;
        RAW = 23;
        LONG_RAW = 24;
        ROWID = 104;
        RESULT_SET = 102;
        DATE = 12;
        BLOB = 113;
        CLOB = 112;
        BFILE = 114;
        NAMED_TYPE = 109;
        REF_TYPE = 111;
        TIMESTAMP = 180;
        TIMESTAMPTZ = 181;
        TIMESTAMPLTZ = 231;
        INTERVALYM = 182;
        INTERVALDS = 183;
        PLSQL_INDEX_TABLE = 998;
    }
}

