/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleLog;

public class DBItem
implements Cloneable {
    public byte[] byte_value;
    public InputStream stream_value;
    public int data_size;
    public int original_size;
    public int max_out_size;
    public boolean is_null;
    public char[] char_value;
    public int char_size;
    static final int MAX_NONSTREAM_DATA_SIZE = 65533;

    public DBItem() {
    }

    public DBItem(int max_length) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.DBItem(" + max_length + ")"));
        }
        this.reinitialize(max_length);
    }

    public void reinitialize(int max_length) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.reinitialize(" + max_length + ")"));
        }
        this.is_null = false;
        this.byte_value = null;
        this.char_value = null;
        this.stream_value = null;
        this.data_size = 0;
        this.char_size = 0;
        this.original_size = 0;
        this.max_out_size = max_length;
    }

    public DBItem clone(DBType _dbtype, DBAccess _dbaccess) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)1, (String)("DBItem.clone(_dbtype=" + _dbtype + ", _dbaccess=" + _dbaccess + ")"));
        }
        DBItem clone = _dbaccess.createDBItem(_dbtype);
        clone.is_null = this.is_null;
        clone.byte_value = (byte[])(this.byte_value != null ? new byte[this.byte_value.length] : null);
        clone.char_value = null;
        clone.stream_value = null;
        clone.data_size = this.data_size;
        clone.char_size = this.char_size;
        clone.original_size = this.original_size;
        clone.max_out_size = this.max_out_size;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.clone(DBType, DBAccess): returned " + clone));
        }
        return clone;
    }

    void allocBuffer(int nbytes) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.allocBuffer(" + nbytes + ")"));
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBItem.allocBuffer(nbytes): byte_value=" + this.byte_value));
        }
        if (this.byte_value == null || this.byte_value.length < nbytes) {
            this.byte_value = new byte[nbytes];
        }
    }

    public void allocBuffer() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBItem.allocBuffer()");
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBItem.allocBuffer(): byte_value=" + this.byte_value + ", max_out_size=" + this.max_out_size));
        }
        if (this.byte_value != null && this.byte_value.length == this.max_out_size) {
            return;
        }
        this.allocBuffer(this.max_out_size);
    }

    public void setArrayData(boolean null_flag, byte[] array_value) throws SQLException {
        this.setArrayData(null_flag, array_value, false);
    }

    public void setArrayData(boolean null_flag, byte[] array_value, boolean isAdt) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.setArrayData(null_flag=" + null_flag + ", " + OracleLog.bytesToPrintableForm("array_value []=", array_value) + ")"));
        }
        this.is_null = null_flag;
        if (array_value != null) {
            if (!isAdt && array_value.length > 65533) {
                DBError.throwSqlException((int)68);
            }
            this.data_size = array_value.length;
            this.byte_value = array_value;
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public void setArrayData(boolean null_flag, String str, int FormOfUse) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.setArrayData(null_flag=" + null_flag + ", str=" + str + ", FormOfUse=" + FormOfUse + ")"));
        }
        this.is_null = null_flag;
        if (str != null) {
            this.byte_value = this.StringToBytes(str, FormOfUse);
            this.data_size = this.byte_value.length;
            if (this.data_size > 65533) {
                DBError.throwSqlException((int)68);
            }
        } else {
            this.byte_value = new byte[0];
            this.data_size = 0;
        }
    }

    public byte[] StringToBytes(String str, int FormOfUse) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.StringToBytes(str=" + str + ", FormOfUse=" + FormOfUse + "): returned null"));
        }
        return null;
    }

    public void setStreamData(boolean null_flag, int data_size, InputStream stream) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.setStreamData(null_flag=" + null_flag + ", data_size=" + data_size + ", stream=" + stream + ")"));
        }
        this.is_null = null_flag;
        this.stream_value = stream;
        this.data_size = data_size;
        this.max_out_size = data_size;
    }

    public void setNull() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBItem.setNull()");
        }
        this.is_null = true;
        this.data_size = 0;
        this.char_size = 0;
        this.allocBuffer(0);
    }

    public void defineStreamData(InputStream stream) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.defineStreamData(" + stream + ")"));
        }
        this.data_size = 0;
        this.stream_value = stream;
    }

    public byte[] getBytes() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.getBytes(): returned " + OracleLog.bytesToPrintableForm("byte_value=", this.byte_value)));
        }
        return this.byte_value;
    }

    public int getBytesLength() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBItem.getBytesLength()");
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBItem.getBytesLength(): byte_value=" + this.byte_value));
        }
        if (this.byte_value == null) {
            return 0;
        }
        return this.byte_value.length;
    }

    public char[] getChars(short fo_use) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBItem.getChars(" + fo_use + "): returned null"));
        }
        return null;
    }

    public void clear() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBItem.clear()");
        }
        this.is_null = false;
        this.byte_value = null;
        this.char_value = null;
        this.stream_value = null;
        this.data_size = 0;
        this.char_size = 0;
        this.original_size = 0;
    }

    public void reallocBuffer() {
        int nbytes;
        if (this.max_out_size >= Integer.MAX_VALUE && this.data_size == 0) {
            return;
        }
        int n2 = nbytes = this.max_out_size >= Integer.MAX_VALUE ? this.data_size : this.max_out_size;
        if (this.byte_value == null || this.byte_value.length < nbytes) {
            this.byte_value = new byte[nbytes];
        }
    }

    public void clearBuffer() {
        this.byte_value = null;
        this.char_value = null;
    }

    static {
        MAX_NONSTREAM_DATA_SIZE = 65533;
    }
}

