/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.jdbc.dbaccess.Message;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.SQLStateMapping;
import oracle.jdbc.util.SQLStateRange;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBError {
    private static boolean m_loadedMessages = false;
    private static Message m_message = null;
    private static String m_msgClassName = "oracle.jdbc.dbaccess.Message11";
    static final SQLStateMapping[] mappings = new SQLStateMapping[]{new SQLStateMapping(0, "00000"), new SQLStateMapping(1, "23000"), new SQLStateMapping(22, "42000"), new SQLStateMapping(100, "02000"), new SQLStateMapping(251, "42000"), new SQLStateMapping(1025, "22023"), new SQLStateMapping(1031, "42000"), new SQLStateMapping(1095, "02000"), new SQLStateMapping(1402, "44000"), new SQLStateMapping(1403, "02000"), new SQLStateMapping(1405, "22002"), new SQLStateMapping(1406, "22001"), new SQLStateMapping(1410, "24000"), new SQLStateMapping(1411, "22022"), new SQLStateMapping(1422, "21000"), new SQLStateMapping(1424, "22025"), new SQLStateMapping(1425, "22019"), new SQLStateMapping(1426, "22003"), new SQLStateMapping(1427, "21000"), new SQLStateMapping(1438, "22003"), new SQLStateMapping(1455, "22003"), new SQLStateMapping(1457, "22003"), new SQLStateMapping(1476, "22012"), new SQLStateMapping(1488, "22023"), new SQLStateMapping(8006, "24000")};
    static final SQLStateRange[] ranges = new SQLStateRange[]{new SQLStateRange(17, 21, "61000"), new SQLStateRange(23, 35, "61000"), new SQLStateRange(49, 68, "61000"), new SQLStateRange(100, 120, "62000"), new SQLStateRange(149, 159, "63000"), new SQLStateRange(199, 369, "64000"), new SQLStateRange(369, 429, "60000"), new SQLStateRange(429, 439, "67000"), new SQLStateRange(439, 569, "62000"), new SQLStateRange(569, 599, "69000"), new SQLStateRange(599, 899, "60000"), new SQLStateRange(899, 999, "42000"), new SQLStateRange(999, 1099, "72000"), new SQLStateRange(1000, 1003, "24000"), new SQLStateRange(1099, 1250, "64000"), new SQLStateRange(1399, 1401, "23000"), new SQLStateRange(1401, 1478, "72000"), new SQLStateRange(1478, 1480, "22024"), new SQLStateRange(1480, 1489, "72000"), new SQLStateRange(1489, 1493, "42000"), new SQLStateRange(1493, 1499, "72000"), new SQLStateRange(1499, 1699, "72000"), new SQLStateRange(1699, 1799, "42000"), new SQLStateRange(1799, 1899, "22008"), new SQLStateRange(1899, 2099, "42000"), new SQLStateRange(2090, 2092, "40000"), new SQLStateRange(2139, 2289, "42000"), new SQLStateRange(2289, 2299, "23000"), new SQLStateRange(2375, 2399, "61000"), new SQLStateRange(2399, 2419, "72000"), new SQLStateRange(2419, 2424, "42000"), new SQLStateRange(2424, 2449, "72000"), new SQLStateRange(2449, 2499, "42000"), new SQLStateRange(2699, 2899, "63000"), new SQLStateRange(2999, 3099, "0A000"), new SQLStateRange(3099, 3199, "63000"), new SQLStateRange(3275, 3299, "42000"), new SQLStateRange(3999, 4019, "22023"), new SQLStateRange(4019, 4039, "61000"), new SQLStateRange(4039, 4059, "42000"), new SQLStateRange(4059, 4069, "72000"), new SQLStateRange(4069, 4099, "42000"), new SQLStateRange(5999, 6149, "66000"), new SQLStateRange(6199, 6249, "63000"), new SQLStateRange(6249, 6429, "66000"), new SQLStateRange(6429, 6449, "60000"), new SQLStateRange(6499, 6599, "65000"), new SQLStateRange(6510, 6511, "24000"), new SQLStateRange(6599, 6999, "66000"), new SQLStateRange(6999, 7199, "69000"), new SQLStateRange(7199, 7999, "60000"), new SQLStateRange(7999, 8190, "72000"), new SQLStateRange(9699, 9999, "60000"), new SQLStateRange(9999, 10999, "90000"), new SQLStateRange(11999, 12019, "72000"), new SQLStateRange(12299, 12499, "72000"), new SQLStateRange(12699, 21999, "72000"), new SQLStateRange(12099, 12299, "66000"), new SQLStateRange(12499, 12599, "66000")};
    public static final int JDBC_ERROR_BASE = 17000;
    public static final int JDBC_MAX_ERRORS = 500;
    public static final int EOJ_SUCCESS = 0;
    public static final int EOJ_ERROR = 1;
    public static final int EOJ_IOEXCEPTION = 2;
    public static final int EOJ_INVALID_COLUMN_INDEX = 3;
    public static final int EOJ_INVALID_COLUMN_TYPE = 4;
    public static final int EOJ_UNSUPPORTED_COLUMN_TYPE = 5;
    public static final int EOJ_INVALID_COLUMN_NAME = 6;
    public static final int EOJ_INVALID_DYNAMIC_COLUMN = 7;
    public static final int EOJ_CLOSED_CONNECTION = 8;
    public static final int EOJ_CLOSED_STATEMENT = 9;
    public static final int EOJ_CLOSED_RESULTSET = 10;
    public static final int EOJ_EXHAUSTED_RESULTSET = 11;
    public static final int EOJ_TYPE_CONFLICT = 12;
    public static final int EOJ_WAS_NULL = 13;
    public static final int EOJ_RESULTSET_BEFORE_FIRST_ROW = 14;
    public static final int EOJ_STATEMENT_WAS_CANCELLED = 15;
    public static final int EOJ_STATEMENT_TIMED_OUT = 16;
    public static final int EOJ_CURSOR_ALREADY_INITIALIZED = 17;
    public static final int EOJ_INVALID_CURSOR = 18;
    public static final int EOJ_CAN_ONLY_DESCRIBE_A_QUERY = 19;
    public static final int EOJ_INVALID_ROW_PREFETCH = 20;
    public static final int EOJ_MISSING_DEFINES = 21;
    public static final int EOJ_MISSING_DEFINES_AT_INDEX = 22;
    public static final int EOJ_UNSUPPORTED_FEATURE = 23;
    public static final int EOJ_NO_DATA_READ = 24;
    public static final int EOJ_IS_DEFINES_NULL_ERROR = 25;
    public static final int EOJ_NUMERIC_OVERFLOW = 26;
    public static final int EOJ_STREAM_CLOSED = 27;
    public static final int EOJ_NO_NEW_DEFINE_IF_RESULT_SET_NOT_CLOSED = 28;
    public static final int EOJ_READ_ONLY = 29;
    public static final int EOJ_INVALID_TRANSLEVEL = 30;
    public static final int EOJ_AUTO_CLOSE_ONLY = 31;
    public static final int EOJ_ROW_PREFETCH_NOT_ZERO = 32;
    public static final int EOJ_MALFORMED_SQL92 = 33;
    public static final int EOJ_NON_SUPPORTED_SQL92_TOKEN = 34;
    public static final int EOJ_NON_SUPPORTED_CHAR_SET = 35;
    public static final int EOJ_ORACLE_NUMBER_EXCEPTION = 36;
    public static final int EOJ_FAIL_CONVERSION_UTF8_TO_UCS2 = 37;
    public static final int EOJ_CONVERSION_BYTE_ARRAY_ERROR = 38;
    public static final int EOJ_CONVERSION_CHAR_ARRAY_ERROR = 39;
    public static final int EOJ_SUB_SUB_PROTOCOL_ERROR = 40;
    public static final int EOJ_INVALID_IN_OUT_BINDS = 41;
    public static final int EOJ_INVALID_BATCH_VALUE = 42;
    public static final int EOJ_INVALID_STREAM_SIZE = 43;
    public static final int EOJ_DATASET_ITEMS_NOT_ALLOCATED = 44;
    public static final int EOJ_BEYOND_BINDS_BATCH = 45;
    public static final int EOJ_INVALID_RANK = 46;
    public static final int EOJ_TDS_FORMAT_ERROR = 47;
    public static final int EOJ_UNDEFINED_TYPE = 48;
    public static final int EOJ_INCONSISTENT_ADT = 49;
    public static final int EOJ_NOSUCHELEMENT = 50;
    public static final int EOJ_NOT_AN_OBJECT_TYPE = 51;
    public static final int EOJ_INVALID_REF = 52;
    public static final int EOJ_INVALID_SIZE = 53;
    public static final int EOJ_INVALID_LOB_LOCATOR = 54;
    public static final int EOJ_FAIL_CONVERSION_CHARACTER = 55;
    public static final int EOJ_UNSUPPORTED_CHARSET = 56;
    public static final int EOJ_CLOSED_LOB = 57;
    public static final int EOJ_INVALID_NLS_RATIO = 58;
    public static final int EOJ_CONVERSION_JAVA_ERROR = 59;
    public static final int EOJ_FAIL_CREATE_DESC = 60;
    public static final int EOJ_NO_DESCRIPTOR = 61;
    public static final int EOJ_INVALID_REF_CURSOR = 62;
    public static final int EOJ_NOT_IN_A_TRANSACTION = 63;
    public static final int EOJ_DATABASE_IS_NULL = 64;
    public static final int EOJ_CONV_WAS_NULL = 65;
    public static final int EOJ_ACCESS_SPECIFIC_IMPL = 66;
    public static final int EOJ_INVALID_URL = 67;
    public static final int EOJ_INVALID_ARGUMENTS = 68;
    public static final int EOJ_USE_XA_EXPLICIT = 69;
    public static final int EOJ_INVALID_DATASIZE_LENGTH = 70;
    public static final int EOJ_EXCEEDED_VARRAY_LENGTH = 71;
    public static final int EOJ_VALUE_TOO_BIG = 72;
    public static final int EOJ_LOGICAL_CONN_CLOSED = 73;
    public static final int EOJ_INVALID_NAME_PATTERN = 74;
    public static final int EOJ_INVALID_FORWARD_RSET_OP = 75;
    public static final int EOJ_INVALID_READONLY_RSET_OP = 76;
    public static final int EOJ_FAIL_REF_SETVALUE = 77;
    public static final int EOJ_CONNECTIONS_ALREADY_EXIST = 78;
    public static final int EOJ_USER_CREDENTIALS_FAIL = 79;
    public static final int EOJ_INVALID_BATCH_COMMAND = 80;
    public static final int EOJ_BATCH_ERROR = 81;
    public static final int EOJ_NO_CURRENT_ROW = 82;
    public static final int EOJ_NOT_ON_INSERT_ROW = 83;
    public static final int EOJ_ON_INSERT_ROW = 84;
    public static final int EOJ_UPDATE_CONFLICTS = 85;
    public static final int EOJ_NULL_INSERET_ROW_VALUE = 86;
    public static final int WARN_IGNORE_FETCH_DIRECTION = 87;
    public static final int EOJ_UNSUPPORTED_SYNTAX = 88;
    public static final int EOJ_INTERNAL_ERROR = 89;
    public static final int EOJ_OPER_NOT_ALLOWED = 90;
    public static final int WARN_ALTERNATE_RSET_TYPE = 91;
    public static final int EOJ_NO_JDBC_AT_END_OF_CALL = 92;
    public static final int EOJ_WARN_SUCCESS_WITH_INFO = 93;
    public static final int EOJ_VERSION_MISMATCH = 94;
    public static final int EOJ_NO_STMT_CACHE_SIZE = 95;
    public static final int EOJ_STMT_CACHE_POOLC = 96;
    public static final int EOJ_INVALID_ELEMENT_TYPE = 97;
    public static final int EOJ_INVALID_EMPTYLOB_OP = 98;
    public static final int EOJ_INVALID_INDEXTABLE_ARRAY_LENGTH = 99;
    public static final int EOJ_INVALID_JAVA_OBJECT = 100;
    public static final int EOJ_CONNECTIONPOOL_INVALID_PROPERTIES = 101;
    public static final int EOJ_BFILE_IS_READONLY = 102;
    public static final int EOJ_WRONG_CONNECTION_TYPE_FOR_METHOD = 103;
    public static final int EOJ_NULL_SQL_STRING = 104;
    public static final int EOJ_SESSION_TZ_NOT_SET = 105;
    public static final int EOJ_CONNECTIONPOOL_INVALID_CONFIG = 106;
    public static final int EOJ_CONNECTIONPOOL_INVALID_PROXY_TYPE = 107;
    public static final int WARN_DEFINE_COLUMN_TYPE = 108;
    public static final int EOJ_STANDARD_ENCODING_NOT_FOUND = 109;
    public static final int EOJ_THIN_WARNING = 110;
    public static final int EOJ_WARN_CONN_CACHE_TIMEOUT = 111;
    public static final int EOJ_WARN_THREAD_TIMEOUT_INTERVAL = 112;
    public static final int EOJ_WARN_THREAD_INTERVAL_TOO_BIG = 113;
    public static final int EOJ_LOCAL_COMMIT_IN_GLOBAL_TXN = 114;
    public static final int EOJ_LOCAL_ROLLBACK_IN_GLOBAL_TXN = 115;
    public static final int EOJ_AUTOCOMMIT_IN_GLOBAL_TXN = 116;
    public static final int EOJ_SETSVPT_IN_GLOBAL_TXN = 117;
    public static final int EOJ_GETID_FOR_NAMED_SVPT = 118;
    public static final int EOJ_GETNAME_FOR_UNNAMED_SVPT = 119;
    public static final int EOJ_SETSVPT_WITH_AUTOCOMMIT = 120;
    public static final int EOJ_ROLLBACK_WITH_AUTOCOMMIT = 121;
    public static final int EOJ_ROLLBACK_TO_SVPT_IN_GLOBAL_TXN = 122;
    public static final int EOJ_INVALID_STMT_CACHE_SIZE = 123;
    public static final int EOJ_WARN_CACHE_INACTIVITY_TIMEOUT = 124;
    public static final int EOJ_IMPROPER_STATEMENT_TYPE = 125;
    public static final int EOJ_FIXED_WAIT_TIMEOUT = 126;
    public static final int EOJ_WARN_CACHE_FIXEDWAIT_TIMEOUT = 127;
    public static final int EOJ_INVALID_QUERY_STRING = 128;
    public static final int EOJ_INVALID_DML_STRING = 129;
    public static final int EOJ_QUERY_TIMEOUT_INVALID_STATE = 131;
    public static final int EOJ_INVALID_OBJECT_TO_CONVERT = 132;
    public static final int EOJ_STMT_NOT_EXECUTED = 137;
    public static final int EOJ_UNSUPPORTED_HOLDABILIY = 162;
    public static final int EOJ_HETEROXA_GET_UTF_OPENSTR = 200;
    public static final int EOJ_HETEROXA_GET_UTF_CLOSESTR = 201;
    public static final int EOJ_HETEROXA_GET_UTF_RMNAME = 202;
    public static final int EOJ_HETEROXA_JHANDLE_SIZE = 203;
    public static final int EOJ_HETEROXA_ARRAY_TOO_SHORT = 204;
    public static final int EOJ_HETEROXA_SVCCTX_HANDLE = 205;
    public static final int EOJ_HETEROXA_ENV_HANDLE = 206;
    public static final int EOJ_HETEROXA_NULL_TNSENTRY = 207;
    public static final int EOJ_HETEROXA_OPEN_RMERR = 213;
    public static final int EOJ_HETEROXA_OPEN_INVAL = 215;
    public static final int EOJ_HETEROXA_OPEN_PROTO = 216;
    public static final int EOJ_HETEROXA_CLOSE_RMERR = 233;
    public static final int EOJ_HETEROXA_CLOSE_INVAL = 235;
    public static final int EOJ_HETEROXA_CLOSE_PROTO = 236;
    public static final int TTC_ERR_BASE = 400;
    public static final int TTC0000 = 401;
    public static final int TTC0001 = 402;
    public static final int TTC0002 = 403;
    public static final int TTC0003 = 404;
    public static final int TTC0004 = 405;
    public static final int TTC0005 = 406;
    public static final int TTC0100 = 407;
    public static final int TTC0101 = 408;
    public static final int TTC0102 = 409;
    public static final int TTC0103 = 410;
    public static final int TTC0104 = 411;
    public static final int TTC0105 = 412;
    public static final int TTC0106 = 413;
    public static final int TTC0107 = 414;
    public static final int TTC0108 = 415;
    public static final int TTC0109 = 416;
    public static final int TTC0110 = 417;
    public static final int TTC0111 = 418;
    public static final int TTC0112 = 419;
    public static final int TTC0113 = 420;
    public static final int TTC0114 = 421;
    public static final int TTC0115 = 422;
    public static final int TTC0116 = 423;
    public static final int TTC0117 = 424;
    public static final int TTC0118 = 425;
    public static final int TTC0119 = 426;
    public static final int TTC0120 = 427;
    public static final int TTC0200 = 428;
    public static final int TTC0201 = 429;
    public static final int TTC0202 = 430;
    public static final int TTC0203 = 431;
    public static final int TTC0204 = 432;
    public static final int TTC0205 = 433;
    public static final int TTC0206 = 434;
    public static final int TTC0207 = 435;
    public static final int TTC0208 = 436;
    public static final int TTC0209 = 437;
    public static final int TTC0210 = 438;
    public static final int TTC0211 = 439;
    public static final int TTC0212 = 440;
    public static final int TTC0213 = 441;
    public static final int TTC0214 = 442;
    public static final int TTC0216 = 443;
    public static final int TTC0217 = 444;

    public static SQLException newSqlException(int errNum, Object obj) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.newSqlException(errNum=" + errNum + ", obj=" + obj + ")"));
        }
        String msg = DBError.findMessage((int)errNum, (Object)obj);
        int vendor_code = DBError.getVendorCode((int)errNum);
        return new SQLException(msg, null, vendor_code);
    }

    public static SQLException newSqlException(int errNum) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.newSqlException(" + errNum + ")"));
        }
        return DBError.newSqlException((int)errNum, null);
    }

    public static void throwSqlException(String reason, String SQLState, int vendorCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(reason=\"" + reason + "\", SQLState=" + SQLState + ", vendorCode=" + vendorCode + ")"));
        }
        throw new SQLException(reason, SQLState, vendorCode);
    }

    public static void throwSqlException(int errNum, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(errNum=" + errNum + ", obj=" + obj + ")"));
        }
        if (errNum == 0 || errNum == 13) {
            return;
        }
        String msg = DBError.findMessage((int)errNum, (Object)obj);
        int vendor_code = DBError.getVendorCode((int)errNum);
        DBError.throwSqlException((String)msg, null, (int)vendor_code);
    }

    public static void throwSqlException(SQLException next_exception, int errNum, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(next_exception=" + next_exception + ", errNum=" + errNum + ", obj=" + obj + ")"));
        }
        if (errNum == 0 || errNum == 13) {
            return;
        }
        String msg = DBError.findMessage((int)errNum, (Object)obj);
        int vendor_code = DBError.getVendorCode((int)errNum);
        SQLException first_exception = new SQLException(msg, null, vendor_code);
        first_exception.setNextException(next_exception);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(next_exception, errNum, obj):\n msg=" + msg + ", vendor_code=" + vendor_code + " throw " + first_exception));
        }
        throw first_exception;
    }

    public static void throwSqlException(int errNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(errNum=" + errNum + ")"));
        }
        DBError.throwSqlException((int)errNum, null);
    }

    public static void throwSqlException(IOException e2) throws SQLException {
        int colon_pos;
        int first_pos;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(" + e2 + ")"));
        }
        String e_msg = e2.getMessage();
        int err_code = 0;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)32, (String)("DBError.throwSqlException(e): e_msg=" + e_msg));
        }
        if (e_msg != null && (first_pos = e_msg.indexOf("ORA-")) != -1 && (colon_pos = e_msg.indexOf(":")) != -1) {
            first_pos += 4;
            try {
                err_code = Integer.parseInt(e_msg.substring(first_pos, colon_pos));
            }
            catch (StringIndexOutOfBoundsException ex) {
            }
            catch (NumberFormatException ex) {}
        } else {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)1, (int)4, (int)8, (String)"DBError.throwSqlException(e): Unable to find ORA number from exception");
            }
            DBError.throwSqlException((int)2, (Object)e_msg);
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwSqlException(e): e_msg=" + e_msg + ", err_code=" + err_code));
        }
        DBError.throwSqlException((String)e_msg, null, (int)err_code);
    }

    public static void addSqlException(SQLException ex, String reason, String SQLState, int vendorCode) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.addSqlException(ex=" + ex + ", reason=\"" + reason + "\", SQLState=" + SQLState + ", vendorCode=" + vendorCode + ")"));
        }
        SQLException new_e = new SQLException(reason, SQLState, vendorCode);
        ex.setNextException(new_e);
    }

    public static void throwBatchUpdateException(SQLException se, int nSuccess, int[] updateCounts) throws BatchUpdateException {
        int i2 = 0;
        int[] update_counts = null;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(se=" + se + ", nSuccess=" + nSuccess + ", int[] updateCounts)"));
        }
        if (nSuccess < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)1, (int)4, (int)2, (String)("DBError.throwBatchUpdateException(se, nSuccess, updateCounts[]):\n Invalid argument nSuccess of " + nSuccess + " (expected >= 0)"));
            }
            nSuccess = 0;
        }
        if (updateCounts == null) {
            update_counts = new int[]{};
        } else if (nSuccess >= updateCounts.length) {
            update_counts = updateCounts;
        } else {
            update_counts = new int[nSuccess];
            i2 = 0;
            while (i2 < nSuccess) {
                update_counts[i2] = updateCounts[i2];
                ++i2;
            }
        }
        BatchUpdateException be = new BatchUpdateException(se.getMessage(), se.getSQLState(), se.getErrorCode(), update_counts);
        be.setNextException(se);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(se, nSuccess, updateCounts[]):\n nSuccess=" + nSuccess + ", throw " + be));
        }
        throw be;
    }

    public static void throwBatchUpdateException(String reason, String SQLState, int vendorCode, int nSuccess, int[] updateCounts) throws BatchUpdateException {
        int i2 = 0;
        int[] update_counts = null;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(reason=\"" + reason + "\", SQLState=" + SQLState + ", vendorCode=" + vendorCode + ", nSuccess=" + nSuccess + ", int[] updateCounts)"));
        }
        if (nSuccess < 0) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)1, (int)4, (int)2, (String)("Invalid argument nSuccess of " + nSuccess + " (expected >= 0)"));
            }
            nSuccess = 0;
        }
        if (updateCounts == null) {
            update_counts = new int[]{};
        } else if (nSuccess >= updateCounts.length) {
            update_counts = updateCounts;
        } else {
            update_counts = new int[nSuccess];
            i2 = 0;
            while (i2 < nSuccess) {
                update_counts[i2] = updateCounts[i2];
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(reason, SQLState, vendorCode, nSuccess, updateCounts):\n nSuccess= " + nSuccess + ", reason=" + reason + ", SQLState=" + SQLState + ", vendorCode=" + vendorCode));
        }
        throw new BatchUpdateException(reason, SQLState, vendorCode, update_counts);
    }

    public static void throwBatchUpdateException(int errNum, Object obj, int nSuccess, int[] updateCounts) throws BatchUpdateException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(errNum=" + errNum + ", obj=" + obj + ", nSuccess=" + nSuccess + ", int[] updateCounts)"));
        }
        if (errNum == 0) {
            return;
        }
        String msg = DBError.findMessage((int)errNum, (Object)obj);
        int vendor_code = DBError.getVendorCode((int)errNum);
        DBError.throwBatchUpdateException((String)msg, null, (int)vendor_code, (int)nSuccess, (int[])updateCounts);
    }

    public static void throwBatchUpdateException(int errNum, int nSuccess, int[] updateCounts) throws BatchUpdateException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.throwBatchUpdateException(errNum=" + errNum + ", nSuccess=" + nSuccess + ", int[] updateCounts)"));
        }
        DBError.throwBatchUpdateException((int)errNum, null, (int)nSuccess, (int[])updateCounts);
    }

    public static void throwUnsupportedFeatureSqlException() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)"DBError.throwUnsupportedFeatureSqlException()");
        }
        DBError.throwSqlException((int)23);
    }

    public static void SQLToIOException(SQLException e2) throws IOException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.SQLToIOException(" + e2 + ")"));
        }
        throw new IOException(e2.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String findMessage(int errNum, Object obj) {
        String ret_msg;
        String key;
        block13: {
            key = null;
            ret_msg = null;
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.findMessage(errNum=" + errNum + ", obj=" + obj + ")"));
                OracleLog.print(null, (int)1, (int)4, (int)32, (String)("DBError.findMessage(errNum, obj): m_loadedMessages=" + m_loadedMessages));
            }
            if (!m_loadedMessages) {
                try {
                    try {
                        m_message = (Message)Class.forName(m_msgClassName).newInstance();
                        m_loadedMessages = true;
                    }
                    catch (ClassNotFoundException e2) {
                        Object var8_5 = null;
                        if (!m_loadedMessages && OracleLog.TRACE) {
                            OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): Failed to load class " + m_msgClassName));
                        }
                        break block13;
                    }
                    catch (IllegalAccessException e3) {
                        Object var8_6 = null;
                        if (!m_loadedMessages && OracleLog.TRACE) {
                            OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): Failed to load class " + m_msgClassName));
                        }
                        break block13;
                    }
                    catch (InstantiationException e4) {
                        Object var8_7 = null;
                        if (!m_loadedMessages && OracleLog.TRACE) {
                            OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): Failed to load class " + m_msgClassName));
                        }
                        break block13;
                    }
                    Object var8_4 = null;
                    if (m_loadedMessages || !OracleLog.TRACE) break block13;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!m_loadedMessages && OracleLog.TRACE) {
                        OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): Failed to load class " + m_msgClassName));
                    }
                    throw throwable;
                }
                OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): Failed to load class " + m_msgClassName));
            }
        }
        key = DBError.getMsgKey((int)errNum);
        ret_msg = m_message == null ? (obj == null ? key + ": (no message for error)" : key + ": (no message for error) " + obj) : m_message.msg(key, obj);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.findMessage(errNum, obj): returned " + ret_msg));
        }
        return ret_msg;
    }

    public static SQLWarning newSqlWarning(String reason, String SQLState, int vendorCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.newSqlWarning(reason=" + reason + ", SQLState=" + SQLState + ", vendorCode=" + vendorCode + ")"));
        }
        return DBError.addSqlWarning(null, (String)reason, (String)SQLState, (int)vendorCode);
    }

    public static SQLWarning newSqlWarning(int errNum, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.newSqlWarning(errNum=" + errNum + ", obj=" + obj + ")"));
        }
        return DBError.addSqlWarning(null, (int)errNum, (Object)obj);
    }

    public static SQLWarning newSqlWarning(int errNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.newSqlWarning(errNum=" + errNum + ")"));
        }
        return DBError.addSqlWarning(null, (int)errNum);
    }

    public static SQLWarning addSqlWarning(SQLWarning first_warning, String reason, String SQLState, int vendorCode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.addSqlWarning(first_warning=" + first_warning + "reason=\"" + reason + "\", SQLState=" + SQLState + ", vendorCode=" + vendorCode + ")"));
        }
        SQLWarning new_warning = new SQLWarning(reason, SQLState, vendorCode);
        return DBError.addSqlWarning((SQLWarning)first_warning, (SQLWarning)new_warning);
    }

    public static SQLWarning addSqlWarning(SQLWarning first_warning, SQLWarning new_warning) throws SQLException {
        if (first_warning == null) {
            return new_warning;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.addSqlWarning(first_warning=" + first_warning + ", new_warning=" + new_warning + ")"));
            if (new_warning != null) {
                OracleLog.print(null, (int)1, (int)4, (int)32, (String)("DBError.newSqlWarning(reason=\"" + new_warning.getMessage() + "\", SQLState=" + new_warning.getSQLState() + ", vendorCode=" + new_warning.getErrorCode() + ")"));
            }
        }
        first_warning.setNextWarning(new_warning);
        return first_warning;
    }

    public static SQLWarning addSqlWarning(SQLWarning first_warning, int errNum, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.addSqlWarning(first_warning=" + first_warning + ", errNum=" + errNum + ", obj=" + obj + ")"));
        }
        if (errNum == 0 || errNum == 13) {
            return first_warning;
        }
        String msg = DBError.findMessage((int)errNum, (Object)obj);
        int vendor_code = DBError.getVendorCode((int)errNum);
        return DBError.addSqlWarning((SQLWarning)first_warning, (String)("Warning: " + msg), null, (int)vendor_code);
    }

    public static SQLWarning addSqlWarning(SQLWarning first_warning, int errNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.addSqlWarning(first_warning=" + first_warning + ", errNum=" + errNum + ")"));
        }
        return DBError.addSqlWarning((SQLWarning)first_warning, (int)errNum, null);
    }

    public static void check_error(IOException e2) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.check_error(" + e2 + ")"));
        }
        DBError.throwSqlException((IOException)e2);
    }

    public static void check_error(int errNum, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.check_error(errNum=" + errNum + ", obj=" + obj + ")"));
        }
        DBError.throwSqlException((int)errNum, (Object)obj);
    }

    public static void check_error(int errNum) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.check_error(errNum=" + errNum + ")"));
        }
        DBError.throwSqlException((int)errNum, null);
    }

    public static String ErrorToSQLState(int oracleError) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.ErrorToSQLState(" + oracleError + ")"));
        }
        int i2 = 0;
        while (i2 < mappings.length) {
            if (oracleError == DBError.mappings[i2].err) {
                return DBError.mappings[i2].SQLState;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < ranges.length) {
            if (oracleError > DBError.ranges[i3].low && oracleError <= DBError.ranges[i3].high) {
                return DBError.ranges[i3].SQLState;
            }
            ++i3;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)"DBError.ErrorToSQLState(oracleError): returned 99999");
        }
        return "99999";
    }

    public static int getVendorCode(int errNum) {
        if (errNum >= 500 && OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)8, (String)("DBError.getVendorCode(" + errNum + "), " + errNum + " is out of range"));
        }
        return 17000 + errNum;
    }

    static String getMsgKey(int errNum) {
        int vendor_code = DBError.getVendorCode((int)errNum);
        String ret_key = "ORA-" + Integer.toString(vendor_code);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)1, (int)4, (int)16, (String)("DBError.getMsgKey(errNum=" + errNum + "): returned " + ret_key));
        }
        return ret_key;
    }

    public static void test() {
        IOException io_e;
        OracleLog.config((int)0, (int)1, (int)32);
        OracleLog.setSubmodMask((int)1, (int)4);
        OracleLog.setLogStream((PrintStream)System.out);
        try {
            DBError.throwSqlException((String)"exception_message_1", (String)"sql_state_1", (int)25);
        }
        catch (SQLException e2) {
            DBError.printSqlException((SQLException)e2);
        }
        try {
            DBError.throwSqlException((int)412, (Object)new String("object_string"));
        }
        catch (SQLException e3) {
            DBError.printSqlException((SQLException)e3);
        }
        try {
            DBError.throwSqlException((int)6);
        }
        catch (SQLException e4) {
            DBError.printSqlException((SQLException)e4);
        }
        try {
            DBError.throwSqlException((int)999);
        }
        catch (SQLException e5) {
            DBError.printSqlException((SQLException)e5);
        }
        try {
            DBError.throwSqlException((int)13);
        }
        catch (SQLException e6) {
            DBError.printSqlException((SQLException)e6);
        }
        try {
            io_e = new IOException("ORA-00601: cleanup lock conflict");
            DBError.throwSqlException((IOException)io_e);
        }
        catch (SQLException e7) {
            DBError.printSqlException((SQLException)e7);
        }
        try {
            io_e = new IOException("some unknown io exception");
            DBError.throwSqlException((IOException)io_e);
        }
        catch (SQLException e8) {
            DBError.printSqlException((SQLException)e8);
        }
    }

    public static void printSqlException(SQLException e2) {
        OracleLog.print(null, (int)1, (int)4, (int)32, (String)"SQLException:");
        OracleLog.print(null, (int)1, (int)4, (int)32, (String)("  message  = \"" + e2.getMessage() + "\""));
        OracleLog.print(null, (int)1, (int)4, (int)32, (String)("  SQLState = \"" + e2.getSQLState() + "\""));
        OracleLog.print(null, (int)1, (int)4, (int)32, (String)("  errCode  = " + e2.getErrorCode()));
    }

    static {
        JDBC_ERROR_BASE = 17000;
        JDBC_MAX_ERRORS = 500;
        EOJ_SUCCESS = 0;
        EOJ_ERROR = 1;
        EOJ_IOEXCEPTION = 2;
        EOJ_INVALID_COLUMN_INDEX = 3;
        EOJ_INVALID_COLUMN_TYPE = 4;
        EOJ_UNSUPPORTED_COLUMN_TYPE = 5;
        EOJ_INVALID_COLUMN_NAME = 6;
        EOJ_INVALID_DYNAMIC_COLUMN = 7;
        EOJ_CLOSED_CONNECTION = 8;
        EOJ_CLOSED_STATEMENT = 9;
        EOJ_CLOSED_RESULTSET = 10;
        EOJ_EXHAUSTED_RESULTSET = 11;
        EOJ_TYPE_CONFLICT = 12;
        EOJ_WAS_NULL = 13;
        EOJ_RESULTSET_BEFORE_FIRST_ROW = 14;
        EOJ_STATEMENT_WAS_CANCELLED = 15;
        EOJ_STATEMENT_TIMED_OUT = 16;
        EOJ_CURSOR_ALREADY_INITIALIZED = 17;
        EOJ_INVALID_CURSOR = 18;
        EOJ_CAN_ONLY_DESCRIBE_A_QUERY = 19;
        EOJ_INVALID_ROW_PREFETCH = 20;
        EOJ_MISSING_DEFINES = 21;
        EOJ_MISSING_DEFINES_AT_INDEX = 22;
        EOJ_UNSUPPORTED_FEATURE = 23;
        EOJ_NO_DATA_READ = 24;
        EOJ_IS_DEFINES_NULL_ERROR = 25;
        EOJ_NUMERIC_OVERFLOW = 26;
        EOJ_STREAM_CLOSED = 27;
        EOJ_NO_NEW_DEFINE_IF_RESULT_SET_NOT_CLOSED = 28;
        EOJ_READ_ONLY = 29;
        EOJ_INVALID_TRANSLEVEL = 30;
        EOJ_AUTO_CLOSE_ONLY = 31;
        EOJ_ROW_PREFETCH_NOT_ZERO = 32;
        EOJ_MALFORMED_SQL92 = 33;
        EOJ_NON_SUPPORTED_SQL92_TOKEN = 34;
        EOJ_NON_SUPPORTED_CHAR_SET = 35;
        EOJ_ORACLE_NUMBER_EXCEPTION = 36;
        EOJ_FAIL_CONVERSION_UTF8_TO_UCS2 = 37;
        EOJ_CONVERSION_BYTE_ARRAY_ERROR = 38;
        EOJ_CONVERSION_CHAR_ARRAY_ERROR = 39;
        EOJ_SUB_SUB_PROTOCOL_ERROR = 40;
        EOJ_INVALID_IN_OUT_BINDS = 41;
        EOJ_INVALID_BATCH_VALUE = 42;
        EOJ_INVALID_STREAM_SIZE = 43;
        EOJ_DATASET_ITEMS_NOT_ALLOCATED = 44;
        EOJ_BEYOND_BINDS_BATCH = 45;
        EOJ_INVALID_RANK = 46;
        EOJ_TDS_FORMAT_ERROR = 47;
        EOJ_UNDEFINED_TYPE = 48;
        EOJ_INCONSISTENT_ADT = 49;
        EOJ_NOSUCHELEMENT = 50;
        EOJ_NOT_AN_OBJECT_TYPE = 51;
        EOJ_INVALID_REF = 52;
        EOJ_INVALID_SIZE = 53;
        EOJ_INVALID_LOB_LOCATOR = 54;
        EOJ_FAIL_CONVERSION_CHARACTER = 55;
        EOJ_UNSUPPORTED_CHARSET = 56;
        EOJ_CLOSED_LOB = 57;
        EOJ_INVALID_NLS_RATIO = 58;
        EOJ_CONVERSION_JAVA_ERROR = 59;
        EOJ_FAIL_CREATE_DESC = 60;
        EOJ_NO_DESCRIPTOR = 61;
        EOJ_INVALID_REF_CURSOR = 62;
        EOJ_NOT_IN_A_TRANSACTION = 63;
        EOJ_DATABASE_IS_NULL = 64;
        EOJ_CONV_WAS_NULL = 65;
        EOJ_ACCESS_SPECIFIC_IMPL = 66;
        EOJ_INVALID_URL = 67;
        EOJ_INVALID_ARGUMENTS = 68;
        EOJ_USE_XA_EXPLICIT = 69;
        EOJ_INVALID_DATASIZE_LENGTH = 70;
        EOJ_EXCEEDED_VARRAY_LENGTH = 71;
        EOJ_VALUE_TOO_BIG = 72;
        EOJ_LOGICAL_CONN_CLOSED = 73;
        EOJ_INVALID_NAME_PATTERN = 74;
        EOJ_INVALID_FORWARD_RSET_OP = 75;
        EOJ_INVALID_READONLY_RSET_OP = 76;
        EOJ_FAIL_REF_SETVALUE = 77;
        EOJ_CONNECTIONS_ALREADY_EXIST = 78;
        EOJ_USER_CREDENTIALS_FAIL = 79;
        EOJ_INVALID_BATCH_COMMAND = 80;
        EOJ_BATCH_ERROR = 81;
        EOJ_NO_CURRENT_ROW = 82;
        EOJ_NOT_ON_INSERT_ROW = 83;
        EOJ_ON_INSERT_ROW = 84;
        EOJ_UPDATE_CONFLICTS = 85;
        EOJ_NULL_INSERET_ROW_VALUE = 86;
        WARN_IGNORE_FETCH_DIRECTION = 87;
        EOJ_UNSUPPORTED_SYNTAX = 88;
        EOJ_INTERNAL_ERROR = 89;
        EOJ_OPER_NOT_ALLOWED = 90;
        WARN_ALTERNATE_RSET_TYPE = 91;
        EOJ_NO_JDBC_AT_END_OF_CALL = 92;
        EOJ_WARN_SUCCESS_WITH_INFO = 93;
        EOJ_VERSION_MISMATCH = 94;
        EOJ_NO_STMT_CACHE_SIZE = 95;
        EOJ_STMT_CACHE_POOLC = 96;
        EOJ_INVALID_ELEMENT_TYPE = 97;
        EOJ_INVALID_EMPTYLOB_OP = 98;
        EOJ_INVALID_INDEXTABLE_ARRAY_LENGTH = 99;
        EOJ_INVALID_JAVA_OBJECT = 100;
        EOJ_CONNECTIONPOOL_INVALID_PROPERTIES = 101;
        EOJ_BFILE_IS_READONLY = 102;
        EOJ_WRONG_CONNECTION_TYPE_FOR_METHOD = 103;
        EOJ_NULL_SQL_STRING = 104;
        EOJ_SESSION_TZ_NOT_SET = 105;
        EOJ_CONNECTIONPOOL_INVALID_CONFIG = 106;
        EOJ_CONNECTIONPOOL_INVALID_PROXY_TYPE = 107;
        WARN_DEFINE_COLUMN_TYPE = 108;
        EOJ_STANDARD_ENCODING_NOT_FOUND = 109;
        EOJ_THIN_WARNING = 110;
        EOJ_WARN_CONN_CACHE_TIMEOUT = 111;
        EOJ_WARN_THREAD_TIMEOUT_INTERVAL = 112;
        EOJ_WARN_THREAD_INTERVAL_TOO_BIG = 113;
        EOJ_LOCAL_COMMIT_IN_GLOBAL_TXN = 114;
        EOJ_LOCAL_ROLLBACK_IN_GLOBAL_TXN = 115;
        EOJ_AUTOCOMMIT_IN_GLOBAL_TXN = 116;
        EOJ_SETSVPT_IN_GLOBAL_TXN = 117;
        EOJ_GETID_FOR_NAMED_SVPT = 118;
        EOJ_GETNAME_FOR_UNNAMED_SVPT = 119;
        EOJ_SETSVPT_WITH_AUTOCOMMIT = 120;
        EOJ_ROLLBACK_WITH_AUTOCOMMIT = 121;
        EOJ_ROLLBACK_TO_SVPT_IN_GLOBAL_TXN = 122;
        EOJ_INVALID_STMT_CACHE_SIZE = 123;
        EOJ_WARN_CACHE_INACTIVITY_TIMEOUT = 124;
        EOJ_IMPROPER_STATEMENT_TYPE = 125;
        EOJ_FIXED_WAIT_TIMEOUT = 126;
        EOJ_WARN_CACHE_FIXEDWAIT_TIMEOUT = 127;
        EOJ_INVALID_QUERY_STRING = 128;
        EOJ_INVALID_DML_STRING = 129;
        EOJ_QUERY_TIMEOUT_INVALID_STATE = 131;
        EOJ_INVALID_OBJECT_TO_CONVERT = 132;
        EOJ_STMT_NOT_EXECUTED = 137;
        EOJ_UNSUPPORTED_HOLDABILIY = 162;
        EOJ_HETEROXA_GET_UTF_OPENSTR = 200;
        EOJ_HETEROXA_GET_UTF_CLOSESTR = 201;
        EOJ_HETEROXA_GET_UTF_RMNAME = 202;
        EOJ_HETEROXA_JHANDLE_SIZE = 203;
        EOJ_HETEROXA_ARRAY_TOO_SHORT = 204;
        EOJ_HETEROXA_SVCCTX_HANDLE = 205;
        EOJ_HETEROXA_ENV_HANDLE = 206;
        EOJ_HETEROXA_NULL_TNSENTRY = 207;
        EOJ_HETEROXA_OPEN_RMERR = 213;
        EOJ_HETEROXA_OPEN_INVAL = 215;
        EOJ_HETEROXA_OPEN_PROTO = 216;
        EOJ_HETEROXA_CLOSE_RMERR = 233;
        EOJ_HETEROXA_CLOSE_INVAL = 235;
        EOJ_HETEROXA_CLOSE_PROTO = 236;
        TTC_ERR_BASE = 400;
        TTC0000 = 401;
        TTC0001 = 402;
        TTC0002 = 403;
        TTC0003 = 404;
        TTC0004 = 405;
        TTC0005 = 406;
        TTC0100 = 407;
        TTC0101 = 408;
        TTC0102 = 409;
        TTC0103 = 410;
        TTC0104 = 411;
        TTC0105 = 412;
        TTC0106 = 413;
        TTC0107 = 414;
        TTC0108 = 415;
        TTC0109 = 416;
        TTC0110 = 417;
        TTC0111 = 418;
        TTC0112 = 419;
        TTC0113 = 420;
        TTC0114 = 421;
        TTC0115 = 422;
        TTC0116 = 423;
        TTC0117 = 424;
        TTC0118 = 425;
        TTC0119 = 426;
        TTC0120 = 427;
        TTC0200 = 428;
        TTC0201 = 429;
        TTC0202 = 430;
        TTC0203 = 431;
        TTC0204 = 432;
        TTC0205 = 433;
        TTC0206 = 434;
        TTC0207 = 435;
        TTC0208 = 436;
        TTC0209 = 437;
        TTC0210 = 438;
        TTC0211 = 439;
        TTC0212 = 440;
        TTC0213 = 441;
        TTC0214 = 442;
        TTC0216 = 443;
        TTC0217 = 444;
    }
}

