/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBData;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.StructDescriptor;

public class DBDataSetImpl
extends DBDataSet {
    private static int _MIN_ARG_COUNT = 1;
    private static final boolean DEBUG = false;
    protected OracleConnection m_connection;
    protected OracleStatement m_statement;
    private boolean m_dynamic = false;
    private int m_arrayDepth = 0;
    private boolean m_cleanedData = false;
    private boolean m_isCached = false;
    private byte m_sql_kind;
    private boolean m_sql_kind_cached;
    private int m_noOfArgs;
    protected int m_dataSetType;
    protected DBData[] data;
    protected DBType[] types;
    private DBItem[] m_last_bind_values = null;
    private boolean newDBType = false;
    private DBItem[] m_tmp_first_row_items = null;
    private DBType[] m_tmp_first_row_types = null;
    protected boolean m_first_row;
    private short[] form_of_use = null;

    private void init() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.init()");
        }
        this.m_dynamic = false;
        this.m_first_row = true;
        this.m_noOfArgs = 0;
        this.data = null;
        this.types = null;
        this.m_cleanedData = false;
    }

    private void _transformToDynamic() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl._transformToDynamic()");
        }
        this.m_dynamic = true;
        this.m_arrayDepth = 0;
        if (!this.m_first_row) {
            this._cleanData();
            int i2 = 0;
            while (i2 < this.types.length) {
                this._allocData(i2);
                ++i2;
            }
        }
    }

    private final void _allocData(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._allocData(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._allocData(index): data=" + this.data + ", m_dynamic=" + this.m_dynamic));
            if (this.data != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._allocData(index): data[" + index + "]=" + this.data[index]));
            }
        }
        if (this.data[index] != null) {
            return;
        }
        this.data[index] = this.m_dynamic ? new DBData() : new DBData(this.m_arrayDepth);
    }

    private final void _allocDataAndItems(int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._allocDataAndItems(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._allocDataAndItems(index): m_dynamic=" + this.m_dynamic));
        }
        if (this.m_dynamic) {
            DBError.throwSqlException((int)89);
        }
        this._allocData(index);
        this._allocItemsAndBuffers(index);
    }

    private void _allocItemsAndBuffers(int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._allocItemsAndBuffers(" + index + ")"));
        }
        int row_i = 0;
        int nitems = this.data[index].getNItems();
        DBType dbtype = this.types[index];
        row_i = 0;
        while (row_i < nitems) {
            this.data[index].setItem(row_i, this.m_connection.db_access.createDBItem(dbtype));
            if (!dbtype.is_stream && dbtype.type != 109 && dbtype.type != 111) {
                this.data[index].getItem(row_i).allocBuffer();
            }
            ++row_i;
        }
    }

    public final void _cleanData() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl._cleanData()");
        }
        if (this.data != null) {
            int len = this.data.length;
            int i2 = 0;
            while (i2 < len) {
                if (this.data[i2] != null) {
                    this.data[i2].cleanup();
                    this.data[i2] = null;
                }
                ++i2;
            }
            this.m_cleanedData = true;
        }
    }

    public final DBItem _getDBItem(int index, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._getDBItem(index=" + index + ", rank=" + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getDBItem(index, rank): data=" + this.data));
            if (this.data != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getDBItem(index, rank): data[" + index + "]=" + this.data[index]));
            }
        }
        if (this.data == null || this.data[index] == null) {
            return null;
        }
        return this.data[index].getItem(rank);
    }

    private final DBItem _getLastDBItem(int index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._getLastDBItem(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getLastDBItem(index): data=" + this.data));
            if (this.data != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getLastDBItem(index): data[" + index + "]=" + this.data[index]));
            }
        }
        if (this.data == null || this.data[index] == null) {
            return null;
        }
        if (this.m_dynamic) {
            int lastRowNum = this.data[index].getNItems();
            if (lastRowNum == 0) {
                return null;
            }
            return this.data[index].getItem(lastRowNum - 1);
        }
        return this.data[index].getItem(this.m_arrayDepth - 1);
    }

    private final void _setDBItem(DBItem item, int colIndex, int rowIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._setDBItem(item=" + item + ", colIndex=" + colIndex + ", rowIndex=" + rowIndex + ")"));
        }
        if (this.data[colIndex] == null) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl._setDBItem() dumping DBDataSet info\n" + this.getInfoString()));
            }
            DBError.throwSqlException((int)44);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._setDBItem(item, colIndex, rowIndex): m_dynamic=" + this.m_dynamic));
        }
        if (this.m_dynamic) {
            this.data[colIndex].addItem(item);
        } else {
            this.data[colIndex].setItem(rowIndex, item);
        }
    }

    private final DBType _getDBType(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._getDBType(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getDBType(index): types=" + this.types + ", index=" + index));
        }
        if (this.types != null && index >= 0 && index < this.types.length) {
            return this.types[index];
        }
        return null;
    }

    private final void _setDBType(int index, DBType dbtype) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._setDBType(index=" + index + ", dbtype=" + dbtype + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._setDBType(index, dbtype): types=" + this.types + ", index=" + index));
        }
        if (this.types != null && index >= 0 && index < this.types.length) {
            this.types[index] = dbtype;
        }
    }

    private void _alloc_tmp_binds(int index, boolean isInBind) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._alloc_tmp_binds(index=" + index + ", isInBind=" + isInBind + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._alloc_tmp_binds(index, isInBind): m_tmp_first_row_types=" + this.m_tmp_first_row_types));
        }
        if (this.m_tmp_first_row_types == null) {
            int length = Math.max(index + 1, _MIN_ARG_COUNT);
            if (isInBind) {
                this.m_tmp_first_row_items = new DBItem[length];
            }
            this.m_tmp_first_row_types = new DBType[length];
        } else if (index >= this.m_tmp_first_row_types.length) {
            int length = this.m_tmp_first_row_types.length;
            length = Math.max(index + 1, length);
            if (isInBind) {
                DBItem[] new_row_items = new DBItem[2 * length];
                System.arraycopy(this.m_tmp_first_row_items, 0, new_row_items, 0, this.m_tmp_first_row_items.length);
                this.m_tmp_first_row_items = new_row_items;
                new_row_items = null;
            }
            DBType[] new_row_types = new DBType[2 * length];
            System.arraycopy(this.m_tmp_first_row_types, 0, new_row_types, 0, this.m_tmp_first_row_types.length);
            this.m_tmp_first_row_types = new_row_types;
            new_row_types = null;
        }
    }

    protected DBType _getBindDBType(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._getBindDBType(index= " + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._getBindDBType(index): m_first_row=" + this.m_first_row));
        }
        DBType dbtype = null;
        if (this.m_first_row) {
            if (index + 1 > this.m_noOfArgs) {
                this.m_noOfArgs = index + 1;
            }
            this._alloc_tmp_binds(index, true);
            dbtype = this.m_tmp_first_row_types[index];
        } else {
            dbtype = this._getDBType(index);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._getBindDBType(index): returned " + dbtype));
        }
        return dbtype;
    }

    protected DBType _createOrGetBindDBType(int index, int type) throws SQLException {
        DBType dbtype;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._createOrGetBindDBType(index= " + index + ", type= " + type + ")"));
        }
        if (!(this.m_first_row || this.data != null && this.data.length > index)) {
            this.m_first_row = true;
            if (this.types != null && this.types.length > 0) {
                this.m_tmp_first_row_types = new DBType[this.types.length];
                this.m_tmp_first_row_items = new DBItem[this.types.length];
                System.arraycopy(this.types, 0, this.m_tmp_first_row_types, 0, this.m_tmp_first_row_types.length);
                System.arraycopy(this.m_last_bind_values, 0, this.m_tmp_first_row_items, 0, this.m_tmp_first_row_items.length);
            }
        }
        if ((dbtype = this._getBindDBType(index)) == null || dbtype.type != type) {
            this.newDBType = true;
            if (!this.m_sql_kind_cached) {
                this.m_sql_kind = this.m_statement.getSqlKind();
                this.m_sql_kind_cached = true;
            }
            dbtype = this.m_sql_kind == 1 || this.m_sql_kind == 3 ? this.m_connection.db_access.createDBType(type, this.m_dataSetType == 1, this.m_sql_kind == 1) : this.m_connection.db_access.createDBType(type, true, this.getFormOfUse(index));
        } else {
            this.newDBType = false;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._createOrGetBindDBType(index, type): returned " + dbtype));
        }
        return dbtype;
    }

    protected DBItem _createOrGetDBItem(int index, DBType dbtype, int rank) throws SQLException {
        DBItem item = null;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._createOrGetDBItem(index=" + index + ", dbtype=" + dbtype + ", rank=" + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._createOrGetDBItem(index, dbtype, rank): m_first_row=" + this.m_first_row));
        }
        if (this.m_first_row) {
            item = this.m_connection.db_access.createDBItem(dbtype);
        } else {
            item = this._getDBItem(index, rank);
            DBItem prev_item = null;
            prev_item = rank == 0 ? this._getLastDBItem(index) : this._getDBItem(index, rank - 1);
            if (item == null || prev_item != null && prev_item.equals(item)) {
                item = this.m_connection.db_access.createDBItem(dbtype);
            } else {
                item.reinitialize(dbtype.max_length);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._createOrGetDBItem(index, dbtype, rank): returned " + item));
        }
        return item;
    }

    protected void _setBindDBItem(int index, DBItem item) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._setBindDBItem(index=" + index + ", item=" + item + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._setBindDBItem(index, item): m_first_row=" + this.m_first_row));
        }
        if (this.m_first_row) {
            this.m_tmp_first_row_items[index] = item;
        } else {
            this.m_last_bind_values[index] = item;
        }
    }

    protected void _setBindDBType(int index, DBType type) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._setBindDBType(index=" + index + ", type=" + type + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._setBindDBType(index, type): m_first_row=" + this.m_first_row));
        }
        type.FormOfUse = this.getFormOfUse(index);
        type.ncs = type.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
        if (this.m_first_row) {
            this.m_tmp_first_row_types[index] = type;
        } else {
            this._setDBType(index, type);
        }
    }

    private final void _setRowItems(int colIndex, DBItem item) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._setRowItems(colIndex= " + colIndex + ", item= " + item + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._setRowItems(colIndex, item): m_dynamic=" + this.m_dynamic));
        }
        if (this.m_dynamic) {
            DBError.throwSqlException((int)89);
        }
        this.data[colIndex].setItem(0, item);
        int row_i = 1;
        while (row_i < this.m_arrayDepth) {
            DBItem item_copy = item.clone(this.types[colIndex], this.m_connection.db_access);
            this.data[colIndex].setItem(row_i, item_copy);
            ++row_i;
        }
    }

    private void _bindsRowCompleted(int rank) throws SQLException {
        int i2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl._bindRowCompleted(rank= " + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._bindRowCompleted(rank): m_dataSetType=" + this.m_dataSetType + ", m_noOfArgs=" + this.m_noOfArgs + ", m_first_row=" + this.m_first_row + ", m_cleanedData=" + this.m_cleanedData));
        }
        if (rank == -1 && !this.m_dynamic) {
            this._transformToDynamic();
        }
        if (this.m_first_row) {
            this.m_first_row = false;
            this.data = new DBData[this.m_noOfArgs];
            this.types = new DBType[this.m_noOfArgs];
            this.m_last_bind_values = new DBItem[this.m_noOfArgs];
            i2 = 0;
            while (i2 < this.m_noOfArgs) {
                if (this.m_tmp_first_row_types != null && this.m_tmp_first_row_types[i2] != null) {
                    this.types[i2] = this.m_tmp_first_row_types[i2];
                    if (this.m_dataSetType == 1) {
                        this.m_last_bind_values[i2] = this.m_tmp_first_row_items[i2];
                        this._allocData(i2);
                    } else {
                        this._allocDataAndItems(i2);
                    }
                }
                ++i2;
            }
            if (this.m_tmp_first_row_types != null) {
                i2 = 0;
                while (i2 < this.m_tmp_first_row_types.length) {
                    this.m_tmp_first_row_types[i2] = null;
                    this.m_tmp_first_row_items[i2] = null;
                    ++i2;
                }
                this.m_tmp_first_row_items = null;
                this.m_tmp_first_row_types = null;
            }
        }
        if (this.m_cleanedData) {
            i2 = 0;
            while (i2 < this.m_noOfArgs) {
                if (this.types != null && this.types[i2] != null) {
                    if (this.m_dataSetType == 1) {
                        this._allocData(i2);
                    } else {
                        this._allocDataAndItems(i2);
                    }
                }
                ++i2;
            }
            this.m_cleanedData = false;
        }
        if (this.m_dataSetType == 1) {
            i2 = 0;
            while (i2 < this.types.length) {
                if (this.m_last_bind_values[i2] != null) {
                    this._setDBItem(this.m_last_bind_values[i2], i2, rank);
                }
                ++i2;
            }
        }
    }

    private void _definesRowCompleted() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl._definesRowCompleted()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl._definesRowCompleted(): m_dynamic=" + this.m_dynamic + ", m_noOfArgs= " + this.m_noOfArgs));
        }
        this.m_first_row = false;
        if (!this.m_dynamic) {
            if (this.types == null) {
                DBError.throwSqlException((int)21);
            }
            if (this.types.length == 0) {
                DBError.throwSqlException((int)21);
            }
            int col_num = this.types.length;
            this.data = new DBData[col_num];
            int col_i = 0;
            while (col_i < col_num) {
                this.data[col_i] = new DBData(this.m_arrayDepth);
                ++col_i;
            }
        }
        int column_index = 0;
        while (column_index < this.m_noOfArgs) {
            DBType dbtype = this.types[column_index];
            DBItem item = this.m_connection.db_access.createDBItem(dbtype);
            if (dbtype.type != 109 && dbtype.type != 111 && !dbtype.is_stream) {
                item.allocBuffer();
            }
            this._setRowItems(column_index, item);
            ++column_index;
        }
    }

    private final void _createArrayFromTypes(int arrayDepth) throws SQLException {
    }

    public DBDataSetImpl(OracleConnection conn, OracleStatement stmt, int nrows, int dataSetType) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.DBDataSetImpl(conn=" + conn + ", stmt=" + stmt + ", nrows=" + nrows + ", dataSetType= " + dataSetType + ")"));
        }
        this.init();
        this.m_connection = conn;
        this.m_statement = stmt;
        this.m_arrayDepth = nrows;
        this.m_dataSetType = dataSetType;
    }

    public final boolean isDynamic() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.isDynamic(): returned " + this.m_dynamic));
        }
        return this.m_dynamic;
    }

    public int getNoOfArgs() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getNoOfArgs(): returned " + this.m_noOfArgs));
        }
        return this.m_noOfArgs;
    }

    public void setNoOfDefineCol(int noOfArgs) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setNoOfDefineCol(noOfArgs= " + noOfArgs + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setNoOfDefineCol(noOfArgs): m_dynamic=" + this.m_dynamic + ", m_dataSetType=" + this.m_dataSetType + ", noOfArgs=" + noOfArgs));
        }
        if (this.m_dynamic || this.m_dataSetType != 0) {
            return;
        }
        this.m_noOfArgs = noOfArgs;
        DBType[] saveTypes = this.types;
        this.types = new DBType[this.m_noOfArgs];
        if (saveTypes != null) {
            int colsToCopy = this.m_noOfArgs < saveTypes.length ? this.m_noOfArgs : saveTypes.length;
            int i2 = 0;
            while (i2 < colsToCopy) {
                this.types[i2] = saveTypes[i2];
                ++i2;
            }
            Object var2_2 = null;
        }
    }

    public boolean isStreamType(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.isStreamType(index= " + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.isStreamType(index): types=" + this.types));
        }
        if (this.types != null && index < this.types.length && this.types[index] != null) {
            return this.types[index].is_stream;
        }
        return false;
    }

    public boolean hasStreamType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.hasStreamType()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.hasStreamType(): types=" + this.types));
        }
        if (this.types != null) {
            int i2 = 0;
            while (i2 < this.types.length) {
                if (this.types[i2] != null && this.types[i2].is_stream) {
                    return true;
                }
                ++i2;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.hasStreamType(): returned false");
        }
        return false;
    }

    public int getMissingType() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.getMissingType()");
        }
        int index = 0;
        while (index < this.types.length) {
            if (this.types[index] == null) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getMissingType(): returned " + index));
                }
                return index;
            }
            ++index;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.getMissingType(): returned -1");
        }
        return -1;
    }

    public final byte[] getBytesItem(int index, int rank) throws SQLException {
        DBItem item;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getBytesItem(index=" + index + ", rank=" + rank + ")"));
        }
        byte[] returnVal = null;
        if (this.data != null && this.data[index] != null && (item = this.data[index].getItem(rank)) != null && !item.is_null) {
            returnVal = new byte[item.data_size];
            System.arraycopy(item.byte_value, 0, returnVal, 0, item.data_size);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getBytesItem(index, rank): returned " + OracleLog.bytesToPrintableForm("returnVal=", returnVal)));
        }
        return returnVal;
    }

    public final char[] getCharsItem(int index, int rank, int[] char_size, short fo_use) throws SQLException {
        DBItem item;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getCharsItem(index=" + index + ", rank=" + rank + ", int[] char_size, fo_use=" + fo_use + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getCharsItem(index, rank, char_size, fo_use): data=" + this.data));
        }
        char[] returnVal = null;
        if (this.data != null && this.data[index] != null && (item = this.data[index].getItem(rank)) != null && !item.is_null) {
            item.getChars(fo_use);
            returnVal = item.char_value;
            char_size[0] = item.char_size;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getCharsItem(index, rank, char_size, fo_use): returned " + OracleLog.bytesToPrintableForm("returnVal=", OracleLog.charsToUcs2Bytes(returnVal))));
        }
        return returnVal;
    }

    public final InputStream getStreamItem(int index, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getStreamItem(index= " + index + ", rank= " + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getStreamItem(index, rank): data=" + this.data));
            if (this.data != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getStreamItem(index, rank): data[" + index + "]=" + this.data[index]));
            }
        }
        if (this.data == null || this.data[index] == null) {
            return null;
        }
        DBItem item = this.data[index].getItem(rank);
        if (item == null || item.is_null) {
            return null;
        }
        try {
            if (((OracleInputStream)item.stream_value).isClosed()) {
                DBError.throwSqlException((int)27);
            }
            if (!((OracleInputStream)item.stream_value).needBytes()) {
                item.setNull();
                return null;
            }
            return item.stream_value;
        }
        catch (IOException e2) {
            DBError.throwSqlException((IOException)e2);
            return null;
        }
    }

    public final char[] getCharsStreamItem(int index, int rank, int[] char_size) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getCharsStreamItem(index= " + index + ", rank= " + rank + ", int[] char_size)"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getCharsStreamItem(index, rank, int[] char_size): data=" + this.data));
            if (this.data != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getCharsStreamItem(index, rank, int[] char_size): data[" + index + "]=" + this.data[index]));
            }
        }
        if (this.data == null || this.data[index] == null) {
            return null;
        }
        DBItem item = this.data[index].getItem(rank);
        if (item == null || item.is_null) {
            return null;
        }
        char[] ret_val = item.getChars((short)1);
        char_size[0] = item.char_size;
        return ret_val;
    }

    public final void setStreamItem(int index, int rank, InputStream stream) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setStreamItem(index=" + index + ", rank=" + rank + ", stream=" + stream + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setStreamItem(index, rank, stream): data=" + this.data));
        }
        if (this.data == null || this.data[index] == null) {
            return;
        }
        this.data[index].getItem((int)rank).stream_value = stream;
    }

    public boolean dataAllocated(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.dataAllocated(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.dataAllocated(index): data=" + this.data));
        }
        return this.data != null && index < this.data.length && this.data[index] != null;
    }

    public final byte[] getBytes(int colIndex, int rowIndex) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getBytes(colIndex=" + colIndex + ", rowIndex=" + rowIndex + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getBytes(colIndex, rowIndex): data=" + this.data));
        }
        if (this.data.length < colIndex) {
            return null;
        }
        return this.data[colIndex].getItem(rowIndex).getBytes();
    }

    public final boolean isNull(int index, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.isNull(index=" + index + ", rank=" + rank + ")"));
        }
        return this.data[index].getItem((int)rank).is_null;
    }

    public final void setNull(int index, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setNull(index=" + index + ", rank=" + rank + ")"));
        }
        this.data[index].getItem(rank).setNull();
    }

    public final int getType(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getType(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getType(index): types=" + this.types));
        }
        if (this.types == null || index < 0 || this.types.length <= index || this.types[index] == null) {
            return -1;
        }
        return this.types[index].type;
    }

    public final int getExternalType(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getExternalType(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getExternalType(index): types=" + this.types));
        }
        if (this.types == null || index < 0 || this.types.length <= index || this.types[index] == null) {
            return -1;
        }
        return this.types[index].external_type;
    }

    public final OracleType getOtype(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getOtype(" + index + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.getOtype(index): types=" + this.types));
        }
        if (this.types == null || this.types.length <= index || this.types[index] == null) {
            return null;
        }
        return this.types[index].otype;
    }

    public final void setType(int index, int type, int maxLength, short FormOfUse) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setType(index=" + index + ", type=" + type + ", maxLength=" + maxLength + ", FormOfUse=" + FormOfUse + ")"));
        }
        this.setType(index, type, 0, maxLength, FormOfUse);
    }

    public void setType(int index, int internalType, int externalType, int maxLength, short FormOfUse) throws SQLException {
        this.setType(index, internalType, externalType, maxLength, FormOfUse, false);
    }

    public void setType(int index, int internalType, int externalType, int maxLength, short FormOfUse, boolean isSizeConverted) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setType(index=" + index + ", internalType=" + internalType + ", externalType=" + externalType + ", maxLength=" + maxLength + ", FormOfUse=" + FormOfUse + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setTypes(index, internalType, externalType, maxLength, FormOfUse):\nm_dataSetType= " + this.m_dataSetType));
        }
        DBType dbtype = null;
        if (this.m_dataSetType == 0) {
            if (index + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(index + 1);
            }
            dbtype = this.m_connection.db_access.createDBType(internalType, false);
            if (!isSizeConverted && internalType == 96 || internalType == 1 || internalType == 999) {
                if (maxLength > 0) {
                    dbtype.setMaxSize(maxLength);
                }
            } else if (maxLength > 0 && maxLength < dbtype.max_length) {
                dbtype.max_length = maxLength;
            }
            dbtype.FormOfUse = FormOfUse;
            dbtype.ncs = dbtype.isNType() ? (int)this.m_connection.conversion.getNCharSet() : (int)this.m_connection.conversion.getDbCharSet();
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.setType: DBTtype.max_length=" + dbtype.max_length + ", DBType.type=" + dbtype.type + ", DBType.external_type=" + dbtype.external_type));
            }
            this._setDBType(index, dbtype);
        } else {
            dbtype = this._createOrGetBindDBType(index, internalType);
            if (maxLength > 0 && maxLength < dbtype.max_length) {
                dbtype.max_length = maxLength;
            }
            this._setBindDBType(index, dbtype);
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.setType: DBTtype.max_length=" + dbtype.max_length + ", DBType.type=" + dbtype.type + ", DBType.external_type=" + dbtype.external_type));
            }
            if (this.m_dataSetType == 2 && !this.m_first_row) {
                this._allocDataAndItems(index);
            }
        }
        dbtype.setExternalType(externalType);
    }

    public final void setType(int index, int type, OracleType otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setType(index=" + index + ", type=" + type + ", otype=" + otype + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setType(index, type, otype): m_dataSetType=" + this.m_dataSetType));
        }
        if (this.m_dataSetType == 0) {
            if (index + 1 > this.m_noOfArgs) {
                this.setNoOfDefineCol(index + 1);
            }
            DBType dbtype = this.m_connection.db_access.createDBType(type, false);
            dbtype.otype = otype;
            this._setDBType(index, dbtype);
        } else {
            DBType dbtype = this._createOrGetBindDBType(index, type);
            dbtype.otype = otype;
            this._setBindDBType(index, dbtype);
        }
    }

    public final void clearItems() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.clearItems()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.clearItems():\nm_first_row= " + this.m_first_row + ", m_tmp_first_row_items=" + this.m_tmp_first_row_items));
        }
        if (this.m_first_row && this.m_tmp_first_row_items != null) {
            int col_index = 0;
            while (col_index < this.m_noOfArgs) {
                this.m_tmp_first_row_items[col_index] = null;
                ++col_index;
            }
        } else {
            int col_index = 0;
            while (col_index < this.m_noOfArgs) {
                this.m_last_bind_values[col_index] = null;
                ++col_index;
            }
            if (this.data == null) {
                return;
            }
            int i2 = 0;
            while (i2 < this.data.length) {
                if (this.data[i2] != null) {
                    this.data[i2].clearItems();
                }
                ++i2;
            }
            this.m_cleanedData = true;
        }
    }

    public final void cleanup() {
        int length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.cleanup()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.cleanup()\nm_tmp_first_row_items= " + this.m_tmp_first_row_items));
        }
        this.cleanTypes();
        this.cleanData();
        this.data = null;
        int ii = 0;
        this.m_last_bind_values = null;
        if (this.m_tmp_first_row_items != null) {
            length = this.m_tmp_first_row_items.length;
            ii = 0;
            while (ii < length) {
                this.m_tmp_first_row_items[ii] = null;
                ++ii;
            }
            this.m_tmp_first_row_items = null;
        }
        if (this.m_tmp_first_row_types != null) {
            length = this.m_tmp_first_row_types.length;
            ii = 0;
            while (ii < length) {
                this.m_tmp_first_row_types[ii] = null;
                ++ii;
            }
            this.m_tmp_first_row_types = null;
        }
        this.init();
    }

    public final void cleanTypes() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.cleanTypes():\nm_dataSetType= " + this.m_dataSetType));
        }
        if (this.types != null) {
            int i2 = 0;
            while (i2 < this.types.length) {
                this.types[i2] = null;
                ++i2;
            }
        }
        this.types = null;
        this.m_noOfArgs = 0;
    }

    public final void cleanData() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.cleanData()");
        }
        if (this.m_last_bind_values != null) {
            int len = this.m_last_bind_values.length;
            int i2 = 0;
            while (i2 < len) {
                if (this.m_last_bind_values[i2] != null) {
                    this.m_last_bind_values[i2] = null;
                }
                ++i2;
            }
        }
        this._cleanData();
    }

    public void setBatchSize(int newBatchSize) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setBatchSize(newBatchSize=" + newBatchSize + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setBatchSize: original batch size was " + this.m_arrayDepth + ", dataset was \n" + this.getInfoString() + ", m_first_row=" + this.m_first_row + ", m_dynamic=" + this.m_dynamic + ", data=" + this.data + ", types=" + this.types));
        }
        if (newBatchSize == this.m_arrayDepth) {
            return;
        }
        this.m_arrayDepth = newBatchSize;
        if (this.m_first_row || this.m_dynamic) {
            return;
        }
        if (this.data != null && this.types != null) {
            int len = this.data.length;
            int col = 0;
            while (col < len) {
                DBType dbtype = this.types[col];
                if (this.data[col] == null) {
                    this.data[col] = new DBData(this.m_arrayDepth);
                } else {
                    DBData origData = this.data[col];
                    int numItems = origData.getNItems();
                    int rowsToCopy = numItems < newBatchSize ? numItems : newBatchSize;
                    this.data[col] = new DBData(newBatchSize);
                    int row = 0;
                    while (row < rowsToCopy) {
                        this.data[col].setItem(row, origData.getItem(row));
                        ++row;
                    }
                    int clength = -1;
                    DBItem oitem = origData.getItem(0);
                    if (oitem != null && oitem.byte_value != null) {
                        clength = oitem.byte_value.length;
                    }
                    row = rowsToCopy;
                    while (row < newBatchSize) {
                        DBItem newItem = this.m_connection.db_access.createDBItem(dbtype);
                        if (clength == -1) {
                            newItem.allocBuffer();
                        } else {
                            newItem.allocBuffer(clength);
                        }
                        this.data[col].setItem(row, newItem);
                        ++row;
                    }
                }
                ++col;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setBatchSize: dataset changed to=\n" + this.getInfoString()));
        }
    }

    public void rowCompleted(int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.rowCompleted(" + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.rowCompleted(" + rank + "): m_dataSetType=" + this.m_dataSetType));
        }
        if (this.m_dataSetType == 0) {
            this._definesRowCompleted();
        } else {
            this._bindsRowCompleted(rank);
        }
    }

    public boolean setBytesBindItem(int index, int rank, int type, byte[] data) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setBytesBindItem(index=" + index + ", rank=" + rank + ", type=" + type + ", " + OracleLog.bytesToPrintableForm("byte[] data=", data) + ")"));
        }
        if (this.m_isCached && !this.m_first_row && (this.types == null || this.types.length < index || this.types[index] == null || this.types[index].type != type || data != null && this.types[index].max_length < data.length)) {
            this.setFirstRow(true);
            if (index > 0) {
                this.m_tmp_first_row_types = new DBType[this.types.length];
                this.m_tmp_first_row_items = new DBItem[this.m_last_bind_values.length];
                System.arraycopy(this.types, 0, this.m_tmp_first_row_types, 0, this.types.length);
                System.arraycopy(this.m_last_bind_values, 0, this.m_tmp_first_row_items, 0, this.m_last_bind_values.length);
            }
        }
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        boolean retValue = this.newDBType;
        if (data == null) {
            item.setNull();
        } else {
            if (dbtype.max_length < data.length) {
                dbtype.max_length = data.length;
                retValue = true;
            }
            item.setArrayData(false, data);
        }
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setBytesBindItem(index, rank, type, data[]):\n returned " + retValue));
        }
        return retValue;
    }

    public boolean setBytesBindItem(int index, int rank, int type, String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setBytesBindItem(index" + index + ", rank=" + rank + ", type=" + type + ", str=" + str + ")"));
        }
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        boolean retValue = this.newDBType;
        if (str == null) {
            item.setNull();
        } else {
            item.setArrayData(false, str, (int)this.getFormOfUse(index));
            if (dbtype.max_length < item.byte_value.length) {
                dbtype.max_length = item.byte_value.length;
                retValue = true;
            }
        }
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setBytesBindItem(index, rank, type, str): returned " + retValue));
        }
        return retValue;
    }

    public void setStreamBindItem(int index, int rank, int type, InputStream istream, int dataSize) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setStreamBindItem(index=" + index + ", rank=" + rank + ", type=" + type + ", istream=" + istream + ", dataSize=" + dataSize + ")"));
        }
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        item.setStreamData(false, dataSize, istream);
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
    }

    public boolean setNullADTBindItem(int index, int rank, int type, OracleType otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setNullADTBindItem(index=" + index + ", rank=" + rank + ", type=" + type + ", otype=" + otype + ")"));
        }
        boolean retValue = false;
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        ((OracleTypeADT)otype).getTOID();
        if (!otype.isInHierarchyOf(dbtype.otype)) {
            retValue = true;
            dbtype.otype = otype;
        }
        item.setNull();
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setNullADTBindItem(index, rank, type, otype): returned " + retValue));
        }
        return retValue;
    }

    public void setNullBindItem(int index, int rank, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setNullBindItem(index=" + index + ", rank=" + rank + ", type=" + type + ")"));
        }
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        item.setNull();
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
    }

    public void setADTBindType(int index, int rank, int type, OracleType otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setADTBindType(index=" + index + ", rank=" + rank + ", type=" + type + ", otype=" + otype + ")"));
        }
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        ((OracleTypeADT)otype).getTOID();
        dbtype.max_length = 0;
        dbtype.otype = otype;
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, null);
    }

    public boolean setADTBindItem(int index, int rank, int type, byte[] pickled_bytes, OracleType otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setADTBindItem(index=" + index + ", rank=" + rank + ", type=" + type + ", " + OracleLog.bytesToPrintableForm("byte[] pickled_bytes=", pickled_bytes) + ", otype=" + otype + ")"));
        }
        boolean retValue = false;
        DBType dbtype = this._createOrGetBindDBType(index, type);
        DBItem item = this._createOrGetDBItem(index, dbtype, rank);
        ((OracleTypeADT)otype).getTOID();
        dbtype.max_length = pickled_bytes.length;
        if (!otype.isInHierarchyOf(dbtype.otype)) {
            retValue = true;
            dbtype.otype = otype;
        }
        item.setArrayData(false, pickled_bytes, true);
        this._setBindDBType(index, dbtype);
        this._setBindDBItem(index, item);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setADTBindItem(index, rank, type, pickled_bytes, otype): returned " + retValue));
        }
        return retValue;
    }

    public int checkBindTypes(DBDataSet _dbset2, int index, int type) throws SQLException {
        DBType bind_type;
        DBType bind_type2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.checkBindTypes(_dbset2=" + _dbset2 + ", index=" + index + ", type=" + type + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.checkBindTypes(_dbset2, index, type): m_first_row=" + this.m_first_row));
        }
        if (index < 0) {
            DBError.throwSqlException((int)3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > index && (bind_type2 = this._getDBType(index)) != null && (bind_type2.type != type || bind_type2.max_length == 0 && !this.m_statement.isColumnSetNull(index + 1))) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.checkBindTypes(_dbset2, index, type): returned -1");
            }
            return -1;
        }
        DBDataSetImpl dbset2 = (DBDataSetImpl)_dbset2;
        if (!(dbset2 == null || dbset2.types == null || dbset2.types.length <= index || (bind_type = dbset2._getDBType(index)) == null || bind_type.type == type || this.m_connection.looseTimestampDateCheck && (bind_type.type == 180 && type == 12 || bind_type.type == 12 && type == 180) || bind_type.type == 96 && type == 1 || bind_type.type == 1 && type == 96)) {
            DBError.throwSqlException((int)12);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.checkBindTypes(_dbset2, index, type): returned 0");
        }
        return 0;
    }

    public int checkBindObjectTypes(DBDataSet _dbset2, int index, int type, StructDescriptor desc) throws SQLException {
        DBType bind_type;
        DBType bind_type2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.checkBindObjectTypes(_dbset2=" + _dbset2 + ", index" + index + ", type=" + type + ", desc=" + desc + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.checkBindObjectTypes(_dbset2, index, type, desc): m_first_row=" + this.m_first_row));
        }
        if (index < 0) {
            DBError.throwSqlException((int)3);
        }
        if (this.m_first_row) {
            return 0;
        }
        if (this.types != null && this.types.length > index && (bind_type2 = this._getDBType(index)) != null && (bind_type2.type != type || bind_type2.max_length == 0 && !this.m_statement.isColumnSetNull(index + 1) || !bind_type2.otype.isInHierarchyOf(desc))) {
            return -1;
        }
        DBDataSetImpl dbset2 = (DBDataSetImpl)_dbset2;
        if (!(dbset2 == null || dbset2.types == null || dbset2.types.length <= index || (bind_type = dbset2._getDBType(index)) == null || bind_type.type == type || bind_type.type == 96 && type == 1 || bind_type.type == 1 && type == 96)) {
            DBError.throwSqlException((int)12);
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.checkBindObjectTypes(_dbset2, index, type, desc): returned =0");
        }
        return 0;
    }

    public int checkBindsInAndOut(DBDataSet _dbset2, int rank) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.checkBindsInAndOut(_dbset2=" + _dbset2 + ", rank=" + rank + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.checkBindsInAndOut(_dbset2, rank): \nthis DBDataSetImpl is " + this.getInfoString()));
            if (_dbset2 != null) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.checkBindsInAndOut(_dbset2, rank): \n_dbset2 DBDataSetImpl is " + _dbset2.getInfoString()));
            }
        }
        DBDataSetImpl dbset2 = (DBDataSetImpl)_dbset2;
        int length = 0;
        if (this.types != null) {
            length = this.types.length;
        }
        if (dbset2 != null && dbset2.types != null && dbset2.types.length > length) {
            length = dbset2.types.length;
        }
        int i2 = 0;
        while (i2 < length) {
            if (!(this.data != null && i2 < this.data.length && this.data[i2] != null && this.data[i2].getItem(rank) != null || dbset2 != null && dbset2.data != null && i2 < dbset2.data.length && dbset2.data[i2] != null && dbset2.data[i2].getItem(rank) != null)) {
                if (OracleLog.TRACE) {
                    OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.checkBindsInAndOut(_dbset2, rank): returned " + i2));
                }
                return i2;
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.checkBindsInAndOut(_dbset2, rank): returned -1");
        }
        return -1;
    }

    public void removeFirstRow() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.removeFirstRow()");
        }
        if (this.data != null) {
            int j2 = 0;
            while (j2 < this.data.length) {
                this.data[j2].removeFirstItem();
                ++j2;
            }
        }
    }

    public void prependRowidColumn() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.prependRowidColumn()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.prependRowidColumn():\nDBDataSetImpl.prependRowidColumn dataset was " + this.getInfoString()));
        }
        ++this.m_noOfArgs;
        DBType[] newTypes = new DBType[this.m_noOfArgs];
        newTypes[0] = this.m_connection.db_access.createDBType(104, false);
        System.arraycopy(this.types, 0, newTypes, 1, this.types.length);
        this.types = newTypes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.prependRowidColumn():\nDBDataSetImpl.prependRowidColumn dataset changed to\n" + this.getInfoString()));
        }
    }

    public void removeRowidColumn() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.removeRowidColumn()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.removeRowidColumn()\nDBDataSetImpl.removeRowidColumn dataset was " + this.getInfoString()));
        }
        --this.m_noOfArgs;
        DBType[] newTypes = new DBType[this.m_noOfArgs];
        System.arraycopy(this.types, 1, newTypes, 0, this.types.length - 1);
        this.types = newTypes;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBDataSetImpl.removeRowidColumn()\nDBDataSetImpl.removeRowidColumn dataset changed to\n" + this.getInfoString()));
        }
    }

    public void enterCache() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.enterCache()");
        }
        if (this.m_dataSetType != 0) {
            this.cleanData();
            this.m_isCached = true;
        } else if (this.m_statement.columns_defined_by_user) {
            this.m_statement.columns_defined_by_user = false;
            this.cleanTypes();
        }
    }

    public void reactivate() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.reactivate()");
        }
    }

    public DBType[] getDBTypes() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.getDBTypes()");
        }
        return this.types;
    }

    public DBData[] getDBData() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.getDBData()");
        }
        return this.data;
    }

    public final String getInfoString() throws SQLException {
        int i2;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.getInfoString()");
        }
        StringBuffer str = new StringBuffer("");
        str.append(this + "\n" + "  DBDataSetImpl.m_dynamic=" + this.m_dynamic + "\n" + "  DBDataSetImpl.m_arrayDepth=" + this.m_arrayDepth + " (valid only when m_dynamic=false)\n");
        str.append("  DBDataSetImpl.m_dataSetType=" + this.m_dataSetType + "\n");
        str.append("  DBDataSetImpl.m_noOfArgs=" + this.m_noOfArgs + "\n");
        if (this.types == null) {
            str.append("  DBDataSetImpl.types is null");
        } else {
            str.append("  DBDataSetImpl.types.length=" + this.types.length);
            i2 = 0;
            while (i2 < this.types.length) {
                if (this.types[i2] == null) {
                    str.append("\n    types[" + i2 + "]=null");
                } else {
                    str.append("\n    types[" + i2 + "].type=" + DBType.getStringType((int)this.types[i2].type) + " (max_length=" + this.types[i2].max_length + ")");
                }
                ++i2;
            }
        }
        str.append("\n");
        if (this.data == null) {
            str.append("  DBDataSetImpl.data is null");
        } else {
            str.append("  DBDataSetImpl.data.length=" + this.data.length);
            i2 = 0;
            while (i2 < this.data.length) {
                if (this.data[i2] == null) {
                    str.append("\n    data[" + i2 + "]=null");
                } else {
                    int j2 = 0;
                    while (j2 < this.data[i2].getNItems()) {
                        DBItem di = this.data[i2].getItem(j2);
                        if (di == null) {
                            str.append("\n    data[" + i2 + "].items[" + j2 + "]=null");
                        } else {
                            str.append("\n    data[" + i2 + "].items[" + j2 + "] has " + di.data_size + " bytes:\n");
                            if (di.byte_value != null) {
                                str.append("\n    data[" + i2 + "].items[" + j2 + "] has " + di.byte_value.length + " bytes allocated\n");
                                str.append(OracleLog.bytesToFormattedStr(di.byte_value, di.data_size, "    "));
                            }
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        if (this.m_last_bind_values == null) {
            str.append("  DBDataSetImpl.m_last_bind_values is null\n");
        } else {
            str.append("  DBDataSetImpl.m_last_bind_values has size of " + this.m_last_bind_values.length + "\n");
        }
        if (this.m_tmp_first_row_items == null) {
            str.append("  DBDataSetImpl.m_tmp_first_row_items is null\n");
        } else {
            str.append("  DBDataSetImpl.m_tmp_first_row_items has size of " + this.m_tmp_first_row_items.length + "\n");
        }
        if (this.m_tmp_first_row_types == null) {
            str.append("  DBDataSetImpl.m_tmp_first_row_types is null\n");
        } else {
            str.append("  DBDataSetImpl.m_tmp_first_row_types has size of " + this.m_tmp_first_row_types.length + "\n");
        }
        return str.toString();
    }

    public short getFormOfUse(int index) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.getFormOfUse(" + index + "): form_of_use=" + this.form_of_use));
        }
        if (this.form_of_use == null) {
            return 1;
        }
        if (this.form_of_use.length <= index) {
            return 1;
        }
        if (this.form_of_use[index] == 0) {
            return 1;
        }
        return this.form_of_use[index];
    }

    public void setFormOfUse(int paramIndex, short FormOfUse) {
        DBType dbtype;
        int length;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setFormOfUse(paramIndex=" + paramIndex + ", FormOfUse=" + FormOfUse + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBDataSetImpl.setFormOfUse(paramIndex, FormOfUse): form_of_use=" + this.form_of_use));
        }
        int index = paramIndex - 1;
        if (this.form_of_use == null) {
            length = Math.max(index + 1, _MIN_ARG_COUNT);
            this.form_of_use = new short[length];
        } else if (index >= this.form_of_use.length) {
            length = this.form_of_use.length;
            length = Math.max(index + 1, length);
            short[] new_form_of_use = new short[2 * length];
            System.arraycopy(this.form_of_use, 0, new_form_of_use, 0, this.form_of_use.length);
            this.form_of_use = new_form_of_use;
            new_form_of_use = null;
        }
        this.form_of_use[index] = FormOfUse;
        if (this.m_dataSetType == 2 && (dbtype = this._getBindDBType(index)) != null) {
            this._setBindDBType(index, dbtype);
        }
    }

    public void setFirstRow(boolean flag) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.setFirstRow(" + flag + ")"));
        }
        this.m_first_row = flag;
    }

    public void clearItem(int rowNum, boolean onlyItems) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBDataSetImpl.clearItem(" + rowNum + ", " + onlyItems + " )"));
        }
        if (!onlyItems && this.m_first_row && this.m_tmp_first_row_items != null) {
            int col_index = 0;
            while (col_index < this.m_noOfArgs) {
                this.m_tmp_first_row_items[col_index] = null;
                ++col_index;
            }
        } else {
            int i2;
            if (this.data == null) {
                return;
            }
            if (!onlyItems) {
                i2 = 0;
                while (i2 < this.m_last_bind_values.length) {
                    this.m_last_bind_values[i2] = null;
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.data.length && this.data[i2] != null) {
                this.data[i2].clearItem(rowNum);
                ++i2;
            }
            this.m_cleanedData = true;
        }
    }

    public final void clearItemBuffers() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBDataSetImpl.clearBuffers()");
        }
        if (this.data != null) {
            int i2 = 0;
            while (i2 < this.data.length) {
                if (this.data[i2] != null) {
                    this.data[i2].clearItemBuffers();
                }
                ++i2;
            }
        }
    }

    public void reallocOutBuffers() throws SQLException {
        if (this.data != null) {
            int i2 = 0;
            while (i2 < this.data.length && this.data[i2] != null) {
                this.data[i2].reallocItemBuffers();
                ++i2;
            }
        }
    }

    static {
        DEBUG = false;
    }
}

