/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.driver.OracleLog;

public class DBData {
    private boolean m_dynamic = false;
    private DBItem[] m_items = null;
    private Vector m_vector = null;

    public DBData(int nItems) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.DBData(" + nItems + ")"));
        }
        this.m_dynamic = false;
        this.m_items = new DBItem[nItems];
    }

    public void setItem(int num, DBItem item) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.setItem(num=" + num + ", item=" + item + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBData.setItem(num, item): m_dynamic=" + this.m_dynamic));
        }
        if (this.m_dynamic) {
            DBError.throwSqlException((int)89);
        }
        this.checkItemNumber(num);
        this.m_items[num] = item;
    }

    public DBData() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBData.DBData()");
        }
        this.m_dynamic = true;
        this.m_vector = new Vector();
    }

    public int addItem(DBItem item) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.addItem(" + item + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBData.addItem(item): m_dynamic=" + this.m_dynamic));
        }
        if (!this.m_dynamic) {
            DBError.throwSqlException((int)89);
        }
        this.m_vector.addElement(item);
        return this.m_vector.size();
    }

    public void removeFirstItem() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBData.removeFirstItem()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBData.removeFirstItem(): m_dynamic=" + this.m_dynamic));
        }
        if (!this.m_dynamic) {
            DBError.throwSqlException((int)89);
        }
        this.m_vector.removeElementAt(0);
    }

    public final boolean isDynamic() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.isDynamic(): returned " + this.m_dynamic));
        }
        return this.m_dynamic;
    }

    public final void clearItems() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBData.clearItems()");
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBData.clearItems(): m_dynamic=" + this.m_dynamic + ", m_vector=" + this.m_vector));
        }
        if (this.m_dynamic) {
            if (this.m_vector != null) {
                this.m_vector.removeAllElements();
            }
        } else if (this.m_items != null) {
            int i2 = 0;
            while (i2 < this.m_items.length) {
                this.m_items[i2] = null;
                ++i2;
            }
        }
    }

    public final void cleanup() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)"DBData.cleanup()");
        }
        this.clearItems();
        this.m_vector = null;
        this.m_items = null;
    }

    public int getNItems() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.getNItems(): m_dynamic=" + this.m_dynamic));
        }
        return this.m_dynamic ? this.m_vector.size() : this.m_items.length;
    }

    public DBItem getItem(int num) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.getItem(" + num + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)32, (String)("DBData.getItem(num): m_dynamic=" + this.m_dynamic));
        }
        DBItem ret_item = null;
        if (this.m_dynamic) {
            if (num < 0) {
                DBError.throwSqlException((int)46);
            } else {
                ret_item = num >= this.getNItems() ? null : (DBItem)this.m_vector.elementAt(num);
            }
        } else {
            this.checkItemNumber(num);
            ret_item = this.m_items[num];
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.getItem(num): returned " + ret_item));
        }
        return ret_item;
    }

    private void checkItemNumber(int num) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.checkItemNumber(" + num + ")"));
        }
        if (num < 0 || num >= this.getNItems()) {
            if (OracleLog.TRACE) {
                OracleLog.print((Object)this, (int)2, (int)2, (int)2, (String)("Invalid item number " + num + " (range 0.." + this.getNItems() + ")"));
            }
            DBError.throwSqlException((int)46);
        }
    }

    public void clearItem(int rowNumber) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)2, (int)16, (String)("DBData.clearItem(" + rowNumber + ")"));
            OracleLog.print((Object)this, (int)2, (int)2, (int)64, (String)("DBData.clearItem(rowNumber): m_dynamic=" + this.m_dynamic + ", m_vector=" + this.m_vector + ", rowNumber=" + rowNumber + ", m_items=" + this.m_items));
        }
        if (this.m_dynamic && this.m_vector != null && rowNumber < this.m_vector.size()) {
            this.m_vector.removeElementAt(rowNumber);
        }
        if (this.m_items == null || rowNumber >= this.m_items.length) {
            return;
        }
        this.m_items[rowNumber] = null;
    }

    public void clearItemBuffers() throws SQLException {
        if (this.m_items != null) {
            int i2 = 0;
            while (i2 < this.m_items.length) {
                if (this.m_items[i2] != null) {
                    this.m_items[i2].clearBuffer();
                }
                ++i2;
            }
        }
    }

    public void reallocItemBuffers() throws SQLException {
        if (this.m_items != null) {
            int i2 = 0;
            while (i2 < this.m_items.length) {
                if (this.m_items[i2] != null) {
                    this.m_items[i2].reallocBuffer();
                }
                ++i2;
            }
        }
    }
}

