/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBConversion {
    public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
    protected short m_dbNCharSet;
    protected short m_dbCharSet;
    protected short m_charSet;
    private CharacterSet m_databaseCs;
    private CharacterSet m_databaseNCs;
    private CharacterSet m_accessCs;
    private CharacterSet m_asciiCs;
    public static final short DBCS_CHARSET = -1;
    public static final short UCS2_CHARSET = -5;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short AL16UTF16_CHARSET = 2000;

    public DBConversion(short svrCharSet, short accessCharSet, short svrNCharSet) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.DBConversion( svrCharSet=" + svrCharSet + ", accessCharSet=" + accessCharSet + ", svrNCharSet=" + svrNCharSet + ")"));
        }
        switch (accessCharSet) {
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: 
            case 873: {
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)accessCharSet);
            }
        }
        this.m_dbCharSet = svrCharSet;
        this.m_charSet = accessCharSet;
        this.m_databaseCs = CharacterSet.make(this.m_dbCharSet);
        this.m_dbNCharSet = svrNCharSet;
        this.m_databaseNCs = CharacterSet.make(this.m_dbNCharSet);
        this.m_accessCs = accessCharSet == -1 ? this.m_databaseCs : CharacterSet.make(this.m_charSet);
    }

    public short getDbCharSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.getDbCharSet(): returned " + this.m_dbCharSet));
        }
        return this.m_dbCharSet;
    }

    public short getNCharSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.getNCharSet(): returned " + this.m_dbNCharSet));
        }
        return this.m_dbNCharSet;
    }

    public boolean IsNCharFixedWith() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)"DBConversion.IsNCharFixedWith()");
            OracleLog.print((Object)this, (int)4, (int)32, (String)("DBConversion.IsNCharFixedWith(): m_dbNCharSet=" + this.m_dbNCharSet + ", AL16UTF16_CHARSET=" + 2000));
        }
        return this.m_dbNCharSet == 2000;
    }

    public short getAccessCharSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)"DBConversion.getAccessCharSet()");
            OracleLog.print((Object)this, (int)4, (int)32, (String)("DBConversion.getAccessCharSet(): m_charSet=" + this.m_charSet + ", m_dbCharSet=" + this.m_dbCharSet));
        }
        if (this.m_charSet == -1) {
            return this.m_dbCharSet;
        }
        return this.m_charSet;
    }

    public CharacterSet getDbCharSetObj() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.getDbCharSetObj(): returned " + this.m_databaseCs));
        }
        return this.m_databaseCs;
    }

    public CharacterSet getAccessCharSetObj() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.getAccessCharSetObj(): returned " + this.m_accessCs));
        }
        return this.m_accessCs;
    }

    public CharacterSet getAccessNCharSetObj() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.getAccessNCharSetObj(): returned " + this.m_databaseNCs));
        }
        return this.m_databaseNCs;
    }

    public static boolean isAccessCharSetSupported(short charset) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.isAccessCharSetSupported(" + charset + ")"));
        }
        boolean ret = false;
        switch (charset) {
            case -5: 
            case -1: 
            case 1: 
            case 31: 
            case 870: 
            case 871: {
                ret = true;
                break;
            }
            default: {
                ret = false;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.isAccessCharSetSupported(charset): returned " + ret));
        }
        return ret;
    }

    public static byte[] stringToAccessCharBytes(String str, short charset) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAccessCharBytes(str=" + str + ", charset=" + charset + ")"));
        }
        if (str == null) {
            return null;
        }
        byte[] ret_bytes = null;
        switch (charset) {
            case -5: {
                ret_bytes = DBConversion.stringToUcs2Bytes((String)str);
                break;
            }
            case 1: 
            case 31: {
                ret_bytes = DBConversion.stringToAsciiBytes((String)str);
                break;
            }
            case 870: 
            case 871: {
                ret_bytes = DBConversion.stringToUtf8Bytes((String)str);
                break;
            }
            case 2000: {
                ret_bytes = DBConversion.stringToUcs2Bytes((String)str);
                break;
            }
            case 873: {
                ret_bytes = DBConversion.stringToAL32UTF8Bytes((String)str);
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)charset);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAccessCharBytes(str, charset): returned " + OracleLog.bytesToPrintableForm("DBAccess bytes=", ret_bytes)));
        }
        return ret_bytes;
    }

    public byte[] StringToCharBytes(String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.StringToCharBytes(" + str + ")"));
            OracleLog.print((Object)this, (int)4, (int)32, (String)("DBConversion.StringToCharBytes(str): m_charSet=" + this.m_charSet));
        }
        if (this.m_charSet == -1) {
            return this.m_databaseCs.convertWithReplacement(str);
        }
        return DBConversion.stringToAccessCharBytes((String)str, (short)this.m_charSet);
    }

    public byte[] StringToNCharBytes(String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.StringToNCharBytes(" + str + ")"));
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.StringToNCharBytes(str): m_charSet=" + this.m_charSet));
        }
        if (this.m_charSet == -1) {
            return this.m_databaseNCs.convertWithReplacement(str);
        }
        return DBConversion.stringToAccessCharBytes((String)str, (short)this.m_dbNCharSet);
    }

    public String CharBytesToString(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.CharBytesToString(" + OracleLog.bytesToPrintableForm("bytes=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        String ret_str = null;
        switch (this.m_charSet) {
            case -5: {
                ret_str = DBConversion.ucs2BytesToString((byte[])bytes, (int)nbytes);
                break;
            }
            case 1: 
            case 31: {
                ret_str = new String(bytes, 0, 0, nbytes);
                break;
            }
            case 870: 
            case 871: {
                ret_str = DBConversion.utf8BytesToString((byte[])bytes, (int)nbytes);
                break;
            }
            case 873: {
                ret_str = DBConversion.al32utf8BytesToString((byte[])bytes, (int)nbytes);
                break;
            }
            case -1: {
                ret_str = this.m_databaseCs.toStringWithReplacement(bytes, 0, nbytes);
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.CharBytesToString(bytes, nbytes): returned " + ret_str));
        }
        return ret_str;
    }

    public String NCharBytesToString(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.NCharBytesToString(" + OracleLog.bytesToPrintableForm("bytes[], nbytes=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        String ret_str = null;
        if (this.m_charSet == -1) {
            ret_str = this.m_databaseNCs.toStringWithReplacement(bytes, 0, nbytes);
        } else {
            switch (this.m_dbNCharSet) {
                case -5: {
                    ret_str = DBConversion.ucs2BytesToString((byte[])bytes, (int)nbytes);
                    break;
                }
                case 1: 
                case 31: {
                    ret_str = new String(bytes, 0, 0, nbytes);
                    break;
                }
                case 870: 
                case 871: {
                    ret_str = DBConversion.utf8BytesToString((byte[])bytes, (int)nbytes);
                    break;
                }
                case 2000: {
                    ret_str = DBConversion.ucs2BytesToString((byte[])bytes, (int)nbytes);
                    break;
                }
                case 873: {
                    ret_str = DBConversion.al32utf8BytesToString((byte[])bytes, (int)nbytes);
                    break;
                }
                case -1: {
                    ret_str = this.m_databaseCs.toStringWithReplacement(bytes, 0, nbytes);
                    break;
                }
                default: {
                    DBConversion.unexpectedCharset((short)this.m_charSet);
                }
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.NCharBytesToString(bytes[], nbytes): returned " + ret_str));
        }
        return ret_str;
    }

    public int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToCHARBytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        return this.javaCharsToCHARBytes(chars, nchars, bytes, this.m_charSet);
    }

    public int javaCharsToNCHARBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToNCHARBytes(chars=" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        return this.javaCharsToCHARBytes(chars, nchars, bytes, this.m_dbNCharSet);
    }

    private int javaCharsToCHARBytes(char[] chars, int nchars, byte[] bytes, short cs) throws SQLException {
        int ret = 0;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToCHARBytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars, nchars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", cs=" + cs));
        }
        switch (cs) {
            case -5: {
                ret = DBConversion.javaCharsToUcs2Bytes((char[])chars, (int)nchars, (byte[])bytes);
                break;
            }
            case 1: 
            case 31: {
                ret = DBConversion.javaCharsToAsciiBytes((char[])chars, (int)nchars, (byte[])bytes);
                break;
            }
            case 870: 
            case 871: {
                ret = DBConversion.javaCharsToUtf8Bytes((char[])chars, (int)nchars, (byte[])bytes);
                break;
            }
            case 2000: {
                ret = DBConversion.javaCharsToUcs2Bytes((char[])chars, (int)nchars, (byte[])bytes);
                break;
            }
            case 873: {
                ret = DBConversion.javaCharsToAL32UTF8Bytes((char[])chars, (int)0, (int)nchars, (byte[])bytes, (int)0);
                break;
            }
            case -1: {
                ret = this.javaCharsToDbCsBytes(chars, nchars, bytes);
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToCHARBytes(chars, nchars, bytes[], cs): returned " + ret));
        }
        return ret;
    }

    public int CHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.CHARBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        return this.charBytesToJavaChars(bytes, nbytes, chars, (int)this.m_charSet);
    }

    public int NCHARBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.NCHARBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        return this.charBytesToJavaChars(bytes, nbytes, chars, (int)this.m_dbNCharSet);
    }

    public int charBytesToJavaChars(byte[] bytes, int nbytes, char[] chars, int cs) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.charBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", cs=" + cs + ")"));
        }
        int ret = 0;
        switch (cs) {
            case -5: {
                ret = DBConversion.ucs2BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
                break;
            }
            case 1: 
            case 31: {
                ret = DBConversion.asciiBytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
                break;
            }
            case 870: 
            case 871: {
                ret = DBConversion.utf8BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
                break;
            }
            case 2000: {
                ret = DBConversion.ucs2BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
                break;
            }
            case 873: {
                ret = DBConversion.al32utf8BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
                break;
            }
            case -1: {
                ret = this.dbCsBytesToJavaChars(bytes, nbytes, chars);
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.charBytesToJavaChars(bytes[], nbytes, chars, cs): returned " + ret));
        }
        return ret;
    }

    public int CHARBytesToJavaChars(byte[] bytes, int[] nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.CHARBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", int[] nbytes," + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        return this._CHARBytesToJavaChars(bytes, nbytes, chars, this.m_charSet);
    }

    public int NCHARBytesToJavaChars(byte[] bytes, int[] nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.NCHARBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", int[] nbytes, " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        return this._CHARBytesToJavaChars(bytes, nbytes, chars, this.m_dbNCharSet);
    }

    public int _CHARBytesToJavaChars(byte[] bytes, int[] nbytes, char[] chars, short cs) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion._CHARBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", int[] nbytes, " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", cs=" + cs + ")"));
        }
        int count = 0;
        switch (cs) {
            case -5: {
                count = DBConversion.ucs2BytesToJavaChars((byte[])bytes, (int)nbytes[0], (char[])chars);
                nbytes[0] = nbytes[0] % 2;
                break;
            }
            case 1: 
            case 31: {
                count = DBConversion.asciiBytesToJavaChars((byte[])bytes, (int)nbytes[0], (char[])chars);
                nbytes[0] = 0;
                break;
            }
            case 870: 
            case 871: {
                count = DBConversion.utf8BytesToJavaChars((byte[])bytes, (int[])nbytes, (char[])chars);
                break;
            }
            case 873: {
                count = DBConversion.al32utf8BytesToJavaChars((byte[])bytes, (int[])nbytes, (char[])chars);
                break;
            }
            case -1: {
                count = this.dbCsBytesToJavaChars(bytes, nbytes[0], chars);
                nbytes[0] = 0;
                break;
            }
            default: {
                DBConversion.unexpectedCharset((short)this.m_charSet);
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion._CHARBytesToJavaChars(bytes[], nbytes[], chars[], cs): returned " + count));
        }
        return count;
    }

    public byte[] asciiBytesToCHARBytes(byte[] bytes) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.asciiBytesToCHARBytes(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
            OracleLog.print((Object)this, (int)4, (int)32, (String)("DBConversion.asciiBytesToCHARBytes(bytes[]): m_charSet=" + this.m_charSet));
        }
        byte[] retbytes = null;
        switch (this.m_charSet) {
            case -5: {
                retbytes = new byte[bytes.length * 2];
                int i2 = 0;
                int retbyte_i = 0;
                while (i2 < bytes.length) {
                    retbytes[retbyte_i++] = 0;
                    retbytes[retbyte_i++] = bytes[i2];
                    ++i2;
                }
                break;
            }
            case -1: {
                if (this.m_asciiCs == null) {
                    this.m_asciiCs = CharacterSet.make(1);
                }
                try {
                    retbytes = this.m_databaseCs.convert(this.m_asciiCs, bytes, 0, bytes.length);
                }
                catch (SQLException e2) {
                    if (!OracleLog.TRACE) break;
                    OracleLog.print((Object)this, (int)4, (int)8, (String)("DBConversion.asciiBytesToCHARBytes(bytes[]):\n DBCS_CHARSET case got exception: " + e2));
                    if (e2 == null) break;
                    OracleLog.print((Object)this, (int)4, (int)8, (String)("DBConversion.asciiBytesToCHARBytes(bytes[]):\n DBCS_CHARSET case got exception: " + e2.getMessage()));
                }
                break;
            }
            default: {
                retbytes = bytes;
            }
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.asciiBytesToCHARBytes(bytes[]): returned " + OracleLog.bytesToPrintableForm("retbytes=", retbytes)));
        }
        return retbytes;
    }

    public int javaCharsToDbCsBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToDbCsBytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        int num_conv_bytes = 0;
        DBConversion.catchCharsLen((char[])chars, (int)nchars);
        String str = new String(chars, 0, nchars);
        byte[] dbcs_bytes = this.m_databaseCs.convertWithReplacement(str);
        str = null;
        if (dbcs_bytes != null) {
            num_conv_bytes = dbcs_bytes.length;
            DBConversion.catchBytesLen((byte[])bytes, (int)num_conv_bytes);
            int i2 = 0;
            while (i2 < num_conv_bytes) {
                bytes[i2] = dbcs_bytes[i2];
                ++i2;
            }
            dbcs_bytes = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.javaCharsToDbCsBytes(chars[], nchars, bytes[]): returned " + num_conv_bytes));
        }
        return num_conv_bytes;
    }

    public int dbCsBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.dbCsBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int num_conv_chars = 0;
        DBConversion.catchBytesLen((byte[])bytes, (int)nbytes);
        String conv_str = this.m_databaseCs.toStringWithReplacement(bytes, 0, nbytes);
        if (conv_str != null) {
            num_conv_chars = conv_str.length();
            DBConversion.catchCharsLen((char[])chars, (int)num_conv_chars);
            conv_str.getChars(0, num_conv_chars, chars, 0);
            conv_str = null;
        }
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.dbCsBytesToJavaChars(bytes[], nbytes, chars[]): returned " + num_conv_chars));
        }
        return num_conv_chars;
    }

    public static byte[] stringToUcs2Bytes(String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToUcs2Bytes(" + str + ")"));
        }
        char[] chars = str.toCharArray();
        int nchars = chars.length;
        byte[] bytes = new byte[2 * nchars];
        DBConversion.javaCharsToUcs2Bytes((char[])chars, (int)nchars, (byte[])bytes);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToUcs2Bytes(str): returned \n" + OracleLog.bytesToPrintableForm("bytes=", bytes)));
        }
        return bytes;
    }

    public static String ucs2BytesToString(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ucs2BytesToString(" + OracleLog.bytesToPrintableForm("bytes=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        char[] chars = new char[nbytes / 2];
        DBConversion.ucs2BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
        return new String(chars);
    }

    public static int javaCharsToUcs2Bytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUcs2Bytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        DBConversion.catchCharsLen((char[])chars, (int)nchars);
        DBConversion.catchBytesLen((byte[])bytes, (int)(nchars * 2));
        int char_i = 0;
        int byte_i = 0;
        while (char_i < nchars) {
            bytes[byte_i++] = (byte)(chars[char_i] >> 8 & 0xFF);
            bytes[byte_i++] = (byte)(chars[char_i] & 0xFF);
            ++char_i;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUcs2Bytes(chars[], nchars, bytes[]): returned " + byte_i));
        }
        return byte_i;
    }

    public static char ucs2BytesToChar(byte[] bytes, int byteIndex) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ucs2BytesToChar(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", byteIndex=" + byteIndex + ")"));
        }
        return (char)(bytes[byteIndex] << 8 | bytes[byteIndex + 1] & 0xFF);
    }

    public static int ucs2BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ucs2BytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int offset = 0;
        int chars_offset = 0;
        int count = nbytes;
        int chars_i = chars_offset;
        int bytes_i = offset;
        int bytes_end = offset + count;
        while (bytes_i + 1 < bytes_end) {
            int hibyte = bytes[bytes_i] << 8;
            int c2 = hibyte | bytes[bytes_i + 1] & 0xFF;
            if (DBConversion.isHiSurrogate((char)c2)) {
                if ((bytes_i += 2) + 1 < bytes_end) {
                    char c22 = (char)((bytes[bytes_i] << 8) + (bytes[bytes_i + 1] & 0xFF));
                    chars[chars_i++] = DBConversion.isLoSurrogate((char)c22) ? c2 : 65533;
                    chars[chars_i++] = c22;
                } else {
                    chars[chars_i++] = 65533;
                }
            } else {
                chars[chars_i++] = c2;
            }
            bytes_i += 2;
        }
        bytes_i = chars_i - chars_offset;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ucs2BytesToJavaChars(bytes[], nbytes, chars[]): returned " + bytes_i));
        }
        return bytes_i;
    }

    public static byte[] stringToAsciiBytes(String str) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAsciiBytes(" + str + ")"));
        }
        byte[] bytearr = new byte[str.length()];
        str.getBytes(0, str.length(), bytearr, 0);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAsciiBytes(str): returned " + OracleLog.bytesToPrintableForm("bytearr=", bytearr)));
        }
        return bytearr;
    }

    public static int javaCharsToAsciiBytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToAsciiBytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        DBConversion.catchCharsLen((char[])chars, (int)nchars);
        DBConversion.catchBytesLen((byte[])bytes, (int)nchars);
        int i2 = 0;
        while (i2 < nchars) {
            bytes[i2] = (byte)chars[i2];
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToAsciiBytes(chars[], nchars, bytes): returned " + nchars));
        }
        return nchars;
    }

    public static int asciiBytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.asciiBytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        DBConversion.catchBytesLen((byte[])bytes, (int)nbytes);
        DBConversion.catchCharsLen((char[])chars, (int)nbytes);
        int i2 = 0;
        while (i2 < nbytes) {
            chars[i2] = DBConversion.byteToChar((byte)bytes[i2]);
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.asciiBytesToJavaChars(bytes[], nbytes, chars[]): returned " + nbytes));
        }
        return nbytes;
    }

    private static char byteToChar(byte inByte) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.byteToChar(" + inByte + ")"));
        }
        return (char)(0xFF & inByte);
    }

    private static byte[] stringToUtf8Bytes(String str) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToUtf8Bytes(" + str + ")"));
        }
        int nchars = str.length();
        char[] chars = new char[nchars];
        str.getChars(0, nchars, chars, 0);
        return DBConversion.javaCharsToUtf8Bytes((char[])chars);
    }

    private static int javaCharsToUtf8Bytes(char[] chars, int nchars, byte[] bytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUtf8Bytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ", nchars=" + nchars + ", " + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ")"));
        }
        int nbytes = bytes.length;
        DBConversion.catchCharsLen((char[])chars, (int)nchars);
        int i2 = 0;
        int byte_i = 0;
        while (i2 < nchars) {
            char c2 = chars[i2];
            if ((c2 & 0xFF80) == 0) {
                if (byte_i >= nbytes) break;
                bytes[byte_i++] = (byte)c2;
            } else if ((c2 & 0xF800) == 0) {
                if (byte_i + 1 >= nbytes) break;
                bytes[byte_i++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                bytes[byte_i++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                if (byte_i + 2 >= nbytes) break;
                bytes[byte_i++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytes[byte_i++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[byte_i++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++i2;
        }
        if (i2 < nchars) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)4, (int)2, (String)("DBConversion.javaCharsToUtf8Bytes(chars[], nchars, bytes[]): Output buffer of " + nbytes + " bytes is too small for " + nchars + " characters"));
            }
            DBError.check_error((int)39, (Object)"javaCharsToUtf8Bytes");
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUtf8Bytes(chars[], nchars, bytes[]): returned " + byte_i));
        }
        return byte_i;
    }

    private static byte[] javaCharsToUtf8Bytes(char[] chars) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUtf8Bytes(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int nchars = chars.length;
        int nbytes = DBConversion.stringUTF8Length((char[])chars);
        byte[] bytes = new byte[nbytes];
        int i2 = 0;
        int byte_i = 0;
        while (i2 < nchars) {
            char c2 = chars[i2];
            if ((c2 & 0xFF80) == 0) {
                bytes[byte_i++] = (byte)c2;
            } else if ((c2 & 0xF800) == 0) {
                bytes[byte_i++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                bytes[byte_i++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                bytes[byte_i++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytes[byte_i++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[byte_i++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToUtf8Bytes(chars[]): returned " + OracleLog.bytesToPrintableForm("bytes[]=", bytes)));
        }
        return bytes;
    }

    private static String utf8BytesToString(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.utf8BytesToString(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        char[] chars = new char[nbytes];
        int str_len = DBConversion.utf8BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
        return new String(chars, 0, str_len);
    }

    public static int utf8BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.utf8BytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int[] nbytesArr = new int[]{nbytes};
        return DBConversion.utf8BytesToJavaChars((byte[])bytes, (int[])nbytesArr, (char[])chars);
    }

    private static int utf8BytesToJavaChars(byte[] bytes, int[] nbytesArr, char[] chars) throws SQLException {
        int b2;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.utf8BytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", int[] nbytesArr, " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int offset = 0;
        int chars_offset = 0;
        int[] countArr = nbytesArr;
        int count = countArr[0];
        countArr[0] = 0;
        int bytes_index = offset;
        int bytes_end = offset + count;
        int chars_index = chars_offset;
        int charsLength = chars.length;
        block5: while (bytes_index < bytes_end) {
            byte c2 = bytes[bytes_index++];
            b2 = c2 & 0xF0;
            switch (b2 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = (char)(c2 & 0xFFFFFFFF);
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break block5;
                }
                case 12: 
                case 13: {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = 1;
                        break block5;
                    }
                    char c22 = DBConversion.conv2ByteUTFtoUTF16((byte)c2, (byte)bytes[bytes_index++]);
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c22;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 3;
                    break block5;
                }
                case 14: {
                    int c1;
                    char c22;
                    if (bytes_index + 1 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        break block5;
                    }
                    if (DBConversion.isHiSurrogate((char)(c1 = DBConversion.conv3ByteUTFtoUTF16((byte)c2, (byte)bytes[bytes_index++], (byte)bytes[bytes_index++])))) {
                        if (chars_index > charsLength - 2) {
                            countArr[0] = bytes_end - bytes_index + 4;
                            break block5;
                        }
                        if (bytes_index >= bytes_end) continue block5;
                        c2 = bytes[bytes_index];
                        if ((byte)(c2 & 0xF0) != -32) {
                            chars[chars_index++] = 65533;
                            break;
                        }
                        if (++bytes_index + 1 >= bytes_end) {
                            countArr[0] = bytes_end - bytes_index + 1;
                            break block5;
                        }
                        chars[chars_index++] = DBConversion.isLoSurrogate((char)(c22 = DBConversion.conv3ByteUTFtoUTF16((byte)c2, (byte)bytes[bytes_index++], (byte)bytes[bytes_index++]))) ? c1 : 65533;
                        chars[chars_index++] = c22;
                        break;
                    }
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c1;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 4;
                    break block5;
                }
                default: {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = 65533;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break block5;
                }
            }
        }
        b2 = chars_index - chars_offset;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.utf8BytesToJavaChars(bytes[],  int[] nbytesArr, chars[]): returned " + b2));
        }
        return b2;
    }

    private static int stringUTF8Length(char[] chars) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringUTF8Length(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int utflen = 0;
        int slen = chars.length;
        int i2 = 0;
        while (i2 < slen) {
            char c2 = chars[i2];
            utflen = c2 >= '\u0000' && c2 <= '\u007f' ? ++utflen : (c2 >= '\u0080' && c2 <= '\u07ff' ? (utflen += 2) : (utflen += 3));
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringUTF8Length: return:" + utflen));
        }
        return utflen;
    }

    private static void failUTF8Conv() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)"DBConversion.failUTF8Conv(). Error occurred during the UTF-8 conversion process");
        }
        DBError.check_error((int)37, (Object)"failUTF8Conv");
    }

    private static int stringAL32Length(char[] chars) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringAL32Length(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int utflen = 0;
        int slen = chars.length;
        int i2 = 0;
        while (i2 < slen) {
            char c2 = chars[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                ++utflen;
            } else if (c2 >= '\u0080' && c2 <= '\u07ff') {
                utflen += 2;
            } else if (c2 >= '\ud800' && c2 <= '\udbff') {
                char d2;
                if (++i2 < slen && (d2 = chars[i2]) >= '\udc00' && d2 <= '\udfff') {
                    utflen += 4;
                }
            } else if (c2 < '\udc00' || c2 > '\udfff') {
                utflen += 3;
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringAL32Length: return:" + utflen));
        }
        return utflen;
    }

    public static int al32utf8BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.al32utf8BytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int[] nbytesArr = new int[]{nbytes};
        int ret = DBConversion.al32utf8BytesToJavaChars((byte[])bytes, (int[])nbytesArr, (char[])chars);
        if (nbytesArr[0] > 0) {
            DBConversion.failAL32UTF8Conv();
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)"DBConversion.al32utf8BytesToJavaChars: returns");
        }
        return ret;
    }

    private static int al32utf8BytesToJavaChars(byte[] bytes, int[] nbytesArr, char[] chars) throws SQLException {
        int w;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.al32utf8BytesToJavaChars(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", int[] nbytesArr, " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int[] countArr = nbytesArr;
        int offsetBytes = 0;
        int offsetChars = 0;
        int count = countArr[0];
        countArr[0] = 0;
        int bytes_index = offsetBytes;
        int bytes_end = offsetBytes + count;
        int chars_index = offsetChars;
        int charsLength = chars.length;
        block6: while (bytes_index < bytes_end) {
            byte c2 = bytes[bytes_index++];
            int b2 = c2 & 0xF0;
            switch (b2 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = (char)(c2 & 0xFFFFFFFF);
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break block6;
                }
                case 12: 
                case 13: {
                    if (bytes_index >= bytes_end) {
                        countArr[0] = 1;
                        break block6;
                    }
                    char c22 = DBConversion.conv2ByteUTFtoUTF16((byte)c2, (byte)bytes[bytes_index++]);
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c22;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 3;
                    break block6;
                }
                case 14: {
                    if (bytes_index + 1 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        break block6;
                    }
                    char c22 = DBConversion.conv3ByteAL32UTF8toUTF16((byte)c2, (byte)bytes[bytes_index++], (byte)bytes[bytes_index++]);
                    if (chars_index < charsLength) {
                        chars[chars_index++] = c22;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 4;
                    break block6;
                }
                case 15: {
                    if (bytes_index + 2 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        break block6;
                    }
                    if (chars_index > charsLength - 2) {
                        countArr[0] = bytes_end - bytes_index + 2;
                        break block6;
                    }
                    if ((w = DBConversion.conv4ByteAL32UTF8toUTF16((byte)c2, (byte)bytes[bytes_index++], (byte)bytes[bytes_index++], (byte)bytes[bytes_index++], (char[])chars, (int)chars_index)) == 1) {
                        ++chars_index;
                        break;
                    }
                    chars_index += 2;
                    break;
                }
                default: {
                    if (chars_index < charsLength) {
                        chars[chars_index++] = 65533;
                        break;
                    }
                    countArr[0] = bytes_end - bytes_index + 2;
                    break block6;
                }
            }
        }
        w = chars_index - offsetChars;
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.al32utf8BytesToJavaChars(bytes[],  int[] nbytesArr, chars[]): returned " + w));
        }
        return w;
    }

    private static String al32utf8BytesToString(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.al32utf8BytesToString(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        char[] chars = new char[nbytes];
        int str_len = DBConversion.al32utf8BytesToJavaChars((byte[])bytes, (int)nbytes, (char[])chars);
        return new String(chars, 0, str_len);
    }

    private static byte[] stringToAL32UTF8Bytes(String str) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAL32UTF8Bytes(" + str + ")"));
        }
        int len = str.length();
        char[] chararr = new char[len];
        str.getChars(0, len, chararr, 0);
        byte[] bigbytearr = new byte[4 * len];
        int nbBytes = 0;
        try {
            nbBytes = DBConversion.javaCharsToAL32UTF8Bytes((char[])chararr, (int)0, (int)len, (byte[])bigbytearr, (int)0);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        byte[] bytearr = new byte[nbBytes];
        System.arraycopy(bigbytearr, 0, bytearr, 0, nbBytes);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.stringToAL32UTF8Bytes(): return: " + OracleLog.bytesToPrintableForm("bytes[]=", bytearr)));
        }
        return bytearr;
    }

    private static int javaCharsToAL32UTF8Bytes(char[] chars, int chars_offset, int chars_count, byte[] bytes, int bytes_begin) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToAL32UTF8Bytes(chars, chars_offset=" + chars_offset + ", " + "chars_count=" + chars_count + ", " + "bytes, " + "bytes_begin=" + bytes_begin + ")"));
        }
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        if (chars_begin < 0) {
            chars_begin = 0;
        }
        if (chars_end > chars.length) {
            chars_end = chars.length;
        }
        if (bytes_begin < 0) {
            bytes_begin = 0;
        }
        if (bytes_begin >= bytes.length) {
            DBConversion.failAL32UTF8Conv();
        }
        int byte_index = bytes_begin;
        int i2 = chars_begin;
        while (i2 < chars_end) {
            char c2 = chars[i2];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                bytes[byte_index++] = (byte)c2;
                if (byte_index >= bytes.length) {
                    DBConversion.failAL32UTF8Conv();
                }
            } else if (c2 >= '\ud800' && c2 <= '\udbff') {
                char c22;
                if (i2 + 1 < chars_end && (c22 = chars[i2 + 1]) >= '\udc00' & c22 <= '\udfff') {
                    int uuuuu = (c2 >> 6 & 0xF) + 1;
                    if (byte_index + 3 >= bytes.length) {
                        DBConversion.failAL32UTF8Conv();
                    }
                    bytes[byte_index++] = (byte)(uuuuu >> 2 & 2 | 0xF0);
                    bytes[byte_index++] = (byte)((uuuuu & 3) << 4 | c2 >> 2 & 0xF | 0x80);
                    bytes[byte_index++] = (byte)((c2 & 3) << 4 | c22 >> 6 & 0xF | 0x80);
                    bytes[byte_index++] = (byte)(c22 & 0x3F | 0x80);
                    ++i2;
                }
            } else if (c2 > '\u07ff') {
                if (byte_index + 2 >= bytes.length) {
                    DBConversion.failAL32UTF8Conv();
                }
                bytes[byte_index++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                bytes[byte_index++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[byte_index++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            } else {
                if (byte_index + 1 >= bytes.length) {
                    DBConversion.failAL32UTF8Conv();
                }
                bytes[byte_index++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                bytes[byte_index++] = (byte)(0x80 | c2 >> 0 & 0x3F);
            }
            ++i2;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.javaCharsToAL32UTF8Bytes: return: " + byte_index));
        }
        return byte_index;
    }

    private static void failAL32UTF8Conv() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)"DBConversion.failAL32UTF8Conv(). Error occurredduring the AL32UTF8 conversion process");
        }
        DBError.check_error((int)55, (Object)"failAL32UTF8Conv");
    }

    public static byte[] BigDecimalToNumberBytes(BigDecimal num) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.BigDecimalToNumberBytes(" + num + ")"));
        }
        if (num == null) {
            return null;
        }
        return NUMBER.toBytes(num);
    }

    public static BigDecimal NumberBytesToBigDecimal(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToBigDecimal(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toBigDecimal(bytes);
    }

    public static byte NumberBytesToByte(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToByte(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toByte(bytes);
    }

    public static byte[] ByteToNumberBytes(byte x) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ByteToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static short NumberBytesToShort(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToShort(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toShort(bytes);
    }

    public static byte[] ShortToNumberBytes(short x) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.ShortToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static int NumberBytesToInt(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToInt(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toInt(bytes);
    }

    public static byte[] IntToNumberBytes(int x) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.IntToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static long NumberBytesToLong(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToLong(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toLong(bytes);
    }

    public static byte[] LongToNumberBytes(long x) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.LongToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static float NumberBytesToFloat(byte[] bytes, int nbytes) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToFloat(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toFloat(bytes);
    }

    public static byte[] FloatToNumberBytes(float x) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.FloatToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static double NumberBytesToDouble(byte[] bytes, int nbytes) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToDouble(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toDouble(bytes);
    }

    public static byte[] DoubleToNumberBytes(double x) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.DoubleToNumberBytes(" + x + ")"));
        }
        return NUMBER.toBytes(x);
    }

    public static byte[] BooleanToNumberBytes(boolean b2) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.BooleanToNumberBytes(" + b2 + ")"));
        }
        return NUMBER.toBytes(b2);
    }

    public static boolean NumberBytesToBoolean(byte[] bytes, int nbytes) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.NumberBytesToBoolean(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + ")"));
        }
        return NUMBER.toBoolean(bytes);
    }

    public Date DateBytesToDate(byte[] array, int dataSize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.DateBytesToDate(" + OracleLog.bytesToPrintableForm("array[]=", array) + ", dataSize=" + dataSize + ")"));
        }
        return DATE.toDate(array);
    }

    public byte[] DateToDateBytes(Date x) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.DateToDateBytes(" + x + ")"));
        }
        return DATE.toBytes(x);
    }

    public Time DateBytesToTime(byte[] array, int dataSize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.DateBytesToTime(" + OracleLog.bytesToPrintableForm("array[]=", array) + ", dataSize=" + dataSize + ")"));
        }
        return DATE.toTime(array);
    }

    public byte[] TimeToDateBytes(Time x) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.TimeToDateBytes(" + x + ")"));
        }
        return DATE.toBytes(x);
    }

    public Timestamp DateBytesToTimestamp(byte[] array, int dataSize) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.DateBytesToTimestamp(" + OracleLog.bytesToPrintableForm("array[]=", array) + ", dataSize=" + dataSize + ")"));
        }
        return DATE.toTimestamp(array);
    }

    public byte[] TimestampToDateBytes(Timestamp x) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.TimestampToDateBytes(" + x + ")"));
        }
        return DATE.toBytes(x);
    }

    public static boolean isCharSetMultibyte(short charSet) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.isCharSetMultibyte(" + charSet + ")"));
        }
        switch (charSet) {
            case 1: 
            case 31: {
                return false;
            }
            case -5: 
            case -1: 
            case 870: 
            case 871: 
            case 873: {
                return true;
            }
        }
        return false;
    }

    public static int requestLength(int final_length, int conversion) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.requestLength(final_length=" + final_length + ", conversion=" + conversion + ")"));
        }
        switch (conversion) {
            case 0: {
                return final_length;
            }
            case 1: {
                return final_length / 2;
            }
            case 5: {
                return final_length;
            }
            case 4: {
                return final_length * 2;
            }
            case 2: {
                return final_length / 2;
            }
            case 3: {
                return final_length / 4;
            }
        }
        return final_length;
    }

    public int getMaxCharbyteSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)"DBConversion.getMaxCharbyteSize()");
        }
        return this._getMaxCharbyteSize(this.m_charSet);
    }

    public int getMaxNCharbyteSize() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)"DBConversion.getMaxNCharbyteSize()");
        }
        return this._getMaxCharbyteSize(this.m_dbNCharSet);
    }

    public int _getMaxCharbyteSize(short cs) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion._getMaxCharbyteSize(" + cs + ")"));
        }
        switch (cs) {
            case 1: {
                return 1;
            }
            case 31: {
                return 1;
            }
            case 870: 
            case 871: {
                return 3;
            }
            case -5: 
            case 2000: {
                return 2;
            }
            case -1: {
                return 4;
            }
            case 873: {
                return 4;
            }
        }
        return 1;
    }

    public boolean isUcs2CharSet() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)"DBConversion.isUcs2CharSet()");
            OracleLog.print((Object)this, (int)4, (int)32, (String)("DBConversion.isUcs2CharSet(): m_charSet=" + this.m_charSet));
        }
        return this.m_charSet == -5;
    }

    public static int RAWBytesToHexChars(byte[] bytes, int nbytes, char[] chars) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.RAWBytesToHexChars(" + OracleLog.bytesToPrintableForm("bytes[]", bytes) + ", nbytes=" + nbytes + ", " + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + ")"));
        }
        int byte_i = 0;
        int char_i = 0;
        while (byte_i < nbytes) {
            chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] >> 4 & 0xF));
            chars[char_i++] = (char)RepConversion.nibbleToHex((byte)(bytes[byte_i] & 0xF));
            ++byte_i;
        }
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.RAWBytesToHexChars(bytes[], nbytes, chars[]): returned " + char_i));
        }
        return char_i;
    }

    public InputStream ConvertStream(InputStream stream, int conversion) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertStream(stream=" + stream + ", conversion=" + conversion + ")"));
        }
        return new OracleConversionInputStream(this, stream, conversion);
    }

    public InputStream ConvertStream(InputStream stream, int conversion, int max_bytes) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertStream(stream=" + stream + ", conversion=" + conversion + ", max_bytes=" + max_bytes + ")"));
        }
        return new OracleConversionInputStream(this, stream, conversion, max_bytes);
    }

    public InputStream ConvertStream(Reader stream, int conversion, int max_chars) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertStream(stream=" + stream + ", conversion=" + conversion + ", max_chars=" + max_chars + ")"));
        }
        return new OracleConversionInputStream(this, stream, conversion, max_chars);
    }

    public InputStream ConvertStream(Reader stream, int conversion, int max_chars, short form_of_use) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertStream(stream=" + stream + ", conversion=" + conversion + ", max_chars=" + max_chars + ", form_of_use=" + form_of_use + ")"));
        }
        OracleConversionInputStream ocis = new OracleConversionInputStream(this, stream, conversion, max_chars);
        ocis.setFormOfUse(form_of_use);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertStream(stream, conversion, max_chars, form_of_use): returned " + ocis));
        }
        return ocis;
    }

    public Reader ConvertCharacterStream(InputStream stream, int conversion) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertCharacterStream(stream=" + stream + ", conversion=" + conversion + ")"));
        }
        return new OracleConversionReader(this, stream, conversion);
    }

    public Reader ConvertCharacterStream(InputStream stream, int conversion, short form_of_use) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertCharacterStream(stream=" + stream + ", conversion=" + conversion + ", form_of_use=" + form_of_use + ")"));
        }
        OracleConversionReader ocr = new OracleConversionReader(this, stream, conversion);
        ocr.setFormOfUse(form_of_use);
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)4, (int)16, (String)("DBConversion.ConvertCharacterStream(stream, conversion, form_of_use): returned " + ocr));
        }
        return ocr;
    }

    protected static void unexpectedCharset(short charSet) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)2, (String)("DBConversion.unexpectedCharset(" + charSet + ")"));
        }
        DBError.check_error((int)35, (Object)"DBConversion");
    }

    protected static void catchBytesLen(byte[] bytes, int nbytes) throws SQLException {
        if (nbytes > bytes.length) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)4, (int)2, (String)("DBConversion.catchBytesLen(" + OracleLog.bytesToPrintableForm("bytes[]=", bytes) + ", nbytes=" + nbytes + "): " + "Invalid byte array length of " + bytes.length + "(expected " + nbytes + ")"));
            }
            DBError.check_error((int)39, (Object)"catchBytesLen");
        }
    }

    protected static void catchCharsLen(char[] chars, int nchars) throws SQLException {
        if (nchars > chars.length) {
            if (OracleLog.TRACE) {
                OracleLog.print(null, (int)4, (int)2, (String)("DBConversion.catchCharsLen(" + OracleLog.bytesToPrintableForm("chars[]=", OracleLog.charsToUcs2Bytes(chars)) + "Invalid char array length of " + chars.length + "(expected " + nchars + ")"));
            }
            DBError.check_error((int)39, (Object)"catchCharsLen");
        }
    }

    public static int getUtfLen(char c2) {
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.getUtfLen(" + c2 + ")"));
        }
        int utf_len = 0;
        utf_len = (c2 & 0xFF80) == 0 ? 1 : ((c2 & 0xF800) == 0 ? 2 : 3);
        if (OracleLog.TRACE) {
            OracleLog.print(null, (int)4, (int)16, (String)("DBConversion.getUtfLen(c): returned " + utf_len));
        }
        return utf_len;
    }

    static final boolean isHiSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\ud800';
    }

    static final boolean isLoSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\udc00';
    }

    static final boolean check80toBF(byte b2) {
        return (b2 & 0xFFFFFFC0) == -128;
    }

    static final boolean check80to8F(byte b2) {
        return (b2 & 0xFFFFFFF0) == -128;
    }

    static final boolean check80to9F(byte b2) {
        return (b2 & 0xFFFFFFE0) == -128;
    }

    static final boolean checkA0toBF(byte b2) {
        return (b2 & 0xFFFFFFE0) == -96;
    }

    static final boolean check90toBF(byte b2) {
        return (b2 & 0xFFFFFFC0) == -128 && (b2 & 0x30) != 0;
    }

    static final char conv2ByteUTFtoUTF16(byte c2, byte c22) {
        if (c2 < -62 || c2 > -33 || !DBConversion.check80toBF((byte)c22)) {
            return '\ufffd';
        }
        return (char)((c2 & 0x1F) << 6 | c22 & 0x3F);
    }

    static final char conv3ByteUTFtoUTF16(byte c2, byte c22, byte c3) {
        if (!(c2 == -32 && DBConversion.checkA0toBF((byte)c22) && DBConversion.check80toBF((byte)c3) || c2 >= -31 && c2 <= -17 && DBConversion.check80toBF((byte)c22) && DBConversion.check80toBF((byte)c3))) {
            return '\ufffd';
        }
        return (char)((c2 & 0xF) << 12 | (c22 & 0x3F) << 6 | c3 & 0x3F);
    }

    static final char conv3ByteAL32UTF8toUTF16(byte c2, byte c22, byte c3) {
        if (!(c2 == -32 && DBConversion.checkA0toBF((byte)c22) && DBConversion.check80toBF((byte)c3) || c2 >= -31 && c2 <= -20 && DBConversion.check80toBF((byte)c22) && DBConversion.check80toBF((byte)c3) || c2 == -19 && DBConversion.check80to9F((byte)c22) && DBConversion.check80toBF((byte)c3) || c2 >= -18 && c2 <= -17 && DBConversion.check80toBF((byte)c22) && DBConversion.check80toBF((byte)c3))) {
            return '\ufffd';
        }
        return (char)((c2 & 0xF) << 12 | (c22 & 0x3F) << 6 | c3 & 0x3F);
    }

    static final int conv4ByteAL32UTF8toUTF16(byte c2, byte c22, byte c3, byte c4, char[] chars, int cpos) {
        boolean chars_count = false;
        if (!(c2 == -16 && DBConversion.check90toBF((byte)c22) && DBConversion.check80toBF((byte)c3) && DBConversion.check80toBF((byte)c4) || c2 >= -15 && c2 <= -13 && DBConversion.check80toBF((byte)c22) && DBConversion.check80toBF((byte)c3) && DBConversion.check80toBF((byte)c4) || c2 == -12 && DBConversion.check80to8F((byte)c22) && DBConversion.check80toBF((byte)c3) && DBConversion.check80toBF((byte)c4))) {
            chars[cpos] = 65533;
            return 1;
        }
        chars[cpos] = (char)((((c2 & 7) << 2 | (c22 >>> 4 & 3) - 1) & 0xF) << 6 | (c22 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
        chars[cpos + 1] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
        return 2;
    }

    static {
        UTF16_REPLACEMENT_CHAR = (char)65533;
        DBCS_CHARSET = (short)-1;
        UCS2_CHARSET = (short)-5;
        ASCII_CHARSET = 1;
        ISO_LATIN_1_CHARSET = (short)31;
        AL24UTFFSS_CHARSET = (short)870;
        UTF8_CHARSET = (short)871;
        AL32UTF8_CHARSET = (short)873;
        AL16UTF16_CHARSET = (short)2000;
    }
}

