/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;

public class DBColumn {
    public String name;
    public int type;
    public int max_length;
    public boolean nullable;
    public int precision;
    public int scale;
    public int flags;
    public int contflag;
    public int total_elems;
    public short FormOfUse;
    public OracleType otype;

    public DBColumn() {
    }

    public void setDBColumnForV8(byte[] toid, int vsn, int csi, short csfrm, String sql_name) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBColumn.setDBColumnForV8(" + OracleLog.bytesToPrintableForm("byte[] toid=", toid) + ", vsn=" + vsn + ", csi=" + csi + ", csfrm=" + csfrm + ", sql_name=" + sql_name + ")"));
        }
        this.FormOfUse = csfrm;
        this.otype = new OracleTypeADT(toid, vsn, csi, csfrm, sql_name);
    }

    public DBColumn(String name, boolean nullable, int type, int flags, int precision, int scale, int max_len, int total_elems, int contflag) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBColumn.DBColumn(name=" + name + ", nullable=" + nullable + ", type=" + type + ", flags=" + flags + ", precision=" + precision + ", scale=" + scale + ", max_len=" + max_len + ", total_elems-" + total_elems + ", contflag=" + contflag + ")"));
        }
        this.name = name;
        this.nullable = nullable;
        this.type = type;
        this.max_length = max_len;
        this.precision = precision;
        this.scale = scale;
        this.contflag = contflag;
        this.total_elems = total_elems;
        this.flags = flags;
    }

    public String getColumnName() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBColumn.getColumnName(): returned " + this.name));
        }
        return this.name;
    }
}

