/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.dbaccess;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import oracle.gss.util.NLSLocale;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.dbaccess.DBColumn;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBDataSetImpl;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBItem;
import oracle.jdbc.dbaccess.DBStatement;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TypeDescriptor;

public abstract class DBAccess {
    public static final short ORACLE8_PROD_VERSION = 8030;
    public static final short ORACLE81_PROD_VERSION = 8100;
    public static final byte IS_UNINITIALIZED = -1;
    public static final byte IS_SELECT = 0;
    public static final byte IS_PLSQL_BLOCK = 1;
    public static final byte IS_DML = 2;
    public static final byte IS_CALL_BLOCK = 3;
    public static final byte IS_OTHER = 4;
    public static final byte BIND_IN = 1;
    public static final byte BIND_OUT = 16;
    protected SQLWarning connectionWarning = null;
    protected SQLWarning statementWarning = null;

    public abstract DBConversion logon(String var1, String var2, String var3, Properties var4) throws SQLException, IOException;

    public abstract void logoff() throws SQLException, IOException;

    public abstract void commit() throws SQLException, IOException;

    public abstract void rollback() throws SQLException, IOException;

    public abstract void setAutoCommit(boolean var1) throws SQLException, IOException;

    public abstract DBStatement open() throws SQLException, IOException;

    public abstract void closeQuery(DBStatement var1) throws SQLException, IOException;

    public abstract void close(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] describe(DBStatement var1) throws SQLException, IOException;

    public abstract DBColumn[] parseExecuteDescribe(DBStatement var1, byte[] var2, DBDataSet var3) throws SQLException, IOException;

    public abstract int executeFetch(DBStatement var1, byte var2, DBDataSet var3, int var4, DBDataSet var5, int var6) throws SQLException, IOException;

    public int executeFetchNeedDefines(DBStatement dbstmt, byte type, DBDataSet in_dataset, int batch, DBDataSet out_dataset, int rows) throws SQLException, IOException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.executeFetchNeedDefines(dbstmt=" + dbstmt + ", type=" + type + ", in_dataset=" + in_dataset + ", batch=" + batch + ", out_dataset=" + out_dataset + ", rows=" + rows + ")"));
        }
        return this.executeFetch(dbstmt, type, in_dataset, batch, out_dataset, rows);
    }

    public abstract int parseExecuteFetch(DBStatement var1, byte var2, byte[] var3, DBDataSet var4, int var5, DBDataSet var6, int var7) throws SQLException, IOException;

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3) throws SQLException, IOException;

    public abstract int read(DBStatement var1, byte[] var2, int var3) throws SQLException, IOException;

    public int read(DBStatement dbstmt, byte[] buffer, int length, int colIndex) throws SQLException, IOException {
        return this.read(dbstmt, buffer, length);
    }

    public abstract byte[] getVersion() throws SQLException, IOException;

    public abstract short getVersionNumber() throws SQLException;

    public abstract int getDefaultPrefetch();

    public abstract int getDefaultStreamChunkSize();

    public abstract void cancel() throws SQLException, IOException;

    public DBStatement RefCursorBytesToDBStatement(DBStatement dbstmt, byte[] array) throws SQLException, IOException {
        return this.RefCursorBytesToDBStatement(array);
    }

    public abstract DBStatement RefCursorBytesToDBStatement(byte[] var1) throws SQLException, IOException;

    public abstract byte[] DBStatementToRefCursorBytes(DBStatement var1) throws SQLException, IOException;

    public void startup(String startup_str, int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.startup(startup_str=" + startup_str + ", mode=" + mode + ")"));
        }
        DBError.check_error((int)66, (Object)"startup");
    }

    public void shutdown(int mode) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.shutdown(" + mode + ")"));
        }
        DBError.check_error((int)66, (Object)"shutdown");
    }

    public void archive(int mode, int aseq, String acstext) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.archive(mode=" + mode + ", aseq=" + aseq + ", acstext=" + acstext + ")"));
        }
        DBError.check_error((int)66, (Object)"archive");
    }

    public void getOracleTypeADT(OracleTypeADT otype) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getOracleTypeADT(" + otype + ")"));
        }
    }

    public DBDataSet createDBDataSet(OracleConnection conn, OracleStatement stmt, int batchSize, int dataSetType) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.createDBDataSet(conn=" + conn + ", stmt=" + stmt + ", batchSize=" + batchSize + ", dataSetType=" + dataSetType + ")"));
        }
        return new DBDataSetImpl(conn, stmt, batchSize, dataSetType);
    }

    public abstract DBType createDBType(int var1, boolean var2) throws SQLException;

    public DBType createDBType(int type, boolean isInBind, boolean isPlsql) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)1, (String)("DBAccess.createDBType(type=" + type + ", isInBind=" + isInBind + ", isPlsql=" + isPlsql + ")"));
        }
        return this.createDBType(type, true);
    }

    public DBType createDBType(int type, boolean isInBind, short formOfUseField) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)1, (String)("DBAccess.createDBType(type=" + type + ", isInBind=" + isInBind + ", formOfUseField=" + formOfUseField + ")"));
        }
        return this.createDBType(type, true);
    }

    public abstract DBItem createDBItem(DBType var1) throws SQLException;

    public abstract int fetch(DBStatement var1, DBDataSet var2, int var3, int var4) throws SQLException, IOException;

    public long lobWrite(BLOB blob, long offset, byte[] buffer, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobWrite(oracle.sql.BLOB blob, " + offset + ", byte[] buffer, " + length + ")"));
            OracleLog.print((Object)this, (int)2, (int)32, (String)("DBAccess.lobWrite(blob=" + blob + ", offset=" + offset + ", " + OracleLog.bytesToPrintableForm("buffer[]=", buffer) + ", length=" + length + ")"));
        }
        return LobPlsqlUtil.plsql_write((BLOB)blob, (long)offset, (byte[])buffer, (int)length);
    }

    public long lobWrite(CLOB clob, long offset, char[] buffer, int length) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobWrite(oracle.sql.CLOB clob, " + offset + ", char[] buffer, " + length + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.lobWrite(clob=" + clob + ", offset=" + offset + ", " + OracleLog.bytesToPrintableForm("buffer[]=", OracleLog.charsToUcs2Bytes(buffer)) + ", length=" + length + ")"));
        }
        return LobPlsqlUtil.plsql_write((CLOB)clob, (long)offset, (char[])buffer, (int)length);
    }

    public long lobRead(BLOB blob, long offset, long amount, byte[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobRead(oracle.sql.BLOB blob, offset=" + offset + ", amount=" + amount + ", byte[] buffer)"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.lobRead(blob=" + blob + ", offset, amount, " + OracleLog.bytesToPrintableForm("byte[] buffer=", buffer) + ")"));
        }
        return LobPlsqlUtil.plsql_read((BLOB)blob, (long)offset, (long)amount, (byte[])buffer);
    }

    public long lobRead(BFILE bfile, long offset, long amount, byte[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobRead(oracle.sql.BFILE bfile, offset=" + offset + ", amount=" + amount + ", byte[] buffer)"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.lobRead(bfile=" + bfile + ", offset, amount, " + OracleLog.bytesToPrintableForm("byte[] buffer=", buffer) + ")"));
        }
        return LobPlsqlUtil.plsql_read((BFILE)bfile, (long)offset, (long)amount, (byte[])buffer);
    }

    public long lobRead(CLOB clob, long offset, long amount, char[] buffer) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobRead(oracle.sql.CLOB clob, offset=" + offset + ", amount=" + amount + ", char[] buffer)"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.lobRead(clob=" + clob + ", offset, amount, " + OracleLog.bytesToPrintableForm("buffer[]=", OracleLog.charsToUcs2Bytes(buffer)) + ")"));
        }
        return LobPlsqlUtil.plsql_read((CLOB)clob, (long)offset, (long)amount, (char[])buffer);
    }

    public long lobLength(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobLength(" + blob + ")"));
        }
        return LobPlsqlUtil.plsql_length((BLOB)blob);
    }

    public long lobLength(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobLength(" + bfile + ")"));
        }
        return LobPlsqlUtil.plsql_length((BFILE)bfile);
    }

    public long lobLength(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.lobLength(" + clob + ")"));
        }
        return LobPlsqlUtil.plsql_length((CLOB)clob);
    }

    public long hasPattern(BLOB blob, byte[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.hasPattern(oracle.sql.BLOB blob, byte [] pattern, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.hasPattern(blob=" + blob + ", " + OracleLog.bytesToPrintableForm("pattern[]=", pattern) + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_hasPattern((BLOB)blob, (byte[])pattern, (long)startPos);
    }

    public long hasPattern(CLOB clob, char[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.hasPattern(oracle.sql.CLOB clob, char [] pattern, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.hasPattern(clob=" + clob + ", " + OracleLog.bytesToPrintableForm("pattern[]=", OracleLog.charsToUcs2Bytes(pattern)) + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_hasPattern((CLOB)clob, (char[])pattern, (long)startPos);
    }

    public long hasPattern(BFILE bfile, byte[] pattern, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.hasPattern(oracle.sql.BFILE bfile, , byte[] pattern, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.hasPattern(bfile=" + bfile + OracleLog.bytesToPrintableForm("byte [] pattern=", pattern) + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_hasPattern((BFILE)bfile, (byte[])pattern, (long)startPos);
    }

    public long isSubLob(BLOB blob, BLOB subBlob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.isSubLob(oracle.sql.BLOB blob, oracle.sql.BLOB subBlob, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.isSubLob(blob=" + blob + ", subBlob=" + subBlob + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_isSubLob((BLOB)blob, (BLOB)subBlob, (long)startPos);
    }

    public long isSubLob(CLOB clob, CLOB subClob, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.isSubLob(oracle.sql.CLOB clob, oracle.sql.CLOB subClob, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.isSubLob(clob=" + clob + ", subClob=" + subClob + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_isSubLob((CLOB)clob, (CLOB)subClob, (long)startPos);
    }

    public long isSubLob(BFILE bfile, BFILE subBfile, long startPos) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.isSubLob(oracle.sql.BFILE bfile, oracle.sql.BFILE subBfile, startPos=" + startPos + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.isSubLob(bfile=" + bfile + ", subBfile=" + subBfile + ", startPos=" + startPos + ")"));
        }
        return LobPlsqlUtil.plsql_isSubLob((BFILE)bfile, (BFILE)subBfile, (long)startPos);
    }

    public void fileOpen(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileOpen(" + bfile + ")"));
        }
        LobPlsqlUtil.plsql_fileOpen((BFILE)bfile);
    }

    public boolean fileIsOpen(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileIsOpen(" + bfile + ")"));
        }
        return LobPlsqlUtil.plsql_fileIsOpen((BFILE)bfile);
    }

    public boolean fileExists(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileExists(" + bfile + ")"));
        }
        return LobPlsqlUtil.plsql_fileExists((BFILE)bfile);
    }

    public String fileGetName(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileGetName(" + bfile + ")"));
        }
        return LobPlsqlUtil.plsql_fileGetName((BFILE)bfile);
    }

    public String fileGetDirAlias(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileGetDirAlias(" + bfile + ")"));
        }
        return LobPlsqlUtil.plsql_fileGetDirAlias((BFILE)bfile);
    }

    public void fileClose(BFILE bfile) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.fileClose(" + bfile + ")"));
        }
        LobPlsqlUtil.plsql_fileClose((BFILE)bfile);
    }

    public long getLobChunkSize(BLOB blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getLobChunkSize(" + blob + ")"));
        }
        return LobPlsqlUtil.plsql_getChunkSize((BLOB)blob);
    }

    public long getLobChunkSize(CLOB clob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getLobChunkSize(" + clob + ")"));
        }
        return LobPlsqlUtil.plsql_getChunkSize((CLOB)clob);
    }

    public void trimLob(Connection conn, Datum lob, int type, long newlen) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.trimLob(Connection conn, oracle.sql.Datum lob, type=" + type + ", newlen=" + newlen + ")"));
            OracleLog.print((Object)this, (int)2, (int)64, (String)("DBAccess.trimLob(conn=" + conn + ", lob=" + lob + ", type=" + type + ", newlen=" + newlen + ")"));
        }
        LobPlsqlUtil.plsql_trimLob((Connection)conn, (Datum)lob, (int)type, (long)newlen);
    }

    public Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type) throws SQLException {
        return this.createTemporaryLob(conn, cache, duration, type, (short)1);
    }

    public Datum createTemporaryLob(Connection conn, boolean cache, int duration, int type, short form) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.createTemporaryLob(conn=" + conn + ", cache=" + cache + ", duration=" + duration + ", type=" + type + ", form=" + form + ")"));
        }
        return LobPlsqlUtil.plsql_createTemporaryLob((Connection)conn, (boolean)cache, (int)duration, (int)type, (short)form);
    }

    public void freeTemporaryLob(Connection conn, Datum temp_lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.freeTemporaryLob(conn=" + conn + ", temp_lob=" + temp_lob + ", type=" + type + ")"));
        }
        LobPlsqlUtil.plsql_freeTemporaryLob((Connection)conn, (Datum)temp_lob, (int)type);
    }

    public boolean isTemporaryLob(Connection conn, Datum lob, int type) throws SQLException {
        byte[] locator;
        boolean result = false;
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.isTemporaryLob(conn=" + conn + ", lob=" + lob + ", type=" + type + ")"));
        }
        if (((locator = lob.shareBytes())[7] & 1) > 0 || (locator[4] & 0x40) > 0) {
            result = true;
        }
        return result;
    }

    public void openLob(Connection conn, Datum lob, int mode, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.openLob(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", mode=" + mode + ", type=" + type + ")"));
        }
        LobPlsqlUtil.plsql_openLob((Connection)conn, (Datum)lob, (int)mode, (int)type);
    }

    public void closeLob(Connection conn, Datum lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.closeLob(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", type=" + type + ")"));
        }
        LobPlsqlUtil.plsql_closeLob((Connection)conn, (Datum)lob, (int)type);
    }

    public boolean isLobOpen(Connection conn, Datum lob, int type) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.isLobOpen(conn=" + conn + ", oracle.sql.Datum lob=" + lob + ", type=" + type + ")"));
        }
        return LobPlsqlUtil.plsql_isLobOpen((Connection)conn, (Datum)lob, (int)type);
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getDBAccessProperties()");
        }
        DBError.throwSqlException((int)66, (Object)"getDBAccessProperties");
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getDBAccessProperties(): returned null");
        }
        return null;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getConnectionPoolInfo()");
        }
        DBError.throwSqlException((int)66, (Object)"getConnectionPoolInfo");
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getConnectionPoolInfo(): returned null");
        }
        return null;
    }

    public void setConnectionPoolInfo(Properties info) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setConnectionPoolInfo(" + info + ")"));
        }
        DBError.throwSqlException((int)66, (Object)"setConnectionPoolInfo");
    }

    public int getNlsRatio() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getNlsRatio(): returned 1");
        }
        return 1;
    }

    public int getC2SNlsRatio() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getC2SNlsRatio(): returned 1");
        }
        return 1;
    }

    public void initNls(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.initNls(" + conn + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setNlsParamsClient(OracleConnection conn) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setNlsParamsClient(" + conn + ")"));
        }
        Statement stmt = null;
        Object rset = null;
        Object date_format = null;
        boolean isSessionTZ = this.getVersionNumber() >= 8100;
        TimeZone tz = TimeZone.getDefault();
        int l_rawOffset = tz.getRawOffset();
        int hr = l_rawOffset / 3600000;
        int mi = l_rawOffset / 60000 % 60;
        if (tz.useDaylightTime() && tz.inDaylightTime(new Date())) {
            hr = hr > 0 ? --hr : ++hr;
        }
        String TZ = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
        try {
            try {
                stmt = conn.createStatement();
                Locale defaultLocale = Locale.getDefault();
                Object nlsDateFormat = null;
                NLSLocale nlslocale = NLSLocale.getInstance();
                stmt.execute("ALTER SESSION SET " + (isSessionTZ ? "TIME_ZONE='" + TZ + "'" : "") + " NLS_LANGUAGE = '" + nlslocale.getNLSLanguage(defaultLocale) + "' NLS_TERRITORY = '" + nlslocale.getNLSTerritory(defaultLocale) + "'");
            }
            catch (SQLException e2) {
                Object var15_16 = null;
                if (stmt == null) return;
                stmt.close();
                return;
            }
            Object var15_15 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (stmt != null) {
                stmt.close();
            }
            stmt = null;
            throw throwable;
        }
        stmt.close();
    }

    public SQLWarning getConnectionWarning() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getConnectionWarning(): returned " + this.connectionWarning));
        }
        return this.connectionWarning;
    }

    public void setConnectionWarning(SQLWarning warn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setStatementWarning( warn =" + warn + " )"));
        }
        this.connectionWarning = warn;
    }

    public SQLWarning getStatementWarning() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getStatementWarning(): returned " + this.statementWarning));
        }
        return this.statementWarning;
    }

    public void setStatementWarning(SQLWarning warn) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setStatementWarning( warn =" + warn + " )"));
        }
        this.statementWarning = warn;
    }

    public int getMinAsciiStreamSize(OracleConnection conn, int min_ascii_stream_size) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getMinAsciiStreamSize(conn=" + conn + ", min_ascii_stream_size=" + min_ascii_stream_size + ")"));
        }
        if (conn.conversion.isUcs2CharSet()) {
            return min_ascii_stream_size / 2;
        }
        return min_ascii_stream_size;
    }

    public void registerTAFCallback(Connection conn, OracleOCIFailover cbk, Object obj) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.registerTAFCallback(conn=" + conn + ", cbk=" + cbk + ", obj=" + obj + ")"));
        }
        DBError.throwSqlException((int)23);
    }

    public TypeDescriptor getAnyDataEmbTypeDesc(DBStatement stmt, DBDataSet dbset, OracleTypeADT otype, int row_index, int col_index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getAnyDataEmbTypeDesc(stmt=" + stmt + ", dbst=" + dbset + ", ridx=" + row_index + ", cidx=" + col_index + ")"));
        }
        DBError.throwSqlException((int)23);
        return null;
    }

    public int getAnyDataEmbDataPos(DBStatement stmt, int row_index, int col_index) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.getAnyDataEmbDataPos(stmt=" + stmt + ", ridx=" + row_index + ", cidx=" + col_index + ")"));
        }
        DBError.throwSqlException((int)23);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearClientIdentifier(OracleConnection conn, String clientId) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.clearClientIdentifier(conn=" + conn + ", clientId=" + clientId + ")"));
        }
        CallableStatement cstmt = null;
        try {
            try {
                cstmt = conn.prepareCall("begin dbms_session.clear_identifier(); end;");
                cstmt.execute();
            }
            catch (SQLException e2) {
                if (!OracleLog.TRACE) throw e2;
                OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.clearClientIdentifier(conn, clientId): \n cstmt=" + cstmt + ", conn=" + conn + ", clentId=" + clientId + ", throw " + e2));
                throw e2;
            }
            Object var6_4 = null;
            if (cstmt == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (cstmt != null) {
                cstmt.close();
            }
            cstmt = null;
            throw throwable;
        }
        cstmt.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClientIdentifier(OracleConnection conn, String clientId) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setClientIdentifier(conn=" + conn + ", clientId=" + clientId + ")"));
        }
        CallableStatement cstmt = null;
        try {
            try {
                cstmt = conn.prepareCall("begin dbms_session.set_identifier(?); end;");
                cstmt.setString(1, clientId);
                cstmt.execute();
            }
            catch (SQLException e2) {
                if (!OracleLog.TRACE) throw e2;
                OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setClientIdentifier(conn, clientId): \n cstmt=" + cstmt + ", conn=" + conn + ", clientId=" + clientId + ". throw " + e2));
                throw e2;
            }
            Object var6_4 = null;
            if (cstmt == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (cstmt != null) {
                cstmt.close();
            }
            cstmt = null;
            throw throwable;
        }
        cstmt.close();
    }

    public void setCreateStatementAsRefCursor(boolean value) {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)("DBAccess.setCreateStatementAsRefCursor(" + value + "): no op"));
        }
    }

    public boolean getCreateStatementAsRefCursor() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getCreateStatementAsRefCursor(): returned false");
        }
        return false;
    }

    public boolean getFetchOnNewRefCursor() {
        if (OracleLog.TRACE) {
            OracleLog.print((Object)this, (int)2, (int)16, (String)"DBAccess.getFetchOnNewRefCursor(): returned true");
        }
        return true;
    }

    public Class classForNameAndSchema(String name, String ignore) throws ClassNotFoundException {
        return Class.forName(name);
    }

    public Class safelyGetClassForName(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
    }

    public int getMaxCharSize() throws SQLException {
        DBError.throwSqlException((int)58);
        return -1;
    }

    public void registerConnection(OracleConnection conn) {
    }

    public String getUserName() throws SQLException {
        return null;
    }

    static {
        ORACLE8_PROD_VERSION = (short)8030;
        ORACLE81_PROD_VERSION = (short)8100;
        IS_UNINITIALIZED = (byte)-1;
        IS_SELECT = 0;
        IS_PLSQL_BLOCK = 1;
        IS_DML = (byte)2;
        IS_CALL_BLOCK = (byte)3;
        IS_OTHER = (byte)4;
        BIND_IN = 1;
        BIND_OUT = (byte)16;
    }
}

