/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.io.Serializable;
import java.util.Locale;
import oracle.gss.util.UnicodeProperty;
import oracle.sql.ConverterArchive;

public class XmlValidate
implements Serializable {
    public static final short PARTIAL_ESCAPE = 0;
    public static final short FULL_ESCAPE = 1;
    private UnicodeProperty UnicodeProp;
    private static final String UNICODEFILE = "/oracle/gss/util/data/unicodeprop.glb";

    public XmlValidate() {
        ConverterArchive converterArchive = new ConverterArchive();
        this.UnicodeProp = (UnicodeProperty)converterArchive.readObj(UNICODEFILE);
    }

    public String SqlToXmlName(String string, short s2) {
        String string2 = new String();
        int n2 = string.length();
        int n3 = 1;
        if (n2 == 0) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == ':') {
            string2 = String.valueOf(string2) + "_x003A_";
        } else if (n2 >= 2 && string.substring(0, 2).equals("_x")) {
            string2 = String.valueOf(string2) + "_x005F_";
        } else if (s2 == 1 && n2 >= 3 && string.substring(0, 3).toUpperCase(Locale.US).equals("XML")) {
            string2 = String.valueOf(string2) + "_xFFFF_" + string.substring(0, 3);
            n3 = 3;
        } else if (c2 >= '\ud800' && c2 < '\udc00') {
            if (n2 > 1) {
                string2 = String.valueOf(string2) + this.hexEscape(c2 << 16 | string.charAt(1) & 0xFFFF);
                n3 = 2;
            } else {
                string2 = String.valueOf(string2) + this.hexEscape(c2);
            }
        } else {
            string2 = this.isFirstNameChar((int)c2) ? String.valueOf(string2) + c2 : String.valueOf(string2) + this.hexEscape(c2);
        }
        int n4 = n3;
        while (n4 < n2) {
            char c3 = string.charAt(n4);
            if (c3 >= '\ud800' && c3 < '\udc00') {
                if (n4 + 1 < n2) {
                    string2 = String.valueOf(string2) + this.hexEscape(c3 << 16 | string.charAt(n4 + 1) & 0xFFFF);
                    ++n4;
                } else {
                    string2 = String.valueOf(string2) + this.hexEscape(c3);
                }
            } else {
                string2 = !this.isNameChar((int)c3) ? String.valueOf(string2) + this.hexEscape(c3) : (c3 == ':' && s2 == 1 ? String.valueOf(string2) + "_x003A_" : String.valueOf(string2) + c3);
            }
            ++n4;
        }
        return string2;
    }

    public String XmlToSqlName(String string) {
        String string2 = new String();
        int n2 = string.length();
        boolean bl = false;
        String string3 = null;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (bl) {
                if (c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9') {
                    string3 = String.valueOf(string3) + c2;
                } else if (c2 == '_') {
                    bl = false;
                    int n4 = string3.length();
                    if (n4 > 4) {
                        char c3 = (char)Integer.parseInt(string3.substring(0, n4 - 4), 16);
                        char c4 = (char)Integer.parseInt(string3.substring(n4 - 4), 16);
                        string2 = String.valueOf(string2) + c3;
                        string2 = String.valueOf(string2) + c4;
                    } else {
                        int n5 = Integer.parseInt(string3, 16);
                        if (n5 != 65535) {
                            string2 = String.valueOf(string2) + (char)n5;
                        }
                    }
                } else {
                    string2 = String.valueOf(string2) + "_x" + string3 + c2;
                    bl = false;
                }
            } else if (c2 == '_' && n3 + 1 < n2 && string.charAt(n3 + 1) == 'x') {
                bl = true;
                string3 = new String();
                ++n3;
            } else {
                string2 = String.valueOf(string2) + c2;
            }
            ++n3;
        }
        return string2;
    }

    private String hexEscape(char c2) {
        String string = Integer.toHexString(c2);
        switch (string.length()) {
            case 1: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
                break;
            }
        }
        return string;
    }

    private String hexEscape(int n2) {
        String string = Integer.toHexString(n2);
        switch (string.length()) {
            case 1: 
            case 5: {
                string = "_x000" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 2: 
            case 6: {
                string = "_x00" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 3: 
            case 7: {
                string = "_x0" + string.toUpperCase(Locale.US) + "_";
                break;
            }
            case 4: 
            case 8: {
                string = "_x" + string.toUpperCase(Locale.US) + "_";
                break;
            }
        }
        return string;
    }

    public boolean isAlphaNum(int n2) {
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return this.isLetter(n2) || s2 == 7 || s2 == 8 || s2 == 9;
    }

    public boolean isBaseChar(int n2) {
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return this.isLetter(n2) || this.isDigit(n2) || s2 == 4 || s2 == 6 || s2 == 5;
    }

    public boolean isChar(int n2) {
        return n2 >= 32 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533 || n2 == 9 || n2 == 10 || n2 == 13 || n2 >= 65536 && n2 <= 0x10FFFF;
    }

    public boolean isCombiningChar(int n2) {
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return !this.isCompatibility(n2) && (s2 == 4 || s2 == 6 || s2 == 5);
    }

    public boolean isCompatibility(int n2) {
        return this.UnicodeProp.isCompatibility(n2);
    }

    public boolean isDigit(int n2) {
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return s2 == 7;
    }

    public boolean isExtender(int n2) {
        return n2 == 183 || n2 == 720 || n2 == 721 || n2 == 903 || n2 == 1600 || n2 == 3654 || n2 == 3782 || n2 == 12293 || n2 >= 12337 && n2 <= 12341 || n2 >= 12445 && n2 <= 12446 || n2 >= 12540 && n2 <= 12542 || n2 == 6211 || n2 == 750;
    }

    public boolean isFirstNameChar(int n2) {
        if (n2 >= 97 && n2 <= 122) {
            return true;
        }
        if (n2 >= 65 && n2 <= 90) {
            return true;
        }
        if (n2 == 95 || n2 == 58) {
            return true;
        }
        if (n2 == 47) {
            return false;
        }
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        switch (s2) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 19: {
                return !this.UnicodeProp.isCompatibility(n2) && (n2 < 8413 || n2 > 8416);
            }
        }
        return n2 >= 699 && n2 <= 705 || n2 == 1369 || n2 == 1765 || n2 == 1766;
    }

    public boolean isIdeographic(int n2) {
        return this.isAlphaNum(n2) || this.isPunctuation(n2);
    }

    public boolean isLetter(int n2) {
        if (n2 >= 97 && n2 <= 122) {
            return true;
        }
        if (n2 >= 65 && n2 <= 90) {
            return true;
        }
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return s2 == 2 || s2 == 1 || s2 == 19 || s2 == 3 || s2 == 8;
    }

    public boolean isNameChar(int n2) {
        if (n2 >= 97 && n2 <= 122) {
            return true;
        }
        if (n2 >= 65 && n2 <= 90) {
            return true;
        }
        if (n2 == 95 || n2 == 46 || n2 == 58 || n2 == 45) {
            return true;
        }
        if (n2 == 47) {
            return false;
        }
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        switch (s2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: {
                return !this.UnicodeProp.isCompatibility(n2) && (n2 < 8413 || n2 > 8416);
            }
        }
        return n2 >= 699 && n2 <= 705 || n2 == 1369 || n2 == 1765 || n2 == 1766;
    }

    public boolean isPunctuation(int n2) {
        short s2 = this.UnicodeProp.getProperties(n2, (short)0);
        return s2 == 20 || s2 == 21 || s2 == 22 || s2 == 23 || s2 == 26;
    }

    public boolean isSpace(int n2) {
        return n2 == 32 || n2 == 9 || n2 == 13 || n2 == 10;
    }
}

