/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterConverter;
import oracle.sql.converter.CharacterConverter12Byte;

public class MultiByte12MapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    int m_ucsReplacement;
    Vector mapStore;
    CharacterConverter12Byte m_charConv;

    MultiByte12MapSetter(int n2, int n3, int n4) {
        super(n2);
        this.mapStore = new Vector();
    }

    MultiByte12MapSetter(CharacterConverter characterConverter, CharacterConverter12Byte characterConverter12Byte, int n2, int n3) throws IOException {
        super(n2);
        this.m_ucsReplacement = n3;
        this.mapStore = new Vector();
        this.m_charConv = characterConverter12Byte;
        if (characterConverter != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverter.extractCodepoints(vector);
            int n4 = 0;
            while (n4 < vector.size()) {
                int[] nArray = (int[])vector.elementAt(n4);
                this.set(nArray[0], nArray[1]);
                ++n4;
            }
        }
    }

    void buildMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7 = 8;
        int n8 = 8;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        int n11 = 1 << n7;
        char[] cArray = new char[n11];
        char[][] cArray2 = new char[n11][2];
        int n12 = 0;
        while (n12 < n11) {
            cArray[n12] = 65535;
            cArray2[n12][0] = (char)n10;
            cArray2[n12][1] = '\u0000';
            ++n12;
        }
        int n13 = this.mapStore.size();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        n12 = 0;
        while (n12 < n13) {
            nArray = (int[])this.mapStore.elementAt(n12);
            n6 = nArray[1];
            if (n6 != -1) {
                n5 = nArray[0];
                if (hashtable.get(new Integer(n6)) == null) {
                    hashtable.put(new Integer(n6), new Integer(n5));
                } else {
                    hashtable2.put(new Integer(n6), hashtable.get(new Integer(n6)));
                }
                n4 = n5 >> n8 & n9;
                cArray[n4] = '\u0001';
                n3 = n5 & n10;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
            }
            ++n12;
        }
        int n14 = n2 = n10 + 1;
        int n15 = 0;
        n12 = 0;
        while (n12 < n11) {
            if (cArray[n12] != '\uffff') {
                int n16 = cArray2[n12][0];
                cArray[n12] = (char)(n14 - (n15 < n16 ? n15 : n16));
                n14 = cArray[n12] + n2;
                n15 = n2 - cArray2[n12][1] - 1;
            }
            ++n12;
        }
        int[] nArray2 = new int[n14];
        n12 = 0;
        while (n12 < n14) {
            nArray2[n12] = -1;
            ++n12;
        }
        n13 = this.mapStore.size();
        n12 = 0;
        while (n12 < n13) {
            nArray = (int[])this.mapStore.elementAt(n12);
            n6 = nArray[1];
            if (n6 != -1) {
                n5 = nArray[0];
                n4 = n5 >> n8 & n9;
                n3 = n5 & n10;
                int n17 = cArray[n4] + n3;
                nArray2[n17] = n6;
            }
            ++n12;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setDuplicateMapping(hashtable2);
    }

    void finish() {
        this.buildMapping();
    }

    boolean set(int n2, int n3) throws IOException {
        if (n2 > 65535) {
            this.printErrorMsg("***** Error: source code point " + MappingSetter.intToHex8((int)n2) + " is too big for 1-2 byte converter");
            return false;
        }
        n3 = (int)CharacterSet.convertUTF32toUTF16((long)n3 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n2, n3};
        this.mapStore.addElement(nArray);
        return true;
    }

    void setArray(char[] cArray) {
        int n2 = cArray.length;
        this.m_charConv.m_ucsCharLevel1 = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_charConv.m_ucsCharLevel1[n3] = cArray[n3];
            ++n3;
        }
    }

    void setArray2(int[] nArray) {
        int n2 = nArray.length;
        this.m_charConv.m_ucsCharLevel2 = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.m_charConv.m_ucsCharLevel2[n3] = nArray[n3];
            ++n3;
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.m_charConv.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            this.m_charConv.extraUnicodeToOracleMapping[n2][0] = (Integer)k2;
            this.m_charConv.extraUnicodeToOracleMapping[n2++][1] = (Integer)hashtable.get(k2);
        }
    }
}

