/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import net.sourceforge.jtds.jdbc.BlobImpl;
import net.sourceforge.jtds.jdbc.ClobImpl;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.DateTime;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.UniqueIdentifier;
import net.sourceforge.jtds.util.Logger;

public class Support {
    private static final Integer INTEGER_ZERO = new Integer(0);
    private static final Integer INTEGER_ONE = new Integer(1);
    private static final Long LONG_ZERO = new Long(0L);
    private static final Long LONG_ONE = new Long(1L);
    private static final Float FLOAT_ZERO = new Float(0.0);
    private static final Float FLOAT_ONE = new Float(1.0);
    private static final Double DOUBLE_ZERO = new Double(0.0);
    private static final Double DOUBLE_ONE = new Double(1.0);
    private static final BigDecimal BIG_DECIMAL_ZERO = new BigDecimal(0.0);
    private static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal(1.0);
    private static final Date DATE_ZERO = new Date(0L);
    private static final Time TIME_ZERO = new Time(0L);
    private static final BigInteger MAX_VALUE_28 = new BigInteger("9999999999999999999999999999");
    private static final BigInteger MAX_VALUE_38 = new BigInteger("99999999999999999999999999999999999999");
    private static final HashMap typeMap = new HashMap();
    private static final char[] hex;
    private static final GregorianCalendar cal;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbc$BlobImpl;
    static /* synthetic */ Class class$net$sourceforge$jtds$jdbc$ClobImpl;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$lang$Throwable;

    public static String toHex(byte[] bytes) {
        int len = bytes.length;
        if (len > 0) {
            StringBuffer buf = new StringBuffer(len * 2);
            int i2 = 0;
            while (i2 < len) {
                int b1 = bytes[i2] & 0xFF;
                buf.append(hex[b1 >> 4]);
                buf.append(hex[b1 & 0xF]);
                ++i2;
            }
            return buf.toString();
        }
        return "";
    }

    static BigDecimal normalizeBigDecimal(BigDecimal value, int maxPrecision) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.scale() < 0) {
            value = value.setScale(0);
        }
        if (value.scale() > maxPrecision) {
            value = value.setScale(maxPrecision, 4);
        }
        BigInteger max = maxPrecision == 28 ? MAX_VALUE_28 : MAX_VALUE_38;
        while (value.abs().unscaledValue().compareTo(max) > 0) {
            int scale = value.scale() - 1;
            if (scale < 0) {
                throw new SQLException(Messages.get("error.normalize.numtoobig", String.valueOf(maxPrecision)), "22000");
            }
            value = value.setScale(scale, 4);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    static Object convert(Object callerReference, Object x, int jdbcType, String charSet) throws SQLException {
        try {
            switch (jdbcType) {
                case -6: 
                case 4: 
                case 5: {
                    if (x == null) {
                        return INTEGER_ZERO;
                    }
                    if (x instanceof Integer) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Integer((int)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Integer(((Number)x).intValue());
                    }
                    if (x instanceof String) {
                        return new Integer(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? INTEGER_ONE : INTEGER_ZERO;
                }
                case -5: {
                    if (x == null) {
                        return LONG_ZERO;
                    }
                    if (x instanceof Long) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Long((long)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Long(((Number)x).longValue());
                    }
                    if (x instanceof String) {
                        return new Long(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? LONG_ONE : LONG_ZERO;
                }
                case 7: {
                    if (x == null) {
                        return FLOAT_ZERO;
                    }
                    if (x instanceof Float) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Float((float)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Float(((Number)x).floatValue());
                    }
                    if (x instanceof String) {
                        return new Float(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? FLOAT_ONE : FLOAT_ZERO;
                }
                case 6: 
                case 8: {
                    if (x == null) {
                        return DOUBLE_ZERO;
                    }
                    if (x instanceof Double) {
                        return x;
                    }
                    if (x instanceof Byte) {
                        return new Double((double)((Byte)x & 0xFF));
                    }
                    if (x instanceof Number) {
                        return new Double(((Number)x).doubleValue());
                    }
                    if (x instanceof String) {
                        return new Double(((String)x).trim());
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? DOUBLE_ONE : DOUBLE_ZERO;
                }
                case 2: 
                case 3: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof BigDecimal) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return new BigDecimal(x.toString());
                    }
                    if (x instanceof String) {
                        return new BigDecimal((String)x);
                    }
                    if (!(x instanceof Boolean)) break;
                    return (Boolean)x != false ? BIG_DECIMAL_ONE : BIG_DECIMAL_ZERO;
                }
                case 1: 
                case 12: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof String) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return x.toString();
                    }
                    if (x instanceof Boolean) {
                        return (Boolean)x != false ? "1" : "0";
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        long length = clob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(Messages.get("error.normalize.lobtoobig"), "22000");
                        }
                        return clob.getSubString(1L, (int)length);
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        long length = blob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(Messages.get("error.normalize.lobtoobig"), "22000");
                        }
                        x = blob.getBytes(1L, (int)length);
                    }
                    if (x instanceof byte[]) {
                        return Support.toHex((byte[])x);
                    }
                    return x.toString();
                }
                case -7: 
                case 16: {
                    if (x == null) {
                        return Boolean.FALSE;
                    }
                    if (x instanceof Boolean) {
                        return x;
                    }
                    if (x instanceof Number) {
                        return ((Number)x).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                    if (!(x instanceof String)) break;
                    String tmp = ((String)x).trim();
                    return tmp.equals("1") || tmp.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
                }
                case -3: 
                case -2: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof byte[]) {
                        return x;
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        return blob.getBytes(1L, (int)blob.length());
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        long length = clob.length();
                        if (length > Integer.MAX_VALUE) {
                            throw new SQLException(Messages.get("error.normalize.lobtoobig"), "22000");
                        }
                        x = clob.getSubString(1L, (int)length);
                    }
                    if (x instanceof String) {
                        if (charSet == null) {
                            charSet = "ISO-8859-1";
                        }
                        try {
                            return ((String)x).getBytes(charSet);
                        }
                        catch (UnsupportedEncodingException e2) {
                            return ((String)x).getBytes();
                        }
                    }
                    if (!(x instanceof UniqueIdentifier)) break;
                    return ((UniqueIdentifier)x).getBytes();
                }
                case 93: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toTimestamp();
                    }
                    if (x instanceof Timestamp) {
                        return x;
                    }
                    if (x instanceof Date) {
                        return new Timestamp(((Date)x).getTime());
                    }
                    if (x instanceof Time) {
                        return new Timestamp(((Time)x).getTime());
                    }
                    if (!(x instanceof String)) break;
                    return Timestamp.valueOf(((String)x).trim());
                }
                case 91: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toDate();
                    }
                    if (x instanceof Date) {
                        return x;
                    }
                    if (x instanceof Time) {
                        return DATE_ZERO;
                    }
                    if (x instanceof Timestamp) {
                        GregorianCalendar e2 = cal;
                        synchronized (e2) {
                            cal.setTime((java.util.Date)x);
                            cal.set(11, 0);
                            cal.set(12, 0);
                            cal.set(13, 0);
                            cal.set(14, 0);
                            Date length = new Date(cal.getTime().getTime());
                            return length;
                        }
                    }
                    if (!(x instanceof String)) break;
                    return Date.valueOf(((String)x).trim());
                }
                case 92: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof DateTime) {
                        return ((DateTime)x).toTime();
                    }
                    if (x instanceof Time) {
                        return x;
                    }
                    if (x instanceof Date) {
                        return TIME_ZERO;
                    }
                    if (x instanceof Timestamp) {
                        GregorianCalendar e2 = cal;
                        synchronized (e2) {
                            cal.setTime((java.util.Date)x);
                            cal.set(1, 1970);
                            cal.set(2, 0);
                            cal.set(5, 1);
                            Time length = new Time(cal.getTime().getTime());
                            return length;
                        }
                    }
                    if (!(x instanceof String)) break;
                    return Time.valueOf(((String)x).trim());
                }
                case 1111: {
                    return x;
                }
                case 2000: {
                    throw new SQLException(Messages.get("error.convert.badtypes", x.getClass().getName(), Support.getJdbcTypeName(jdbcType)), "22005");
                }
                case -4: 
                case 2004: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof Blob) {
                        return x;
                    }
                    if (x instanceof byte[]) {
                        return new BlobImpl(Support.getConnection(callerReference), (byte[])x);
                    }
                    if (x instanceof Clob) {
                        Clob clob = (Clob)x;
                        try {
                            int c2;
                            if (charSet == null) {
                                charSet = "ISO-8859-1";
                            }
                            Reader rdr = clob.getCharacterStream();
                            BlobImpl blob = new BlobImpl(Support.getConnection(callerReference));
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(blob.setBinaryStream(1L), charSet));
                            while ((c2 = rdr.read()) >= 0) {
                                void var8_30;
                                out.write((int)var8_30);
                            }
                            out.close();
                            rdr.close();
                            return blob;
                        }
                        catch (UnsupportedEncodingException e3) {
                            x = clob.getSubString(1L, (int)clob.length());
                        }
                        catch (IOException e4) {
                            throw new SQLException(Messages.get("error.generic.ioerror", e4.getMessage()), "HY000");
                        }
                    }
                    if (!(x instanceof String)) break;
                    BlobImpl blob = new BlobImpl(Support.getConnection(callerReference));
                    String data = (String)x;
                    if (charSet == null) {
                        charSet = "ISO-8859-1";
                    }
                    try {
                        blob.setBytes(1L, data.getBytes(charSet));
                    }
                    catch (UnsupportedEncodingException e5) {
                        blob.setBytes(1L, data.getBytes());
                    }
                    return blob;
                }
                case -1: 
                case 2005: {
                    if (x == null) {
                        return null;
                    }
                    if (x instanceof Clob) {
                        return x;
                    }
                    if (x instanceof Blob) {
                        Blob blob = (Blob)x;
                        try {
                            int b2;
                            InputStream is = blob.getBinaryStream();
                            ClobImpl clob = new ClobImpl(Support.getConnection(callerReference));
                            Writer out = clob.setCharacterStream(1L);
                            while ((b2 = is.read()) >= 0) {
                                void c2;
                                out.write(hex[c2 >> 4]);
                                out.write(hex[c2 & 0xF]);
                            }
                            out.close();
                            is.close();
                            return clob;
                        }
                        catch (IOException e6) {
                            throw new SQLException(Messages.get("error.generic.ioerror", e6.getMessage()), "HY000");
                        }
                    }
                    if (x instanceof Boolean) {
                        x = (Boolean)x != false ? "1" : "0";
                    } else if (!(x instanceof byte[])) {
                        x = x.toString();
                    }
                    if (x instanceof byte[]) {
                        ClobImpl clob = new ClobImpl(Support.getConnection(callerReference));
                        clob.setString(1L, Support.toHex((byte[])x));
                        return clob;
                    }
                    if (!(x instanceof String)) break;
                    return new ClobImpl(Support.getConnection(callerReference), (String)x);
                }
                default: {
                    throw new SQLException(Messages.get("error.convert.badtypeconst", Support.getJdbcTypeName(jdbcType)), "HY004");
                }
            }
            throw new SQLException(Messages.get("error.convert.badtypes", x.getClass().getName(), Support.getJdbcTypeName(jdbcType)), "22005");
        }
        catch (NumberFormatException nfe) {
            throw new SQLException(Messages.get("error.convert.badnumber", Support.getJdbcTypeName(jdbcType)), "22000");
        }
    }

    static int getJdbcType(Object value) {
        if (value == null) {
            return 0;
        }
        return Support.getJdbcType(value.getClass());
    }

    static int getJdbcType(Class typeClass) {
        if (typeClass == null) {
            return 2000;
        }
        Object type = typeMap.get(typeClass);
        if (type == null) {
            return Support.getJdbcType(typeClass.getSuperclass());
        }
        return (Integer)type;
    }

    static String getJdbcTypeName(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "ERROR";
    }

    static String getClassName(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case 16: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case -4: 
            case 2004: {
                return "java.sql.Blob";
            }
            case -1: 
            case 2005: {
                return "java.sql.Clob";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        return "java.lang.Object";
    }

    static void embedData(StringBuffer buf, Object value, boolean isUnicode, ConnectionJDBC2 connection) throws SQLException {
        Object tmp;
        buf.append(' ');
        if (value == null) {
            buf.append("NULL ");
            return;
        }
        if (value instanceof Blob) {
            Blob blob = (Blob)value;
            value = blob.getBytes(1L, (int)blob.length());
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            value = clob.getSubString(1L, (int)clob.length());
        }
        if (value instanceof DateTime) {
            value = ((DateTime)value).toObject();
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            int len = bytes.length;
            if (len >= 0) {
                buf.append('0').append('x');
                if (len == 0 && connection.getTdsVersion() < 3) {
                    buf.append('0').append('0');
                } else {
                    int i2 = 0;
                    while (i2 < len) {
                        int b1 = bytes[i2] & 0xFF;
                        buf.append(hex[b1 >> 4]);
                        buf.append(hex[b1 & 0xF]);
                        ++i2;
                    }
                }
            }
        } else if (value instanceof String) {
            tmp = (String)value;
            int len = ((String)tmp).length();
            if (isUnicode) {
                buf.append('N');
            }
            buf.append('\'');
            int i3 = 0;
            while (i3 < len) {
                char c2 = ((String)tmp).charAt(i3);
                if (c2 == '\'') {
                    buf.append('\'');
                    if (i3 + 1 < len && ((String)tmp).charAt(i3 + 1) == '\'') {
                        ++i3;
                    }
                }
                buf.append(c2);
                ++i3;
            }
            buf.append('\'');
        } else if (value instanceof Date) {
            tmp = cal;
            synchronized (tmp) {
                cal.setTime((Date)value);
                int year = cal.get(1);
                if (year < 1753 || year > 9999) {
                    throw new SQLException(Messages.get("error.datetime.range"), "22003");
                }
                buf.append('\'');
                long dt = (long)year * 10000L;
                dt += (long)((cal.get(2) + 1) * 100);
                buf.append(dt += (long)cal.get(5));
                buf.append('\'');
            }
        } else if (value instanceof Time) {
            tmp = cal;
            synchronized (tmp) {
                cal.setTime((Time)value);
                buf.append('\'');
                int t = cal.get(11);
                buf.append(t < 10 ? "0" + t + ':' : t + ":");
                t = cal.get(12);
                buf.append(t < 10 ? "0" + t + ':' : t + ":");
                t = cal.get(13);
                buf.append(t < 10 ? "0" + t + '\'' : t + "'");
            }
        } else if (value instanceof Timestamp) {
            tmp = cal;
            synchronized (tmp) {
                cal.setTime((Timestamp)value);
                int year = cal.get(1);
                if (year < 1753 || year > 9999) {
                    throw new SQLException(Messages.get("error.datetime.range"), "22003");
                }
                buf.append('\'');
                long dt = (long)year * 10000L;
                dt += (long)((cal.get(2) + 1) * 100);
                buf.append(dt += (long)cal.get(5));
                buf.append(' ');
                int t = cal.get(11);
                buf.append(t < 10 ? "0" + t + ':' : t + ":");
                t = cal.get(12);
                buf.append(t < 10 ? "0" + t + ':' : t + ":");
                t = cal.get(13);
                buf.append(t < 10 ? "0" + t + '.' : t + ".");
                t = (int)(cal.getTime().getTime() % 1000L);
                if (t < 100) {
                    buf.append('0');
                }
                if (t < 10) {
                    buf.append('0');
                }
                buf.append(t);
                buf.append('\'');
            }
        } else if (value instanceof Boolean) {
            buf.append((Boolean)value != false ? (char)'1' : '0');
        } else if (value instanceof BigDecimal) {
            tmp = value.toString();
            int maxlen = connection.getMaxPrecision();
            if (((String)tmp).charAt(0) == '-') {
                ++maxlen;
            }
            if (((String)tmp).indexOf(46) >= 0) {
                ++maxlen;
            }
            if (((String)tmp).length() > maxlen) {
                buf.append(((String)tmp).substring(0, maxlen));
            } else {
                buf.append((String)tmp);
            }
        } else {
            buf.append(value.toString());
        }
        buf.append(' ');
    }

    static String getStatementKey(String sql, ParamInfo[] params, int serverType, String catalog, boolean autoCommit, boolean cursor) {
        StringBuffer key;
        if (serverType == 1) {
            key = new StringBuffer(1 + catalog.length() + sql.length() + 11 * params.length);
            key.append(cursor ? (char)'C' : 'X');
            key.append(catalog);
            key.append(sql);
            int i2 = 0;
            while (i2 < params.length) {
                key.append(params[i2].sqlType);
                ++i2;
            }
        } else {
            key = new StringBuffer(sql.length() + 2);
            key.append(autoCommit ? (char)'T' : 'F');
            key.append(sql);
        }
        return key.toString();
    }

    static String getParameterDefinitions(ParamInfo[] parameters) {
        StringBuffer sql = new StringBuffer(parameters.length * 15);
        int i2 = 0;
        while (i2 < parameters.length) {
            if (parameters[i2].name == null) {
                sql.append("@P");
                sql.append(i2);
            } else {
                sql.append(parameters[i2].name);
            }
            sql.append(' ');
            sql.append(parameters[i2].sqlType);
            if (i2 + 1 < parameters.length) {
                sql.append(',');
            }
            ++i2;
        }
        return sql.toString();
    }

    static String substituteParamMarkers(String sql, ParamInfo[] list) {
        char[] buf = new char[sql.length() + list.length * 7];
        int bufferPtr = 0;
        int start = 0;
        StringBuffer number = new StringBuffer(4);
        int i2 = 0;
        while (i2 < list.length) {
            int pos = list[i2].markerPos;
            if (pos > 0) {
                sql.getChars(start, pos, buf, bufferPtr);
                bufferPtr += pos - start;
                start = pos + 1;
                buf[bufferPtr++] = 32;
                buf[bufferPtr++] = 64;
                buf[bufferPtr++] = 80;
                number.setLength(0);
                number.append(i2);
                number.getChars(0, number.length(), buf, bufferPtr);
                bufferPtr += number.length();
                buf[bufferPtr++] = 32;
            }
            ++i2;
        }
        if (start < sql.length()) {
            sql.getChars(start, sql.length(), buf, bufferPtr);
            bufferPtr += sql.length() - start;
        }
        return new String(buf, 0, bufferPtr);
    }

    static String substituteParameters(String sql, ParamInfo[] list, ConnectionJDBC2 connection) throws SQLException {
        int len = sql.length();
        int i2 = 0;
        while (i2 < list.length) {
            if (!(list[i2].isRetVal || list[i2].isSet || list[i2].isOutput)) {
                throw new SQLException(Messages.get("error.prepare.paramnotset", Integer.toString(i2 + 1)), "07000");
            }
            Object value = list[i2].value;
            if (value instanceof InputStream || value instanceof Reader) {
                try {
                    value = list[i2].jdbcType == -1 || list[i2].jdbcType == 2005 || list[i2].jdbcType == 12 ? list[i2].getString("US-ASCII") : (Object)list[i2].getBytes("US-ASCII");
                    list[i2].value = value;
                }
                catch (IOException e2) {
                    throw new SQLException(Messages.get("error.generic.ioerror", e2.getMessage()), "HY000");
                }
            }
            len = value instanceof String ? (len += ((String)value).length() + 5) : (value instanceof byte[] ? (len += ((byte[])value).length * 2 + 4) : (len += 32));
            ++i2;
        }
        StringBuffer buf = new StringBuffer(len + 16);
        int start = 0;
        int i3 = 0;
        while (i3 < list.length) {
            int pos = list[i3].markerPos;
            if (pos > 0) {
                buf.append(sql.substring(start, list[i3].markerPos));
                start = pos + 1;
                boolean isUnicode = connection.getTdsVersion() >= 3 && list[i3].isUnicode;
                Support.embedData(buf, list[i3].value, isUnicode, connection);
            }
            ++i3;
        }
        if (start < sql.length()) {
            buf.append(sql.substring(start));
        }
        return buf.toString();
    }

    static byte[] encodeString(String cs, String value) {
        try {
            return value.getBytes(cs);
        }
        catch (UnsupportedEncodingException e2) {
            return value.getBytes();
        }
    }

    public static SQLWarning linkException(SQLWarning sqle, Throwable cause) {
        return (SQLWarning)Support.linkException((Exception)sqle, cause);
    }

    public static SQLException linkException(SQLException sqle, Throwable cause) {
        return (SQLException)Support.linkException((Exception)sqle, cause);
    }

    public static Throwable linkException(Exception exception, Throwable cause) {
        Class<?> exceptionClass = exception.getClass();
        Class[] parameterTypes = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = Support.class$("java.lang.Throwable")) : class$java$lang$Throwable};
        Object[] arguments = new Object[]{cause};
        try {
            Method initCauseMethod = exceptionClass.getMethod("initCause", parameterTypes);
            initCauseMethod.invoke((Object)exception, arguments);
        }
        catch (NoSuchMethodException e2) {
            if (Logger.isActive()) {
                Logger.logException((Exception)cause);
            }
        }
        catch (Exception e3) {
            // empty catch block
        }
        return exception;
    }

    public static long timeToZone(java.util.Date value, Calendar target) {
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            java.util.Date tmp = target.getTime();
            try {
                cal.setTime(value);
                if (!Driver.JDBC3 && value instanceof Timestamp) {
                    cal.set(14, ((Timestamp)value).getNanos() / 1000000);
                }
                target.set(11, cal.get(11));
                target.set(12, cal.get(12));
                target.set(13, cal.get(13));
                target.set(14, cal.get(14));
                target.set(1, cal.get(1));
                target.set(2, cal.get(2));
                target.set(5, cal.get(5));
                long l2 = target.getTime().getTime();
                Object var7_5 = null;
                target.setTime(tmp);
                return l2;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                target.setTime(tmp);
                throw throwable;
            }
        }
    }

    public static long timeFromZone(java.util.Date value, Calendar target) {
        GregorianCalendar gregorianCalendar = cal;
        synchronized (gregorianCalendar) {
            java.util.Date tmp = target.getTime();
            try {
                target.setTime(value);
                if (!Driver.JDBC3 && value instanceof Timestamp) {
                    target.set(14, ((Timestamp)value).getNanos() / 1000000);
                }
                cal.set(11, target.get(11));
                cal.set(12, target.get(12));
                cal.set(13, target.get(13));
                cal.set(14, target.get(14));
                cal.set(1, target.get(1));
                cal.set(2, target.get(2));
                cal.set(5, target.get(5));
                long l2 = cal.getTime().getTime();
                Object var7_5 = null;
                target.setTime(tmp);
                return l2;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                target.setTime(tmp);
                throw throwable;
            }
        }
    }

    public static Object convertLOB(Object value) throws SQLException {
        if (value instanceof Clob) {
            Clob c2 = (Clob)value;
            return c2.getSubString(1L, (int)c2.length());
        }
        if (value instanceof Blob) {
            Blob b2 = (Blob)value;
            return b2.getBytes(1L, (int)b2.length());
        }
        return value;
    }

    public static int convertLOBType(int type) {
        switch (type) {
            case 2004: {
                return -4;
            }
            case 2005: {
                return -1;
            }
        }
        return type;
    }

    public static boolean isWindowsOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static ConnectionJDBC2 getConnection(Object callerReference) {
        Connection connection;
        block6: {
            if (callerReference == null) {
                throw new IllegalArgumentException("callerReference cannot be null.");
            }
            try {
                if (callerReference instanceof Connection) {
                    connection = (Connection)callerReference;
                    break block6;
                }
                if (callerReference instanceof Statement) {
                    connection = ((Statement)callerReference).getConnection();
                    break block6;
                }
                if (callerReference instanceof ResultSet) {
                    connection = ((ResultSet)callerReference).getStatement().getConnection();
                    break block6;
                }
                throw new IllegalArgumentException("callerReference is invalid.");
            }
            catch (SQLException e2) {
                throw new IllegalStateException(e2.getMessage());
            }
        }
        return (ConnectionJDBC2)connection;
    }

    private Support() {
    }

    static int calculateNamedPipeBufferSize(int tdsVersion, int packetSize) {
        if (packetSize == 0) {
            if (tdsVersion >= 3) {
                return 4096;
            }
            return 512;
        }
        return packetSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        typeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Support.class$("java.lang.Byte")) : class$java$lang$Byte, new Integer(-6));
        typeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Support.class$("java.lang.Short")) : class$java$lang$Short, new Integer(5));
        typeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Support.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(4));
        typeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Support.class$("java.lang.Long")) : class$java$lang$Long, new Integer(-5));
        typeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Support.class$("java.lang.Float")) : class$java$lang$Float, new Integer(7));
        typeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Support.class$("java.lang.Double")) : class$java$lang$Double, new Integer(8));
        typeMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Support.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new Integer(3));
        typeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Support.class$("java.lang.Boolean")) : class$java$lang$Boolean, new Integer(16));
        typeMap.put(array$B == null ? (array$B = Support.class$("[B")) : array$B, new Integer(-3));
        typeMap.put(class$java$sql$Date == null ? (class$java$sql$Date = Support.class$("java.sql.Date")) : class$java$sql$Date, new Integer(91));
        typeMap.put(class$java$sql$Time == null ? (class$java$sql$Time = Support.class$("java.sql.Time")) : class$java$sql$Time, new Integer(92));
        typeMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Support.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new Integer(93));
        typeMap.put(class$net$sourceforge$jtds$jdbc$BlobImpl == null ? (class$net$sourceforge$jtds$jdbc$BlobImpl = Support.class$("net.sourceforge.jtds.jdbc.BlobImpl")) : class$net$sourceforge$jtds$jdbc$BlobImpl, new Integer(-4));
        typeMap.put(class$net$sourceforge$jtds$jdbc$ClobImpl == null ? (class$net$sourceforge$jtds$jdbc$ClobImpl = Support.class$("net.sourceforge.jtds.jdbc.ClobImpl")) : class$net$sourceforge$jtds$jdbc$ClobImpl, new Integer(-1));
        typeMap.put(class$java$lang$String == null ? (class$java$lang$String = Support.class$("java.lang.String")) : class$java$lang$String, new Integer(12));
        typeMap.put(class$java$sql$Blob == null ? (class$java$sql$Blob = Support.class$("java.sql.Blob")) : class$java$sql$Blob, new Integer(-4));
        typeMap.put(class$java$sql$Clob == null ? (class$java$sql$Clob = Support.class$("java.sql.Clob")) : class$java$sql$Clob, new Integer(-1));
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        cal = new GregorianCalendar();
    }
}

