/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.sourceforge.jtds.jdbc.CharsetInfo;
import net.sourceforge.jtds.jdbc.ConnectionJDBC2;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.RequestStream;
import net.sourceforge.jtds.jdbc.ResponseStream;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.ssl.SocketFactories;
import net.sourceforge.jtds.util.Logger;

class SharedSocket {
    private Socket socket;
    private Socket sslSocket;
    private DataOutputStream out;
    private DataInputStream in;
    private int maxBufSize = 512;
    private final ArrayList socketTable = new ArrayList();
    private int responseOwner = -1;
    private final byte[] hdrBuf = new byte[8];
    private static int globalMemUsage;
    private static int peakMemUsage;
    private static int memoryBudget;
    private static int minMemPkts;
    private static boolean securityViolation;
    private int tdsVersion;
    protected final int serverType;
    private CharsetInfo charsetInfo;
    private int packetCount;
    private String host;
    private int port;
    private boolean cancelPending;
    private Object cancelMonitor = new Object();
    private byte[] doneBuffer = new byte[9];
    private static final int TDS_DONE_TOKEN = 253;
    private static final int TDS_DONE_LEN = 9;
    private static final int TDS_HDR_LEN = 8;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$lang$String;

    protected SharedSocket(int tdsVersion, int serverType) {
        this.tdsVersion = tdsVersion;
        this.serverType = serverType;
    }

    SharedSocket(ConnectionJDBC2 connection) throws IOException, UnknownHostException {
        this(connection.getTdsVersion(), connection.getServerType());
        this.host = connection.getServerName();
        this.port = connection.getPortNumber();
        this.socket = Driver.JDBC3 ? this.createSocketForJDBC3(connection) : new Socket(this.host, this.port);
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
        this.socket.setTcpNoDelay(connection.getTcpNoDelay());
        this.socket.setSoTimeout(connection.getSocketTimeout() * 1000);
    }

    private Socket createSocketForJDBC3(ConnectionJDBC2 connection) throws IOException {
        String host = connection.getServerName();
        int port = connection.getPortNumber();
        int loginTimeout = connection.getLoginTimeout();
        try {
            Constructor<Object> constructor = (class$java$net$Socket == null ? (class$java$net$Socket = SharedSocket.class$("java.net.Socket")) : class$java$net$Socket).getConstructor(new Class[0]);
            Socket socket = (Socket)constructor.newInstance(new Object[0]);
            constructor = Class.forName("java.net.InetSocketAddress").getConstructor(class$java$lang$String == null ? (class$java$lang$String = SharedSocket.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            Object address = constructor.newInstance(host, new Integer(port));
            Method connect = (class$java$net$Socket == null ? (class$java$net$Socket = SharedSocket.class$("java.net.Socket")) : class$java$net$Socket).getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
            connect.invoke((Object)socket, address, new Integer(loginTimeout * 1000));
            return socket;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (IOException)Support.linkException(new IOException("Could not create socket"), cause);
        }
        catch (Exception e2) {
            return new Socket(host, port);
        }
    }

    void enableEncryption(String ssl) throws IOException {
        Logger.println("Enabling TLS encryption");
        this.sslSocket = SocketFactories.getSocketFactory(ssl, this.socket).createSocket(this.getHost(), this.getPort());
        this.setOut(new DataOutputStream(this.sslSocket.getOutputStream()));
        this.setIn(new DataInputStream(this.sslSocket.getInputStream()));
    }

    void disableEncryption() throws IOException {
        Logger.println("Disabling TLS encryption");
        this.sslSocket.close();
        this.sslSocket = null;
        this.setOut(new DataOutputStream(this.socket.getOutputStream()));
        this.setIn(new DataInputStream(this.socket.getInputStream()));
    }

    void setCharsetInfo(CharsetInfo charsetInfo) {
        this.charsetInfo = charsetInfo;
    }

    CharsetInfo getCharsetInfo() {
        return this.charsetInfo;
    }

    String getCharset() {
        return this.charsetInfo.getCharset();
    }

    RequestStream getRequestStream(int bufferSize, int maxPrecision) {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int id = 0;
            while (id < this.socketTable.size()) {
                if (this.socketTable.get(id) == null) break;
                ++id;
            }
            VirtualSocket vsock = new VirtualSocket(id);
            if (id >= this.socketTable.size()) {
                this.socketTable.add(vsock);
            } else {
                this.socketTable.set(id, vsock);
            }
            RequestStream requestStream = new RequestStream(this, id, bufferSize, maxPrecision);
            return requestStream;
        }
    }

    ResponseStream getResponseStream(RequestStream requestStream, int bufferSize) {
        return new ResponseStream(this, requestStream.getStreamId(), bufferSize);
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    protected void setTdsVersion(int tdsVersion) {
        this.tdsVersion = tdsVersion;
    }

    static void setMemoryBudget(int memoryBudget) {
        SharedSocket.memoryBudget = memoryBudget;
    }

    static int getMemoryBudget() {
        return memoryBudget;
    }

    static void setMinMemPkts(int minMemPkts) {
        SharedSocket.minMemPkts = minMemPkts;
    }

    static int getMinMemPkts() {
        return minMemPkts;
    }

    boolean isConnected() {
        return this.socket != null;
    }

    boolean cancel(int streamId) {
        Object object = this.cancelMonitor;
        synchronized (object) {
            if (this.responseOwner == streamId && !this.cancelPending) {
                try {
                    this.cancelPending = true;
                    byte[] cancel = new byte[]{6, 1, 0, 8, 0, 0, this.tdsVersion >= 3 ? (byte)1 : 0, 0};
                    this.getOut().write(cancel, 0, 8);
                    this.getOut().flush();
                    if (Logger.isActive()) {
                        Logger.logPacket(streamId, false, cancel);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void close() throws IOException {
        if (Logger.isActive()) {
            Logger.println("TdsSocket: Max buffer memory used = " + peakMemUsage / 1024 + "KB");
        }
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            int i2 = 0;
            while (i2 < this.socketTable.size()) {
                VirtualSocket vsock = (VirtualSocket)this.socketTable.get(i2);
                if (vsock != null && vsock.diskQueue != null) {
                    try {
                        vsock.diskQueue.close();
                        vsock.queueFile.delete();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                ++i2;
            }
            try {
                if (this.sslSocket != null) {
                    this.sslSocket.close();
                    this.sslSocket = null;
                }
                Object var6_5 = null;
                if (this.socket == null) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.socket == null) throw throwable;
                this.socket.close();
                throw throwable;
            }
            this.socket.close();
            {
            }
            return;
        }
    }

    void forceClose() {
        if (this.socket != null) {
            try {
                try {
                    this.socket.close();
                }
                catch (IOException ioe) {
                    Object var3_2 = null;
                    this.sslSocket = null;
                    this.socket = null;
                }
                Object var3_1 = null;
                this.sslSocket = null;
                this.socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sslSocket = null;
                this.socket = null;
                throw throwable;
            }
        }
    }

    void closeStream(int streamId) {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            if (vsock.diskQueue != null) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            this.socketTable.set(streamId, null);
        }
    }

    byte[] sendNetPacket(int streamId, byte[] buffer) throws IOException {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            while (vsock.inputPkts > 0) {
                if (Logger.isActive()) {
                    Logger.println("TdsSocket: Unread data in input packet queue");
                }
                this.dequeueInput(vsock);
            }
            if (this.responseOwner != -1) {
                VirtualSocket other = (VirtualSocket)this.socketTable.get(this.responseOwner);
                byte[] tmpBuf = null;
                boolean ourData = other.owner == streamId;
                do {
                    tmpBuf = this.readPacket(ourData ? tmpBuf : null);
                    if (ourData) continue;
                    this.enqueueInput(other, tmpBuf);
                } while (tmpBuf[1] == 0);
            }
            this.getOut().write(buffer, 0, SharedSocket.getPktLen(buffer));
            if (buffer[1] != 0) {
                this.getOut().flush();
                this.responseOwner = streamId;
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    byte[] getNetPacket(int streamId, byte[] buffer) throws IOException {
        ArrayList arrayList = this.socketTable;
        synchronized (arrayList) {
            VirtualSocket vsock = this.lookup(streamId);
            if (vsock.inputPkts > 0) {
                byte[] byArray = this.dequeueInput(vsock);
                return byArray;
            }
            if (this.responseOwner == -1) {
                throw new IOException("Stream " + streamId + " attempting to read when no request has been sent");
            }
            if (this.responseOwner != streamId) {
                throw new IOException("Stream " + streamId + " is trying to read data that belongs to stream " + this.responseOwner);
            }
            byte[] byArray = this.readPacket(buffer);
            return byArray;
        }
    }

    private void enqueueInput(VirtualSocket vsock, byte[] buffer) throws IOException {
        if (globalMemUsage + buffer.length > memoryBudget && vsock.pktQueue.size() >= minMemPkts && !securityViolation && vsock.diskQueue == null) {
            try {
                vsock.queueFile = File.createTempFile("jtds", ".tmp");
                vsock.queueFile.deleteOnExit();
                vsock.diskQueue = new RandomAccessFile(vsock.queueFile, "rw");
                while (vsock.pktQueue.size() > 0) {
                    byte[] tmpBuf = (byte[])vsock.pktQueue.removeFirst();
                    vsock.diskQueue.write(tmpBuf, 0, SharedSocket.getPktLen(tmpBuf));
                    ++vsock.pktsOnDisk;
                }
            }
            catch (SecurityException se) {
                securityViolation = true;
                vsock.queueFile = null;
                vsock.diskQueue = null;
            }
        }
        if (vsock.diskQueue != null) {
            vsock.diskQueue.write(buffer, 0, SharedSocket.getPktLen(buffer));
            ++vsock.pktsOnDisk;
        } else {
            vsock.pktQueue.addLast(buffer);
            if ((globalMemUsage += buffer.length) > peakMemUsage) {
                peakMemUsage = globalMemUsage;
            }
        }
        ++vsock.inputPkts;
    }

    private byte[] dequeueInput(VirtualSocket vsock) throws IOException {
        byte[] buffer = null;
        if (vsock.pktsOnDisk > 0) {
            if (vsock.diskQueue.getFilePointer() == vsock.diskQueue.length()) {
                vsock.diskQueue.seek(0L);
            }
            vsock.diskQueue.readFully(this.hdrBuf, 0, 8);
            int len = SharedSocket.getPktLen(this.hdrBuf);
            buffer = new byte[len];
            System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
            vsock.diskQueue.readFully(buffer, 8, len - 8);
            --vsock.pktsOnDisk;
            if (vsock.pktsOnDisk < 1) {
                try {
                    vsock.diskQueue.close();
                    vsock.queueFile.delete();
                    Object var5_4 = null;
                    vsock.queueFile = null;
                    vsock.diskQueue = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    vsock.queueFile = null;
                    vsock.diskQueue = null;
                    throw throwable;
                }
            }
        } else if (vsock.pktQueue.size() > 0) {
            buffer = (byte[])vsock.pktQueue.removeFirst();
            globalMemUsage -= buffer.length;
        }
        if (buffer != null) {
            --vsock.inputPkts;
        }
        return buffer;
    }

    private byte[] readPacket(byte[] buffer) throws IOException {
        try {
            this.getIn().readFully(this.hdrBuf);
        }
        catch (EOFException e2) {
            throw new IOException("DB server closed connection.");
        }
        byte packetType = this.hdrBuf[0];
        if (packetType != 2 && packetType != 1 && packetType != 4) {
            throw new IOException("Unknown packet type 0x" + Integer.toHexString(packetType & 0xFF));
        }
        int len = SharedSocket.getPktLen(this.hdrBuf);
        if (len < 8 || len > 65536) {
            throw new IOException("Invalid network packet length " + len);
        }
        if (buffer == null || len > buffer.length) {
            buffer = new byte[len];
            if (len > this.maxBufSize) {
                this.maxBufSize = len;
            }
        }
        System.arraycopy(this.hdrBuf, 0, buffer, 0, 8);
        try {
            this.getIn().readFully(buffer, 8, len - 8);
        }
        catch (EOFException e3) {
            throw new IOException("DB server closed connection.");
        }
        if (++this.packetCount == 1 && this.serverType == 1 && "NTLMSSP".equals(new String(buffer, 11, 7))) {
            buffer[1] = 1;
        }
        Object object = this.cancelMonitor;
        synchronized (object) {
            if (this.cancelPending) {
                if (len >= 17) {
                    System.arraycopy(buffer, len - 9, this.doneBuffer, 0, 9);
                } else {
                    int frag = len - 8;
                    System.arraycopy(this.doneBuffer, frag, this.doneBuffer, 0, 9 - frag);
                    System.arraycopy(buffer, 8, this.doneBuffer, 9 - frag, frag);
                }
                if (buffer[1] == 1) {
                    if ((this.doneBuffer[0] & 0xFF) < 253) {
                        throw new IOException("Expecting a TDS_DONE or TDS_DONEPROC.");
                    }
                    if ((this.doneBuffer[1] & 0x20) != 0) {
                        this.cancelPending = false;
                    } else {
                        buffer[1] = 0;
                    }
                }
            }
            if (buffer[1] != 0) {
                this.responseOwner = -1;
            }
        }
        return buffer;
    }

    private VirtualSocket lookup(int streamId) {
        if (streamId < 0 || streamId > this.socketTable.size()) {
            throw new IllegalArgumentException("Invalid parameter stream ID " + streamId);
        }
        VirtualSocket vsock = (VirtualSocket)this.socketTable.get(streamId);
        if (vsock.owner != streamId) {
            throw new IllegalStateException("Internal error: bad stream ID " + streamId);
        }
        return vsock;
    }

    static int getPktLen(byte[] buf) {
        int lo = buf[3] & 0xFF;
        int hi = (buf[2] & 0xFF) << 8;
        return hi | lo;
    }

    protected void setTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    protected DataInputStream getIn() {
        return this.in;
    }

    protected void setIn(DataInputStream in) {
        this.in = in;
    }

    protected DataOutputStream getOut() {
        return this.out;
    }

    protected void setOut(DataOutputStream out) {
        this.out = out;
    }

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        memoryBudget = 100000;
        minMemPkts = 8;
    }

    private static class VirtualSocket {
        final int owner;
        final LinkedList pktQueue;
        boolean flushInput;
        boolean complete;
        File queueFile;
        RandomAccessFile diskQueue;
        int pktsOnDisk;
        int inputPkts;

        VirtualSocket(int streamId) {
            this.owner = streamId;
            this.pktQueue = new LinkedList();
            this.flushInput = false;
            this.complete = false;
            this.queueFile = null;
            this.diskQueue = null;
            this.pktsOnDisk = 0;
            this.inputPkts = 0;
        }
    }
}

