/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.util.Logger;

public class RequestStream {
    private final SharedSocket socket;
    private byte[] buffer;
    private int bufferPtr;
    private byte pktType;
    private final int streamId;
    private boolean isClosed;
    private int bufferSize;
    private int maxPrecision;

    RequestStream(SharedSocket socket, int streamId, int bufferSize, int maxPrecision) {
        this.streamId = streamId;
        this.socket = socket;
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.bufferPtr = 8;
        this.maxPrecision = maxPrecision;
    }

    void setBufferSize(int size) {
        if (size < this.bufferPtr || size == this.bufferSize) {
            return;
        }
        if (size < 512 || size > 32768) {
            throw new IllegalArgumentException("Invalid buffer size parameter " + size);
        }
        byte[] tmp = new byte[size];
        System.arraycopy(this.buffer, 0, tmp, 0, this.bufferPtr);
        this.buffer = tmp;
    }

    int getBufferSize() {
        return this.bufferSize;
    }

    int getMaxPrecision() {
        return this.maxPrecision;
    }

    byte getMaxDecimalBytes() {
        return this.maxPrecision <= 28 ? (byte)13 : 17;
    }

    int getStreamId() {
        return this.streamId;
    }

    void setPacketType(byte pktType) {
        this.pktType = pktType;
    }

    void write(byte b2) throws IOException {
        if (this.bufferPtr == this.buffer.length) {
            this.putPacket(0);
        }
        this.buffer[this.bufferPtr++] = b2;
    }

    void write(byte[] b2) throws IOException {
        int bytesToWrite = b2.length;
        int off = 0;
        while (bytesToWrite > 0) {
            int available = this.buffer.length - this.bufferPtr;
            if (available == 0) {
                this.putPacket(0);
                continue;
            }
            int bc = available > bytesToWrite ? bytesToWrite : available;
            System.arraycopy(b2, off, this.buffer, this.bufferPtr, bc);
            off += bc;
            this.bufferPtr += bc;
            bytesToWrite -= bc;
        }
    }

    void write(byte[] b2, int off, int len) throws IOException {
        int limit = off + len > b2.length ? b2.length : off + len;
        int bytesToWrite = limit - off;
        int i2 = len - bytesToWrite;
        while (bytesToWrite > 0) {
            int available = this.buffer.length - this.bufferPtr;
            if (available == 0) {
                this.putPacket(0);
                continue;
            }
            int bc = available > bytesToWrite ? bytesToWrite : available;
            System.arraycopy(b2, off, this.buffer, this.bufferPtr, bc);
            off += bc;
            this.bufferPtr += bc;
            bytesToWrite -= bc;
        }
        while (i2 > 0) {
            this.write((byte)0);
            --i2;
        }
    }

    void write(int i2) throws IOException {
        this.write((byte)i2);
        this.write((byte)(i2 >> 8));
        this.write((byte)(i2 >> 16));
        this.write((byte)(i2 >> 24));
    }

    void write(short s2) throws IOException {
        this.write((byte)s2);
        this.write((byte)(s2 >> 8));
    }

    void write(long l2) throws IOException {
        this.write((byte)l2);
        this.write((byte)(l2 >> 8));
        this.write((byte)(l2 >> 16));
        this.write((byte)(l2 >> 24));
        this.write((byte)(l2 >> 32));
        this.write((byte)(l2 >> 40));
        this.write((byte)(l2 >> 48));
        this.write((byte)(l2 >> 56));
    }

    void write(double f2) throws IOException {
        long l2 = Double.doubleToLongBits(f2);
        this.write((byte)l2);
        this.write((byte)(l2 >> 8));
        this.write((byte)(l2 >> 16));
        this.write((byte)(l2 >> 24));
        this.write((byte)(l2 >> 32));
        this.write((byte)(l2 >> 40));
        this.write((byte)(l2 >> 48));
        this.write((byte)(l2 >> 56));
    }

    void write(float f2) throws IOException {
        int l2 = Float.floatToIntBits(f2);
        this.write((byte)l2);
        this.write((byte)(l2 >> 8));
        this.write((byte)(l2 >> 16));
        this.write((byte)(l2 >> 24));
    }

    void write(String s2) throws IOException {
        if (this.socket.getTdsVersion() >= 3) {
            int len = s2.length();
            int i2 = 0;
            while (i2 < len) {
                char c2 = s2.charAt(i2);
                if (this.bufferPtr == this.buffer.length) {
                    this.putPacket(0);
                }
                this.buffer[this.bufferPtr++] = (byte)c2;
                if (this.bufferPtr == this.buffer.length) {
                    this.putPacket(0);
                }
                this.buffer[this.bufferPtr++] = (byte)(c2 >> 8);
                ++i2;
            }
        } else {
            this.writeAscii(s2);
        }
    }

    void write(char[] s2, int off, int len) throws IOException {
        int i2 = off;
        int limit = off + len > s2.length ? s2.length : off + len;
        while (i2 < limit) {
            char c2 = s2[i2];
            if (this.bufferPtr == this.buffer.length) {
                this.putPacket(0);
            }
            this.buffer[this.bufferPtr++] = (byte)c2;
            if (this.bufferPtr == this.buffer.length) {
                this.putPacket(0);
            }
            this.buffer[this.bufferPtr++] = (byte)(c2 >> 8);
            ++i2;
        }
    }

    void writeAscii(String s2) throws IOException {
        String charsetName = this.socket.getCharset();
        if (charsetName != null) {
            try {
                this.write(s2.getBytes(charsetName));
            }
            catch (UnsupportedEncodingException e2) {
                this.write(s2.getBytes());
            }
        } else {
            this.write(s2.getBytes());
        }
    }

    void writeStreamBytes(InputStream in, int length) throws IOException {
        byte[] buffer = new byte[1024];
        while (length > 0) {
            int res = in.read(buffer);
            if (res < 0) {
                throw new IOException("Data in stream less than specified by length");
            }
            this.write(buffer, 0, res);
            length -= res;
        }
        if (length < 0 || in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
    }

    void writeReaderChars(Reader in, int length) throws IOException {
        char[] cbuffer = new char[512];
        byte[] bbuffer = new byte[1024];
        while (length > 0) {
            int res = in.read(cbuffer);
            if (res < 0) {
                throw new IOException("Data in stream less than specified by length");
            }
            int i2 = 0;
            int j2 = -1;
            while (i2 < res) {
                bbuffer[++j2] = (byte)cbuffer[i2];
                bbuffer[++j2] = (byte)(cbuffer[i2] >> 8);
                ++i2;
            }
            this.write(bbuffer, 0, res * 2);
            length -= res;
        }
        if (length < 0 || in.read() >= 0) {
            throw new IOException("More data in stream than specified by length");
        }
    }

    void writeReaderBytes(Reader in, int length) throws IOException {
        char[] buffer = new char[1024];
        int i2 = 0;
        while (i2 < length) {
            int result = in.read(buffer);
            if (result == -1) {
                throw new IOException("Data in stream less than specified by length");
            }
            if (i2 + result > length) {
                throw new IOException("More data in stream than specified by length");
            }
            this.write(Support.encodeString(this.socket.getCharset(), new String(buffer, 0, result)));
            i2 += result;
        }
    }

    void write(BigDecimal value) throws IOException {
        if (value == null) {
            this.write((byte)0);
        } else {
            byte signum = value.signum() < 0 ? (byte)0 : 1;
            BigInteger bi = value.unscaledValue();
            byte[] mantisse = bi.abs().toByteArray();
            byte len = (byte)(mantisse.length + 1);
            if (len > this.getMaxDecimalBytes()) {
                throw new IOException("BigDecimal to big to send");
            }
            if (this.socket.serverType == 2) {
                this.write(len);
                this.write(signum == 0 ? (byte)1 : 0);
                int i2 = 0;
                while (i2 < mantisse.length) {
                    this.write(mantisse[i2]);
                    ++i2;
                }
            } else {
                this.write(len);
                this.write(signum);
                int i3 = mantisse.length - 1;
                while (i3 >= 0) {
                    this.write(mantisse[i3]);
                    --i3;
                }
            }
        }
    }

    void flush() throws IOException {
        this.putPacket(1);
    }

    void close() {
        this.isClosed = true;
    }

    int getTdsVersion() {
        return this.socket.getTdsVersion();
    }

    int getServerType() {
        return this.socket.serverType;
    }

    private void putPacket(int last) throws IOException {
        if (this.isClosed) {
            throw new IOException("RequestStream is closed");
        }
        this.buffer[0] = this.pktType;
        this.buffer[1] = (byte)last;
        this.buffer[2] = (byte)(this.bufferPtr >> 8);
        this.buffer[3] = (byte)this.bufferPtr;
        this.buffer[4] = 0;
        this.buffer[5] = 0;
        this.buffer[6] = this.socket.getTdsVersion() >= 3 ? (byte)1 : 0;
        this.buffer[7] = 0;
        if (Logger.isActive()) {
            Logger.logPacket(this.streamId, false, this.buffer);
        }
        this.buffer = this.socket.sendNetPacket(this.streamId, this.buffer);
        this.bufferPtr = 8;
    }
}

