/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.util.Logger;

public class MSSqlServerInfo {
    private int numRetries;
    private int timeout;
    private String[] serverInfoStrings;

    public MSSqlServerInfo(String host) throws SQLException {
        block6: {
            this.numRetries = 3;
            this.timeout = 2000;
            try {
                InetAddress addr = InetAddress.getByName(host);
                DatagramSocket socket = new DatagramSocket();
                byte[] msg = new byte[]{2};
                DatagramPacket p2 = new DatagramPacket(msg, msg.length, addr, 1434);
                socket.send(p2);
                byte[] buf = new byte[4096];
                p2 = new DatagramPacket(buf, buf.length);
                socket.setSoTimeout(this.timeout);
                int i2 = 0;
                while (i2 < this.numRetries) {
                    try {
                        socket.receive(p2);
                        String infoString = MSSqlServerInfo.extractString(buf, p2.getLength());
                        this.serverInfoStrings = MSSqlServerInfo.split(infoString, 59);
                        return;
                    }
                    catch (InterruptedIOException toEx) {
                        if (Logger.isActive()) {
                            Logger.logException(toEx);
                        }
                        ++i2;
                    }
                }
            }
            catch (Exception e2) {
                if (!Logger.isActive()) break block6;
                Logger.logException(e2);
            }
        }
        throw new SQLException(Messages.get("error.msinfo.badinfo", host), "HY000");
    }

    public int getPortForInstance(String instanceName) throws SQLException {
        if (this.serverInfoStrings == null) {
            return -1;
        }
        if (instanceName == null || instanceName.length() == 0) {
            instanceName = "MSSQLSERVER";
        }
        String curInstance = null;
        String curPort = null;
        int index = 0;
        while (index < this.serverInfoStrings.length) {
            if (this.serverInfoStrings[index].length() == 0) {
                curInstance = null;
                curPort = null;
            } else {
                String key = this.serverInfoStrings[index];
                String value = "";
                if (++index < this.serverInfoStrings.length) {
                    value = this.serverInfoStrings[index];
                }
                if ("InstanceName".equals(key)) {
                    curInstance = value;
                }
                if ("tcp".equals(key)) {
                    curPort = value;
                }
                if (curInstance != null && curPort != null && curInstance.equalsIgnoreCase(instanceName)) {
                    try {
                        return Integer.parseInt(curPort);
                    }
                    catch (NumberFormatException e2) {
                        throw new SQLException(Messages.get("error.msinfo.badport", instanceName), "HY000");
                    }
                }
            }
            ++index;
        }
        return -1;
    }

    private static final String extractString(byte[] buf, int len) {
        int headerLength = 3;
        return new String(buf, 3, len - 3);
    }

    public static String[] split(String s2, int ch) {
        int size = 0;
        int pos = 0;
        while (pos != -1) {
            pos = s2.indexOf(ch, pos + 1);
            ++size;
        }
        String[] res = new String[size];
        int i2 = 0;
        int p1 = 0;
        int p2 = s2.indexOf(ch);
        do {
            res[i2++] = s2.substring(p1, p2 == -1 ? s2.length() : p2);
            p1 = p2 + 1;
            p2 = s2.indexOf(ch, p1);
        } while (p1 != 0);
        return res;
    }
}

