/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.util.Logger;

public final class CharsetInfo {
    private static final String CHARSETS_RESOURCE_NAME = "net/sourceforge/jtds/jdbc/Charsets.properties";
    private static final HashMap charsets = new HashMap();
    private static final HashMap lcidToCharsetMap = new HashMap();
    private static final CharsetInfo[] sortToCharsetMap = new CharsetInfo[256];
    private final String charset;
    private final boolean wideChars;

    public static CharsetInfo getCharset(String serverCharset) {
        return (CharsetInfo)charsets.get(serverCharset.toUpperCase());
    }

    public static CharsetInfo getCharsetForLCID(int lcid) {
        return (CharsetInfo)lcidToCharsetMap.get(new Integer(lcid));
    }

    public static CharsetInfo getCharsetForSortOrder(int sortOrder) {
        return sortToCharsetMap[sortOrder];
    }

    public static CharsetInfo getCharset(byte[] collation) throws SQLException {
        CharsetInfo charset = collation[4] != 0 ? CharsetInfo.getCharsetForSortOrder(collation[4] & 0xFF) : CharsetInfo.getCharsetForLCID((collation[2] & 0xF) << 16 | (collation[1] & 0xFF) << 8 | collation[0] & 0xFF);
        if (charset == null) {
            throw new SQLException(Messages.get("error.charset.nocollation", Support.toHex(collation)), "2C000");
        }
        return charset;
    }

    public CharsetInfo(String descriptor) {
        this.wideChars = !descriptor.substring(0, 1).equals("1");
        this.charset = descriptor.substring(2);
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isWideChars() {
        return this.wideChars;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof CharsetInfo)) {
            return false;
        }
        CharsetInfo charsetInfo = (CharsetInfo)o2;
        return this.charset.equals(charsetInfo.charset);
    }

    public int hashCode() {
        return this.charset.hashCode();
    }

    public String toString() {
        return this.charset;
    }

    static {
        try {
            InputStream stream = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                stream = classLoader.getResourceAsStream(CHARSETS_RESOURCE_NAME);
            }
            if (stream == null) {
                stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){
                    static /* synthetic */ Class class$net$sourceforge$jtds$jdbc$CharsetInfo;

                    public Object run() {
                        ClassLoader loader = (class$net$sourceforge$jtds$jdbc$CharsetInfo == null ? (class$net$sourceforge$jtds$jdbc$CharsetInfo = 1.class$("net.sourceforge.jtds.jdbc.CharsetInfo")) : class$net$sourceforge$jtds$jdbc$CharsetInfo).getClassLoader();
                        if (loader == null) {
                            loader = ClassLoader.getSystemClassLoader();
                        }
                        return loader.getResourceAsStream(CharsetInfo.CHARSETS_RESOURCE_NAME);
                    }

                    static /* synthetic */ Class class$(String x0) {
                        try {
                            return Class.forName(x0);
                        }
                        catch (ClassNotFoundException x1) {
                            throw new NoClassDefFoundError(x1.getMessage());
                        }
                    }
                });
            }
            if (stream != null) {
                Properties tmp = new Properties();
                tmp.load(stream);
                HashMap instances = new HashMap();
                Enumeration<?> e2 = tmp.propertyNames();
                while (e2.hasMoreElements()) {
                    String key = (String)e2.nextElement();
                    CharsetInfo value = new CharsetInfo(tmp.getProperty(key));
                    CharsetInfo prevInstance = (CharsetInfo)instances.get(value.getCharset());
                    if (prevInstance != null) {
                        if (prevInstance.isWideChars() != value.isWideChars()) {
                            throw new IllegalStateException("Inconsistent Charsets.properties");
                        }
                        value = prevInstance;
                    }
                    if (key.startsWith("LCID_")) {
                        Integer lcid = new Integer(key.substring(5));
                        lcidToCharsetMap.put(lcid, value);
                        continue;
                    }
                    if (key.startsWith("SORT_")) {
                        CharsetInfo.sortToCharsetMap[Integer.parseInt((String)key.substring((int)5))] = value;
                        continue;
                    }
                    charsets.put(key, value);
                }
            } else {
                Logger.println("Can't load Charsets.properties");
            }
        }
        catch (IOException e3) {
            Logger.logException(e3);
        }
    }
}

