/*
 * Decompiled with CFR 0.152.
 */
package es.jmj.gdra;

import es.jmj.gdra.Gdra_deflib;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class Gdra_tcp {
    private String sDEST = null;
    private int iPORT = 0;
    private static boolean bDEBUG = false;
    public static final int SOCKET_TIMEOUT_LINE = 40000;
    public static final int SOCKET_TIMEOUT_OPEN = 30000;
    public static final int SOCKET_TIMEOUT_RESOLVE = 15000;
    public static final int SOCKET_BLOCK_SIZE = 1024;
    private Socket connection;
    private DataOutputStream output;
    private DataInputStream input;

    public Gdra_tcp(String sDEST, int iPORT) {
        this.sDEST = sDEST;
        this.iPORT = iPORT;
    }

    public static SocketAddress resolve(String sHost, int iPort) {
        InetSocketAddress sockaddr = null;
        long dStart = System.currentTimeMillis();
        long dTimeoutMs = 15000L;
        while (true) {
            try {
                InetAddress.getByName(sHost);
                sockaddr = new InetSocketAddress(sHost, iPort);
            }
            catch (Exception e2) {
                Gdra_deflib.Sleep(1000L);
                sockaddr = null;
                if (System.currentTimeMillis() - dStart <= dTimeoutMs) continue;
            }
            break;
        }
        if (bDEBUG) {
            if (sockaddr == null) {
                Gdra_deflib.Alert("[OpenErrResolve1] ");
            } else {
                Gdra_deflib.Alert("[OpenResolved] " + ((Object)sockaddr).toString());
            }
        }
        return sockaddr;
    }

    public boolean isClosed() {
        return this.output == null || this.input == null || this.connection == null;
    }

    public boolean open() {
        if (bDEBUG) {
            Gdra_deflib.Alert("[Open] " + this.sDEST + " : " + this.iPORT);
        }
        try {
            this.connection = new Socket();
            this.connection.setSoTimeout(40000);
            this.connection.connect(Gdra_tcp.resolve(this.sDEST, this.iPORT), 30000);
            if (bDEBUG) {
                Gdra_deflib.Alert("[OpenOk] " + this.sDEST + " : " + this.iPORT);
            }
        }
        catch (Exception e2) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[OpenE1] " + e2);
            }
            return false;
        }
        try {
            this.connection.setSoTimeout(40000);
            this.input = new DataInputStream(this.connection.getInputStream());
            this.output = new DataOutputStream(this.connection.getOutputStream());
        }
        catch (Exception e3) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[OpenErr2] " + e3);
            }
            return false;
        }
        return true;
    }

    public boolean close() {
        try {
            if (this.output != null) {
                this.output.flush();
                this.output.close();
                this.output = null;
            }
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recv(byte[] data, int iOffset, int iLen) {
        int iNow = 0;
        int iDone = 0;
        int iBlock = 0;
        if (data == null) {
            return 0;
        }
        if (iLen == 0) {
            return 0;
        }
        if (this.isClosed()) {
            return 0;
        }
        try {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Recv] max " + iLen);
            }
            do {
                if ((iBlock = iLen - iDone) > 1024) {
                    iBlock = 1024;
                }
                if ((iNow = this.input.read(data, iOffset + iDone, iBlock)) != -1) continue;
                if (bDEBUG) {
                    Gdra_deflib.Alert("[Recv] err line");
                }
                return 0;
            } while ((iDone += iNow) < iLen);
        }
        catch (Exception e2) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Recv] err excp line " + e2);
            }
            return 0;
        }
        if (bDEBUG) {
            Gdra_deflib.Alert("[Recv ok] sz= " + iDone);
        }
        return iDone;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitData(int dTimeoutMs) {
        try {
            if (this.isClosed()) {
                return -1;
            }
            long dStart = System.currentTimeMillis();
            do {
                if (this.input.available() != 0) {
                    return 1;
                }
                Gdra_deflib.Sleep(100L);
            } while (dTimeoutMs != 0 && System.currentTimeMillis() - dStart <= (long)dTimeoutMs);
            if (bDEBUG) {
                Gdra_deflib.Alert("[Wait] timeout");
            }
            return 0;
        }
        catch (Exception e2) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Wait] except :" + e2);
            }
            if (bDEBUG) {
                Gdra_deflib.Alert("[Wait] error");
            }
            return -1;
        }
    }

    public void flush() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.output.flush();
        }
        catch (IOException e2) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Flush] errorio=" + e2);
            }
            return;
        }
    }

    public int send(byte[] data, int iOffset, int iLen) {
        int iDone;
        boolean iNow = false;
        if (data == null) {
            return 0;
        }
        if (iLen == 0) {
            return 0;
        }
        if (this.isClosed()) {
            return 0;
        }
        try {
            int iBlock;
            if (bDEBUG) {
                Gdra_deflib.Alert("[Send] sz=" + iLen);
            }
            iDone = 0;
            do {
                if ((iBlock = iLen - iDone) > 1024) {
                    iBlock = 1024;
                }
                this.output.write(data, iOffset + iDone, iBlock);
            } while ((iDone += iBlock) < iLen);
        }
        catch (IOException e2) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Send] errorio=" + e2);
            }
            return 0;
        }
        catch (Exception e3) {
            if (bDEBUG) {
                Gdra_deflib.Alert("[Send] error=" + e3);
            }
            return 0;
        }
        if (bDEBUG) {
            Gdra_deflib.Alert("[Send] done=" + iDone);
        }
        return iDone;
    }

    public int id() {
        if (this.connection == null) {
            return 0;
        }
        return this.connection.hashCode();
    }
}

