/*
 * Decompiled with CFR 0.152.
 */
package es.jmj.gdra;

import java.security.MessageDigest;
import java.util.Arrays;

public class Gdra_cblock {
    public byte[] RAW = new byte[Gdra_cblock.getHEADERSIZE() + Gdra_cblock.getDATAMAXSIZE()];
    private final int gdr_dat_offset_TAG1 = 0;
    private final int gdr_dat_size_TAG1 = 1;
    private final int gdr_dat_TAG1 = 18;
    private final int gdr_dat_offset_TAG2 = 1;
    private final int gdr_dat_size_TAG2 = 1;
    private final int gdr_dat_TAG2 = 34;
    private final int gdr_dat_offset_CMD = 2;
    private final int gdr_dat_size_CMD = 1;
    private final int gdr_dat_offset_RESULT = 3;
    private final int gdr_dat_size_RESULT = 1;
    private final int gdr_dat_offset_NEXT = 4;
    private final int gdr_dat_size_NEXT = 1;
    private final int gdr_dat_offset_USER = 5;
    private final int gdr_dat_size_USER = 30;
    private final int gdr_dat_offset_CHKSUM = 35;
    private final int gdr_dat_size_CHKSUM = 1;
    private final int gdr_dat_offset_SZDATA = 36;
    private final int gdr_dat_size_SZDATA = 2;
    private final int gdr_dat_offset_EXTRA = 38;
    private final int gdr_dat_size_EXTRA = 12;
    private final int gdr_dat_offset_DATA = 50;
    public static final byte CMD_RECVDATA = 41;
    public static final byte CMD_SENDDATA = 51;
    private static final int MD5_ENCODE_MAX = 4096;
    private static final int MD5_ENCODE_BLOCK = 16;

    public void setCMD(byte CMD) {
        this.RAW[2] = CMD;
    }

    public void setRESULT(byte RESULT) {
        this.RAW[3] = RESULT;
    }

    public void setCHKSUM() {
        int sz = Gdra_cblock.getHEADERSIZE() + this.getDATASIZE();
        int chksum = 0;
        this.RAW[35] = 0;
        int i2 = 0;
        while (i2 < sz) {
            chksum = (byte)(chksum + this.RAW[i2]);
            ++i2;
        }
        this.RAW[35] = (byte)(0 - chksum);
    }

    public int getCMD() {
        return this.RAW[2];
    }

    public int getRESULT() {
        return this.RAW[3];
    }

    public boolean getCHKSUM() {
        int sz = Gdra_cblock.getHEADERSIZE() + this.getDATASIZE();
        byte chksum = 0;
        int i2 = 0;
        while (i2 < sz) {
            chksum = (byte)(chksum + this.RAW[i2]);
            ++i2;
        }
        return chksum == 0;
    }

    public boolean getTAG() {
        return this.RAW[0] == 18 && this.RAW[1] == 34;
    }

    public void setTAG() {
        this.RAW[0] = 18;
        this.RAW[1] = 34;
    }

    public void setDATA(byte[] data) {
        try {
            Arrays.fill(this.RAW, 50, Gdra_cblock.getDATAMAXSIZE(), (byte)0);
            int sz = data.length;
            if (sz > Gdra_cblock.getDATAMAXSIZE()) {
                sz = Gdra_cblock.getDATAMAXSIZE();
            }
            System.arraycopy(data, 0, this.RAW, 50, sz);
            this.setDATASIZE(sz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getDATA() {
        try {
            short szData = (short)this.getDATASIZE();
            byte[] bResult = new byte[szData];
            System.arraycopy(this.RAW, 50, bResult, 0, szData);
            return bResult;
        }
        catch (Exception exception) {
            return new byte[1];
        }
    }

    public void setNEXT(boolean bNEXT) {
        this.RAW[4] = bNEXT ? (byte)1 : 0;
    }

    public boolean getNEXT() {
        return this.RAW[4] != 0;
    }

    public void setDATASIZE(int iSize) {
        short szData = (short)iSize;
        this.RAW[36] = Gdra_cblock.LOBYTE(szData);
        this.RAW[37] = Gdra_cblock.HIBYTE(szData);
    }

    public int getDATASIZE() {
        return (short)Gdra_cblock.MAKEWORD(this.RAW[36], this.RAW[37]);
    }

    public static int getHEADERSIZE() {
        return 50;
    }

    public static int getDATAMAXSIZE() {
        return 1000;
    }

    public String getUSER() {
        return this.getPartialData(false, 5, 30);
    }

    public void setUSER(String sUser) {
        this.setPartialData(5, 30, sUser);
    }

    public boolean setHASH(boolean bEncode, String sUser, String sPass) {
        byte[] secret = sPass.getBytes();
        byte[] handshake = sUser.getBytes();
        this.setUSER(sUser);
        if (bEncode) {
            int szData = Gdra_cblock.MD5_encode(this.RAW, Gdra_cblock.getHEADERSIZE(), this.getDATASIZE(), secret, 0, secret.length, handshake, 0, handshake.length, this.RAW, Gdra_cblock.getHEADERSIZE());
            this.setDATASIZE(szData);
        } else {
            int szData = Gdra_cblock.MD5_decode(this.RAW, Gdra_cblock.getHEADERSIZE(), this.getDATASIZE(), secret, 0, secret.length, handshake, 0, handshake.length, this.RAW, Gdra_cblock.getHEADERSIZE());
            this.setDATASIZE(szData);
        }
        return true;
    }

    private String getPartialData(boolean raw, int offset, int size) {
        String sResult = null;
        try {
            byte[] rawbytes = new byte[size];
            System.arraycopy(this.RAW, offset, rawbytes, 0, size);
            if (raw) {
                sResult = new String(rawbytes);
            } else {
                int i2 = 0;
                while (i2 < rawbytes.length && rawbytes[i2] != 0) {
                    ++i2;
                }
                sResult = new String(rawbytes, 0, i2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sResult;
    }

    private void setPartialData(int offset, int size, String data) {
        try {
            Arrays.fill(this.RAW, offset, size, (byte)0);
            int sz = data.length();
            if (sz > size) {
                sz = size;
            }
            System.arraycopy(data.getBytes(), 0, this.RAW, offset, sz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte LOBYTE(short wWORD) {
        return (byte)(wWORD & 0xFF);
    }

    public static byte HIBYTE(short wWORD) {
        return (byte)(wWORD >> 8 & 0xFF);
    }

    public static int MAKEWORD(short LOWORD, short HIWORD) {
        return LOWORD & 0xFF | HIWORD << 8;
    }

    public static boolean MD5_hash(byte[] source, int iSZsouce, byte[] dest) {
        try {
            MessageDigest m2 = MessageDigest.getInstance("MD5");
            m2.update(source, 0, iSZsouce);
            m2.digest(dest, 0, 16);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int MEMSET(byte[] dest, int iOffsetDest, byte bChar, int iSize) {
        Arrays.fill(dest, iOffsetDest, iOffsetDest + iSize, bChar);
        return 0;
    }

    public static int MEMCPY(byte[] dest, int iOffsetDest, byte[] source, int iOffsetSource, int iSize) {
        System.arraycopy(source, iOffsetSource, dest, iOffsetDest, iSize);
        return 0;
    }

    public static int MD5_encode(byte[] data, int iOffsetData, int iSZdata, byte[] secret, int iOffsetSecret, int iSZsecret, byte[] seed, int iOffsetSeed, int iSZseed, byte[] dest, int iOffsetDest) {
        byte[] buffer = new byte[4097];
        byte[] digest = new byte[16];
        byte[] tmpData = new byte[4096];
        int len = 0;
        try {
            int i2;
            int n2;
            len = iSZdata;
            if (len >= 4096) {
                len = 4096;
            }
            iSZdata = len;
            Gdra_cblock.MEMCPY(tmpData, 0, data, iOffsetData, iSZdata);
            if (len % 16 != 0) {
                n2 = 16 - len % 16;
                i2 = len;
                while (n2 > 0) {
                    tmpData[i2] = 0;
                    --n2;
                    ++i2;
                }
                len = iSZdata = i2;
            } else if (len == 0) {
                Gdra_cblock.MEMSET(tmpData, 0, (byte)0, 16);
                len = 16;
                iSZdata = 16;
            }
            Gdra_cblock.MEMCPY(buffer, 0, secret, iOffsetSecret, iSZsecret);
            Gdra_cblock.MEMCPY(buffer, iSZsecret, seed, iOffsetSeed, iSZseed);
            Gdra_cblock.MD5_hash(buffer, iSZsecret + iSZseed, digest);
            i2 = 0;
            while (i2 < 16) {
                int n3 = i2;
                tmpData[n3] = (byte)(tmpData[n3] ^ digest[i2]);
                ++i2;
            }
            if (len <= 16) {
                Gdra_cblock.MEMCPY(dest, iOffsetDest, tmpData, 0, len);
                return len;
            }
            n2 = 0;
            while (n2 < 4096 && n2 <= len - 16) {
                Gdra_cblock.MEMCPY(buffer, iSZsecret, tmpData, n2, 16);
                Gdra_cblock.MD5_hash(buffer, iSZsecret + 16, digest);
                i2 = 0;
                while (i2 < 16) {
                    int n4 = i2 + n2 + 16;
                    tmpData[n4] = (byte)(tmpData[n4] ^ digest[i2]);
                    ++i2;
                }
                n2 += 16;
            }
            Gdra_cblock.MEMCPY(dest, iOffsetDest, tmpData, 0, len);
            return len;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int MD5_decode(byte[] data, int iOffsetData, int iSZdata, byte[] secret, int iOffsetSecret, int iSZsecret, byte[] seed, int iOffsetSeed, int iSZseed, byte[] dest, int iOffsetDest) {
        byte[] buffer = new byte[4097];
        byte[] digest = new byte[16];
        byte[] r2 = new byte[16];
        byte[] tmpData = new byte[4096];
        try {
            int rlen;
            if (iSZdata >= 4096) {
                iSZdata = 4096;
            }
            Gdra_cblock.MEMCPY(tmpData, 0, data, iOffsetData, iSZdata);
            Gdra_cblock.MEMCPY(buffer, 0, secret, iOffsetSecret, iSZsecret);
            Gdra_cblock.MEMCPY(buffer, iSZsecret, seed, iOffsetSeed, iSZseed);
            Gdra_cblock.MD5_hash(buffer, iSZsecret + iSZseed, digest);
            Gdra_cblock.MEMCPY(r2, 0, tmpData, 0, 16);
            int i2 = 0;
            while (i2 < 16 && i2 < iSZdata) {
                int n2 = i2;
                tmpData[n2] = (byte)(tmpData[n2] ^ digest[i2]);
                ++i2;
            }
            if (iSZdata <= 16) {
                Gdra_cblock.MEMCPY(dest, iOffsetDest, tmpData, 0, iSZdata);
                return iSZdata;
            }
            int n3 = rlen = (iSZdata - 1) / 16 * 16;
            while (n3 > 0) {
                if (n3 == 16) {
                    Gdra_cblock.MEMCPY(buffer, iSZsecret, r2, 0, 16);
                } else {
                    Gdra_cblock.MEMCPY(buffer, iSZsecret, tmpData, n3 - 16, 16);
                }
                Gdra_cblock.MD5_hash(buffer, iSZsecret + 16, digest);
                i2 = 0;
                while (i2 < 16 && i2 + n3 < iSZdata) {
                    int n4 = i2 + n3;
                    tmpData[n4] = (byte)(tmpData[n4] ^ digest[i2]);
                    ++i2;
                }
                n3 -= 16;
            }
            Gdra_cblock.MEMCPY(dest, iOffsetDest, tmpData, 0, iSZdata);
            return iSZdata;
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

