/*
 * Decompiled with CFR 0.152.
 */
import es.jmj.gdra.Gdra_dat;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class Gdr_sql {
    private Gdr_main display;
    private Gdr_config config;
    private boolean sql_started = false;
    private Connection sql_connection = null;
    private Statement sql_statement = null;

    public Gdr_sql(Gdr_main display, Gdr_config config) {
        this.display = display;
        this.config = config;
    }

    private String sql_mysql_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(mysql).E!";
        try {
            if (this.sql_statement != null && this.sql_statement.isClosed()) {
                this.sql_started = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 3306;
        }
        try {
            String sCONSTR = "jdbc:mysql://" + sServer + ":" + iPort + "/" + sDb;
            this.display.addlog("SQL (mysql): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("com.mysql.jdbc.Driver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL (mysql): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL (mysql): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_ms2000_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(ms2000).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1433;
        }
        try {
            String sCONSTR = "jdbc:jtds:sqlserver://" + sServer + ":" + iPort + "/" + sDb;
            this.display.addlog("SQL (ms2000): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL (ms2000): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL (ms2000): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_oracle_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(oracle).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1521;
        }
        try {
            String sCONSTR = "jdbc:oracle:thin:@" + sServer + ":" + iPort + ":" + sDb;
            this.display.addlog("SQL (Oracle): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL (Oracle): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL (Oracle): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_oracle1_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(oracle1).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1521;
        }
        try {
            String sCONSTR = "(DESCRIPTION = (ADDRESS_LIST = (ADDRESS = (PROTOCOL=TCP)(HOST=" + sServer + ")(PORT=" + iPort + "))    )    (CONNECT_DATA=(SERVICE_NAME=" + sDb + "))  )";
            this.display.addlog("SQL(Oracle1): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL(Oracle1): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL(Oracle1): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_oracle2_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(oracle2).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1521;
        }
        try {
            String sCONSTR = "jdbc:oracle:thin:@" + sServer + ":" + iPort + "/" + sDb;
            this.display.addlog("SQL(Oracle2): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL(Oracle2): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL(Oracle2): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_oracle3_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(oracle3).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1521;
        }
        try {
            String sCONSTR = "jdbc:oracle:thin:@//" + sServer + ":" + iPort + "/" + sDb;
            this.display.addlog("SQL(Oracle3): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL(Oracle3): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL(Oracle3): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_progress_start(String sServer, int iPort, String sDb, String sUsr, String sPass) {
        String sError = "SQL(progress).E!";
        if (this.sql_started) {
            return null;
        }
        if (iPort == 0) {
            iPort = 1521;
        }
        try {
            String sCONSTR = "jdbc:oracle:thin:@//" + sServer + ":" + iPort + "/" + sDb;
            this.display.addlog("SQL(progress): " + sCONSTR + " " + "(" + sUsr + ") ...");
            Class.forName("oracle.jdbc.driver.OracleDriver");
            this.sql_connection = DriverManager.getConnection(sCONSTR, sUsr, sPass);
            this.sql_statement = this.sql_connection.createStatement();
            this.display.addlog("SQL(progress): Conectados.");
            this.sql_started = true;
            return null;
        }
        catch (Exception ex) {
            sError = "SQL(progress): ERROR " + ex;
            this.display.addlog(sError);
            return sError;
        }
    }

    private String sql_start() {
        if (this.sql_started) {
            this.display.addlog("SQL-seems connect");
            try {
                if (this.sql_connection.isClosed()) {
                    this.sql_end();
                }
            }
            catch (Exception ex) {
                this.display.addlog("SQL-reconnect");
                this.sql_end();
            }
        }
        String sResult = null;
        switch (this.config.getSQL_Mode()) {
            case 501: {
                sResult = this.sql_mysql_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 2000: {
                sResult = this.sql_ms2000_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 401: {
                sResult = this.sql_oracle_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 411: {
                sResult = this.sql_oracle1_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 421: {
                sResult = this.sql_oracle2_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 431: {
                sResult = this.sql_oracle3_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            case 500: {
                sResult = this.sql_progress_start(this.config.getSQL_Server(), this.config.getSQL_Port(), this.config.getSQL_DB(), this.config.getSQL_User(), this.config.getSQL_Pass());
                break;
            }
            default: {
                sResult = "SQL:Type not allowed:" + this.config.getSQL_Mode();
            }
        }
        if (sResult != null) {
            this.display.addlog(sResult);
        }
        return sResult;
    }

    private boolean sql_end() {
        if (!this.sql_started) {
            return true;
        }
        try {
            this.sql_connection.close();
        }
        catch (SQLException error) {
            this.display.addlog("SQL end ERROR :" + error);
        }
        this.sql_connection = null;
        this.sql_started = false;
        return true;
    }

    int exists(Gdra_dat data) {
        String sQuery;
        block6: {
            int accion = 0;
            sQuery = null;
            ResultSet rs = null;
            sQuery = this.getSelectDataSentence(data);
            rs = this.sql_statement.executeQuery(sQuery);
            if (!rs.next()) break block6;
            accion = rs.getInt(Gdra_dat.getNameACCION());
            switch (accion) {
                case 1: 
                case 2: 
                case 3: {
                    this.display.addlog("1 <-(" + accion + ") " + sQuery);
                    return 1;
                }
            }
            try {
                this.display.addlog("-1 <-(" + accion + ") " + sQuery);
                return -1;
            }
            catch (Exception e2) {
                this.display.addlog("EXISTS:" + e2);
                this.sql_end();
                this.sql_start();
            }
        }
        this.display.addlog("0 <- " + sQuery);
        return 0;
    }

    boolean update(Gdra_dat data) {
        boolean bUpdated = false;
        String sUpdate = this.getUpdateDataSentence(data);
        try {
            int rows = this.sql_statement.executeUpdate(sUpdate);
            if (rows == 1) {
                bUpdated = true;
            }
        }
        catch (Exception e2) {
            this.display.addlog("UPDATE:" + e2);
        }
        this.display.addlog(bUpdated + " <- " + sUpdate);
        return bUpdated;
    }

    boolean insert(Gdra_dat data) {
        boolean bInserted = false;
        String sInsert = this.getInsertDataSentence(data);
        try {
            int rows = this.sql_statement.executeUpdate(sInsert);
            if (rows == 1) {
                bInserted = true;
            }
        }
        catch (Exception e2) {
            this.display.addlog("INSERT:" + e2);
        }
        this.display.addlog(bInserted + " <- " + sInsert);
        return bInserted;
    }

    public boolean dataFitData(List<Gdra_dat> datas) {
        String sError = null;
        Gdra_dat data = null;
        this.display.addlog("dataFit(" + datas.size() + ").in");
        sError = this.sql_start();
        if (sError == null) {
            int datas_size = datas.size();
            int i2 = 0;
            while (i2 < datas_size) {
                boolean bResult;
                this.display.addlog("dataFit(" + datas.size() + ") [" + i2 + "]");
                data = datas.get(i2);
                switch (this.exists(data)) {
                    case 1: {
                        bResult = this.update(data);
                        break;
                    }
                    case 0: {
                        bResult = this.insert(data);
                        break;
                    }
                    default: {
                        bResult = true;
                    }
                }
                if (!bResult) {
                    return false;
                }
                ++i2;
            }
            this.display.addlog("dataFit(" + datas.size() + ").done");
            return true;
        }
        this.display.addlog("dataFit(" + datas.size() + ").sqldown");
        return false;
    }

    public List<Gdra_dat> dataGet(String sTractora, String sIdapli) {
        String sError = null;
        LinkedList<Gdra_dat> datas = null;
        ResultSet results = null;
        String query = null;
        int regnum = 0;
        sError = this.sql_start();
        if (sError == null) {
            Gdra_dat data;
            query = "SELECT * FROM " + this.config.getSQL_Table_Data() + " WHERE " + Gdra_dat.getNameACCION() + "=1 ";
            if (!sTractora.equals("")) {
                query = String.valueOf(query) + " AND " + Gdra_dat.getNameTRACTORA() + " = '" + sTractora + "'";
            }
            if (!sIdapli.equals("")) {
                query = String.valueOf(query) + " AND " + Gdra_dat.getNameIDEAPLIC() + " = '" + sIdapli + "'";
            }
            try {
                this.display.addlog("SQL: " + query);
                results = this.sql_statement.executeQuery(query);
                if (!results.next()) {
                    this.display.addlog("SQL: no results!");
                    return null;
                }
            }
            catch (Exception e2) {
                sError = "SQL get ERROR : " + e2;
                this.display.addlog(sError);
                return null;
            }
            try {
                regnum = 0;
                if (datas == null) {
                    datas = new LinkedList<Gdra_dat>();
                }
                while ((data = this.getDatFromCursor(results, ++regnum)) != null) {
                    datas.add(data);
                    if (results.next()) continue;
                }
                this.display.addlog("=" + regnum);
            }
            catch (Exception e3) {
                sError = "SQL get2 ERROR : " + e3;
                this.display.addlog(sError);
                return null;
            }
            query = "SELECT * FROM " + this.config.getSQL_Table_Tipo();
            try {
                this.display.addlog("SQLt: " + query);
                results = this.sql_statement.executeQuery(query);
                if (results.next()) {
                    regnum = 0;
                    if (datas == null) {
                        datas = new LinkedList();
                    }
                    do {
                        ++regnum;
                        data = this.getTipoFromCursor(results);
                        if (data == null) break;
                        datas.add(data);
                    } while (results.next());
                    this.display.addlog("=" + regnum);
                }
            }
            catch (Exception e4) {
                sError = "SQL get tipos ERROR : " + e4;
                this.display.addlog(sError);
                return null;
            }
            query = "SELECT * FROM " + this.config.getSQL_Table_Inci();
            try {
                this.display.addlog("SQLt: " + query);
                results = this.sql_statement.executeQuery(query);
                if (results.next()) {
                    regnum = 0;
                    if (datas == null) {
                        datas = new LinkedList();
                    }
                    do {
                        ++regnum;
                        data = this.getInciFromCursor(results);
                        if (data == null) break;
                        datas.add(data);
                    } while (results.next());
                    this.display.addlog("=" + regnum);
                }
            }
            catch (Exception e5) {
                sError = "SQL get tipos ERROR : " + e5;
                this.display.addlog(sError);
                return null;
            }
        }
        return datas;
    }

    public String getUserPass(String sUser) {
        String sError = null;
        String sPASS = null;
        ResultSet results = null;
        String query = null;
        sError = this.sql_start();
        if (sError == null) {
            query = "SELECT * FROM " + this.config.getSQL_Table_User() + " WHERE usuario='" + sUser + "'";
            try {
                this.display.addlog("SQLu: " + query);
                results = this.sql_statement.executeQuery(query);
                if (!results.next()) {
                    return null;
                }
            }
            catch (Exception e2) {
                sError = "SQL usr1 ERROR : " + e2;
                this.display.addlog(sError);
                return null;
            }
            try {
                sPASS = results.getString("clave");
            }
            catch (Exception e3) {
                sError = "SQL usr2 ERROR : " + e3;
                this.display.addlog(sError);
                return null;
            }
        }
        this.display.addlog(sError);
        return sPASS;
    }

    public String getSelectDataSentence(Gdra_dat data) {
        String sComplex = "SELECT * FROM " + this.config.getSQL_Table_Data() + " WHERE " + Gdra_dat.getNameNUMRUTA() + "=" + Gdra_dat.str2num(data.getNUMRUTA()) + " AND " + Gdra_dat.getNameNUMORDEN() + "=" + Gdra_dat.str2num(data.getNUMORDEN()) + " AND " + Gdra_dat.getNameCODUBICR() + "=" + Gdra_dat.str2num(data.getCODUBICR()) + ";";
        return sComplex;
    }

    public String getInsertDataSentence(Gdra_dat dat) {
        String sColumns = "(" + Gdra_dat.getNameNUMRUTA() + "," + Gdra_dat.getNameNOMRUTA() + "," + Gdra_dat.getNameNUMORDEN() + "," + Gdra_dat.getNameCODUBICR() + "," + Gdra_dat.getNameNUMCONTENEDOR() + "," + Gdra_dat.getNameCODCONTENEDOR() + "," + Gdra_dat.getNameNOMCONTENEDOR() + "," + Gdra_dat.getNameCAPCONTENEDOR() + "," + Gdra_dat.getNameTRACTORA() + "," + Gdra_dat.getNameSEMIREMOLQUE() + "," + Gdra_dat.getNameCONDUCTOR() + "," + Gdra_dat.getNamePAIS() + "," + Gdra_dat.getNamePROVINCIA() + "," + Gdra_dat.getNameLOCALIDAD() + "," + Gdra_dat.getNamePUEBLO() + "," + Gdra_dat.getNameNOMCALLE() + "," + Gdra_dat.getNameGPSLAT() + "," + Gdra_dat.getNameGPSLONG() + "," + Gdra_dat.getNameIDEAPLIC() + "," + Gdra_dat.getNameINCIDENCIAS() + "," + Gdra_dat.getNameRECOGIDO() + "," + Gdra_dat.getNameACCION() + "," + Gdra_dat.getNameESTADO() + "," + Gdra_dat.getNameFECHA() + "," + Gdra_dat.getNameFECHA2() + "," + Gdra_dat.getNameFecUltRe() + "," + Gdra_dat.getNameKMINI() + "," + Gdra_dat.getNameKMFIN() + "," + "NumRutaPred,RecogidoKGS,RepartidoKGS,CodPais,CodProvi," + "CodLoca,CodPuebl," + "FechaRuta," + "HorarioRecogida," + Gdra_dat.getNameIDSEMI() + "," + Gdra_dat.getNameIDNUEVO() + "," + Gdra_dat.getNameCENSADO() + ")";
        Date now = new Date();
        String sTimeStamp = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss", Locale.getDefault()).format(now);
        String sValues = "VALUES (" + Gdra_dat.str2num(dat.getNUMRUTA()) + "," + "'" + dat.getNOMRUTA() + "'," + Gdra_dat.str2num(dat.getNUMORDEN()) + "," + "'" + dat.getCODUBICR() + "'," + "'" + dat.getNUMCONTENEDOR() + "'," + "'" + dat.getCODCONTENEDOR() + "'," + "'" + dat.getNOMCONTENEDOR() + "'," + "'" + dat.getCAPCONTENEDOR() + "'," + "'" + dat.getTRACTORA() + "'," + "'" + dat.getSEMIREMOLQUE() + "'," + "'" + dat.getCONDUCTOR() + "'," + "'" + dat.getPAIS() + "'," + "'" + dat.getPROVINCIA() + "'," + "'" + dat.getLOCALIDAD() + "'," + "'" + dat.getPUEBLO() + "'," + "'" + dat.getNOMCALLE() + "'," + Gdra_dat.str2float(dat.getGPSLAT()) + "," + Gdra_dat.str2float(dat.getGPSLONG()) + "," + "'" + dat.getIDEAPLIC() + "'," + "'" + dat.getINCIDENCIAS() + "'," + "'" + dat.getRECOGIDO() + "'," + Gdra_dat.str2num(dat.getACCION()) + "," + "'" + dat.getESTADO() + "'," + "'" + dat.getFECHA() + "'," + "'" + dat.getFECHA2() + "'," + "'" + dat.getFecUltRe() + "'," + "'" + dat.getKMINI() + "'," + "'" + dat.getKMFIN() + "'," + "0,0,0,0,0," + "0,0," + "'" + sTimeStamp + "'," + "''," + "'" + dat.getIDSEMI() + "'," + "'" + dat.getIDNUEVO() + "'," + "'" + dat.getCENSADO() + "'" + ")";
        String sComplex = "INSERT INTO " + this.config.getSQL_Table_Data() + " " + sColumns + " " + sValues + "\r\n";
        return sComplex;
    }

    public String getUpdateDataSentence(Gdra_dat dat) {
        String sSET = "SET ";
        sSET = String.valueOf(sSET) + " " + Gdra_dat.getNameNUMRUTA() + "=" + Gdra_dat.str2num(dat.getNUMRUTA()) + "," + " " + Gdra_dat.getNameCODCONTENEDOR() + "='" + dat.getCODCONTENEDOR() + "'," + " " + Gdra_dat.getNameNOMCONTENEDOR() + "='" + dat.getNOMCONTENEDOR() + "'," + " " + Gdra_dat.getNameCAPCONTENEDOR() + "='" + dat.getCAPCONTENEDOR() + "'," + " " + Gdra_dat.getNameTRACTORA() + "='" + dat.getTRACTORA() + "'," + " " + Gdra_dat.getNameSEMIREMOLQUE() + "='" + dat.getSEMIREMOLQUE() + "'," + " " + Gdra_dat.getNameCONDUCTOR() + "='" + dat.getCONDUCTOR() + "'," + " " + Gdra_dat.getNamePAIS() + "='" + dat.getPAIS() + "'," + " " + Gdra_dat.getNamePROVINCIA() + "='" + dat.getPROVINCIA() + "'," + " " + Gdra_dat.getNameLOCALIDAD() + "='" + dat.getLOCALIDAD() + "'," + " " + Gdra_dat.getNamePUEBLO() + "='" + dat.getPUEBLO() + "'," + " " + Gdra_dat.getNameNOMCALLE() + "='" + dat.getNOMCALLE() + "'," + " " + Gdra_dat.getNameGPSLAT() + "=" + Gdra_dat.str2float(dat.getGPSLAT()) + "," + " " + Gdra_dat.getNameGPSLONG() + "=" + Gdra_dat.str2float(dat.getGPSLONG()) + "," + " " + Gdra_dat.getNameINCIDENCIAS() + "='" + dat.getINCIDENCIAS() + "'," + " " + Gdra_dat.getNameRECOGIDO() + "='" + dat.getRECOGIDO() + "'," + " " + Gdra_dat.getNameACCION() + "=" + Gdra_dat.str2num(dat.getACCION()) + "," + " " + Gdra_dat.getNameESTADO() + "='" + dat.getESTADO() + "'," + " " + Gdra_dat.getNameFECHA() + "='" + dat.getFECHA() + "'," + " " + Gdra_dat.getNameFECHA2() + "='" + dat.getFECHA2() + "'," + " " + Gdra_dat.getNameFecUltRe() + "='" + dat.getFecUltRe() + "'," + " " + Gdra_dat.getNameKMINI() + "='" + dat.getKMINI() + "'," + " " + Gdra_dat.getNameKMFIN() + "='" + dat.getKMFIN() + "'," + " " + Gdra_dat.getNameIDSEMI() + "='" + dat.getIDSEMI() + "'," + " " + Gdra_dat.getNameIDNUEVO() + "='" + dat.getIDNUEVO() + "'," + " " + Gdra_dat.getNameCENSADO() + "='" + dat.getCENSADO() + "' ";
        String sUpdate = "UPDATE " + this.config.getSQL_Table_Data() + " " + sSET + " WHERE " + Gdra_dat.getNameNUMRUTA() + "=" + Gdra_dat.str2num(dat.getNUMRUTA()) + " AND " + Gdra_dat.getNameNUMORDEN() + "=" + Gdra_dat.str2num(dat.getNUMORDEN()) + " AND " + Gdra_dat.getNameCODUBICR() + "=" + Gdra_dat.str2num(dat.getCODUBICR());
        return sUpdate;
    }

    public Gdra_dat getDatFromCursor(ResultSet result, int regnum) {
        Gdra_dat data = null;
        try {
            data = new Gdra_dat();
            data.setTag(1);
            data.setREG(regnum * 10 + result.getInt(Gdra_dat.getNameNUMRUTA()) * 10000);
            data.setNUMRUTA(Gdra_dat.num2str(result.getInt(Gdra_dat.getNameNUMRUTA())));
            data.setNOMRUTA(result.getString(Gdra_dat.getNameNOMRUTA()));
            data.setNUMORDEN(Gdra_dat.num2str(result.getInt(Gdra_dat.getNameNUMORDEN())));
            data.setCODUBICR(result.getString(Gdra_dat.getNameCODUBICR()));
            data.setNUMCONTENEDOR(result.getString(Gdra_dat.getNameNUMCONTENEDOR()));
            data.setCODCONTENEDOR(result.getString(Gdra_dat.getNameCODCONTENEDOR()));
            data.setNOMCONTENEDOR(result.getString(Gdra_dat.getNameNOMCONTENEDOR()));
            data.setCAPCONTENEDOR(result.getString(Gdra_dat.getNameCAPCONTENEDOR()));
            data.setTRACTORA(result.getString(Gdra_dat.getNameTRACTORA()));
            data.setSEMIREMOLQUE(result.getString(Gdra_dat.getNameSEMIREMOLQUE()));
            data.setCONDUCTOR(result.getString(Gdra_dat.getNameCONDUCTOR()));
            data.setGPSLAT(Gdra_dat.float2str(result.getFloat(Gdra_dat.getNameGPSLAT())));
            data.setGPSLONG(Gdra_dat.float2str(result.getFloat(Gdra_dat.getNameGPSLONG())));
            data.setIDEAPLIC(result.getString(Gdra_dat.getNameIDEAPLIC()));
            data.setINCIDENCIAS(result.getString(Gdra_dat.getNameINCIDENCIAS()));
            data.setRECOGIDO(result.getString(Gdra_dat.getNameRECOGIDO()));
            data.setACCION(Gdra_dat.num2str(result.getInt(Gdra_dat.getNameACCION())));
            data.setESTADO(result.getString(Gdra_dat.getNameESTADO()));
            data.setPAIS(result.getString(Gdra_dat.getNamePAIS()));
            data.setPROVINCIA(result.getString(Gdra_dat.getNamePROVINCIA()));
            data.setPUEBLO(result.getString(Gdra_dat.getNamePUEBLO()));
            data.setNOMCALLE(result.getString(Gdra_dat.getNameNOMCALLE()));
            data.setLOCALIDAD(result.getString(Gdra_dat.getNameLOCALIDAD()));
            data.setFECHA(result.getString(Gdra_dat.getNameFECHA()));
            data.setFECHA2(result.getString(Gdra_dat.getNameFECHA2()));
            data.setFecUltRe(result.getString(Gdra_dat.getNameFecUltRe()));
            data.setKMINI(result.getString(Gdra_dat.getNameKMINI()));
            data.setKMFIN(result.getString(Gdra_dat.getNameKMFIN()));
            data.setIDSEMI(result.getString(Gdra_dat.getNameIDSEMI()));
            data.setIDNUEVO(result.getString(Gdra_dat.getNameIDNUEVO()));
            data.setCENSADO(result.getString(Gdra_dat.getNameCENSADO()));
        }
        catch (Exception e2) {
            this.display.addlog("SQLgd: " + e2);
        }
        return data;
    }

    public Gdra_dat getTipoFromCursor(ResultSet result) {
        Gdra_dat data = null;
        try {
            data = new Gdra_dat();
            data.setTag(3);
            data.setREG(Gdra_dat.str2num(result.getString("CodContenedor")));
            data.setMULTIPLE(result.getString("NomContenedor"));
            data.setCODCONTENEDOR(result.getString("CodContenedor"));
            data.setCAPCONTENEDOR(result.getString("Capacidad"));
            data.setNOMCONTENEDOR(result.getString("NomContenedor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public Gdra_dat getInciFromCursor(ResultSet result) {
        Gdra_dat data = null;
        try {
            data = new Gdra_dat();
            data.setTag(2);
            data.setREG(Gdra_dat.str2num(result.getString("id")));
            data.setMULTIPLE(result.getString("Descripcion"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }
}

