/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class Gdr_main
extends JFrame {
    private static int app_Ancho = 580;
    private static int app_Alto = 450;
    private static final String gdr_version = "GDR 25.G25A";
    private static final String gdr_info = "Conector de datos para recogidas";
    private JTextField edit;
    private JList list;
    private DefaultListModel listdata;
    private Gdr_config config;
    private Gdr_debug debug;
    private Gdr_tcp server;
    private Gdr_sql sql;
    private static Gdr_main display;
    private static int IO;
    private static int CLOSE;
    private int cons = 0;
    private int cons_top = 0;
    private long lRecv;
    private long lSend;
    private long lCmds;
    private int screenLines = 0;

    static {
        IO = 1;
        CLOSE = 0;
    }

    public void updateStatus() {
        if (this.edit != null) {
            this.edit.setText("Conexiones:" + this.cons + " (" + this.cons_top + ")" + "     Comandos:" + this.lCmds + "     KB.in:" + this.lRecv / 1024L + "     KB.out:" + this.lSend / 1024L + "         Inicio: " + Gdr_debug.getUpTime());
        }
    }

    public void addCon() {
        ++this.cons_top;
        ++this.cons;
        this.updateStatus();
    }

    public void delCon() {
        --this.cons;
        this.updateStatus();
    }

    public void addCounters(int iRecv, int iSend) {
        this.lRecv += (long)iRecv;
        this.lSend += (long)iSend;
    }

    public void addCommand() {
        ++this.lCmds;
        this.updateStatus();
    }

    public void addlog(String str) {
        if (this.screenLines > 128) {
            if (this.listdata != null) {
                this.listdata.clear();
            }
            if (this.listdata != null) {
                this.listdata.addElement("Clean Screen");
            }
            this.screenLines = 0;
        }
        Gdr_debug.addlog(str);
        String strlog = Gdr_debug.formatlinelog(str);
        if (this.listdata != null) {
            this.listdata.addElement(strlog);
        }
        if (this.list != null) {
            this.list.ensureIndexIsVisible(this.screenLines);
        }
        ++this.screenLines;
    }

    public void addlogDepth(String str) {
        this.addlog(str);
    }

    public void clearScreen() {
        if (this.listdata != null) {
            this.listdata.clear();
        }
        if (this.listdata != null) {
            this.listdata.addElement("Clean Screen.");
        }
        this.screenLines = 0;
    }

    public void infoScreen() {
        String sinfo = "GDR 25.G25A\r\nConector de datos para recogidas\r\n\r\n" + System.getProperty("user.dir") + "\r\n\r\n";
        if (this.config != null) {
            sinfo = String.valueOf(sinfo) + "P" + this.config.getTCP_Port() + " " + this.config.getSQL_Server() + ":" + this.config.getSQL_Port() + " " + this.config.getSQL_DB() + "\r\n\r\n";
        }
        JOptionPane.showMessageDialog(null, sinfo, gdr_version, 1);
    }

    public Gdr_main() {
        super(gdr_version);
        if (IO != 0) {
            JMenu MainMenu = new JMenu("Opciones");
            MainMenu.setMnemonic(79);
            JMenuItem MainMenu_CLEARSCREEN = new JMenuItem("Limpiar pantalla");
            MainMenu.add(MainMenu_CLEARSCREEN);
            MainMenu_CLEARSCREEN.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    Gdr_main.this.clearScreen();
                }
            });
            MainMenu.addSeparator();
            JMenuItem MainMenu_INFOSCREEN = new JMenuItem("Acerca de...");
            MainMenu.add(MainMenu_INFOSCREEN);
            MainMenu_INFOSCREEN.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    Gdr_main.this.infoScreen();
                }
            });
            JMenuBar MainMenu_Container = new JMenuBar();
            MainMenu_Container.add(MainMenu);
            this.setJMenuBar(MainMenu_Container);
            this.listdata = new DefaultListModel();
            this.list = new JList(this.listdata);
            this.list.setAutoscrolls(true);
            JScrollPane barra = new JScrollPane(this.list);
            this.edit = new JTextField("");
            this.edit.setEditable(false);
            this.addlog(gdr_version);
            this.updateStatus();
            display = this;
            display.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e2) {
                    display.repaint();
                }

                @Override
                public void windowClosing(WindowEvent e2) {
                    int i2 = JOptionPane.showConfirmDialog(display, "\u00bfCerrar servidor?", Gdr_main.gdr_version, 0);
                    if (i2 == 0) {
                        display.stop();
                    } else {
                        display.repaint();
                    }
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.edit, "South");
            this.getContentPane().add((Component)barra, "Center");
            this.setSize(app_Ancho, app_Alto);
            this.getContentPane();
            this.setDefaultCloseOperation(0);
            this.setVisible(true);
            this.validate();
        }
        this.config = new Gdr_config(this);
        this.sql = new Gdr_sql(this, this.config);
        this.server = new Gdr_tcp(this, this.sql, this.config);
        if (CLOSE == 1) {
            this.stop();
            return;
        }
        if (!this.server.start()) {
            this.stop();
        }
    }

    public void stop() {
        Toolkit.getDefaultToolkit().beep();
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0 && args[0] != null && (args[0].contentEquals("TEXT") || args[0].contentEquals("TEXT"))) {
            IO = 0;
            return;
        }
        if (args != null && args.length > 0 && args[0] != null && (args[0].contentEquals("CONSOLE") || args[0].contentEquals("console"))) {
            IO = 0;
            new Gdr_main();
            return;
        }
        if (args != null && args.length > 0 && args[0] != null && (args[0].contentEquals("CLOSE") || args[0].contentEquals("close"))) {
            CLOSE = 1;
        }
        JFrame.setDefaultLookAndFeelDecorated(true);
        new Gdr_main();
    }
}

