/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Gdr_debug {
    private static String logFile = "gdr.log";
    private static String logFileBase = "gdr";
    private static String logFileExt = ".log";
    private static long logLimitSize = 0xA00000L;
    private static long logCallsCheckLimitSize = 100L;
    private static int logLimitNum = 6;
    private static final DateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm.ss,SSS ");
    private static Date init = new Date();
    private static int logLimitsCtr = 0;

    private static void logLimits() {
        if ((long)(++logLimitsCtr) < logCallsCheckLimitSize) {
            return;
        }
        logLimitsCtr = 0;
        File flog = new File(logFile);
        if (flog.length() < logLimitSize) {
            return;
        }
        int iCTR = logLimitNum;
        while (true) {
            File fnow = new File(iCTR == 0 ? logFile : String.valueOf(logFileBase) + "-" + iCTR + logFileExt);
            if (iCTR == logLimitNum) {
                fnow.delete();
            } else {
                fnow.renameTo(new File(String.valueOf(logFileBase) + "-" + (iCTR + 1) + logFileExt));
            }
            if (iCTR == 0) break;
            --iCTR;
        }
    }

    public static String getUpTime() {
        return "[" + df.format(init) + "]";
    }

    public static String formatlinelog(String msg) {
        if (msg.charAt(0) == '[') {
            return msg;
        }
        Date now = new Date();
        String sThrd = "     " + Long.toHexString(Thread.currentThread().getId());
        try {
            sThrd = sThrd.substring(sThrd.length() - 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + df.format(now) + " " + sThrd + "] " + msg + "\r\n";
    }

    public static void addlog(String msg) {
        try {
            Gdr_debug.logLimits();
            Date now = new Date();
            FileWriter aWriter = new FileWriter(logFile, true);
            String linelog = Gdr_debug.formatlinelog(msg);
            aWriter.write(linelog);
            System.out.print(linelog);
            aWriter.flush();
            aWriter.close();
        }
        catch (Exception e2) {
            System.out.println(Gdr_debug.stack2string(e2));
        }
    }

    private static String stack2string(Exception e2) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e2.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Exception e22) {
            return "bad stack2string";
        }
    }

    public static String debug_bytes(byte[] data, int iOffset, int iSize) {
        String sResult = new String("\r\n");
        int iONLINE = 0;
        while (true) {
            if (iOffset >= iSize || iONLINE > 8) {
                sResult = String.valueOf(sResult) + "]:" + (iOffset - 1) + " \r\n";
                iONLINE = 0;
            }
            if (iOffset >= iSize) break;
            if (iONLINE == 0) {
                sResult = String.valueOf(sResult) + " " + iOffset + ":[ ";
                iONLINE = 1;
            }
            sResult = String.valueOf(sResult) + Integer.toHexString(data[iOffset] & 0xFF) + " ";
            ++iOffset;
            ++iONLINE;
        }
        return sResult;
    }
}

