/*
 * Decompiled with CFR 0.152.
 */
import es.jmj.gdra.Gdra_cblock;
import es.jmj.gdra.Gdra_dat;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

public class Gdr_con
extends Thread {
    private Socket connection;
    private DataInputStream input;
    private DataOutputStream output;
    private final int MAX_TCP_BLOCK = 1024;
    private Gdr_main display;
    private Gdr_config config;
    private Gdr_sql sql;
    private Gdr_tcp server;
    private String sIP;
    private boolean bCOMMAND_EXIT = false;
    private String secret;
    private byte[] handshake;
    private int dCONV_MODE;

    public void display(String str) {
        this.display.addlog(this.getName() + "." + str);
    }

    @Override
    public void run() {
        int dCONV_TOUT = this.config.getTCP_Timeout() * 1000;
        boolean dCONV_MODE = false;
        int iLoopCtr = 0;
        String sUser = null;
        String sPass = null;
        this.server.addCon(this);
        try {
            this.sIP = this.connection.getInetAddress().toString();
            this.display("INIT.client at " + this.sIP);
            this.display("LOOP.client (tout=" + dCONV_TOUT + "ms)...");
            long lTINI = System.currentTimeMillis();
            while (true) {
                long lTNOW;
                if ((lTNOW = System.currentTimeMillis()) - lTINI > (long)dCONV_TOUT) {
                    this.display("LOOP.TIMEOUT  (" + (lTNOW - lTINI) + " > " + dCONV_TOUT + "ms)");
                } else {
                    Gdra_cblock block;
                    if (!this.dataReady()) continue;
                    this.display("LOOP.client --------");
                    lTINI = System.currentTimeMillis();
                    List blocks = new LinkedList<Gdra_cblock>();
                    int i2 = 0;
                    while (true) {
                        block = new Gdra_cblock();
                        if (this.recv(block.RAW, 0, 2) == 0) {
                            throw new Exception("Cabecera no recibida (" + i2 + ")[]");
                        }
                        if (!block.getTAG()) {
                            throw new Exception("Cabecera erronea (" + i2 + ")[]");
                        }
                        if (this.recv(block.RAW, 2, Gdra_cblock.getHEADERSIZE() - 2) == 0) {
                            throw new Exception("Header no recibido");
                        }
                        int datasz = block.getDATASIZE();
                        if (datasz != 0 && this.recv(block.RAW, Gdra_cblock.getHEADERSIZE(), datasz) == 0) {
                            throw new Exception("Datos no recibidos");
                        }
                        if (!block.getCHKSUM()) {
                            throw new Exception("Datos incorrectos (" + i2 + ")[" + datasz + "]");
                        }
                        if (sPass == null || sUser == null) {
                            sUser = block.getUSER();
                            sPass = "user";
                        }
                        if (sPass == null || sUser == null) {
                            throw new Exception("Datos an\ufffdnimos (" + i2 + ")[" + datasz + "]");
                        }
                        if (!block.setHASH(false, sUser, sPass)) {
                            throw new Exception("Datos mal codificados (" + i2 + ")[" + datasz + "]");
                        }
                        blocks.add(block);
                        if (!block.getNEXT()) break;
                        ++i2;
                    }
                    if (sUser != null) {
                        this.display("==> IN [*" + blocks.size() + "] CMD(" + block.getCMD() + ") u:" + sUser);
                    }
                    if ((blocks = this.proc_command(blocks)) != null) {
                        int blocks_size = blocks.size();
                        i2 = 0;
                        while (i2 < blocks_size) {
                            block = (Gdra_cblock)blocks.get(i2);
                            block.setTAG();
                            block.setHASH(true, sUser, sPass);
                            block.setCHKSUM();
                            if (this.send(block.RAW, 0, Gdra_cblock.getHEADERSIZE() + block.getDATASIZE()) == 0) {
                                throw new Exception("Respuesta no enviada");
                            }
                            if (!block.getNEXT()) break;
                            ++i2;
                        }
                        this.display("==> OUT [*" + blocks_size + "]: CMD(" + block.getCMD() + ") u:" + sUser + "  ==>" + block.getRESULT());
                        this.display.addCommand();
                        if (this.bCOMMAND_EXIT) {
                            this.display.stop();
                        }
                        this.display("LOOP.wait -----(" + ++iLoopCtr + ")-----");
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e2) {
            this.display("Client exception " + e2);
        }
        this.end();
    }

    public Gdr_con(Socket s2, Gdr_tcp server, Gdr_main display, Gdr_sql sql, Gdr_config config) {
        this.server = server;
        this.display = display;
        this.config = config;
        this.sql = sql;
        this.connection = s2;
        try {
            this.input = new DataInputStream(this.connection.getInputStream());
            this.output = new DataOutputStream(this.connection.getOutputStream());
            this.connection.setSoTimeout(40000);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.setName("" + s2.getPort());
        this.start();
    }

    public Gdr_con(Gdr_tcp server, Gdr_main display, Gdr_sql sql, Gdr_config config) {
        this.server = null;
        this.display = display;
        this.config = config;
        this.sql = sql;
        this.setName("conPending");
    }

    public synchronized List proc_command(List blocks) {
        Gdra_cblock block = null;
        Gdra_cblock block1_in = null;
        Gdra_dat data1_in = null;
        Gdra_dat data = null;
        LinkedList<Gdra_cblock> ack = null;
        LinkedList<Gdra_dat> datas_in = null;
        List<Gdra_dat> datas_out = null;
        try {
            int blocks_size = blocks.size();
            datas_in = new LinkedList<Gdra_dat>();
            int i2 = 0;
            while (i2 < blocks_size) {
                block = (Gdra_cblock)blocks.get(i2);
                if (block1_in == null) {
                    block1_in = block;
                }
                data = new Gdra_dat();
                data.setData(block.getDATA());
                datas_in.add(data);
                if (data1_in == null) {
                    data1_in = data;
                }
                if (!block.getNEXT()) break;
                ++i2;
            }
            this.display("CMD.in: C" + block1_in.getCMD() + " blocks(" + datas_in.size() + ")");
            datas_out = null;
            if (block1_in.getCMD() == 41) {
                datas_out = this.sql.dataGet(data1_in.getTRACTORA(), data1_in.getIDEAPLIC());
                if (datas_out != null) {
                    block1_in.setRESULT((byte)1);
                } else {
                    block1_in.setRESULT((byte)0);
                }
            }
            if (block1_in.getCMD() == 51) {
                if (this.sql.dataFitData(datas_in)) {
                    block1_in.setRESULT((byte)1);
                } else {
                    block1_in.setRESULT((byte)0);
                }
            }
            if (datas_out == null) {
                block = new Gdra_cblock();
                block.setCMD((byte)block1_in.getCMD());
                block.setRESULT((byte)block1_in.getRESULT());
                block.setNEXT(false);
                ack = new LinkedList();
                ack.add(block);
                this.display("CMD.ack: C" + block.getCMD() + "=" + block.getRESULT() + " blocks(1)");
                return ack;
            }
            ack = new LinkedList<Gdra_cblock>();
            int datas_size = datas_out.size();
            int i3 = 0;
            while (i3 < datas_size) {
                data = datas_out.get(i3);
                block = new Gdra_cblock();
                block.setCMD((byte)block1_in.getCMD());
                block.setRESULT((byte)block1_in.getRESULT());
                block.setDATA(data.getData());
                block.setNEXT(true);
                ack.add(block);
                ++i3;
            }
            block.setNEXT(false);
            return ack;
        }
        catch (Exception e2) {
            this.display("Proc cmd exception " + e2);
            return null;
        }
    }

    public boolean dataReady() {
        block3: {
            if (this.input.available() < 2) break block3;
            return true;
        }
        try {
            Gdr_con.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int send(byte[] data, int iOffset, int iLen) {
        int iSended = 0;
        if (iLen == 0) {
            return 0;
        }
        try {
            iSended = iLen;
            this.output.write(data, iOffset, iLen);
        }
        catch (Exception e2) {
            this.display("Error except write line ");
            return 0;
        }
        this.display.addCounters(0, iSended);
        return iSended;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int waitData(int dTimeoutMs) {
        try {
            if (this.input == null) {
                return -1;
            }
            long dStart = System.currentTimeMillis();
            do {
                if (this.input.available() != 0) {
                    return 1;
                }
                Gdr_con.sleep(100L);
                if (dTimeoutMs != 0) continue;
                return 0;
            } while (System.currentTimeMillis() - dStart <= (long)dTimeoutMs);
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int recv(byte[] data, int iOffset, int iLen) {
        int iNow = 0;
        int iDone = 0;
        int iBlock = 0;
        if (data == null) {
            return 0;
        }
        if (iLen == 0) {
            return 0;
        }
        if (this.input == null) {
            return 0;
        }
        try {
            do {
                if ((iBlock = iLen - iDone) > 1024) {
                    iBlock = 1024;
                }
                if ((iNow = this.input.read(data, iOffset + iDone, iBlock)) != -1) continue;
                this.display("Error read line");
                return 0;
            } while ((iDone += iNow) < iLen);
        }
        catch (Exception e2) {
            this.display("Error except read line");
            return 0;
        }
        this.display.addCounters(iDone, 0);
        return iDone;
    }

    public void end() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.sIP != null) {
                this.display("END.client at " + this.sIP);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.server.delCon(this);
    }
}

